/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MultiFetchOverpassObjectReader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class MultiFetchServerObjectReader
extends OsmServerReader {
    private static final int MAX_IDS_PER_REQUEST = 170;
    private final Set<Long> nodes = new LinkedHashSet<Long>();
    private final Set<Long> ways = new LinkedHashSet<Long>();
    private final Set<Long> relations = new LinkedHashSet<Long>();
    private Set<PrimitiveId> missingPrimitives;
    private final DataSet outputDataSet = new DataSet();

    protected MultiFetchServerObjectReader() {
        this.missingPrimitives = new LinkedHashSet<PrimitiveId>();
    }

    public static MultiFetchServerObjectReader create() {
        return MultiFetchServerObjectReader.create(OverpassDownloadReader.FOR_MULTI_FETCH.get());
    }

    public static MultiFetchServerObjectReader create(boolean fromMirror) {
        if (fromMirror) {
            return new MultiFetchOverpassObjectReader();
        }
        return new MultiFetchServerObjectReader();
    }

    protected void remember(PrimitiveId id) {
        if (id.isNew()) {
            return;
        }
        switch (id.getType()) {
            case NODE: {
                this.nodes.add(id.getUniqueId());
                break;
            }
            case WAY: {
                this.ways.add(id.getUniqueId());
                break;
            }
            case RELATION: {
                this.relations.add(id.getUniqueId());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public MultiFetchServerObjectReader append(DataSet ds, long id, OsmPrimitiveType type) {
        OsmPrimitive p = (OsmPrimitive)ds.getPrimitiveById(id, type);
        switch (type) {
            case NODE: {
                return this.appendNode((Node)p);
            }
            case WAY: {
                return this.appendWay((Way)p);
            }
            case RELATION: {
                return this.appendRelation((Relation)p);
            }
        }
        return this;
    }

    public MultiFetchServerObjectReader appendNode(Node node) {
        if (node == null) {
            return this;
        }
        this.remember(node.getPrimitiveId());
        return this;
    }

    public MultiFetchServerObjectReader appendWay(Way way) {
        if (way == null) {
            return this;
        }
        if (way.isNew()) {
            return this;
        }
        for (Node node : !this.recursesDown() ? way.getNodes() : Collections.emptyList()) {
            if (node.isNew()) continue;
            this.remember(node.getPrimitiveId());
        }
        this.remember(way.getPrimitiveId());
        return this;
    }

    protected MultiFetchServerObjectReader appendRelation(Relation relation) {
        if (relation == null) {
            return this;
        }
        if (relation.isNew()) {
            return this;
        }
        this.remember(relation.getPrimitiveId());
        for (RelationMember member : !this.recursesDown() ? relation.getMembers() : Collections.emptyList()) {
            if (OsmPrimitiveType.from(member.getMember()) == OsmPrimitiveType.RELATION && this.relations.contains(member.getMember().getId()) || member.getMember().isIncomplete()) continue;
            this.append(member.getMember());
        }
        return this;
    }

    public MultiFetchServerObjectReader append(OsmPrimitive primitive) {
        if (primitive instanceof Node) {
            return this.appendNode((Node)primitive);
        }
        if (primitive instanceof Way) {
            return this.appendWay((Way)primitive);
        }
        if (primitive instanceof Relation) {
            return this.appendRelation((Relation)primitive);
        }
        return this;
    }

    public MultiFetchServerObjectReader append(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return this;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            this.append(osmPrimitive);
        }
        return this;
    }

    protected Set<Long> extractIdPackage(Set<Long> ids) {
        HashSet<Long> pkg = new HashSet<Long>();
        if (ids.isEmpty()) {
            return pkg;
        }
        if (ids.size() > 170) {
            Iterator<Long> it = ids.iterator();
            for (int i = 0; i < 170; ++i) {
                pkg.add(it.next());
            }
            ids.removeAll(pkg);
        } else {
            pkg.addAll(ids);
            ids.clear();
        }
        return pkg;
    }

    protected String buildRequestString(OsmPrimitiveType type, Set<Long> idPackage) {
        return type.getAPIName() + "s?" + type.getAPIName() + "s=" + Utils.join(",", idPackage);
    }

    protected void rememberNodesOfIncompleteWaysToLoad(DataSet from) {
        for (Way w : from.getWays()) {
            if (!w.hasIncompleteNodes()) continue;
            for (Node n : w.getNodes()) {
                if (!n.isIncomplete()) continue;
                this.nodes.add(n.getId());
            }
        }
    }

    protected void merge(DataSet from) {
        DataSetMerger visitor = new DataSetMerger(this.outputDataSet, from);
        visitor.merge();
    }

    protected void fetchPrimitives(Set<Long> ids, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
        String msg;
        String baseUrl = this.getBaseUrl();
        switch (type) {
            case NODE: {
                msg = I18n.tr("Fetching a package of nodes from ''{0}''", baseUrl);
                break;
            }
            case WAY: {
                msg = I18n.tr("Fetching a package of ways from ''{0}''", baseUrl);
                break;
            }
            case RELATION: {
                msg = I18n.tr("Fetching a package of relations from ''{0}''", baseUrl);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        progressMonitor.setTicksCount(ids.size());
        progressMonitor.setTicks(0);
        HashSet<Long> toFetch = new HashSet<Long>(ids);
        int threadsNumber = Config.getPref().getInt("osm.download.threads", 2);
        threadsNumber = Utils.clamp(threadsNumber, 1, 2);
        ExecutorService exec = Executors.newFixedThreadPool(threadsNumber, Utils.newThreadFactory(this.getClass() + "-%d", 5));
        ExecutorCompletionService<FetchResult> ecs = new ExecutorCompletionService<FetchResult>(exec);
        ArrayList<Future<FetchResult>> jobs = new ArrayList<Future<FetchResult>>();
        while (!toFetch.isEmpty()) {
            jobs.add(ecs.submit(new Fetcher(type, this.extractIdPackage(toFetch), progressMonitor)));
        }
        for (int i = 0; i < jobs.size() && !this.isCanceled(); ++i) {
            progressMonitor.subTask(msg + "... " + progressMonitor.getTicks() + '/' + progressMonitor.getTicksCount());
            try {
                FetchResult fetchResult = (FetchResult)ecs.take().get();
                if (fetchResult.rc404 != null) {
                    ArrayList toSplit = new ArrayList(fetchResult.rc404);
                    int n = toSplit.size() / 2;
                    jobs.add(ecs.submit(new Fetcher(type, new HashSet<Long>(toSplit.subList(0, n)), progressMonitor)));
                    jobs.add(ecs.submit(new Fetcher(type, new HashSet<Long>(toSplit.subList(n, toSplit.size())), progressMonitor)));
                }
                if (fetchResult.missingPrimitives != null) {
                    this.missingPrimitives.addAll(fetchResult.missingPrimitives);
                }
                if (fetchResult.dataSet == null || this.isCanceled()) continue;
                this.rememberNodesOfIncompleteWaysToLoad(fetchResult.dataSet);
                this.merge(fetchResult.dataSet);
                continue;
            }
            catch (InterruptedException | ExecutionException exception) {
                Logging.error(exception);
            }
        }
        exec.shutdown();
        if (this.isCanceled()) {
            for (Future future : jobs) {
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        int n = this.nodes.size() + this.ways.size() + this.relations.size();
        progressMonitor.beginTask(I18n.trn("Downloading {0} object from ''{1}''", "Downloading {0} objects from ''{1}''", n, n, OsmApi.getOsmApi().getBaseUrl()));
        try {
            this.missingPrimitives = new HashSet<PrimitiveId>();
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.ways, OsmPrimitiveType.WAY, progressMonitor);
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.nodes, OsmPrimitiveType.NODE, progressMonitor);
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.relations, OsmPrimitiveType.RELATION, progressMonitor);
            if (this.outputDataSet != null) {
                this.outputDataSet.deleteInvisible();
            }
            DataSet dataSet = this.outputDataSet;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Set<PrimitiveId> getMissingPrimitives() {
        return this.missingPrimitives;
    }

    protected boolean recursesDown() {
        return false;
    }

    protected class Fetcher
    extends OsmServerReader
    implements Callable<FetchResult> {
        private final Set<Long> pkg;
        private final OsmPrimitiveType type;
        private final ProgressMonitor progressMonitor;

        public Fetcher(OsmPrimitiveType type, Set<Long> idsPackage, ProgressMonitor progressMonitor) {
            this.pkg = idsPackage;
            this.type = type;
            this.progressMonitor = progressMonitor;
        }

        @Override
        public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
            return this.fetch((ProgressMonitor)progressMonitor).dataSet;
        }

        @Override
        public FetchResult call() throws Exception {
            return this.fetch(this.progressMonitor);
        }

        protected FetchResult fetch(ProgressMonitor progressMonitor) throws OsmTransferException {
            try {
                return this.multiGetIdPackage(this.type, this.pkg, progressMonitor);
            }
            catch (OsmApiException e) {
                if (e.getResponseCode() == 404) {
                    if (this.pkg.size() > 4) {
                        FetchResult res = new FetchResult(null, null);
                        res.rc404 = this.pkg;
                        return res;
                    }
                    Logging.info(I18n.tr("Server replied with response code 404, retrying with an individual request for each object.", new Object[0]));
                    return this.singleGetIdPackage(this.type, this.pkg, progressMonitor);
                }
                throw e;
            }
        }

        @Override
        protected String getBaseUrl() {
            return MultiFetchServerObjectReader.this.getBaseUrl();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected FetchResult multiGetIdPackage(OsmPrimitiveType type, Set<Long> pkg, ProgressMonitor progressMonitor) throws OsmTransferException {
            String request = MultiFetchServerObjectReader.this.buildRequestString(type, pkg);
            FetchResult result = null;
            try (InputStream in = this.getInputStream(request, NullProgressMonitor.INSTANCE);){
                if (in == null) {
                    FetchResult fetchResult = null;
                    return fetchResult;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                try {
                    result = new FetchResult(OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(pkg.size(), false)), null);
                    return result;
                }
                catch (IllegalDataException e) {
                    throw new OsmTransferException(e);
                }
            }
            catch (IOException ex) {
                Logging.warn(ex);
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected DataSet singleGetId(OsmPrimitiveType type, long id, ProgressMonitor progressMonitor) throws OsmTransferException {
            String request = MultiFetchServerObjectReader.this.buildRequestString(type, Collections.singleton(id));
            DataSet result = null;
            try (InputStream in = this.getInputStream(request, NullProgressMonitor.INSTANCE);){
                if (in == null) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                try {
                    result = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
                    return result;
                }
                catch (IllegalDataException e) {
                    throw new OsmTransferException(e);
                }
            }
            catch (IOException ex) {
                Logging.warn(ex);
            }
            return result;
        }

        protected FetchResult singleGetIdPackage(OsmPrimitiveType type, Set<Long> pkg, ProgressMonitor progressMonitor) throws OsmTransferException {
            FetchResult result = new FetchResult(new DataSet(), new HashSet<PrimitiveId>());
            String baseUrl = OsmApi.getOsmApi().getBaseUrl();
            for (long id : pkg) {
                try {
                    String msg;
                    switch (type) {
                        case NODE: {
                            msg = I18n.tr("Fetching node with id {0} from ''{1}''", id, baseUrl);
                            break;
                        }
                        case WAY: {
                            msg = I18n.tr("Fetching way with id {0} from ''{1}''", id, baseUrl);
                            break;
                        }
                        case RELATION: {
                            msg = I18n.tr("Fetching relation with id {0} from ''{1}''", id, baseUrl);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    progressMonitor.setCustomText(msg);
                    result.dataSet.mergeFrom(this.singleGetId(type, id, progressMonitor));
                }
                catch (OsmApiException e) {
                    if (e.getResponseCode() == 404) {
                        Logging.info(I18n.tr("Server replied with response code 404 for id {0}. Skipping.", Long.toString(id)));
                        result.missingPrimitives.add(new SimplePrimitiveId(id, type));
                        continue;
                    }
                    throw e;
                }
            }
            return result;
        }
    }

    protected static class FetchResult {
        public final DataSet dataSet;
        public final Set<PrimitiveId> missingPrimitives;
        private Set<Long> rc404;

        public FetchResult(DataSet dataSet, Set<PrimitiveId> missingPrimitives) {
            this.dataSet = dataSet;
            this.missingPrimitives = missingPrimitives;
        }
    }
}

