/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;

final class SSubEachArray
extends AStatement {
    private final Locals.Variable variable;
    private AExpression expression;
    private final SBlock block;
    private PainlessCast cast = null;
    private Locals.Variable array = null;
    private Locals.Variable index = null;
    private Class<?> indexed = null;

    SSubEachArray(Location location, Locals.Variable variable, AExpression expression, SBlock block) {
        super(location);
        this.variable = Objects.requireNonNull(variable);
        this.expression = Objects.requireNonNull(expression);
        this.block = block;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.array = locals.addVariable(this.location, this.expression.actual, "#array" + this.location.getOffset(), true);
        this.index = locals.addVariable(this.location, Integer.TYPE, "#index" + this.location.getOffset(), true);
        this.indexed = this.expression.actual.getComponentType();
        this.cast = AnalyzerCaster.getLegalCast(this.location, this.indexed, this.variable.clazz, true, true);
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeStatementOffset(this.location);
        this.expression.write(classWriter, methodWriter, globals);
        methodWriter.visitVarInsn(MethodWriter.getType(this.array.clazz).getOpcode(54), this.array.getSlot());
        methodWriter.push(-1);
        methodWriter.visitVarInsn(MethodWriter.getType(this.index.clazz).getOpcode(54), this.index.getSlot());
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(begin);
        methodWriter.visitIincInsn(this.index.getSlot(), 1);
        methodWriter.visitVarInsn(MethodWriter.getType(this.index.clazz).getOpcode(21), this.index.getSlot());
        methodWriter.visitVarInsn(MethodWriter.getType(this.array.clazz).getOpcode(21), this.array.getSlot());
        methodWriter.arrayLength();
        methodWriter.ifICmp(156, end);
        methodWriter.visitVarInsn(MethodWriter.getType(this.array.clazz).getOpcode(21), this.array.getSlot());
        methodWriter.visitVarInsn(MethodWriter.getType(this.index.clazz).getOpcode(21), this.index.getSlot());
        methodWriter.arrayLoad(MethodWriter.getType(this.indexed));
        methodWriter.writeCast(this.cast);
        methodWriter.visitVarInsn(MethodWriter.getType(this.variable.clazz).getOpcode(54), this.variable.getSlot());
        if (this.loopCounter != null) {
            methodWriter.writeLoopCounter(this.loopCounter.getSlot(), this.statementCount, this.location);
        }
        this.block.continu = begin;
        this.block.brake = end;
        this.block.write(classWriter, methodWriter, globals);
        methodWriter.goTo(begin);
        methodWriter.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(PainlessLookupUtility.typeToCanonicalTypeName(this.variable.clazz), this.variable.name, this.expression, this.block);
    }
}

