export interface Module {
    classes: ClassModel[];
    imports: {
        [name: string]: Module;
    };
    aliases: AliasNode[];
    enumDeclarations: EnumDeclaration[];
    name: string;
}
export interface AliasNode {
    name: string;
    type: TypeModel;
}
export declare class EnumDeclaration {
    name: string;
    members: string[];
}
export declare enum TypeKind {
    BASIC = 0,
    ARRAY = 1,
    UNION = 2,
}
export interface TypeModel {
    typeKind: TypeKind;
}
export interface BasicType extends TypeModel {
    nameSpace: string;
    basicName: string;
    typeName: string;
    typeArguments: TypeModel[];
    modulePath: string;
}
export interface ArrayType extends TypeModel {
    base: TypeModel;
}
export declare type Arg = string | number | boolean;
export interface UnionType extends TypeModel {
    options: TypeModel[];
}
export interface Annotation {
    name: string;
    arguments: (Arg | Arg[])[];
}
export interface FieldModel {
    name: string;
    type: TypeModel;
    annotations: Annotation[];
    valueConstraint: Constraint;
    optional: boolean;
}
export interface MethodModel {
    start: number;
    end: number;
    name: string;
    text: string;
    returnType: TypeModel;
    arguments: ParameterModel[];
}
export interface ParameterModel {
    start: number;
    end: number;
    name: string;
    text: string;
    type: TypeModel;
}
export interface Constraint {
    isCallConstraint: boolean;
    value?: any;
}
export interface CallConstraint extends Constraint {
    value: Annotation;
}
export interface ValueConstraint extends Constraint {
    value: string | number | boolean;
}
export interface ClassModel {
    name: string;
    annotations: Annotation[];
    moduleName: string;
    extends: TypeModel[];
    implements: TypeModel[];
    fields: FieldModel[];
    methods: MethodModel[];
    typeParameters: string[];
    typeParameterConstraint: string[];
    isInterface: boolean;
    annotationOverridings: {
        [key: string]: Annotation[];
    };
}
export declare function classDecl(name: string, isInteface: boolean): ClassModel;
