/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XNodeInfo;

public class XTree
extends JTree {
    private static final List<String> orderedKeyPropertyList = new ArrayList<String>();
    private MBeansTab mbeansTab;
    private Map<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>();
    private static boolean treeView;
    private static boolean treeViewInit;
    private boolean keyValueView = Boolean.getBoolean("keyValueView");

    public XTree(MBeansTab mbeansTab) {
        this((TreeNode)new DefaultMutableTreeNode("MBeanTreeRootNode"), mbeansTab);
    }

    public XTree(TreeNode root, MBeansTab mbeansTab) {
        super(root, true);
        this.mbeansTab = mbeansTab;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private synchronized void removeChildNode(DefaultMutableTreeNode child) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.removeNodeFromParent(child);
    }

    private synchronized void addChildNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child, int index) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.insertNodeInto(child, parent, index);
    }

    private synchronized void addChildNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            this.addChildNode(parent, child, 0);
            return;
        }
        if (child instanceof ComparableDefaultMutableTreeNode) {
            ComparableDefaultMutableTreeNode comparableChild = (ComparableDefaultMutableTreeNode)child;
            for (int i = childCount - 1; i >= 0; --i) {
                DefaultMutableTreeNode brother = (DefaultMutableTreeNode)parent.getChildAt(i);
                if ((i > 2 || !this.isMetadataNode(brother)) && comparableChild.compareTo(brother) < 0) continue;
                this.addChildNode(parent, child, i + 1);
                return;
            }
            this.addChildNode(parent, child, 0);
            return;
        }
        this.addChildNode(parent, child, childCount);
    }

    @Override
    public synchronized void removeAll() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        model.nodeStructureChanged(root);
        this.nodes.clear();
    }

    public synchronized void removeMBeanFromView(ObjectName mbean) {
        DefaultMutableTreeNode node = null;
        Dn dn = new Dn(mbean);
        if (dn.getTokenCount() > 0) {
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            Token token = dn.getToken(0);
            String hashKey = dn.getHashKey(token);
            node = this.nodes.get(hashKey);
            if (node != null && !node.isRoot()) {
                if (this.hasNonMetadataNodes(node)) {
                    this.removeMetadataNodes(node);
                    String label = token.getValue();
                    XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.NONMBEAN, label, label, token.getTokenValue());
                    this.changeNodeValue(node, userObject);
                } else {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    model.removeNodeFromParent(node);
                    this.nodes.remove(hashKey);
                    this.removeParentFromView(dn, 1, parent);
                }
            }
        }
    }

    private boolean hasNonMetadataNodes(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.children();
        block3: while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            Object uo = n.getUserObject();
            if (uo instanceof XNodeInfo) {
                switch (((XNodeInfo)uo).getType()) {
                    case ATTRIBUTES: 
                    case NOTIFICATIONS: 
                    case OPERATIONS: {
                        continue block3;
                    }
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean hasMetadataNodes(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            Object uo = n.getUserObject();
            if (uo instanceof XNodeInfo) {
                switch (((XNodeInfo)uo).getType()) {
                    case ATTRIBUTES: 
                    case NOTIFICATIONS: 
                    case OPERATIONS: {
                        return true;
                    }
                }
                continue;
            }
            return false;
        }
        return false;
    }

    public boolean isMetadataNode(DefaultMutableTreeNode node) {
        Object uo = node.getUserObject();
        if (uo instanceof XNodeInfo) {
            switch (((XNodeInfo)uo).getType()) {
                case ATTRIBUTES: 
                case NOTIFICATIONS: 
                case OPERATIONS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void removeMetadataNodes(DefaultMutableTreeNode node) {
        HashSet<DefaultMutableTreeNode> metadataNodes = new HashSet<DefaultMutableTreeNode>();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            Object uo = n.getUserObject();
            if (!(uo instanceof XNodeInfo)) continue;
            switch (((XNodeInfo)uo).getType()) {
                case ATTRIBUTES: 
                case NOTIFICATIONS: 
                case OPERATIONS: {
                    metadataNodes.add(n);
                    break;
                }
            }
        }
        for (DefaultMutableTreeNode n : metadataNodes) {
            model.removeNodeFromParent(n);
        }
    }

    private DefaultMutableTreeNode removeParentFromView(Dn dn, int index, DefaultMutableTreeNode node) {
        if (!node.isRoot() && node.isLeaf() && !((XNodeInfo)node.getUserObject()).getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            this.removeChildNode(node);
            String hashKey = dn.getHashKey(dn.getToken(index));
            this.nodes.remove(hashKey);
            this.removeParentFromView(dn, index + 1, parent);
        }
        return node;
    }

    public synchronized void addMBeansToView(Set<ObjectName> mbeans) {
        TreeSet<Dn> dns = new TreeSet<Dn>();
        for (ObjectName mbean : mbeans) {
            Dn dn = new Dn(mbean);
            dns.add(dn);
        }
        for (Dn dn : dns) {
            ObjectName mbean = dn.getObjectName();
            XMBean xmbean = new XMBean(mbean, this.mbeansTab);
            this.addMBeanToView(mbean, xmbean, dn);
        }
    }

    public synchronized void addMBeanToView(ObjectName mbean) {
        XMBean xmbean = new XMBean(mbean, this.mbeansTab);
        Dn dn = new Dn(mbean);
        this.addMBeanToView(mbean, xmbean, dn);
    }

    private synchronized void addMBeanToView(ObjectName mbean, XMBean xmbean, Dn dn) {
        DefaultMutableTreeNode childNode = null;
        DefaultMutableTreeNode parentNode = null;
        Token token = dn.getToken(0);
        String hashKey = dn.getHashKey(token);
        if (this.nodes.containsKey(hashKey)) {
            childNode = this.nodes.get(hashKey);
            Object data = this.createNodeValue(xmbean, token);
            String label = data.toString();
            XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.MBEAN, data, label, mbean.toString());
            this.changeNodeValue(childNode, userObject);
            return;
        }
        childNode = this.createDnNode(dn, token, xmbean);
        this.nodes.put(hashKey, childNode);
        for (int i = 1; i < dn.getTokenCount(); ++i) {
            token = dn.getToken(i);
            hashKey = dn.getHashKey(token);
            if (this.nodes.containsKey(hashKey)) {
                parentNode = this.nodes.get(hashKey);
                this.addChildNode(parentNode, childNode);
                return;
            }
            if ("domain".equals(token.getTokenType())) {
                parentNode = this.createDomainNode(dn, token);
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
                this.addChildNode(root, parentNode);
            } else {
                parentNode = this.createSubDnNode(dn, token);
            }
            this.nodes.put(hashKey, parentNode);
            this.addChildNode(parentNode, childNode);
            childNode = parentNode;
        }
    }

    private synchronized void changeNodeValue(DefaultMutableTreeNode node, XNodeInfo nodeValue) {
        if (node instanceof ComparableDefaultMutableTreeNode) {
            DefaultMutableTreeNode clone = (DefaultMutableTreeNode)node.clone();
            clone.setUserObject(nodeValue);
            if (((ComparableDefaultMutableTreeNode)node).compareTo(clone) == 0) {
                node.setUserObject(nodeValue);
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                model.nodeChanged(node);
            } else {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                this.removeChildNode(node);
                node.setUserObject(nodeValue);
                this.addChildNode(parent, node);
            }
        } else {
            node.setUserObject(nodeValue);
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.nodeChanged(node);
        }
        if (nodeValue.getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            this.removeMetadataNodes(node);
            Object[] treeNodes = node.getPath();
            TreePath path = new TreePath(treeNodes);
            if (this.isExpanded(path)) {
                this.addMetadataNodes(node);
            }
        }
        if (node == this.getLastSelectedPathComponent()) {
            TreePath selectionPath = this.getSelectionPath();
            this.clearSelection();
            this.setSelectionPath(selectionPath);
        }
    }

    private DefaultMutableTreeNode createDomainNode(Dn dn, Token token) {
        ComparableDefaultMutableTreeNode node = new ComparableDefaultMutableTreeNode();
        String label = dn.getDomain();
        XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.NONMBEAN, label, label, label);
        node.setUserObject(userObject);
        return node;
    }

    private DefaultMutableTreeNode createDnNode(Dn dn, Token token, XMBean xmbean) {
        ComparableDefaultMutableTreeNode node = new ComparableDefaultMutableTreeNode();
        Object data = this.createNodeValue(xmbean, token);
        String label = data.toString();
        XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.MBEAN, data, label, xmbean.getObjectName().toString());
        node.setUserObject(userObject);
        return node;
    }

    private DefaultMutableTreeNode createSubDnNode(Dn dn, Token token) {
        ComparableDefaultMutableTreeNode node = new ComparableDefaultMutableTreeNode();
        String label = this.isKeyValueView() ? token.getTokenValue() : token.getValue();
        XNodeInfo userObject = new XNodeInfo(XNodeInfo.Type.NONMBEAN, label, label, token.getTokenValue());
        node.setUserObject(userObject);
        return node;
    }

    private Object createNodeValue(XMBean xmbean, Token token) {
        String label = this.isKeyValueView() ? token.getTokenValue() : token.getValue();
        xmbean.setText(label);
        return xmbean;
    }

    private static Map<String, String> extractKeyValuePairs(String props, ObjectName mbean) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int eq = props.indexOf("=");
        while (eq != -1) {
            String key = props.substring(0, eq);
            String value = mbean.getKeyProperty(key);
            map.put(key, value);
            props = props.substring(key.length() + 1 + value.length());
            if (props.startsWith(",")) {
                props = props.substring(1);
            }
            eq = props.indexOf("=");
        }
        return map;
    }

    private static String getKeyPropertyListString(ObjectName mbean) {
        String props = mbean.getKeyPropertyListString();
        Map<String, String> map = XTree.extractKeyValuePairs(props, mbean);
        StringBuilder sb = new StringBuilder();
        for (String string : orderedKeyPropertyList) {
            if (!map.containsKey(string)) continue;
            sb.append(string + "=" + map.get(string) + ",");
            map.remove(string);
        }
        for (Map.Entry entry : map.entrySet()) {
            sb.append((String)entry.getKey() + "=" + (String)entry.getValue() + ",");
        }
        String orderedKeyPropertyListString = sb.toString();
        orderedKeyPropertyListString = orderedKeyPropertyListString.substring(0, orderedKeyPropertyListString.length() - 1);
        return orderedKeyPropertyListString;
    }

    public void addMetadataNodes(DefaultMutableTreeNode node) {
        XMBean mbean = (XMBean)((XNodeInfo)node.getUserObject()).getData();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        MBeanInfoNodesSwingWorker sw = new MBeanInfoNodesSwingWorker(model, node, mbean);
        if (sw != null) {
            sw.execute();
        }
    }

    private static boolean isTreeView() {
        if (!treeViewInit) {
            treeView = XTree.getTreeViewValue();
            treeViewInit = true;
        }
        return treeView;
    }

    private static boolean getTreeViewValue() {
        String tv = System.getProperty("treeView");
        return tv == null ? true : !tv.equals("false");
    }

    private boolean isKeyValueView() {
        return this.keyValueView;
    }

    static {
        String keyPropertyList = System.getProperty("com.sun.tools.jconsole.mbeans.keyPropertyList");
        if (keyPropertyList == null) {
            orderedKeyPropertyList.add("type");
            orderedKeyPropertyList.add("j2eeType");
        } else {
            StringTokenizer st = new StringTokenizer(keyPropertyList, ",");
            while (st.hasMoreTokens()) {
                orderedKeyPropertyList.add(st.nextToken());
            }
        }
        treeViewInit = false;
    }

    private static class Token {
        private String tokenType;
        private String tokenValue;
        private String key;
        private String value;

        public Token(String tokenType, String tokenValue) {
            this.tokenType = tokenType;
            this.tokenValue = tokenValue;
            this.buildKeyValue();
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getTokenValue() {
            return this.tokenValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        private void buildKeyValue() {
            int index = this.tokenValue.indexOf("=");
            if (index < 0) {
                this.key = this.tokenValue;
                this.value = this.tokenValue;
            } else {
                this.key = this.tokenValue.substring(0, index);
                this.value = this.tokenValue.substring(index + 1, this.tokenValue.length());
            }
        }
    }

    private static class Dn
    implements Comparable<Dn> {
        private ObjectName mbean;
        private String domain;
        private String keyPropertyList;
        private String hashDn;
        private List<Token> tokens = new ArrayList<Token>();

        public Dn(ObjectName mbean) {
            this.mbean = mbean;
            this.domain = mbean.getDomain();
            this.keyPropertyList = XTree.getKeyPropertyListString(mbean);
            if (XTree.isTreeView()) {
                Map map = XTree.extractKeyValuePairs(this.keyPropertyList, mbean);
                for (Map.Entry entry : map.entrySet()) {
                    this.tokens.add(new Token("key", (String)entry.getKey() + "=" + (String)entry.getValue()));
                }
            } else {
                this.tokens.add(new Token("key", "properties=" + this.keyPropertyList));
            }
            this.tokens.add(0, new Token("domain", "domain=" + this.domain));
            Collections.reverse(this.tokens);
            this.computeHashDn();
        }

        public ObjectName getObjectName() {
            return this.mbean;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getKeyPropertyList() {
            return this.keyPropertyList;
        }

        public Token getToken(int index) {
            return this.tokens.get(index);
        }

        public int getTokenCount() {
            return this.tokens.size();
        }

        public String getHashDn() {
            return this.hashDn;
        }

        public String getHashKey(Token token) {
            int begin = this.hashDn.indexOf(token.getTokenValue());
            return this.hashDn.substring(begin, this.hashDn.length());
        }

        private void computeHashDn() {
            if (this.tokens.isEmpty()) {
                return;
            }
            StringBuilder hdn = new StringBuilder();
            for (int i = 0; i < this.tokens.size(); ++i) {
                hdn.append(this.tokens.get(i).getTokenValue());
                hdn.append(",");
            }
            this.hashDn = hdn.substring(0, hdn.length() - 1);
        }

        public String toString() {
            return this.domain + ":" + this.keyPropertyList;
        }

        @Override
        public int compareTo(Dn dn) {
            return this.toString().compareTo(dn.toString());
        }
    }

    private static class ComparableDefaultMutableTreeNode
    extends DefaultMutableTreeNode
    implements Comparable<DefaultMutableTreeNode> {
        private ComparableDefaultMutableTreeNode() {
        }

        @Override
        public int compareTo(DefaultMutableTreeNode node) {
            return this.toString().compareTo(node.toString());
        }
    }

    private static class MBeanInfoNodesSwingWorker
    extends SwingWorker<Object[], Void> {
        private final DefaultTreeModel model;
        private final DefaultMutableTreeNode node;
        private final XMBean mbean;

        public MBeanInfoNodesSwingWorker(DefaultTreeModel model, DefaultMutableTreeNode node, XMBean mbean) {
            this.model = model;
            this.node = node;
            this.mbean = mbean;
        }

        @Override
        public Object[] doInBackground() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            Object[] result = new Object[]{this.mbean.getMBeanInfo(), this.mbean.isBroadcaster()};
            return result;
        }

        @Override
        protected void done() {
            block3: {
                try {
                    Object[] result = (Object[])this.get();
                    MBeanInfo mbeanInfo = (MBeanInfo)result[0];
                    Boolean isBroadcaster = (Boolean)result[1];
                    if (mbeanInfo != null) {
                        this.addMBeanInfoNodes(this.model, this.node, this.mbean, mbeanInfo, isBroadcaster);
                    }
                }
                catch (Exception e) {
                    Throwable t = Utils.getActualException(e);
                    if (!JConsole.isDebug()) break block3;
                    t.printStackTrace();
                }
            }
        }

        private void addMBeanInfoNodes(DefaultTreeModel tree, DefaultMutableTreeNode node, XMBean mbean, MBeanInfo mbeanInfo, Boolean isBroadcaster) {
            MBeanAttributeInfo[] ai = mbeanInfo.getAttributes();
            MBeanOperationInfo[] oi = mbeanInfo.getOperations();
            MBeanNotificationInfo[] ni = mbeanInfo.getNotifications();
            int childIndex = 0;
            if (ai != null && ai.length > 0) {
                DefaultMutableTreeNode attributes = new DefaultMutableTreeNode();
                XNodeInfo attributesUO = new XNodeInfo(XNodeInfo.Type.ATTRIBUTES, mbean, Messages.ATTRIBUTES, null);
                attributes.setUserObject(attributesUO);
                node.insert(attributes, childIndex++);
                for (MBeanFeatureInfo mBeanFeatureInfo : ai) {
                    DefaultMutableTreeNode attribute = new DefaultMutableTreeNode();
                    XNodeInfo attributeUO = new XNodeInfo(XNodeInfo.Type.ATTRIBUTE, new Object[]{mbean, mBeanFeatureInfo}, mBeanFeatureInfo.getName(), null);
                    attribute.setUserObject(attributeUO);
                    attribute.setAllowsChildren(false);
                    attributes.add(attribute);
                }
            }
            if (oi != null && oi.length > 0) {
                DefaultMutableTreeNode operations = new DefaultMutableTreeNode();
                XNodeInfo operationsUO = new XNodeInfo(XNodeInfo.Type.OPERATIONS, mbean, Messages.OPERATIONS, null);
                operations.setUserObject(operationsUO);
                node.insert(operations, childIndex++);
                for (MBeanFeatureInfo mBeanFeatureInfo : oi) {
                    StringBuilder sb = new StringBuilder();
                    for (MBeanParameterInfo mbpi : ((MBeanOperationInfo)mBeanFeatureInfo).getSignature()) {
                        sb.append(mbpi.getType() + ",");
                    }
                    String signature = sb.toString();
                    if (signature.length() > 0) {
                        signature = signature.substring(0, signature.length() - 1);
                    }
                    String toolTipText = mBeanFeatureInfo.getName() + "(" + signature + ")";
                    DefaultMutableTreeNode operation = new DefaultMutableTreeNode();
                    XNodeInfo operationUO = new XNodeInfo(XNodeInfo.Type.OPERATION, new Object[]{mbean, mBeanFeatureInfo}, mBeanFeatureInfo.getName(), toolTipText);
                    operation.setUserObject(operationUO);
                    operation.setAllowsChildren(false);
                    operations.add(operation);
                }
            }
            if (isBroadcaster != null && isBroadcaster.booleanValue()) {
                DefaultMutableTreeNode notifications = new DefaultMutableTreeNode();
                XNodeInfo notificationsUO = new XNodeInfo(XNodeInfo.Type.NOTIFICATIONS, mbean, Messages.NOTIFICATIONS, null);
                notifications.setUserObject(notificationsUO);
                node.insert(notifications, childIndex++);
                if (ni != null && ni.length > 0) {
                    for (MBeanFeatureInfo mBeanFeatureInfo : ni) {
                        DefaultMutableTreeNode notification = new DefaultMutableTreeNode();
                        XNodeInfo notificationUO = new XNodeInfo(XNodeInfo.Type.NOTIFICATION, mBeanFeatureInfo, mBeanFeatureInfo.getName(), null);
                        notification.setUserObject(notificationUO);
                        notification.setAllowsChildren(false);
                        notifications.add(notification);
                    }
                }
            }
            this.model.reload(node);
        }
    }
}

