/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    private static HTMLTransfer _instance = new HTMLTransfer();
    private static final String TEXT_HTML = "text/html";
    private static final int TEXT_HTML_ID = HTMLTransfer.registerType("text/html");
    private static final String TEXT_HTML2 = "TEXT/HTML";
    private static final int TEXT_HTML2_ID = HTMLTransfer.registerType("TEXT/HTML");

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        String string;
        byte[] byArray;
        int n;
        long l;
        transferData.result = 0;
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((l = OS.g_malloc(n = (byArray = Converter.wcsToMbcs(null, string = (String)object, true)).length)) == 0L) {
            return;
        }
        OS.memmove(l, byArray, (long)n);
        transferData.length = n;
        transferData.format = 8;
        transferData.pValue = l;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        String string;
        Object[] objectArray;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        int n = transferData.format * transferData.length / 8 / 2 * 2;
        if (n <= 0) {
            return null;
        }
        char[] cArray = new char[1];
        if (n > 1) {
            OS.memmove(cArray, transferData.pValue, 2L);
        }
        if (cArray[0] == '\ufeff' || cArray[0] == '\ufffe') {
            objectArray = new char[n / 2];
            OS.memmove(objectArray, transferData.pValue, (long)n);
            string = new String((char[])objectArray);
        } else {
            objectArray = new byte[n];
            OS.memmove((byte[])objectArray, transferData.pValue, (long)n);
            char[] cArray2 = Converter.mbcsToWcs(null, (byte[])objectArray);
            string = new String(cArray2);
        }
        int n2 = string.indexOf(0);
        return n2 == -1 ? string : string.substring(0, n2);
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TEXT_HTML_ID, TEXT_HTML2_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TEXT_HTML, TEXT_HTML2};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

