/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Bib2GlsIndex;
import com.dickimawbooks.bib2gls.GlsRecord;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GlsSeeRecord;
import com.dickimawbooks.bib2gls.SortSettings;
import com.dickimawbooks.bib2gls.SupplementalRecord;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.bib.Contributor;
import com.dickimawbooks.texparserlib.latex.CsvList;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.CollationKey;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bib2GlsEntry
extends BibEntry {
    private Vector<GlsRecord> records;
    private HashMap<String, Vector<GlsRecord>> recordMap;
    private Vector<GlsRecord> ignoredRecords;
    private Vector<GlsRecord> supplementalRecords;
    private HashMap<TeXPath, Vector<GlsRecord>> supplementalRecordMap;
    private Vector<GlsRecord> primaryRecords = null;
    private boolean selected = false;
    private String base = "";
    private String originalEntryType;
    private Vector<Bib2GlsEntry> children;
    private HashMap<String, String> fieldValues;
    private Vector<String> deps;
    private Vector<Bib2GlsEntry> hierarchy;
    private Vector<Bib2GlsEntry> crossRefdBy;
    private BibValueList orgParentValue = null;
    private String crossRefTag = null;
    private String[] crossRefs = null;
    private String[] alsocrossRefs = null;
    public static final int NO_SEE = 0;
    public static final int PRE_SEE = 1;
    public static final int POST_SEE = 2;
    protected Bib2Gls bib2gls;
    protected GlsResource resource;
    private CollationKey collationKey;
    private String groupId = null;
    private String labelPrefix = null;
    private String labelSuffix;
    private Bib2GlsEntry dual = null;
    private Number numericSort = null;
    private Object sortObject = null;
    private boolean fieldsParsed = false;
    private boolean triggerRecordFound = false;
    private Vector<String> locationList = null;
    private GlsRecord indexCounterRecord = null;
    private static final Pattern EXT_PREFIX_PATTERN = Pattern.compile("ext(\\d+)\\.(.*)");
    private static final Pattern RANGE_PATTERN = Pattern.compile("(\\(|\\))(.*)");

    public Bib2GlsEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "entry");
    }

    public Bib2GlsEntry(Bib2Gls bib2Gls, String string) {
        super(string.toLowerCase());
        this.bib2gls = bib2Gls;
        this.originalEntryType = string;
        this.resource = bib2Gls.getCurrentResource();
        this.labelPrefix = this.resource.getLabelPrefix();
        this.fieldValues = new HashMap();
        this.deps = new Vector();
        String[] stringArray = this.resource.getLocationCounters();
        if (stringArray == null) {
            this.records = new Vector();
        } else {
            this.recordMap = new HashMap(stringArray.length);
            for (String string2 : stringArray) {
                this.recordMap.put(string2, new Vector());
            }
        }
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String string) {
        this.base = string != null && string.endsWith(".bib") ? string.substring(0, string.length() - 4) : string;
    }

    public void setDual(Bib2GlsEntry bib2GlsEntry) {
        this.dual = bib2GlsEntry;
    }

    public Bib2GlsEntry getDual() {
        return this.dual;
    }

    public GlsResource getResource() {
        return this.resource;
    }

    public String getPrefix() {
        return this.labelPrefix;
    }

    public String getSuffix() {
        return this.labelSuffix;
    }

    public void setSuffix(String string) {
        this.labelSuffix = string;
    }

    @Override
    public String getId() {
        String string = super.getId();
        if (string == null) {
            return this.bib2gls.getMessage("message.missing.id", new Object[0]);
        }
        if (this.labelPrefix == null && this.labelSuffix == null) {
            return string;
        }
        if (this.labelPrefix == null) {
            return string + this.labelSuffix;
        }
        if (this.labelSuffix == null) {
            return this.labelPrefix + string;
        }
        return this.labelPrefix + string + this.labelSuffix;
    }

    public String getOriginalId() {
        return super.getId();
    }

    public void setId(String string, String string2) {
        this.labelPrefix = string;
        this.setId(string2);
    }

    public void setOriginalEntryType(String string) {
        this.originalEntryType = string;
    }

    public String getOriginalEntryType() {
        return this.originalEntryType;
    }

    public String processLabel(String string) {
        return this.processLabel(string, false);
    }

    public String processLabel(String string, boolean bl) {
        block19: {
            if (string.startsWith("dual.")) {
                String string2 = this.resource.getDualPrefix();
                if (string2 == null) {
                    string = string.substring(5);
                } else if (!string2.equals("dual.")) {
                    string = String.format("%s%s", string2, string.substring(5));
                }
            } else if (string.startsWith("tertiary.")) {
                String string3 = this.resource.getTertiaryPrefix();
                if (string3 == null) {
                    string = string.substring(9);
                } else if (!string3.equals("tertiary.")) {
                    string = String.format("%s%s", string3, string.substring(5));
                }
            } else {
                Matcher matcher = EXT_PREFIX_PATTERN.matcher(string);
                if (matcher.matches()) {
                    try {
                        String string4 = this.resource.getExternalPrefix(Integer.parseInt(matcher.group(1)));
                        if (string4 == null) {
                            string = matcher.group(2);
                            break block19;
                        }
                        string = String.format("%s%s", string4, matcher.group(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bib2gls.debug(numberFormatException);
                    }
                } else if (bl) {
                    String string5 = this.resource.getCsLabelPrefix();
                    if (string5 != null) {
                        string = String.format("%s%s", this.resource.getCsLabelPrefix(), string);
                    }
                } else if (this.labelPrefix != null) {
                    string = String.format("%s%s", this.labelPrefix, string);
                }
            }
        }
        return string;
    }

    private boolean isGlsCsOptLabel(String string) {
        block9: {
            block8: {
                if (string.equals("gls") || string.equals("glspl") || string.equals("acrfull") || string.equals("acrlong") || string.equals("acrshort") || string.equals("acrfullpl") || string.equals("acrlongpl") || string.equals("acrshortpl") || string.equals("cgls") || string.equals("cglspl") || string.equals("pgls") || string.equals("pglspl") || string.equals("glsadd") || string.equals("glsdisp") || string.equals("glslink") || string.equals("glsxtrfull") || string.equals("glsxtrfullpl") || string.equals("glsxtrshort") || string.equals("glsxtrshortpl") || string.equals("glsxtrlong") || string.equals("glsxtrlongpl") || string.equals("glsps") || string.equals("glspt") || string.equals("glshyperlink")) {
                    if (string.startsWith("acr")) {
                        this.bib2gls.warningMessage("warning.deprecated.cs", string, "glsxtr" + string.substring(3));
                    }
                    return true;
                }
                if (this.bib2gls.checkAcroShortcuts() && (string.equals("ac") || string.equals("acs") || string.equals("acsp") || string.equals("acl") || string.equals("aclp") || string.equals("acf") || string.equals("acfp"))) {
                    return true;
                }
                if (this.bib2gls.checkAbbrvShortcuts() && (string.equals("ab") || string.equals("abp") || string.equals("as") || string.equals("asp") || string.equals("al") || string.equals("alp") || string.equals("af") || string.equals("afp"))) {
                    return true;
                }
                if (!string.startsWith("glsxtr")) break block8;
                Vector<String> vector = this.bib2gls.getFields();
                HashMap<String, String> hashMap = this.bib2gls.getFieldMap();
                for (String string2 : vector) {
                    if (string.equals("glsxtr" + string2)) {
                        return true;
                    }
                    String string3 = hashMap.get(string2);
                    if (string3 == null || !string.equals("glsxtr" + string3)) continue;
                    return true;
                }
                break block9;
            }
            if (!string.startsWith("gls")) break block9;
            Vector<String> vector = this.bib2gls.getFields();
            HashMap<String, String> hashMap = this.bib2gls.getFieldMap();
            for (String string4 : vector) {
                if (string.equals("gls" + string4)) {
                    return true;
                }
                String string5 = hashMap.get(string4);
                if (string5 == null || !string.equals("gls" + string5)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCsProblematic(String string) {
        return string.equals("foreignlanguage") || string.equals("textcolor") || string.equals("ensuremath") || string.equals("cite") || string.equals("citep") || string.equals("citet") || string.equals("autoref") || string.equals("cref") || string.equals("ref");
    }

    private void checkGlsCs(TeXParser teXParser, TeXObjectList teXObjectList, boolean bl, String string) throws IOException {
        for (int i = 0; i < teXObjectList.size(); ++i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject.isPar() || teXObject instanceof TeXCsRef && ((TeXCsRef)teXObject).getName().equals("par")) {
                teXObjectList.set(i, new TeXCsRef("glspar"));
                continue;
            }
            if (teXObject instanceof TeXCsRef) {
                String string2 = ((TeXCsRef)teXObject).getName();
                String string3 = this.bib2gls.getGlsLikePrefix(string2);
                boolean bl2 = false;
                string2 = string2.toLowerCase();
                boolean bl3 = string3 != null || string2.matches("dgls(pl)?");
                try {
                    Object object;
                    String string4;
                    String string5;
                    TeXObject teXObject2;
                    if (string2.equals("glssee") || string2.equals("glsxtrindexseealso")) {
                        int n;
                        bl2 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        if (teXObject2 instanceof CharObject && (n = ((CharObject)teXObject2).getCharCode()) == 91) {
                            while (i < teXObjectList.size()) {
                                teXObject2 = (TeXObject)teXObjectList.get(i);
                                if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 93) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                    break;
                                }
                                ++i;
                            }
                            while (teXObject2 instanceof Ignoreable) {
                                teXObject2 = (TeXObject)teXObjectList.get(++i);
                            }
                        }
                        if (teXObject2 instanceof Group) {
                            teXObject2 = ((Group)teXObject2).toList();
                        }
                        if (!(string5 = this.processLabel(string4 = teXObject2.toString(teXParser), true)).equals(string4)) {
                            string4 = string5;
                            teXObjectList.set(i, teXParser.getListener().createGroup(string4));
                        }
                        if (this.bib2gls.getVerboseLevel() > 0) {
                            this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), teXObject.toString(teXParser), string4));
                        }
                        this.addDependency(string4);
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        object = teXParser.getListener().createGroup();
                        CsvList csvList = CsvList.getList(teXParser, teXObject2);
                        int n2 = csvList.size() - 1;
                        for (int j = 0; j <= n2; ++j) {
                            TeXObject teXObject3 = (TeXObject)csvList.get(j);
                            string4 = this.processLabel(teXObject3.toString(teXParser), true);
                            ((TeXObjectList)object).add(teXParser.getListener().createString(string4));
                            if (j < n2) {
                                ((TeXObjectList)object).add(teXParser.getListener().getOther(44));
                            }
                            if (this.bib2gls.getVerboseLevel() > 0) {
                                this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), teXObject.toString(teXParser), string4));
                            }
                            this.addDependency(string4);
                        }
                        teXObjectList.set(i, object);
                    } else if (string2.equals("glsxtrp")) {
                        bl2 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        if (teXObject2 instanceof Group) {
                            teXObject2 = ((Group)teXObject2).toList();
                        }
                        if (!(string4 = teXObject2.toString(teXParser)).equals(string5 = this.processLabel(string4, true))) {
                            string4 = string5;
                            teXObjectList.set(i, teXParser.getListener().createGroup(string4));
                        }
                        if (this.bib2gls.getVerboseLevel() > 0) {
                            this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), teXObject.toString(teXParser), string4));
                        }
                        this.addDependency(string4);
                    } else if (this.isGlsCsOptLabel(string2) || bl3) {
                        bl2 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        string4 = "";
                        string5 = "";
                        if (teXObject2 instanceof CharObject) {
                            int n = ((CharObject)teXObject2).getCharCode();
                            if (n == 42 || n == 43 || n == this.bib2gls.getAltModifier()) {
                                string4 = teXObject2.toString(teXParser);
                                teXObject2 = (TeXObject)teXObjectList.get(++i);
                                while (teXObject2 instanceof Ignoreable) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                }
                                if (teXObject2 instanceof CharObject) {
                                    n = ((CharObject)teXObject2).getCharCode();
                                }
                            }
                            if (n == 91) {
                                string5 = "[";
                                while (i < teXObjectList.size()) {
                                    teXObject2 = (TeXObject)teXObjectList.get(i);
                                    string5 = string5 + teXObject2.toString(teXParser);
                                    if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 93) {
                                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                                        break;
                                    }
                                    ++i;
                                }
                                while (teXObject2 instanceof Ignoreable) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                }
                            }
                        }
                        int n = i;
                        if (teXObject2 instanceof BgChar) {
                            object = "";
                            while (!((teXObject2 = (TeXObject)teXObjectList.get(++i)) instanceof EgChar)) {
                                object = (String)object + teXObject2.toString(teXParser);
                            }
                        } else {
                            object = teXObject2 instanceof Group ? ((Group)teXObject2).toList().toString(teXParser) : teXObject2.toString(teXParser);
                        }
                        if (!bl3) {
                            String string6 = this.processLabel((String)object, true);
                            if (!((String)object).equals(string6)) {
                                object = string6;
                                while (i > n) {
                                    teXObjectList.remove(i);
                                    --i;
                                }
                                teXObjectList.set(i, teXParser.getListener().createGroup((String)object));
                            }
                        } else if (string3 != null) {
                            object = string3 + (String)object;
                        }
                        if (this.bib2gls.getVerboseLevel() > 0) {
                            this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), teXObject.toString(teXParser), object));
                        }
                        this.addDependency((String)object);
                        if (this.bib2gls.checkNestedLinkTextField(string) && !string2.equals("glsps") && !string2.equals("glspt")) {
                            this.bib2gls.warning(teXParser, this.bib2gls.getMessage("warning.potential.nested.link", this.getId(), string, String.format("\\%s%s%s", ((TeXCsRef)teXObject).getName(), string4, string5), object));
                        }
                    } else if (this.isCsProblematic(string2)) {
                        bl2 = i == 0;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.bib2gls.warning(teXParser, this.bib2gls.getMessage("warning.can.find.arg", string2));
                }
                if (!bl2 || !bl) continue;
                this.bib2gls.verbose(teXParser, this.bib2gls.getMessage("message.uc.protecting", teXObject.toString(teXParser)));
                teXObjectList.add(0, teXParser.getListener().createGroup());
                ++i;
                continue;
            }
            if (!(teXObject instanceof TeXObjectList)) continue;
            if (teXObject instanceof MathGroup && i == 0 && bl && this.bib2gls.mfirstucMathShiftProtection()) {
                this.bib2gls.verbose(teXParser, this.bib2gls.getMessage("message.uc.protecting", teXObject.toString(teXParser)));
                teXObjectList.add(0, teXParser.getListener().createGroup());
                ++i;
            }
            this.checkGlsCs(teXParser, (TeXObjectList)teXObject, false, string);
        }
    }

    protected boolean fieldsParsed() {
        return this.fieldsParsed;
    }

    @Override
    public boolean checkField(String string) throws BibTeXSyntaxException {
        if (this.bib2gls.isCheckNonBibFieldsOn() && this.bib2gls.isNonBibField(string)) {
            this.bib2gls.warningMessage("warning.non_bib_field", string, this.base == null ? "" : this.base, this.getOriginalId());
        }
        return true;
    }

    public void parseFields(TeXParser teXParser) throws IOException {
        String string;
        Object object;
        Object object2;
        Object object3;
        BibValueList bibValueList;
        BibValueList bibValueList2;
        BibValueList bibValueList3;
        BibValueList bibValueList4;
        BibValueList bibValueList5;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        if (this.fieldsParsed) {
            return;
        }
        this.fieldsParsed = true;
        if (this.resource.hasFieldAliases()) {
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.field.alias.check", this.getOriginalId()));
            }
            object7 = this.resource.getFieldAliasesIterator();
            while (object7.hasNext()) {
                object6 = (String)object7.next();
                object5 = this.resource.getFieldAlias((String)object6);
                object4 = this.removeField((String)object6);
                if (object4 == null) continue;
                TeXObjectList teXObjectList = ((BibValueList)object4).expand(teXParser);
                BibUserString bibUserString = new BibUserString(teXObjectList);
                ((Vector)object4).clear();
                ((Vector)object4).add(bibUserString);
                this.putField((String)object5, (BibValueList)object4);
                if (this.bib2gls.getVerboseLevel() <= 0) continue;
                this.bib2gls.logMessage((String)object6 + "=>" + (String)object5 + "={" + teXObjectList.toString(teXParser) + "}");
            }
        }
        if ((object7 = this.resource.getSaveOriginalIdField()) != null && this.bib2gls.isKnownField((String)object7)) {
            object6 = new BibUserString(teXParser.getListener().createString(this.getOriginalId()));
            object5 = new BibValueList();
            ((Vector)object5).add(object6);
            this.putField((String)object7, (BibValueList)object5);
            this.putField((String)object7, this.getOriginalId());
        }
        object6 = this.bib2gls.getFields();
        if (this.resource.hasSkippedFields()) {
            for (Object object8 : object5 = this.resource.getSkipFields()) {
                this.removeField((String)object8);
            }
        }
        if (this.resource.isCreateMissingParentsEnabled()) {
            this.orgParentValue = this.getField("parent");
            if (this.orgParentValue != null) {
                object5 = this.orgParentValue.expand(teXParser);
                this.orgParentValue = new BibValueList();
                this.orgParentValue.add(new BibUserString((TeXObjectList)((TeXObjectList)object5).clone()));
            }
        }
        boolean bl = this.bib2gls.mfirstucProtection();
        object4 = this.bib2gls.mfirstucProtectionFields();
        if (this.resource.changeShortCase() && (bibValueList5 = this.getField("short")) != null) {
            TeXObjectList teXObjectList = bibValueList5.expand(teXParser);
            this.putField("short", this.resource.applyShortCaseChange(teXParser, bibValueList5));
        }
        if (this.resource.changeLongCase() && (bibValueList4 = this.getField("long")) != null) {
            TeXObjectList teXObjectList = bibValueList4.expand(teXParser);
            this.putField("long", this.resource.applyLongCaseChange(teXParser, bibValueList4));
        }
        if (this.resource.changeDescriptionCase() && (bibValueList3 = this.getField("description")) != null) {
            this.putField("description", this.resource.applyDescriptionCaseChange(teXParser, bibValueList3));
        }
        if (this.resource.changeDualShortCase() && (bibValueList2 = this.getField("dualshort")) != null) {
            this.putField("dualshort", this.resource.applyShortCaseChange(teXParser, bibValueList2));
        }
        if (this.resource.changeDualLongCase() && (bibValueList = this.getField("duallong")) != null) {
            this.putField("duallong", this.resource.applyLongCaseChange(teXParser, bibValueList));
        }
        String string2 = this.resource.getShortPluralSuffix();
        String string3 = this.resource.getDualShortPluralSuffix();
        this.appendShortPluralSuffix(teXParser, "short", "shortplural", string2);
        this.appendShortPluralSuffix(teXParser, "dualshort", "dualshortplural", string3);
        if (this.resource.hasFieldCopies()) {
            boolean bl2 = this.resource.isReplicateOverrideOn();
            byte by = this.resource.getFallbackOnMissingReplicateAction();
            boolean bl3 = false;
            boolean bl4 = false;
            object3 = this.resource.getFieldCopiesIterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = this.getField((String)object2);
                if (object == null) {
                    if (by == 1) {
                        object = this.getFallbackContents((String)object2);
                    } else if (by == 2) {
                        object = new BibValueList();
                    }
                }
                if (object == null) continue;
                Vector<String> vector = this.resource.getFieldCopy((String)object2);
                for (String string4 : vector) {
                    if (this.getField(string4) != null && !bl2) continue;
                    BibValueList bibValueList6 = (BibValueList)((BibValueList)object).clone();
                    if (string4.equals("description") && this.resource.changeDescriptionCase()) {
                        bibValueList6 = this.resource.applyDescriptionCaseChange(teXParser, bibValueList6);
                    } else if (string4.equals("short")) {
                        if (this.resource.changeShortCase()) {
                            bibValueList6 = this.resource.applyShortCaseChange(teXParser, bibValueList6);
                        }
                        if (string2 != null) {
                            bl3 = true;
                        }
                    } else if (string4.equals("long")) {
                        if (this.resource.changeLongCase()) {
                            bibValueList6 = this.resource.applyLongCaseChange(teXParser, bibValueList6);
                        }
                    } else if (string4.equals("dualshort")) {
                        if (this.resource.changeDualShortCase()) {
                            bibValueList6 = this.resource.applyShortCaseChange(teXParser, bibValueList6);
                        }
                        if (string3 != null) {
                            bl4 = true;
                        }
                    } else if (string4.equals("duallong") && this.resource.changeDualLongCase()) {
                        bibValueList6 = this.resource.applyLongCaseChange(teXParser, bibValueList6);
                    }
                    this.putField(string4, bibValueList6);
                }
            }
            if (bl3) {
                this.appendShortPluralSuffix(teXParser, "short", "shortplural", string2);
            }
            if (bl4) {
                this.appendShortPluralSuffix(teXParser, "dualshort", "dualshortplural", string3);
            }
        }
        if ((string = this.resource.getGroupField()) != null) {
            this.putField("group", string);
        }
        Vector<String> vector = null;
        Iterator iterator = ((Vector)object6).iterator();
        while (iterator.hasNext()) {
            CharObject charObject;
            Object object9;
            int n;
            boolean bl5;
            String string5 = (String)iterator.next();
            object3 = this.getField(string5);
            if (object3 == null || string5.equals(object7)) continue;
            object2 = ((BibValueList)object3).expand(teXParser);
            if (((Vector)object3).size() > 1 || !(((Vector)object3).firstElement() instanceof BibUserString)) {
                object = new BibUserString((TeXObject)object2);
                ((Vector)object3).clear();
                ((Vector)object3).add(object);
            }
            if (this.resource.isBibTeXAuthorField(string5)) {
                object2 = this.convertBibTeXAuthorField(teXParser, string5, (BibValueList)object3);
                ((Vector)object3).clear();
                ((Vector)object3).add(new BibUserString((TeXObject)object2));
            }
            if ((object = this.resource.getFieldEncap(string5)) != null) {
                Group group = teXParser.getListener().createGroup();
                group.addAll(object2);
                ((Vector)object2).clear();
                ((TeXObjectList)object2).add(new TeXCsRef((String)object));
                ((TeXObjectList)object2).add(group);
                ((Vector)object3).clear();
                ((Vector)object3).add(new BibUserString((TeXObject)object2));
            }
            if ((object = this.resource.getFieldEncapIncLabel(string5)) != null) {
                Group group = teXParser.getListener().createGroup();
                group.addAll(object2);
                ((Vector)object2).clear();
                ((TeXObjectList)object2).add(new TeXCsRef((String)object));
                ((TeXObjectList)object2).add(group);
                ((TeXObjectList)object2).add(teXParser.getListener().createGroup(this.getId()));
                ((Vector)object3).clear();
                ((Vector)object3).add(new BibUserString((TeXObject)object2));
            }
            if (this.resource.isInterpretField(string5)) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.add(string5);
            }
            if ((bl5 = this.resource.isLabelifyListField(string5)) || this.resource.isLabelifyField(string5)) {
                String string6 = this.bib2gls.convertToLabel(teXParser, (BibValueList)object3, this.resource, bl5);
                object2 = teXParser.getListener().createString(string6);
                ((Vector)object3).clear();
                ((Vector)object3).add(new BibUserString((TeXObject)object2));
                this.putField(string5, string6);
            }
            if (this.resource.isDependencyListField(string5)) {
                this.parseCustomDependencyList(teXParser, (TeXObjectList)object2, string5);
            }
            if (string5.equals("parent") || string5.equals("category") || string5.equals("type") || string5.equals("group") || string5.equals("seealso") || string5.equals("alias")) {
                String string7 = ((TeXObjectList)object2).toString(teXParser);
                if (this.resource.isInterpretLabelFieldsEnabled() && string7.matches("(?s).*[\\\\\\{\\}].*")) {
                    string7 = this.bib2gls.interpret(string7, (BibValueList)object3, true);
                }
                if (string5.equals("parent")) {
                    this.putField(string5, this.processLabel(string7));
                    continue;
                }
                this.putField(string5, string7);
                continue;
            }
            if (!this.bib2gls.isKnownField(string5)) continue;
            boolean bl6 = bl;
            if (bl6 && object4 != null) {
                bl6 = false;
                Object object10 = object4;
                n = ((Object)object10).length;
                for (int i = 0; i < n; ++i) {
                    object9 = object10[i];
                    if (!((String)object9).equals(string5)) continue;
                    bl6 = true;
                    break;
                }
            }
            this.checkGlsCs(teXParser, (TeXObjectList)object2, bl6, string5);
            if (string5.equals("description")) {
                if (this.resource.isStripTrailingNoPostOn()) {
                    int n2 = ((Vector)object2).size();
                    for (n = n2 - 1; n >= 0; --n) {
                        TeXObject teXObject = (TeXObject)((Vector)object2).get(n);
                        if (!(teXObject instanceof Ignoreable)) {
                            if (!(teXObject instanceof ControlSequence) || !((String)(object9 = ((ControlSequence)teXObject).getName())).equals("nopostdesc") && !((String)object9).equals("glsxtrnopostpunc")) break;
                            ((Vector)object2).remove(n);
                            break;
                        }
                        ((Vector)object2).remove(n);
                    }
                }
                block0 : switch (this.resource.getPostDescDot()) {
                    case 1: {
                        ((TeXObjectList)object2).add(teXParser.getListener().getOther(46));
                        break;
                    }
                    case 2: {
                        int n3 = ((Vector)object2).size();
                        for (n = n3 - 1; n >= 0; --n) {
                            TeXObject teXObject = (TeXObject)((Vector)object2).get(n);
                            if (teXObject instanceof CharObject) {
                                int n4 = ((CharObject)teXObject).getCharCode();
                                int n5 = Character.getType(n4);
                                if (n5 == 22 || n5 == 30) continue;
                                if (n5 == 24) break block0;
                                ((TeXObjectList)object2).add(teXParser.getListener().getOther(46));
                                break block0;
                            }
                            if (teXObject instanceof ControlSequence && (((ControlSequence)teXObject).getName().equals("nopostdesc") || ((ControlSequence)teXObject).getName().equals("glsxtrnopostpunc"))) break block0;
                            if (teXObject instanceof Ignoreable) continue;
                            ((TeXObjectList)object2).add(teXParser.getListener().getOther(46));
                            break block0;
                        }
                        break;
                    }
                }
            }
            if (this.resource.isCheckEndPuncOn(string5) && (charObject = this.getEndPunc((TeXObjectList)object2)) != null) {
                this.putField(string5 + "endpunc", charObject.toString(teXParser));
            }
            this.putField(string5, ((TeXObjectList)object2).toString(teXParser));
        }
        if (this.resource.changeNameCase()) {
            this.changeNameCase(teXParser);
        }
        if (this.resource.isCopyAliasToSeeEnabled() && (iterator = this.getField("alias")) != null) {
            BibValueList bibValueList7 = this.getField("see");
            if (bibValueList7 == null) {
                this.putField("see", (BibValueList)((Object)iterator));
            } else {
                object3 = bibValueList7.expand(teXParser);
                ((TeXObjectList)object3).add(teXParser.getListener().getOther(44));
                ((Vector)object3).addAll(((BibValueList)((Object)iterator)).expand(teXParser));
            }
        }
        this.changeFieldCase(teXParser);
        if (vector != null) {
            for (String string8 : vector) {
                String string9;
                object3 = this.getField(string8);
                object2 = ((BibValueList)object3).expand(teXParser);
                object = ((TeXObjectList)object2).toString(teXParser);
                if (((String)object).equals(string9 = Bib2Gls.replaceSpecialChars(this.bib2gls.interpret((String)object, (BibValueList)object3, this.bib2gls.trimFields())))) continue;
                ((Vector)object2).clear();
                ((Vector)object2).addAll(teXParser.getListener().createString(string9));
                ((Vector)object3).clear();
                ((Vector)object3).add(new BibUserString((TeXObject)object2));
            }
        }
    }

    protected void appendShortPluralSuffix(TeXParser teXParser, String string, String string2, String string3) throws IOException {
        if (string3 == null || string3.isEmpty()) {
            return;
        }
        BibValueList bibValueList = this.getField(string2);
        if (bibValueList != null) {
            return;
        }
        bibValueList = this.getField(string);
        if (bibValueList == null) {
            return;
        }
        TeXObjectList teXObjectList = (TeXObjectList)bibValueList.getContents(true);
        BibValueList bibValueList2 = new BibValueList();
        if (teXObjectList != null) {
            bibValueList2.add(new BibUserString(teXObjectList));
        }
        bibValueList2.add(new BibUserString(teXParser.getListener().createString(string3)));
        this.putField(string2, bibValueList2);
    }

    protected void changeNameCase(TeXParser teXParser) throws IOException {
        BibValueList bibValueList;
        BibValueList bibValueList2 = this.getField("name");
        if (bibValueList2 == null) {
            bibValueList2 = this.getFallbackContents("name");
            if (bibValueList2 == null) {
                return;
            }
            bibValueList2 = (BibValueList)bibValueList2.clone();
        }
        if ((bibValueList = this.getField("text")) == null) {
            this.putField("text", bibValueList2);
            this.putField("text", bibValueList2.expand(teXParser).toString(teXParser));
        }
        bibValueList2 = this.resource.applyNameCaseChange(teXParser, bibValueList2);
        TeXObjectList teXObjectList = BibValueList.stripDelim(bibValueList2.expand(teXParser));
        this.putField("name", bibValueList2);
        this.putField("name", teXObjectList.toString(teXParser));
    }

    protected void changeFieldCase(TeXParser teXParser) throws IOException {
        HashMap<String, String> hashMap = this.resource.getFieldCaseOptions();
        if (hashMap == null) {
            return;
        }
        for (String string : hashMap.keySet()) {
            String string2 = hashMap.get(string);
            if (string2.equals("none")) continue;
            this.changeFieldCase(teXParser, string, string2);
        }
    }

    protected void changeFieldCase(TeXParser teXParser, String string, String string2) throws IOException {
        BibValueList bibValueList = this.getField(string);
        if (bibValueList == null) {
            bibValueList = this.getFallbackContents(string);
            if (bibValueList == null) {
                return;
            }
            bibValueList = (BibValueList)bibValueList.clone();
        }
        bibValueList = this.resource.applyCaseChange(teXParser, bibValueList, string2);
        TeXObjectList teXObjectList = BibValueList.stripDelim(bibValueList.expand(teXParser));
        this.putField(string, bibValueList);
        this.putField(string, teXObjectList.toString(teXParser));
    }

    public void convertFieldToDateTime(TeXParser teXParser, String string, String string2, Locale locale, boolean bl, boolean bl2) throws IOException {
        Group group;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Date date;
        String string3 = this.getId();
        this.bib2gls.debugMessage("message.datetime.field.check", string3, string, bl, bl2);
        BibValueList bibValueList = this.getField(string);
        if (bibValueList == null) {
            this.bib2gls.debugMessage("message.field.notset", string, string3);
            return;
        }
        String string4 = this.getFieldValue(string);
        TeXObjectList teXObjectList = (TeXObjectList)bibValueList.expand(teXParser).clone();
        String string5 = string4;
        if (this.bib2gls.useInterpreter() && string4.matches("(?s).*[\\\\\\$\\{\\}\\~].*")) {
            string4 = this.bib2gls.interpret(string4, bibValueList, true);
        }
        DateFormat dateFormat = SortSettings.getDateFormat(locale, string2, bl, bl2);
        try {
            date = dateFormat.parse(string4);
        }
        catch (ParseException parseException) {
            if (dateFormat instanceof SimpleDateFormat) {
                this.bib2gls.warningMessage("warning.cant.parse.datetime.pattern", string, string3, ((SimpleDateFormat)dateFormat).toPattern());
            } else {
                this.bib2gls.warningMessage("warning.cant.parse.datetime.pattern", string, string3, string2);
            }
            this.bib2gls.debug(parseException);
            return;
        }
        Calendar calendar = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        calendar.setTime(date);
        TeXObjectList teXObjectList2 = new TeXObjectList();
        TeXParserListener teXParserListener = teXParser.getListener();
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            if (bl2) {
                teXObjectList2.add(new TeXCsRef("bibglsdatetime"));
                stringBuilder.append("\\bibglsdatetime");
            } else {
                teXObjectList2.add(new TeXCsRef("bibglsdate"));
                stringBuilder.append("\\bibglsdate");
            }
            n6 = calendar.get(1);
            n5 = calendar.get(2) + 1;
            n4 = calendar.get(5);
            n3 = calendar.get(7);
            n2 = calendar.get(6);
            n = calendar.get(0);
            switch (n3) {
                case 2: {
                    n3 = 0;
                    break;
                }
                case 3: {
                    n3 = 1;
                    break;
                }
                case 4: {
                    n3 = 2;
                    break;
                }
                case 5: {
                    n3 = 3;
                    break;
                }
                case 6: {
                    n3 = 4;
                    break;
                }
                case 7: {
                    n3 = 5;
                    break;
                }
                case 1: {
                    n3 = 6;
                }
            }
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n6));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n5));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n4));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n3));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n2));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n));
            stringBuilder.append(String.format("{%d}{%d}{%d}{%d}{%d}{%d}", n6, n5, n4, n3, n2, n));
        } else {
            teXObjectList2.add(new TeXCsRef("bibglstime"));
            stringBuilder.append("\\bibglstime");
        }
        if (bl2) {
            n6 = calendar.get(11);
            n5 = calendar.get(12);
            n4 = calendar.get(13);
            n3 = calendar.get(14);
            n2 = calendar.get(16);
            n = calendar.get(15);
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n6));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n5));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n4));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n3));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n2));
            group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(new UserNumber(n));
            stringBuilder.append(String.format("{%d}{%d}{%d}{%d}{%d}{%d}", n6, n5, n4, n3, n2, n));
        }
        group = teXParserListener.createGroup();
        group.addAll(teXObjectList);
        stringBuilder.append(String.format("{%s}", string5));
        bibValueList.clear();
        bibValueList.add(new BibUserString(teXObjectList2));
        this.putField(string, bibValueList);
        this.putField(string, stringBuilder.toString());
    }

    protected TeXObjectList convertBibTeXAuthorField(TeXParser teXParser, String string, BibValueList bibValueList) throws IOException {
        Vector<Contributor> vector = Bib2GlsEntry.parseContributors(teXParser, bibValueList);
        int n = vector.size();
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("bibglscontributorlist"));
        Group group = teXParserListener.createGroup();
        teXObjectList.add(group);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                group.add(teXParserListener.getOther(44));
            }
            Contributor contributor = vector.get(i);
            String string2 = contributor.getForenames();
            String string3 = contributor.getVonPart();
            String string4 = contributor.getSurname();
            String string5 = contributor.getSuffix();
            group.add(new TeXCsRef("bibglscontributor"));
            if (string2 == null) {
                group.add(teXParserListener.createGroup());
            } else {
                group.add(teXParserListener.createGroup(string2.trim()));
            }
            if (string3 == null) {
                group.add(teXParserListener.createGroup());
            } else {
                group.add(teXParserListener.createGroup(string3.trim()));
            }
            if (string4 == null) {
                group.add(teXParserListener.createGroup());
            } else {
                group.add(teXParserListener.createGroup(string4.trim()));
            }
            if (string5 == null) {
                group.add(teXParserListener.createGroup());
                continue;
            }
            group.add(teXParserListener.createGroup(string5.trim()));
        }
        teXObjectList.add(teXParserListener.createGroup(String.format("%d", n)));
        return teXObjectList;
    }

    protected boolean isSentenceTerminator(int n) {
        int n2;
        String string = this.bib2gls.getMessage("sentence.terminators", new Object[0]);
        for (int i = 0; i < string.length(); i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    protected CharObject getEndPunc(TeXObjectList teXObjectList) {
        int n = teXObjectList.size();
        for (int i = n - 1; i >= 0; --i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof CharObject) {
                CharObject charObject = (CharObject)teXObject;
                int n2 = charObject.getCharCode();
                int n3 = Character.getType(n2);
                if (n3 == 24) {
                    if (this.isSentenceTerminator(n2)) {
                        return charObject;
                    }
                    return null;
                }
                if (n3 == 30 || n3 == 22) continue;
                return null;
            }
            if (teXObject instanceof TeXObjectList) {
                return this.getEndPunc((TeXObjectList)teXObject);
            }
            if (teXObject instanceof Ignoreable) continue;
            return null;
        }
        return null;
    }

    public String getSortFallbackField() {
        return this.resource.getEntryDefaultSortField();
    }

    public String getFallbackValue(String string) {
        if (string.equals("text")) {
            return this.fieldValues.get("name");
        }
        if (string.equals("name")) {
            String string2 = this.fieldValues.get("parent");
            if (string2 == null) {
                return null;
            }
            Bib2GlsEntry bib2GlsEntry = this.resource.getEntry(string2);
            if (bib2GlsEntry == null) {
                return null;
            }
            String string3 = bib2GlsEntry.getFieldValue("name");
            if (string3 != null) {
                return string3;
            }
            return bib2GlsEntry.getFallbackValue("name");
        }
        if (string.equals("sort")) {
            String string4 = this.getSortFallbackField();
            String string5 = this.fieldValues.get(string4);
            if (string5 != null) {
                return string5;
            }
            return this.getFallbackValue(string4);
        }
        if (string.equals("first")) {
            String string6 = this.getFieldValue("text");
            if (string6 != null) {
                return string6;
            }
            return this.getFallbackValue("text");
        }
        if (string.equals("plural")) {
            String string7 = this.getFieldValue("text");
            if (string7 == null) {
                string7 = this.getFallbackValue("text");
            }
            if (string7 != null) {
                String string8 = this.resource.getPluralSuffix();
                return string8 == null ? string7 : string7 + string8;
            }
        } else {
            String string9;
            if (string.equals("firstplural")) {
                String string10 = this.getFieldValue("first");
                if (string10 == null) {
                    string10 = this.fieldValues.get("first");
                }
                if (string10 != null) {
                    String string11 = this.resource.getPluralSuffix();
                    return string11 == null ? string10 : string10 + string11;
                }
                string10 = this.getFieldValue("plural");
                return string10 == null ? this.getFallbackValue("plural") : string10;
            }
            if (string.equals("shortplural")) {
                String string12 = this.getFieldValue("short");
                if (string12 != null) {
                    String string13 = this.resource.getShortPluralSuffix();
                    return string13 == null ? string12 : string12 + string13;
                }
            } else if (string.equals("longplural") && (string9 = this.getFieldValue("long")) != null) {
                String string14 = this.resource.getPluralSuffix();
                return string14 == null ? string9 : string9 + string14;
            }
        }
        return null;
    }

    public BibValueList getFallbackContents(String string) {
        if (string.equals("text")) {
            return this.getField("name");
        }
        if (string.equals("name")) {
            String string2 = this.fieldValues.get("parent");
            if (string2 == null) {
                return null;
            }
            Bib2GlsEntry bib2GlsEntry = this.resource.getEntry(string2);
            if (bib2GlsEntry == null) {
                return null;
            }
            BibValueList bibValueList = bib2GlsEntry.getField("name");
            if (bibValueList != null) {
                return bibValueList;
            }
            return bib2GlsEntry.getFallbackContents("name");
        }
        if (string.equals("sort")) {
            String string3 = this.getSortFallbackField();
            BibValueList bibValueList = this.getField(string3);
            return bibValueList == null ? this.getFallbackContents(string3) : bibValueList;
        }
        if (string.equals("first")) {
            BibValueList bibValueList = this.getField("text");
            return bibValueList == null ? this.getFallbackContents("text") : bibValueList;
        }
        if (string.equals("plural")) {
            BibValueList bibValueList = this.getField("text");
            if (bibValueList == null) {
                bibValueList = this.getFallbackContents("text");
            }
            return this.plural(bibValueList, "glspluralsuffix");
        }
        if (string.equals("firstplural")) {
            BibValueList bibValueList = this.getField("first");
            if (bibValueList == null) {
                bibValueList = this.getField("plural");
                return bibValueList == null ? this.getFallbackContents("plural") : bibValueList;
            }
            return this.plural(bibValueList, "glspluralsuffix");
        }
        if (string.equals("longplural")) {
            return this.plural(this.getField("long"), "glspluralsuffix");
        }
        if (string.equals("shortplural")) {
            return this.plural(this.getField("short"), "abbrvpluralsuffix");
        }
        if (string.equals("duallongplural")) {
            return this.plural(this.getField("duallong"), "glspluralsuffix");
        }
        if (string.equals("dualshortplural")) {
            return this.plural(this.getField("dualshort"), "abbrvpluralsuffix");
        }
        return null;
    }

    protected BibValueList plural(BibValueList bibValueList, String string) {
        if (bibValueList == null) {
            return null;
        }
        bibValueList = (BibValueList)bibValueList.clone();
        bibValueList.add(new BibUserString(new TeXCsRef(string)));
        return bibValueList;
    }

    @Override
    public void parseContents(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        super.parseContents(teXParser, teXObjectList, teXObject);
        this.initMissingFields();
    }

    protected void initMissingFields() {
    }

    public void checkRequiredFields() {
        if (this.getField("name") == null && this.getField("parent") == null) {
            this.missingFieldWarning("name");
        }
        if (this.getField("description") == null) {
            this.missingFieldWarning("description");
        }
    }

    protected void missingFieldWarning(String string) {
        this.bib2gls.warningMessage("warning.missing.field", this.getId(), string);
    }

    public String getCsName() {
        return String.format("bibglsnew%s", this.getEntryType());
    }

    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[4]{%%%n", this.getCsName());
        printWriter.print(" \\longnewglossaryentry*{#1}");
        printWriter.println("{name={#3},#2}{#4}%");
        printWriter.println("}");
    }

    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = null;
        String string3 = "";
        Set<String> set = this.getFieldSet();
        for (String string4 : set) {
            String string5 = this.fieldValues.get(string4);
            if (string5 == null) continue;
            if (string4.equals("description")) {
                string = string5;
                continue;
            }
            if (string4.equals("name")) {
                string2 = string5;
                continue;
            }
            if (this.bib2gls.isKnownField(string4)) {
                printWriter.format("%s", string3);
                string3 = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string4, string5);
                continue;
            }
            if (this.bib2gls.getDebugLevel() <= 0 || this.bib2gls.isInternalField(string4) || this.bib2gls.isKnownSpecialField(string4)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", string4);
        }
        if (string2 == null) {
            string2 = this.getFallbackValue("name");
        }
        printWriter.println("}%");
        printWriter.println(String.format("{%s}%%", string2));
        printWriter.println(String.format("{%s}", string));
    }

    public void writeLocList(PrintWriter printWriter) throws IOException {
        if (this.locationList == null) {
            return;
        }
        for (String string : this.locationList) {
            printWriter.println(String.format("\\glsxtrfieldlistadd{%s}{loclist}{%s}", this.getId(), string));
        }
    }

    public void writeExtraFields(PrintWriter printWriter) throws IOException {
        String string;
        if (this.getEntryType().startsWith("spawned") && (string = this.getFieldValue("progenitor")) != null) {
            printWriter.format("\\GlsXtrSetField{%s}{progenitor}{%s}%n", this.getId(), string);
        }
    }

    public void writeIndexCounterField(PrintWriter printWriter) throws IOException {
        if (this.indexCounterRecord == null) {
            return;
        }
        printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", this.getId(), "indexcounter", this.indexCounterRecord.getLocation());
    }

    public Set<String> getFieldSet() {
        return this.fieldValues.keySet();
    }

    public String getFieldValue(String string) {
        return this.fieldValues.get(string);
    }

    public String putField(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("null label not permitted");
        }
        if (string2 == null) {
            throw new NullPointerException("null value not permitted for field " + string);
        }
        if (this.bib2gls.trimFields()) {
            string2 = string2.trim();
        }
        return this.fieldValues.put(string, string2);
    }

    public String removeFieldValue(String string) {
        return this.fieldValues.remove(string);
    }

    public String getParent() {
        return this.fieldValues.get("parent");
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public String getAlias() {
        return this.getFieldValue("alias");
    }

    public boolean hasAlias() {
        return this.getAlias() != null;
    }

    public boolean hasCrossRefs() {
        return this.crossRefs != null && this.crossRefs.length > 0 || this.alsocrossRefs != null && this.alsocrossRefs.length > 0 || this.hasAlias();
    }

    public String[] getCrossRefs() {
        return this.crossRefs;
    }

    public String[] getAlsoCrossRefs() {
        return this.alsocrossRefs;
    }

    public void addCrossRefdBy(Bib2GlsEntry bib2GlsEntry) {
        if (this.crossRefdBy == null) {
            this.crossRefdBy = new Vector();
        }
        if (!this.crossRefdBy.contains(bib2GlsEntry)) {
            this.crossRefdBy.add(bib2GlsEntry);
        }
    }

    public Iterator<Bib2GlsEntry> getCrossRefdByIterator() {
        return this.crossRefdBy.iterator();
    }

    public boolean hasDependent(String string) {
        return this.deps.contains(string);
    }

    public void addDependency(String string) {
        if (!this.deps.contains(string) && !string.equals(this.getId())) {
            this.deps.add(string);
        }
    }

    public Iterator<String> getDependencyIterator() {
        return this.deps.iterator();
    }

    public boolean hasDependencies() {
        return this.deps.size() > 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Bib2GlsEntry)) {
            return false;
        }
        return this.getId().equals(((Bib2GlsEntry)object).getId());
    }

    public Vector<GlsRecord> getRecords() {
        if (this.records == null) {
            Vector<GlsRecord> vector = new Vector<GlsRecord>();
            for (String string : this.recordMap.keySet()) {
                vector.addAll((Collection<GlsRecord>)this.recordMap.get(string));
            }
            return vector;
        }
        return this.records;
    }

    public int recordCount() {
        int n = 0;
        if (this.supplementalRecords != null) {
            n = this.supplementalRecords.size();
        }
        if (this.ignoredRecords != null) {
            n = this.ignoredRecords.size();
        }
        if (this.records != null) {
            return n + this.records.size();
        }
        for (String string : this.resource.getLocationCounters()) {
            n += this.recordMap.get(string).size();
        }
        return n;
    }

    public int mainRecordCount() {
        if (this.records != null) {
            return this.records.size();
        }
        int n = 0;
        for (String string : this.resource.getLocationCounters()) {
            n += this.recordMap.get(string).size();
        }
        return n;
    }

    public int supplementalRecordCount() {
        return this.supplementalRecords == null ? 0 : this.supplementalRecords.size();
    }

    public int ignoredRecordCount() {
        return this.ignoredRecords == null ? 0 : this.ignoredRecords.size();
    }

    public boolean hasRecords() {
        return this.recordCount() > 0;
    }

    public void addRecord(GlsSeeRecord glsSeeRecord) {
        this.addIgnoredRecord(new GlsRecord(this.bib2gls, glsSeeRecord.getLabel(), "", "page", "glsignore", ""));
        StringBuilder stringBuilder = new StringBuilder();
        if (this.crossRefTag == null) {
            this.crossRefTag = glsSeeRecord.getTag();
        }
        if (this.crossRefTag != null) {
            stringBuilder.append(String.format("[%s]", this.crossRefTag));
        }
        if (this.crossRefs == null) {
            this.crossRefs = glsSeeRecord.getXrLabels();
            for (int i = 0; i < this.crossRefs.length; ++i) {
                if (this.bib2gls.getVerboseLevel() > 0) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "\\glssee", this.crossRefs[i]));
                }
                this.addDependency(this.crossRefs[i]);
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.crossRefs[i]);
            }
        } else {
            int n;
            Vector<String> vector = new Vector<String>();
            String[] stringArray = glsSeeRecord.getXrLabels();
            char c = '\u0000';
            for (n = 0; n < this.crossRefs.length; ++n) {
                if (vector.contains(this.crossRefs[n])) continue;
                if (c == '\u0000') {
                    c = ',';
                } else {
                    stringBuilder.append(c);
                }
                vector.add(this.crossRefs[n]);
                stringBuilder.append(this.crossRefs[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (vector.contains(stringArray[n])) continue;
                if (c == '\u0000') {
                    c = ',';
                } else {
                    stringBuilder.append(c);
                }
                vector.add(stringArray[n]);
                if (this.bib2gls.getVerboseLevel() > 0) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "\\glssee", stringArray[n]));
                }
                this.addDependency(stringArray[n]);
                stringBuilder.append(stringArray[n]);
            }
            this.crossRefs = new String[vector.size()];
            vector.toArray(this.crossRefs);
        }
        this.putField("see", stringBuilder.toString());
    }

    public boolean hasTriggerRecord() {
        return this.triggerRecordFound;
    }

    public void addRecord(GlsRecord glsRecord) {
        String string;
        Vector<GlsRecord> vector;
        Object object;
        if (glsRecord.getFormat().equals("glsignore")) {
            this.bib2gls.debugMessage("message.ignored.record", glsRecord);
            this.addIgnoredRecord(glsRecord);
            return;
        }
        if (glsRecord.getFormat().equals("glstriggerrecordformat")) {
            this.triggerRecordFound = true;
            this.bib2gls.debugMessage("message.ignored.record", glsRecord);
            this.addIgnoredRecord(glsRecord);
            return;
        }
        if (this.indexCounterRecord == null && (object = this.resource.getSaveIndexCounter()) != null && glsRecord.getCounter().equals("wrglossary")) {
            if (((String)object).equals("true")) {
                this.indexCounterRecord = glsRecord;
            } else if (glsRecord.getFormat().equals(object)) {
                this.indexCounterRecord = glsRecord;
            }
        }
        object = null;
        int n = 0;
        if (this.resource.isPrimaryLocation(glsRecord.getFormat())) {
            object = glsRecord;
            if (this.primaryRecords == null) {
                this.primaryRecords = new Vector();
            }
            this.primaryRecords.add((GlsRecord)object);
            n = this.resource.getSavePrimaryLocationSetting();
        }
        if (this.records != null) {
            if (!this.records.contains(glsRecord)) {
                this.bib2gls.debugMessage("message.adding.record", glsRecord, this.getId());
                if (object != null && n == 4) {
                    glsRecord = (GlsRecord)glsRecord.clone();
                    glsRecord.setFormat("glsnumberformat");
                    this.records.add(glsRecord);
                } else if (object == null || n == 2) {
                    this.records.add(glsRecord);
                } else if (n == 3) {
                    this.records.add(this.primaryRecords.size() - 1, glsRecord);
                }
            }
        } else if (!(object != null && n == 1 || (vector = this.recordMap.get(string = glsRecord.getCounter())) == null || vector.contains(glsRecord))) {
            this.bib2gls.debugMessage("message.adding.counter.record", glsRecord, this.getId(), string);
            if (object != null || n == 4) {
                glsRecord = (GlsRecord)glsRecord.clone();
                glsRecord.setFormat("glsnumberformat");
                vector.add(glsRecord);
            } else if (object == null || n == 2) {
                vector.add(glsRecord);
            } else if (this.resource.getSavePrimaryLocationSetting() == 3) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    if (this.resource.isPrimaryLocation(vector.get(i).getFormat())) continue;
                    vector.add(i, glsRecord);
                    bl = true;
                    break;
                }
                if (!bl) {
                    vector.add(glsRecord);
                }
            }
        }
    }

    public void clearRecords() {
        this.bib2gls.debugMessage("message.clearing.records", this.getId());
        if (this.records == null) {
            for (String string : this.recordMap.keySet()) {
                Vector<GlsRecord> vector = this.recordMap.get(string);
                vector.clear();
            }
        } else {
            this.records.clear();
        }
    }

    public void addSupplementalRecord(GlsRecord glsRecord) {
        if (this.supplementalRecords == null) {
            this.supplementalRecords = new Vector();
        }
        if (!this.bib2gls.isMultipleSupplementarySupported()) {
            String string = glsRecord.getFormat();
            string = string.startsWith("(") ? "(glsxtrsupphypernumber" : (string.startsWith(")") ? ")glsxtrsupphypernumber" : "glsxtrsupphypernumber");
            glsRecord.setFormat(string);
        } else if (glsRecord instanceof SupplementalRecord) {
            TeXPath teXPath;
            Vector<GlsRecord> vector;
            if (this.supplementalRecordMap == null) {
                this.supplementalRecordMap = new HashMap();
            }
            if ((vector = this.supplementalRecordMap.get(teXPath = ((SupplementalRecord)((Object)glsRecord)).getSource())) == null) {
                vector = new Vector();
                this.supplementalRecordMap.put(teXPath, vector);
            }
            if (!vector.contains(glsRecord)) {
                vector.add(glsRecord);
            }
        }
        if (!this.supplementalRecords.contains(glsRecord)) {
            this.bib2gls.debugMessage("message.adding.supplemental.record", this.getId());
            this.supplementalRecords.add(glsRecord);
        }
    }

    public void addIgnoredRecord(GlsRecord glsRecord) {
        if (this.ignoredRecords == null) {
            this.ignoredRecords = new Vector();
        }
        if (!this.ignoredRecords.contains(glsRecord)) {
            this.ignoredRecords.add(glsRecord);
        }
    }

    public static void insertRecord(GlsRecord glsRecord, Vector<GlsRecord> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            GlsRecord glsRecord2 = vector.get(i);
            if (glsRecord2.equals(glsRecord)) {
                return;
            }
            int n2 = glsRecord.compareTo(glsRecord2);
            if (n2 > 0) continue;
            vector.add(i, glsRecord);
            return;
        }
        vector.add(glsRecord);
    }

    public void copyRecordsFrom(Bib2GlsEntry bib2GlsEntry) {
        if (bib2GlsEntry.records != null) {
            for (GlsRecord object : bib2GlsEntry.records) {
                this.bib2gls.debugMessage("message.copying.record", object, bib2GlsEntry.getId(), this.getId());
                if (object.getFormat().equals("glsignore") || object.getFormat().equals("glstriggerrecordformat")) {
                    this.addIgnoredRecord(object.copy(this.getId()));
                    continue;
                }
                Bib2GlsEntry.insertRecord(object.copy(this.getId()), this.records);
            }
        } else if (bib2GlsEntry.recordMap != null) {
            for (String string : bib2GlsEntry.recordMap.keySet()) {
                Vector<GlsRecord> vector = bib2GlsEntry.recordMap.get(string);
                if (vector == null) continue;
                Vector<GlsRecord> vector2 = this.recordMap.get(string);
                if (vector2 == null) {
                    vector2 = new Vector();
                    this.recordMap.put(string, vector2);
                }
                for (GlsRecord glsRecord : vector) {
                    this.bib2gls.debugMessage("message.copying.record", glsRecord, bib2GlsEntry.getId(), this.getId());
                    if (glsRecord.getFormat().equals("glsignore") || glsRecord.getFormat().equals("glstriggerrecordformat")) {
                        this.addIgnoredRecord(glsRecord.copy(this.getId()));
                        continue;
                    }
                    Bib2GlsEntry.insertRecord(glsRecord.copy(this.getId()), vector2);
                }
            }
        }
        if (bib2GlsEntry.supplementalRecords != null) {
            for (GlsRecord glsRecord : bib2GlsEntry.supplementalRecords) {
                this.bib2gls.debugMessage("message.copying.record", glsRecord, bib2GlsEntry.getId(), this.getId());
                this.addSupplementalRecord(glsRecord.copy(this.getId()));
            }
        }
    }

    private StringBuilder updateLocationList(int n, String string, String string2, int n2, Vector<GlsRecord> vector, StringBuilder stringBuilder) throws Bib2GlsException {
        GlsRecord glsRecord = null;
        int n3 = 0;
        StringBuilder stringBuilder2 = new StringBuilder();
        GlsRecord glsRecord2 = null;
        int[] nArray = new int[]{0};
        boolean bl = true;
        int n4 = this.resource.getCompactRanges();
        GlsRecord glsRecord3 = null;
        String string3 = null;
        int n5 = 0;
        int n6 = vector.size();
        for (int i = 0; i < n6; ++i) {
            GlsRecord glsRecord4 = vector.get(i);
            String string4 = i == n6 - 1 ? "\\bibglslastDelimN " : "\\bibglsdelimN ";
            this.locationList.add(glsRecord4.getListTeXCode());
            Matcher matcher = RANGE_PATTERN.matcher(glsRecord4.getFormat());
            if (matcher.matches()) {
                char c = matcher.group(1).charAt(0);
                n3 = 0;
                stringBuilder2.setLength(0);
                glsRecord2 = null;
                if (c == '(') {
                    if (glsRecord3 != null) {
                        throw new Bib2GlsException(this.bib2gls.getMessage("error.nested.range", glsRecord4, glsRecord3));
                    }
                    glsRecord3 = glsRecord4;
                    string3 = matcher.group(2);
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    } else if (!bl) {
                        stringBuilder.append(string4);
                    }
                    n5 = stringBuilder.length();
                    stringBuilder.append("\\bibglsrange{");
                    stringBuilder.append(glsRecord4.getFmtTeXCode());
                } else {
                    if (glsRecord3 == null) {
                        throw new Bib2GlsException(this.bib2gls.getMessage("error.range.missing.start", glsRecord4));
                    }
                    stringBuilder.append("\\delimR ");
                    stringBuilder.append(glsRecord4.getFmtTeXCode(glsRecord3, n4));
                    stringBuilder.append("}");
                    glsRecord3 = null;
                    string3 = null;
                }
            } else if (glsRecord3 != null) {
                String string5;
                String string6 = glsRecord4.getFormat();
                if (!glsRecord3.getPrefix().equals(glsRecord4.getPrefix()) || !glsRecord3.getCounter().equals(glsRecord4.getCounter())) {
                    this.bib2gls.warningMessage("error.inconsistent.range", glsRecord4, glsRecord3);
                    string5 = String.format("\\bibglsinterloper{%s}", glsRecord4.getFmtTeXCode());
                    stringBuilder.insert(n5, string5);
                    n5 += string5.length();
                } else if ((string3.isEmpty() || string3.equals("glsnumberformat")) && (string6.isEmpty() || string6.equals("glsnumberformat")) || string3.equals(string6)) {
                    this.bib2gls.debugMessage("message.merge.range", glsRecord4, glsRecord3);
                } else {
                    if (glsRecord4.getFormat().equals("glsnumberformat") || string3.isEmpty()) {
                        this.bib2gls.verboseMessage("message.inconsistent.range", glsRecord4, glsRecord3);
                    } else {
                        this.bib2gls.warningMessage("error.inconsistent.range", glsRecord4, glsRecord3);
                    }
                    string5 = String.format("\\bibglsinterloper{%s}", glsRecord4.getFmtTeXCode());
                    stringBuilder.insert(n5, string5);
                    n5 += string5.length();
                }
            } else if (glsRecord == null) {
                n3 = 1;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                } else if (!bl) {
                    stringBuilder.append(string4);
                }
                stringBuilder.append(glsRecord4.getFmtTeXCode());
            } else if (n < Integer.MAX_VALUE && glsRecord4.follows(glsRecord, n2, nArray)) {
                if (n3 == 1) {
                    glsRecord2 = glsRecord;
                }
                ++n3;
                stringBuilder2.append(string4);
                stringBuilder2.append(glsRecord4.getFmtTeXCode());
            } else if (n3 == 2 && string != null) {
                stringBuilder.append(string);
                stringBuilder.append(string4);
                stringBuilder.append(glsRecord4.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
                glsRecord2 = null;
            } else if (n3 > 2 && string2 != null) {
                stringBuilder.append(string2);
                stringBuilder.append(string4);
                stringBuilder.append(glsRecord4.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
                glsRecord2 = null;
            } else if (n3 >= n) {
                stringBuilder.append("\\delimR ");
                stringBuilder.append(glsRecord.getFmtTeXCode(glsRecord2, n4));
                if (nArray[0] > 1) {
                    stringBuilder.append("\\bibglspassim ");
                }
                nArray[0] = 0;
                stringBuilder.append(string4);
                stringBuilder.append(glsRecord4.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                glsRecord2 = null;
            } else {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append(string4);
                stringBuilder.append(glsRecord4.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
                glsRecord2 = null;
            }
            glsRecord = glsRecord4;
            bl = false;
        }
        if (glsRecord3 != null) {
            throw new Bib2GlsException(this.bib2gls.getMessage("error.range.missing.end", glsRecord3));
        }
        if (glsRecord != null && stringBuilder2.length() > 0) {
            if (n3 >= n) {
                stringBuilder.append("\\delimR ");
                stringBuilder.append(glsRecord.getFmtTeXCode(glsRecord2, n4));
                if (nArray[0] > 1) {
                    stringBuilder.append("\\bibglspassim ");
                }
            } else {
                stringBuilder.append((CharSequence)stringBuilder2);
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public void updateLocationList() throws Bib2GlsException {
        boolean bl;
        int n;
        StringBuilder stringBuilder;
        int n2 = this.resource.getMinLocationRange();
        String string = this.resource.getSuffixF();
        String string2 = this.resource.getSuffixFF();
        int n3 = this.resource.getSeeLocation();
        int n4 = this.resource.getSeeAlsoLocation();
        int n5 = this.resource.getAliasLocation();
        boolean bl2 = this.resource.showLocationPrefix();
        boolean bl3 = this.resource.showLocationSuffix();
        int n6 = this.resource.getLocationGap();
        StringBuilder stringBuilder2 = null;
        this.locationList = new Vector();
        int n7 = this.mainRecordCount() + this.supplementalRecordCount();
        String string3 = this.getAlias();
        if (n5 == 1 && string3 != null) {
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append("\\bibglsusealias{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            if (n7 > 0) {
                stringBuilder2.append("\\bibglsaliassep ");
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("\\glsseeformat");
            stringBuilder.append("{");
            stringBuilder.append(string3);
            stringBuilder.append("}{}");
            this.locationList.add(stringBuilder.toString());
        } else if (n3 == 1 && this.crossRefs != null) {
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append("\\bibglsusesee{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            if (n7 > 0) {
                stringBuilder2.append("\\bibglsseesep ");
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("\\glsseeformat");
            if (this.crossRefTag != null) {
                stringBuilder.append('[');
                stringBuilder.append(this.crossRefTag);
                stringBuilder.append(']');
            }
            stringBuilder.append("{");
            for (n = 0; n < this.crossRefs.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.processLabel(this.crossRefs[n]));
            }
            stringBuilder.append("}{}");
            this.locationList.add(stringBuilder.toString());
        } else if (n4 == 1 && this.alsocrossRefs != null) {
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append("\\bibglsuseseealso{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            if (n7 > 0) {
                stringBuilder2.append("\\bibglsseealsosep ");
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("\\glsxtruseseealsoformat");
            stringBuilder.append("{");
            for (n = 0; n < this.alsocrossRefs.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.processLabel(this.alsocrossRefs[n]));
            }
            stringBuilder.append("}");
            this.locationList.add(stringBuilder.toString());
        }
        boolean bl4 = bl = n7 > 0;
        if (string3 != null && this.resource.aliasLocations() != 2) {
            bl = false;
        }
        if (bl) {
            Object object;
            if (bl2) {
                if (stringBuilder2 == null) {
                    stringBuilder2 = new StringBuilder();
                }
                stringBuilder2.append(String.format("\\bibglslocprefix{%d}", n7));
            }
            String string4 = "";
            if (this.records == null) {
                object = "";
                for (String string5 : this.resource.getLocationCounters()) {
                    Vector<GlsRecord> vector = this.recordMap.get(string5);
                    if (vector.size() <= 0) continue;
                    if (stringBuilder2 == null) {
                        stringBuilder2 = new StringBuilder();
                    }
                    stringBuilder2.append(String.format("%s\\bibglslocationgroup{%s}{%s}{", object, vector.size(), string5));
                    stringBuilder2 = this.updateLocationList(n2, string, string2, n6, vector, stringBuilder2);
                    stringBuilder2.append("}");
                    object = "\\bibglslocationgroupsep ";
                    string4 = "\\bibglssupplementalsep ";
                }
            } else if (this.records.size() > 0) {
                stringBuilder2 = this.updateLocationList(n2, string, string2, n6, this.records, stringBuilder2);
                string4 = "\\bibglssupplementalsep ";
            }
            if (this.supplementalRecords != null && this.supplementalRecords.size() > 0) {
                if (stringBuilder2 == null) {
                    stringBuilder2 = new StringBuilder();
                }
                stringBuilder2.append(String.format("%s\\bibglssupplemental{%d}{", string4, this.supplementalRecords.size()));
                if (this.bib2gls.isMultipleSupplementarySupported()) {
                    object = this.resource.getSupplementalPaths();
                    String string6 = "";
                    Iterator iterator = ((Vector)object).iterator();
                    while (iterator.hasNext()) {
                        void var16_25;
                        TeXPath teXPath = (TeXPath)iterator.next();
                        Vector<GlsRecord> vector = this.supplementalRecordMap.get(teXPath);
                        if (vector == null) continue;
                        stringBuilder2.append(String.format("%s\\bibglssupplementalsublist{%d}{%s}{", var16_25, vector.size(), this.bib2gls.getTeXPathHref(teXPath)));
                        String string7 = "\\bibglssupplementalsubsep ";
                        stringBuilder2 = this.updateLocationList(n2, string, string2, n6, vector, stringBuilder2);
                        stringBuilder2.append("}");
                    }
                } else {
                    stringBuilder2 = this.updateLocationList(n2, string, string2, n6, this.supplementalRecords, stringBuilder2);
                }
                stringBuilder2.append("}");
            }
        }
        if (n5 == 2 && string3 != null) {
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder();
            }
            if (bl) {
                stringBuilder2.append("\\bibglsaliassep ");
            }
            stringBuilder2.append("\\bibglsusealias{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append("\\glsseeformat");
            stringBuilder3.append("{");
            stringBuilder3.append(string3);
            stringBuilder3.append("}{}");
            this.locationList.add(stringBuilder3.toString());
        } else if (n3 == 2 && this.crossRefs != null) {
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder();
            }
            if (bl) {
                stringBuilder2.append("\\bibglsseesep ");
            }
            stringBuilder2.append("\\bibglsusesee{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            StringBuilder stringBuilder4 = new StringBuilder();
            stringBuilder4.append("\\glsseeformat");
            if (this.crossRefTag != null) {
                stringBuilder4.append('[');
                stringBuilder4.append(this.crossRefTag);
                stringBuilder4.append(']');
            }
            stringBuilder4.append("{");
            for (int i = 0; i < this.crossRefs.length; ++i) {
                if (i > 0) {
                    stringBuilder4.append(",");
                }
                stringBuilder4.append(this.processLabel(this.crossRefs[i]));
            }
            stringBuilder4.append("}{}");
            this.locationList.add(stringBuilder4.toString());
        } else if (n4 == 2 && this.alsocrossRefs != null) {
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder();
            }
            if (bl) {
                stringBuilder2.append("\\bibglsseealsosep ");
            }
            stringBuilder2.append("\\bibglsuseseealso{");
            stringBuilder2.append(this.getId());
            stringBuilder2.append("}");
            StringBuilder stringBuilder5 = new StringBuilder();
            stringBuilder5.append("\\glsxtruseseealsoformat");
            stringBuilder5.append("{");
            for (int i = 0; i < this.alsocrossRefs.length; ++i) {
                if (i > 0) {
                    stringBuilder5.append(",");
                }
                stringBuilder5.append(this.processLabel(this.alsocrossRefs[i]));
            }
            stringBuilder5.append("}");
            this.locationList.add(stringBuilder5.toString());
        }
        if (stringBuilder2 != null) {
            if (bl3 && (n7 > 0 || this.crossRefs != null || this.alsocrossRefs != null)) {
                stringBuilder2.append(String.format("\\bibglslocsuffix{%d}", n7));
            }
            this.putField("location", stringBuilder2.toString());
        }
    }

    public String getPrimaryRecordList() throws Bib2GlsException {
        if (this.primaryRecords == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = this.updateLocationList(this.resource.getMinLocationRange(), this.resource.getSuffixF(), this.resource.getSuffixFF(), this.resource.getLocationGap(), this.primaryRecords, stringBuilder);
        return String.format("\\bibglsprimary{%d}{%s}", this.primaryRecords.size(), stringBuilder);
    }

    public void initAlias(TeXParser teXParser) throws IOException {
        String string = this.getFieldValue("alias");
        BibValueList bibValueList = this.getField("alias");
        if (string == null && bibValueList != null) {
            string = bibValueList.expand(teXParser).toString(teXParser);
        }
        if (string == null) {
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.field.not.set", "alias"));
            }
        } else {
            string = this.processLabel(string);
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "alias", string));
            }
            this.addDependency(string);
            this.putField("alias", string);
            this.resource.setAliases(true);
        }
    }

    public void initCrossRefs(TeXParser teXParser) throws IOException {
        if (this.bib2gls.getVerboseLevel() > 0) {
            this.bib2gls.logMessage(this.bib2gls.getMessage("message.checking.crossrefs", this.getId()));
        }
        this.initAlias(teXParser);
        BibValueList bibValueList = this.getField("see");
        BibValueList bibValueList2 = this.getField("seealso");
        if (bibValueList == null) {
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.field.not.set", "see"));
            }
            if (bibValueList2 != null) {
                this.initAlsoCrossRefs(teXParser, bibValueList2, this.getFieldValue("seealso"));
                return;
            }
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.field.not.set", "seealso"));
            }
        }
        if (bibValueList2 != null) {
            this.bib2gls.warningMessage("warning.field.clash", "see", "seealso");
        }
        if (bibValueList == null) {
            return;
        }
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        StringBuilder stringBuilder = new StringBuilder();
        this.initSeeRef(teXParser, teXObjectList, stringBuilder);
    }

    private void initSeeRef(TeXParser teXParser, TeXObjectList teXObjectList, StringBuilder stringBuilder) throws IOException {
        CsvList csvList;
        int n;
        TeXObject teXObject;
        if (teXObjectList instanceof Group) {
            teXObjectList = ((Group)teXObjectList).toList();
        }
        if ((teXObject = teXObjectList.popArg(teXParser, 91, 93)) != null) {
            this.crossRefTag = teXObject.toString(teXParser);
            stringBuilder.append('[');
            stringBuilder.append(this.crossRefTag);
            stringBuilder.append(']');
        }
        if ((n = (csvList = CsvList.getList(teXParser, teXObjectList)).size()) == 0) {
            return;
        }
        this.crossRefs = new String[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject2 = (TeXObject)csvList.get(i);
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = GlsResource.trimList((TeXObjectList)teXObject2);
            }
            this.crossRefs[i] = teXObject2.toString(teXParser);
            String string = this.processLabel(this.crossRefs[i]);
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "see", string));
            }
            this.addDependency(string);
            stringBuilder.append(string);
            if (i == n - 1) continue;
            stringBuilder.append(',');
        }
        this.putField("see", stringBuilder.toString());
    }

    private void initAlsoCrossRefs(TeXParser teXParser, BibValueList bibValueList, String string) throws IOException {
        if (string == null || string.isEmpty() || !this.bib2gls.isKnownField("seealso")) {
            this.initAlsoCrossRefs(teXParser, bibValueList);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "";
            for (String string3 : this.alsocrossRefs = string.trim().split("\\s*,\\s*")) {
                string3 = this.processLabel(string3);
                if (this.bib2gls.getVerboseLevel() > 0) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "seealso", string3));
                }
                this.addDependency(string3);
                stringBuilder.append(string2);
                stringBuilder.append(string3);
                string2 = ",";
            }
            this.putField("seealso", stringBuilder.toString());
        }
    }

    private void initAlsoCrossRefs(TeXParser teXParser, BibValueList bibValueList) throws IOException {
        CsvList csvList;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        if (!this.bib2gls.isKnownField("seealso")) {
            this.bib2gls.warningMessage("warning.field.unsupported", "seealso", "1.16");
            this.crossRefTag = "\\seealsoname ";
            stringBuilder.append("[\\seealsoname]");
            this.initSeeRef(teXParser, teXObjectList, stringBuilder);
            return;
        }
        if (teXObjectList instanceof Group) {
            teXObjectList = ((Group)teXObjectList).toList();
        }
        if ((n = (csvList = CsvList.getList(teXParser, teXObjectList)).size()) == 0) {
            return;
        }
        this.alsocrossRefs = new String[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)csvList.get(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = GlsResource.trimList((TeXObjectList)teXObject);
            }
            this.alsocrossRefs[i] = teXObject.toString(teXParser);
            String string = this.processLabel(this.alsocrossRefs[i]);
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "seealso", string));
            }
            this.addDependency(string);
            stringBuilder.append(string);
            if (i == n - 1) continue;
            stringBuilder.append(',');
        }
        this.putField("seealso", stringBuilder.toString());
    }

    private void parseCustomDependencyList(TeXParser teXParser, TeXObjectList teXObjectList, String string) throws IOException {
        int n;
        Object object;
        if (teXObjectList instanceof Group) {
            teXObjectList = ((Group)teXObjectList).toList();
        }
        StringBuilder stringBuilder = new StringBuilder();
        TeXObject teXObject = teXObjectList.popArg(teXParser, 91, 93);
        if (teXObject != null) {
            object = teXObject.toString(teXParser);
            stringBuilder.append('[');
            stringBuilder.append((String)object);
            stringBuilder.append(']');
        }
        if ((n = ((Vector)(object = CsvList.getList(teXParser, teXObjectList))).size()) == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject2 = ((CsvList)object).getValue(i);
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = GlsResource.trimList((TeXObjectList)teXObject2);
            }
            String string2 = teXObject2.toString(teXParser);
            String string3 = this.processLabel(string2);
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.custom.dep.found", string, this.getId(), string, string3));
            }
            this.addDependency(string3);
            stringBuilder.append(string3);
            if (i == n - 1) continue;
            stringBuilder.append(',');
        }
        if (teXObject != null) {
            teXObjectList.push(teXParser.getListener().getOther(93));
            teXObjectList.push(teXObject);
            teXObjectList.push(teXParser.getListener().getOther(91));
        }
        this.putField(string, stringBuilder.toString());
    }

    public void setCollationKey(CollationKey collationKey) {
        this.collationKey = collationKey;
    }

    public CollationKey getCollationKey() {
        return this.collationKey;
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Bib2GlsEntry createParent(TeXParser teXParser) {
        String string;
        if (this.orgParentValue == null) {
            return null;
        }
        String string2 = string = this.getParent();
        if (string == null) {
            return null;
        }
        Bib2GlsIndex bib2GlsIndex = new Bib2GlsIndex(this.bib2gls);
        if (this.labelPrefix != null && string.startsWith(this.labelPrefix)) {
            bib2GlsIndex.setId(this.labelPrefix, string.substring(this.labelPrefix.length()));
        } else {
            bib2GlsIndex.setId(null, string);
        }
        bib2GlsIndex.base = this.base;
        bib2GlsIndex.putField("name", this.orgParentValue);
        try {
            bib2GlsIndex.parseFields(teXParser);
        }
        catch (TeXSyntaxException teXSyntaxException) {
            this.bib2gls.error(this.bib2gls.getMessage("error.create.missing.parent.failed", string2, this.getId(), teXSyntaxException.getMessage(this.bib2gls)));
            this.bib2gls.debug(teXSyntaxException);
        }
        catch (IOException iOException) {
            this.bib2gls.error(this.bib2gls.getMessage("error.create.missing.parent.failed", string2, this.getId(), iOException.getMessage()));
            this.bib2gls.debug(iOException);
        }
        String string3 = this.getFieldValue("type");
        if (string3 != null) {
            bib2GlsIndex.putField("type", string3);
        }
        return bib2GlsIndex;
    }

    public static Bib2GlsEntry getEntry(String string, Vector<Bib2GlsEntry> vector) {
        for (Bib2GlsEntry bib2GlsEntry : vector) {
            if (!bib2GlsEntry.getId().equals(string)) continue;
            return bib2GlsEntry;
        }
        return null;
    }

    public int getLevel(Vector<Bib2GlsEntry> vector) {
        String string = this.getParent();
        if (string == null) {
            return 0;
        }
        Bib2GlsEntry bib2GlsEntry = Bib2GlsEntry.getEntry(string, vector);
        if (bib2GlsEntry != null) {
            return bib2GlsEntry.getLevel(vector) + 1;
        }
        return 0;
    }

    public void moveUpHierarchy(Vector<Bib2GlsEntry> vector) {
        String string = this.getParent();
        String string2 = this.getId();
        if (string == null) {
            return;
        }
        Bib2GlsEntry bib2GlsEntry = Bib2GlsEntry.getEntry(string, vector);
        String string3 = null;
        if (bib2GlsEntry != null) {
            bib2GlsEntry.removeChild(string2);
            string3 = bib2GlsEntry.getParent();
        }
        if (string3 == null) {
            this.removeField("parent");
            this.removeFieldValue("parent");
            return;
        }
        Bib2GlsEntry bib2GlsEntry2 = Bib2GlsEntry.getEntry(string3, vector);
        if (bib2GlsEntry2 == null) {
            return;
        }
        bib2GlsEntry2.addChild(this);
        this.putField("parent", bib2GlsEntry.getField("parent"));
        this.putField("parent", string3);
    }

    private void addHierarchy(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) throws Bib2GlsException {
        if (this.hierarchy.contains(bib2GlsEntry)) {
            throw new Bib2GlsException(this.bib2gls.getMessage("error.cyclic.hierarchy", bib2GlsEntry.getId()));
        }
        this.hierarchy.add(0, bib2GlsEntry);
        String string = bib2GlsEntry.getParent();
        if (string == null) {
            return;
        }
        Bib2GlsEntry bib2GlsEntry2 = Bib2GlsEntry.getEntry(string, vector);
        if (bib2GlsEntry2 == null) {
            if (this.resource.isStripMissingParentsEnabled()) {
                this.bib2gls.verboseMessage("message.removing.missing.parent", string, bib2GlsEntry.getId());
                bib2GlsEntry.removeField("parent");
                bib2GlsEntry.fieldValues.remove("parent");
            } else {
                this.bib2gls.warningMessage("warning.cant.find.parent", string, bib2GlsEntry.getId());
            }
        } else {
            this.addHierarchy(bib2GlsEntry2, vector);
        }
    }

    public void updateHierarchy(Vector<Bib2GlsEntry> vector) throws Bib2GlsException {
        this.hierarchy = new Vector();
        this.addHierarchy(this, vector);
    }

    public int getHierarchyCount() {
        return this.hierarchy == null ? 0 : this.hierarchy.size();
    }

    public Bib2GlsEntry getHierarchyElement(int n) {
        return this.hierarchy.get(n);
    }

    public Number getNumericSort() {
        return this.numericSort;
    }

    public void setNumericSort(Number number) {
        this.numericSort = number;
    }

    public Object getSortObject() {
        return this.sortObject;
    }

    public void setSortObject(Object object) {
        this.sortObject = object;
    }

    public void addChild(Bib2GlsEntry bib2GlsEntry) {
        if (this.children == null) {
            this.children = new Vector();
        }
        if (!this.children.contains(bib2GlsEntry)) {
            this.children.add(bib2GlsEntry);
        }
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Vector<Bib2GlsEntry> getChildren() {
        return this.children;
    }

    public Bib2GlsEntry getChild(int n) {
        return this.children.get(n);
    }

    private Bib2GlsEntry removeChild(String string) {
        if (this.children == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getId().equals(string)) continue;
            return this.children.remove(i);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getId();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Bib2GlsEntry getMinimalCopy() {
        Bib2GlsEntry bib2GlsEntry = new Bib2GlsEntry(this.bib2gls);
        bib2GlsEntry.originalEntryType = this.originalEntryType;
        bib2GlsEntry.records = this.records;
        bib2GlsEntry.recordMap = this.recordMap;
        bib2GlsEntry.base = this.base;
        bib2GlsEntry.labelPrefix = this.labelPrefix;
        bib2GlsEntry.setId(this.getId());
        return bib2GlsEntry;
    }
}

