/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.netbeans.lib.profiler.heap.CacheDirectory;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HprofHeap;

public class HeapFactory {
    public static Heap createHeap(File file) throws FileNotFoundException, IOException {
        return HeapFactory.createHeap(file, 0);
    }

    public static Heap createHeap(File file, int n) throws FileNotFoundException, IOException {
        File file2;
        CacheDirectory cacheDirectory = CacheDirectory.getHeapDumpCacheDirectory(file);
        if (!cacheDirectory.isTemporary() && (file2 = cacheDirectory.getHeapDumpAuxFile()).exists() && file2.isFile() && file2.canRead()) {
            try {
                return HeapFactory.loadHeap(cacheDirectory);
            }
            catch (IOException iOException) {
                System.err.println("Loading heap dump " + file + " from cache failed.");
                iOException.printStackTrace(System.err);
                cacheDirectory.deleteAllCachedFiles();
            }
        }
        return new HprofHeap(file, n, cacheDirectory);
    }

    static Heap loadHeap(CacheDirectory cacheDirectory) throws FileNotFoundException, IOException {
        File file = cacheDirectory.getHeapDumpAuxFile();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 65536);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        HprofHeap hprofHeap = new HprofHeap(dataInputStream, cacheDirectory);
        dataInputStream.close();
        return hprofHeap;
    }
}

