/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public final class RequestProcessor
implements ScheduledExecutorService {
    private static final RequestProcessor DEFAULT;
    private static final Logger logger;
    private static final RequestProcessor UNLIMITED;
    private static int counter;
    private static final boolean SLOW;
    String name;
    volatile boolean stopped = false;
    volatile boolean finishAwaitingTasks = false;
    private final Object processorLock = new Object();
    private final HashSet<Processor> processors = new HashSet();
    private final SortedSet<Item> queue = new TreeSet<Item>();
    private int throughput;
    private Map<Class<? extends Runnable>, AtomicInteger> inParallel;
    private final int warnParallel;
    private boolean interruptThread;
    private boolean enableStackTraces;
    private static final TopLevelThreadGroup TOP_GROUP;

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String string) {
        this(string, 1);
    }

    public RequestProcessor(Class<?> clazz) {
        this(clazz.getName());
    }

    public RequestProcessor(String string, int n) {
        this(string, n, false);
    }

    public RequestProcessor(String string, int n, boolean bl) {
        this(string, n, bl, SLOW);
    }

    public RequestProcessor(String string, int n, boolean bl, boolean bl2) {
        this(string, n, bl, bl2, 0);
    }

    private RequestProcessor(String string, int n, boolean bl, boolean bl2, int n2) {
        this.throughput = n;
        this.name = string != null ? string : "OpenIDE-request-processor-" + counter++;
        this.interruptThread = bl;
        this.enableStackTraces = bl2;
        this.warnParallel = n2;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    @Override
    public void execute(Runnable runnable) {
        this.post(runnable);
    }

    public Task post(Runnable runnable) {
        return this.post(runnable, 0, 1);
    }

    public Task post(Runnable runnable, int n) {
        return this.post(runnable, n, 1);
    }

    public Task post(Runnable runnable, int n, int n2) {
        Task task = new Task(runnable, n2);
        task.schedule(n);
        return task;
    }

    public Task create(Runnable runnable) {
        return this.create(runnable, false);
    }

    public Task create(Runnable runnable, boolean bl) {
        Task task = new Task(runnable);
        task.markCreated();
        if (bl) {
            task.notifyFinished();
        }
        return task;
    }

    public boolean isRequestProcessorThread() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Processor) {
            Processor processor = (Processor)thread;
            return processor.procesing == this;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            for (Processor processor : this.processors) {
                processor.interrupt();
            }
        }
    }

    @Deprecated
    public static Task postRequest(Runnable runnable) {
        return DEFAULT.post(runnable);
    }

    @Deprecated
    public static Task postRequest(Runnable runnable, int n) {
        return DEFAULT.post(runnable, n);
    }

    @Deprecated
    public static Task postRequest(Runnable runnable, int n, int n2) {
        return DEFAULT.post(runnable, n, n2);
    }

    @Deprecated
    public static Task createRequest(Runnable runnable) {
        return DEFAULT.create(runnable);
    }

    static Logger logger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Item item) {
        boolean bl;
        Logger logger = RequestProcessor.logger();
        boolean bl2 = logger.isLoggable(Level.FINE);
        Object object = this.processorLock;
        synchronized (object) {
            boolean bl3 = bl = item.getTask() == null;
            if (!bl) {
                this.prioritizedEnqueue(item);
                if (this.processors.size() < this.throughput) {
                    Processor processor = Processor.get();
                    this.processors.add(processor);
                    if (processor.getContextClassLoader() != item.ctxLoader) {
                        if (bl2) {
                            ClassLoader classLoader = item.ctxLoader;
                            ClassLoader classLoader2 = processor.getContextClassLoader();
                            logger.log(Level.FINE, "Setting ctxLoader for old:{0} loader:{1}#{2} new:{3} loader:{4}#{5}", new Object[]{processor.getName(), classLoader2 == null ? "<none>" : classLoader2.getClass().getName(), classLoader2 == null ? "-" : Integer.toHexString(System.identityHashCode(processor.getContextClassLoader())), this.name, classLoader == null ? "<none>" : item.ctxLoader.getClass().getName(), classLoader == null ? "-" : Integer.toHexString(System.identityHashCode(item.ctxLoader))});
                        }
                        processor.setContextClassLoader(item.ctxLoader);
                    }
                    processor.setName(this.name);
                    processor.attachTo(this);
                }
            }
        }
        if (bl2) {
            if (bl) {
                logger.log(Level.FINE, "Null task for item {0}", item);
            } else {
                logger.log(Level.FINE, "Item enqueued: {0} status: {1}", new Object[]{item.action, item.enqueued});
            }
        }
    }

    private void prioritizedEnqueue(Item item) {
        this.getQueue().add(item);
        item.enqueued = true;
    }

    Task askForWork(Processor processor, String string, Lookup[] lookupArray) {
        if (this.getQueue().isEmpty() || this.stopped && !this.finishAwaitingTasks) {
            this.processors.remove(processor);
            Processor.put(processor, string);
            return null;
        }
        Item item = this.getQueue().first();
        this.getQueue().remove(item);
        Task task = item.getTask();
        lookupArray[0] = item.current;
        item.clear(processor);
        return task;
    }

    @Override
    public void shutdown() {
        if (this == UNLIMITED) {
            throw new IllegalStateException("Cannot shut down the default request processor");
        }
        this.stopped = true;
        this.finishAwaitingTasks = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        if (this == UNLIMITED) {
            throw new IllegalStateException("Cannot shut down the default request processor");
        }
        this.stop();
        Object object = this.processorLock;
        synchronized (object) {
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.getQueue().size());
            for (Item item : this.getQueue()) {
                Task task = item.getTask();
                if (task == null || task.run == null) continue;
                Runnable runnable = task.run;
                if (runnable instanceof RunnableWrapper) {
                    Runnable runnable2 = ((RunnableWrapper)((Object)runnable)).getRunnable();
                    runnable = runnable2 == null ? runnable : runnable2;
                }
                arrayList.add(runnable);
            }
            return arrayList;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.stopped;
    }

    @Override
    public boolean isTerminated() {
        boolean bl = true;
        Set<Processor> set = this.collectProcessors(new HashSet<Processor>());
        for (Processor processor : set) {
            if (!processor.isAlive() || !processor.belongsTo(this)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        Parameters.notNull("unit", (Object)timeUnit);
        long l2 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        boolean bl = this.stopped;
        long l3 = System.currentTimeMillis() + l2;
        Set<Processor> set = new HashSet<Processor>();
        block0: do {
            if ((set = this.collectProcessors(set)).isEmpty()) {
                return true;
            }
            for (Processor processor : set) {
                long l4 = l3 - System.currentTimeMillis();
                if (l4 <= 0L) {
                    bl = this.collectProcessors(set).isEmpty();
                    break block0;
                }
                if (processor.belongsTo(this)) {
                    processor.join(l4);
                }
                bl = !processor.isAlive() || !processor.belongsTo(this);
            }
            set.clear();
        } while (!set.isEmpty());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Processor> collectProcessors(Set<Processor> set) {
        set.clear();
        Object object = this.processorLock;
        synchronized (object) {
            for (Processor processor : this.processors) {
                if (!processor.belongsTo(this)) continue;
                set.add(processor);
            }
        }
        return set;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        Parameters.notNull("task", callable);
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        RPFutureTask<T> rPFutureTask = new RPFutureTask<T>(callable);
        Task task = this.create(rPFutureTask);
        rPFutureTask.setTask(task);
        task.schedule(0);
        return rPFutureTask;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        Parameters.notNull("task", runnable);
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        RPFutureTask<T> rPFutureTask = new RPFutureTask<T>(runnable, t);
        Task task = this.create(rPFutureTask);
        rPFutureTask.setTask(task);
        task.schedule(0);
        return rPFutureTask;
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.submit(runnable, null);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        Parameters.notNull("tasks", collection);
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        CountDownLatch countDownLatch = new CountDownLatch(collection.size());
        for (Callable<T> callable : collection) {
            if (callable == null) {
                throw new NullPointerException("Contains null tasks: " + collection);
            }
            WaitableCallable<T> waitableCallable = new WaitableCallable<T>(callable, countDownLatch);
            arrayList.add(this.submit(waitableCallable));
        }
        countDownLatch.await();
        return arrayList;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        Object object;
        Parameters.notNull("unit", (Object)timeUnit);
        Parameters.notNull("tasks", collection);
        CountDownLatch countDownLatch = new CountDownLatch(collection.size());
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        for (Callable<T> callable : collection) {
            if (callable == null) {
                throw new NullPointerException("Contains null tasks: " + collection);
            }
            object = new WaitableCallable<T>(callable, countDownLatch);
            arrayList.add(this.submit((Callable<T>)object));
        }
        if (!countDownLatch.await(l, timeUnit)) {
            for (Future future : arrayList) {
                object = (RPFutureTask)future;
                ((RPFutureTask)object).cancel(true);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        Object object;
        Parameters.notNull("tasks", collection);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        AtomicReference atomicReference = new AtomicReference();
        try {
            for (Callable<T> callable : collection) {
                if (callable == null) {
                    throw new NullPointerException("Contains null tasks: " + collection);
                }
                object = new WaitableCallable<T>(callable, atomicReference, countDownLatch);
                arrayList.add(this.submit((Callable<T>)object));
            }
            countDownLatch.await();
        }
        finally {
            for (Future future : arrayList) {
                object = (RPFutureTask)future;
                ((RPFutureTask)object).cancel(true);
            }
        }
        return (T)atomicReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Object object;
        Parameters.notNull("unit", (Object)timeUnit);
        Parameters.notNull("tasks", collection);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        AtomicReference atomicReference = new AtomicReference();
        try {
            for (Callable<T> callable : collection) {
                if (callable == null) {
                    throw new NullPointerException("Contains null tasks: " + collection);
                }
                object = new WaitableCallable<T>(callable, atomicReference, countDownLatch);
                arrayList.add(this.submit((Callable<T>)object));
            }
            countDownLatch.await(l, timeUnit);
        }
        finally {
            for (Future future : arrayList) {
                object = (RPFutureTask)future;
                ((RPFutureTask)object).cancel(true);
            }
        }
        return (T)atomicReference.get();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        Parameters.notNull("command", runnable);
        Parameters.notNull("unit", (Object)timeUnit);
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay: " + l);
        }
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        long l2 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        ScheduledRPFutureTask<Object> scheduledRPFutureTask = new ScheduledRPFutureTask<Object>(runnable, null, l2);
        Task task = this.create(scheduledRPFutureTask);
        scheduledRPFutureTask.setTask(task);
        task.schedule(l2);
        return scheduledRPFutureTask;
    }

    public <T> ScheduledFuture<T> schedule(Callable<T> callable, long l, TimeUnit timeUnit) {
        Parameters.notNull("unit", (Object)timeUnit);
        Parameters.notNull("callable", callable);
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay: " + l);
        }
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        long l2 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        ScheduledRPFutureTask<T> scheduledRPFutureTask = new ScheduledRPFutureTask<T>(callable, l2);
        Task task = this.create(scheduledRPFutureTask);
        scheduledRPFutureTask.setTask(task);
        task.schedule(l2);
        return scheduledRPFutureTask;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.scheduleFixed(runnable, l, l2, timeUnit, false);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.scheduleFixed(runnable, l, l2, timeUnit, true);
    }

    private ScheduledFuture<?> scheduleFixed(Runnable runnable, long l, long l2, TimeUnit timeUnit, boolean bl) {
        Task task;
        Parameters.notNull("unit", (Object)timeUnit);
        Parameters.notNull("command", runnable);
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative delay: " + l2);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative initialDelay: " + l);
        }
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        long l3 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        long l4 = TimeUnit.MILLISECONDS.convert(l2, timeUnit);
        TaskFutureWrapper taskFutureWrapper = bl ? new FixedDelayTask(runnable, l3, l4) : new FixedRateTask(runnable, l, l4);
        taskFutureWrapper.t = task = this.create(taskFutureWrapper);
        task.cancelled = taskFutureWrapper.cancelled;
        task.schedule(l3);
        return taskFutureWrapper;
    }

    private SortedSet<Item> getQueue() {
        assert (Thread.holdsLock(this.processorLock));
        return this.queue;
    }

    static {
        Processor.class.hashCode();
        DEFAULT = new RequestProcessor();
        logger = Logger.getLogger("org.openide.util.RequestProcessor");
        counter = 0;
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        UNLIMITED = new RequestProcessor("Default RequestProcessor", 50, false, SLOW, (SLOW = bl) ? 3 : 0);
        TOP_GROUP = new TopLevelThreadGroup();
    }

    private static final class TickTac
    extends Thread
    implements Comparator<Item> {
        private static TickTac TICK;
        private final PriorityQueue<Item> queue;

        public TickTac() {
            super("RequestProcessor queue manager");
            this.setDaemon(true);
            this.queue = new PriorityQueue<Item>(128, this);
        }

        @Override
        public int compare(Item item, Item item2) {
            if (item.when < item2.when) {
                return -1;
            }
            if (item.when > item2.when) {
                return 1;
            }
            return 0;
        }

        static final synchronized void schedule(Item item, long l) {
            if (TICK == null) {
                TICK = new TickTac();
                TICK.scheduleImpl(item, l);
                TICK.start();
            } else {
                TICK.scheduleImpl(item, l);
            }
            TickTac.class.notifyAll();
        }

        private void scheduleImpl(Item item, long l) {
            assert (Thread.holdsLock(TickTac.class));
            item.when = System.currentTimeMillis() + l;
            this.queue.add(item);
        }

        static final synchronized void cancel(Item item) {
            if (TICK != null) {
                TICK.cancelImpl(item);
                TickTac.class.notifyAll();
            }
        }

        private void cancelImpl(Item item) {
            assert (Thread.holdsLock(TickTac.class));
            this.queue.remove(item);
        }

        @Override
        public void run() {
            while (TICK == this) {
                try {
                    Item item = TickTac.obtainFirst();
                    if (item == null) continue;
                    item.owner.enqueue(item);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private static synchronized Item obtainFirst() throws InterruptedException {
            if (TICK == null) {
                return null;
            }
            PriorityQueue<Item> priorityQueue = TickTac.TICK.queue;
            Item item = priorityQueue.poll();
            if (item == null) {
                TICK = null;
                return null;
            }
            long l = item.when - System.currentTimeMillis();
            if (l > 0L) {
                priorityQueue.add(item);
                TickTac.class.wait(l);
                return null;
            }
            return item;
        }
    }

    private static class Processor
    extends Thread {
        private static final Stack<Processor> pool = new Stack();
        private static final int INACTIVE_TIMEOUT = Integer.getInteger("org.openide.util.RequestProcessor.inactiveTime", 60000);
        private RequestProcessor source;
        private Task todo;
        private boolean idle = true;
        private final Object lock = new Object();
        private RequestProcessor procesing;
        private static final Map<Class<? extends Runnable>, Object> warnedClasses = Collections.synchronizedMap(new WeakHashMap());

        public Processor() {
            super(TOP_GROUP.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
            assert (!Thread.holdsLock(pool));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Processor get() {
            Thread thread = null;
            while (true) {
                Stack<Processor> stack = pool;
                synchronized (stack) {
                    if (pool.isEmpty()) {
                        if (thread != null) {
                            Thread thread2 = thread;
                            ((Processor)thread2).idle = false;
                            thread2.start();
                            return thread2;
                        }
                    } else {
                        assert (Processor.checkAccess(TOP_GROUP.getTopLevelThreadGroup()));
                        Processor processor = pool.pop();
                        processor.idle = false;
                        return processor;
                    }
                }
                thread = new Processor();
            }
        }

        private static boolean checkAccess(ThreadGroup threadGroup) throws SecurityException {
            threadGroup.checkAccess();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void put(Processor processor, String string) {
            Stack<Processor> stack = pool;
            synchronized (stack) {
                processor.setName("Inactive RequestProcessor thread [Was:" + processor.getName() + "/" + string + "]");
                processor.idle = true;
                pool.push(processor);
            }
        }

        void setPrio(int n) {
            if (n != this.getPriority()) {
                this.setPriority(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachTo(RequestProcessor requestProcessor) {
            Object object = this.lock;
            synchronized (object) {
                this.source = requestProcessor;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean belongsTo(RequestProcessor requestProcessor) {
            Object object = this.lock;
            synchronized (object) {
                return this.source == requestProcessor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block27: while (true) {
                Object object;
                RequestProcessor requestProcessor = null;
                Object object2 = this.lock;
                synchronized (object2) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(INACTIVE_TIMEOUT);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    requestProcessor = this.source;
                    this.source = null;
                    if (requestProcessor == null) {
                        object = pool;
                        synchronized (object) {
                            if (this.idle) {
                                pool.remove(this);
                                return;
                            }
                            continue;
                        }
                    }
                }
                object2 = null;
                object = RequestProcessor.logger();
                boolean bl = ((Logger)object).isLoggable(Level.FINE);
                if (bl) {
                    try {
                        this.procesing = requestProcessor;
                        ((Logger)object).log(Level.FINE, "Begining work {0}", this.getName());
                    }
                    finally {
                        this.procesing = null;
                    }
                }
                while (true) {
                    Lookup[] lookupArray = new Lookup[1];
                    Object object3 = requestProcessor.processorLock;
                    synchronized (object3) {
                        this.todo = requestProcessor.askForWork(this, (String)object2, lookupArray);
                        if (this.todo == null) {
                            // MONITOREXIT @DISABLED, blocks:[27, 28, 14, 31] lbl44 : MonitorExitStatement: MONITOREXIT : var6_7
                            if (!bl) continue block27;
                            break;
                        }
                    }
                    this.setPrio(this.todo.getPriority());
                    try {
                        this.procesing = requestProcessor;
                        if (bl) {
                            ((Logger)object).log(Level.FINE, "  Executing {0}", this.todo);
                        }
                        this.registerParallel(this.todo, requestProcessor);
                        Lookups.executeWith((Lookup)lookupArray[0], (Runnable)this.todo);
                        lookupArray[0] = null;
                        if (bl) {
                            ((Logger)object).log(Level.FINE, "  Execution finished in {0}", this.getName());
                        }
                        object2 = this.todo.debug();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        ((Logger)object).log(Level.SEVERE, null, outOfMemoryError);
                    }
                    catch (StackOverflowError stackOverflowError) {
                        Processor.doNotify(this.todo, stackOverflowError);
                    }
                    catch (ThreadDeath threadDeath) {
                    }
                    catch (Throwable throwable) {
                        Processor.doNotify(this.todo, throwable);
                    }
                    finally {
                        this.procesing = null;
                        this.unregisterParallel(this.todo, requestProcessor);
                    }
                    object3 = requestProcessor.processorLock;
                    synchronized (object3) {
                        this.todo = null;
                        Thread.interrupted();
                    }
                }
                try {
                    this.procesing = requestProcessor;
                    ((Logger)object).log(Level.FINE, "Work finished {0}", this.getName());
                    continue;
                }
                finally {
                    this.procesing = null;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void doEvaluate(Task task, Object object, RequestProcessor requestProcessor) {
            Task task2 = this.todo;
            boolean bl = Thread.interrupted();
            try {
                this.todo = task;
                task.run();
            }
            finally {
                Object object2 = object;
                synchronized (object2) {
                    this.todo = task2;
                    if ((bl || this.todo.item == null) && requestProcessor.interruptThread) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void interruptTask(Task task, RequestProcessor requestProcessor) {
            if (task != this.todo) {
                return;
            }
            if (requestProcessor.interruptThread) {
                this.interrupt();
            }
        }

        boolean interrupt(Task task, RequestProcessor requestProcessor) {
            if (task != this.todo) {
                return false;
            }
            this.interrupt();
            return true;
        }

        private static void doNotify(Task task, Throwable throwable) {
            Item item;
            if (SLOW && (item = task.item) != null && item.message == null) {
                item.message = "task failed due to: " + throwable;
                item.initCause(throwable);
                throwable = item;
            }
            RequestProcessor.logger().log(Level.SEVERE, "Error in RequestProcessor " + task.debug(), throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerParallel(Task task, RequestProcessor requestProcessor) {
            AtomicInteger atomicInteger;
            if (requestProcessor.warnParallel == 0 || task.run == null) {
                return;
            }
            Class<?> clazz = task.run.getClass();
            Object object = requestProcessor.processorLock;
            synchronized (object) {
                if (requestProcessor.inParallel == null) {
                    requestProcessor.inParallel = new WeakHashMap();
                }
                if ((atomicInteger = (AtomicInteger)requestProcessor.inParallel.get(clazz)) == null) {
                    atomicInteger = new AtomicInteger(1);
                    requestProcessor.inParallel.put(clazz, atomicInteger);
                } else {
                    atomicInteger.incrementAndGet();
                }
            }
            if (atomicInteger.get() >= requestProcessor.warnParallel && warnedClasses.put(clazz, "") == null) {
                object = "Too many " + clazz.getName() + " (" + atomicInteger + ") in shared RequestProcessor; create your own";
                IllegalStateException illegalStateException = null;
                Item item = task.item;
                if (item != null) {
                    illegalStateException = new IllegalStateException((String)object);
                    illegalStateException.setStackTrace(item.getStackTrace());
                }
                RequestProcessor.logger().log(Level.WARNING, (String)object, illegalStateException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterParallel(Task task, RequestProcessor requestProcessor) {
            if (requestProcessor.warnParallel == 0 || task.run == null) {
                return;
            }
            Object object = requestProcessor.processorLock;
            synchronized (object) {
                Class<?> clazz = task.run.getClass();
                ((AtomicInteger)requestProcessor.inParallel.get(clazz)).decrementAndGet();
            }
        }
    }

    private static class SlowItem
    extends Item {
        SlowItem(Task task, RequestProcessor requestProcessor) {
            super(task, requestProcessor);
        }

        @Override
        public Throwable fillInStackTrace() {
            Throwable throwable = super.fillInStackTrace();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                if (stackTraceElementArray[i].getClassName().startsWith("java.lang") || stackTraceElementArray[i].getClassName().startsWith(RequestProcessor.class.getName())) continue;
                throwable.setStackTrace(Arrays.asList(stackTraceElementArray).subList(i - 1, stackTraceElementArray.length).toArray(new StackTraceElement[0]));
                break;
            }
            return throwable;
        }
    }

    private static class FastItem
    extends Item {
        FastItem(Task task, RequestProcessor requestProcessor) {
            super(task, requestProcessor);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class CreatedItem
    extends Item {
        public CreatedItem(Task task, RequestProcessor requestProcessor) {
            super(task, requestProcessor);
        }

        @Override
        boolean clearOrNew(boolean bl) {
            return bl;
        }

        @Override
        boolean clear(Processor processor) {
            return false;
        }

        @Override
        boolean isNew() {
            return true;
        }
    }

    private static class Item
    extends Exception
    implements Comparable<Item> {
        private static int counter;
        private final RequestProcessor owner;
        private final int cnt;
        final Lookup current;
        final ClassLoader ctxLoader;
        Object action;
        boolean enqueued;
        String message;
        long when;

        Item(Task task, RequestProcessor requestProcessor) {
            this.action = task;
            this.owner = requestProcessor;
            this.cnt = counter++;
            this.current = Lookup.getDefault();
            this.ctxLoader = Thread.currentThread().getContextClassLoader();
        }

        final Task getTask() {
            Object object = this.action;
            return object instanceof Task ? (Task)object : null;
        }

        boolean clearOrNew(boolean bl) {
            return this.clear(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean clear(Processor processor) {
            boolean bl;
            Object object = this.owner.processorLock;
            synchronized (object) {
                bl = this.enqueued ? this.owner.getQueue().remove(this) : true;
                this.action = processor;
            }
            TickTac.cancel(this);
            return bl;
        }

        boolean isNew() {
            return false;
        }

        final Processor getProcessor() {
            Object object = this.action;
            return object instanceof Processor ? (Processor)object : null;
        }

        final int getPriority() {
            Task task = this.getTask();
            return task == null ? 0 : task.getPriority();
        }

        @Override
        public final String getMessage() {
            return this.message;
        }

        @Override
        public int compareTo(Item item) {
            int n;
            if (this == item) {
                return 0;
            }
            int n2 = this.getPriority();
            if (n2 == (n = item.getPriority())) {
                return this.cnt - item.cnt;
            }
            return n - n2;
        }
    }

    public final class Task
    extends org.openide.util.Task
    implements Cancellable {
        private Item item;
        private int priority;
        private long time;
        private Thread lastThread;
        private AtomicBoolean cancelled;

        Task(Runnable runnable) {
            super(runnable);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
        }

        Task(Runnable runnable, int n) {
            super(runnable);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
            if (n < 1) {
                n = 1;
            }
            if (n > 10) {
                n = 10;
            }
            this.priority = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            try {
                object = Task.class;
                synchronized (Task.class) {
                    while (this.lastThread != null) {
                        try {
                            Task.class.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.lastThread = Thread.currentThread();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    this.notifyRunning();
                    this.run.run();
                }
            }
            finally {
                object = this.item;
                if (object == null || ((Item)object).isNew() || ((Item)object).getTask() != this) {
                    this.notifyFinished();
                }
                Class<Task> clazz = Task.class;
                synchronized (Task.class) {
                    this.lastThread = null;
                    Task.class.notifyAll();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
            }
            {
                return;
            }
        }

        public int getDelay() {
            long l = this.time - System.currentTimeMillis();
            if (l < 0L) {
                return 0;
            }
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        public void schedule(int n) {
            this.schedule((long)n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(long l) {
            Item item;
            if (RequestProcessor.this.stopped) {
                return;
            }
            this.time = System.currentTimeMillis() + l;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.cancelled != null) {
                    this.cancelled.set(false);
                }
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear(null);
                }
                item = this.item = RequestProcessor.this.enableStackTraces ? new SlowItem(this, RequestProcessor.this) : new FastItem(this, RequestProcessor.this);
            }
            if (l == 0L) {
                RequestProcessor.this.enqueue(item);
            } else {
                TickTac.schedule(item, l);
            }
        }

        private void markCreated() {
            assert (this.item == null);
            this.item = new CreatedItem(this, null);
        }

        @Override
        public boolean cancel() {
            return this.cancelOrNew(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cancelOrNew(boolean bl) {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean bl2;
                if (this.item == null) {
                    bl2 = false;
                } else {
                    Processor processor = this.item.getProcessor();
                    bl2 = this.item.clearOrNew(bl);
                    if (processor != null) {
                        processor.interruptTask(this, RequestProcessor.this);
                        this.item = null;
                    }
                    if (bl2) {
                        this.item = null;
                    }
                }
                if (bl2) {
                    this.notifyFinished();
                }
                return bl2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel(boolean bl) {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean bl2;
                if (this.cancelled != null) {
                    boolean bl3 = bl2 = !this.cancelled.getAndSet(true);
                    if (bl2) {
                        return false;
                    }
                }
                if (this.item == null) {
                    bl2 = false;
                } else {
                    Processor processor = this.item.getProcessor();
                    bl2 = this.item.clear(null);
                    if (processor != null) {
                        if (bl) {
                            bl2 = processor.interrupt(this, RequestProcessor.this);
                        } else {
                            processor.interruptTask(this, RequestProcessor.this);
                        }
                        if (bl2) {
                            this.item = null;
                        }
                    }
                }
                if (bl2) {
                    this.notifyFinished();
                }
                return bl2;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPriority(int n) {
            if (this.priority == n) {
                return;
            }
            if (n < 1) {
                n = 1;
            }
            if (n > 10) {
                n = 10;
            }
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.item != null && RequestProcessor.this.getQueue().remove(this.item)) {
                    this.priority = n;
                    RequestProcessor.this.prioritizedEnqueue(this.item);
                } else {
                    this.priority = n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl;
                boolean bl2;
                Logger logger = RequestProcessor.logger();
                boolean bl3 = logger.isLoggable(Level.FINE);
                if (bl3) {
                    logger.log(Level.FINE, "Task.waitFinished on {0} from other task in RP: {1}", new Object[]{this, Thread.currentThread().getName()});
                }
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    bl2 = this.cancelOrNew(true);
                    boolean bl4 = bl = bl2 && (this.item == null || this.item.clear(null));
                    if (bl3) {
                        logger.log(Level.FINE, "    ## finished: {0}", this.isFinished());
                        logger.log(Level.FINE, "    ## item: {0}", this.item);
                    }
                }
                if (bl) {
                    if (bl3) {
                        logger.fine("    ## running it synchronously");
                    }
                    object = (Processor)Thread.currentThread();
                    ((Processor)object).doEvaluate(this, RequestProcessor.this.processorLock, RequestProcessor.this);
                } else {
                    if (bl3) {
                        logger.fine("    ## not running it synchronously");
                    }
                    if ((bl2 || this.lastThread != null) && this.lastThread != Thread.currentThread()) {
                        if (bl3) {
                            logger.log(Level.FINE, "    ## waiting for it to be finished: {0} now: {1}", new Object[]{this.lastThread, Thread.currentThread()});
                        }
                        super.waitFinished();
                    }
                }
                if (bl3) {
                    logger.fine("    ## exiting waitFinished");
                }
            } else {
                super.waitFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean waitFinished(long l) throws InterruptedException {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    bl = this.cancelOrNew(true);
                }
                if (bl) {
                    throw new InterruptedException("Cannot wait with timeout " + l + " from the RequestProcessor thread for task: " + this);
                }
                if (this.lastThread != Thread.currentThread()) {
                    return super.waitFinished(l);
                }
                return true;
            }
            return super.waitFinished(l);
        }

        @Override
        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }
    }

    private static final class ScheduledRPFutureTask<T>
    extends RPFutureTask<T>
    implements ScheduledFuture<T> {
        protected final long delayMillis;

        ScheduledRPFutureTask(Callable<T> callable, long l) {
            super(callable);
            this.delayMillis = l;
        }

        ScheduledRPFutureTask(Runnable runnable, T t, long l) {
            super(runnable, t);
            this.delayMillis = l;
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.delayMillis, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            long l = delayed.getDelay(TimeUnit.MILLISECONDS);
            return (int)(this.delayMillis - l);
        }
    }

    private static class RPFutureTask<T>
    extends FutureTask<T>
    implements RunnableWrapper {
        protected volatile Task task;
        private final Runnable runnable;
        private final Cancellable cancellable;

        RPFutureTask(Callable<T> callable) {
            super(callable);
            this.runnable = null;
            this.cancellable = callable instanceof Cancellable ? (Cancellable)((Object)callable) : null;
        }

        RPFutureTask(Runnable runnable, T t) {
            super(runnable, t);
            this.runnable = runnable;
            this.cancellable = runnable instanceof Cancellable ? (Cancellable)((Object)runnable) : null;
        }

        void setTask(Task task) {
            this.task = task;
        }

        RPFutureTask(Callable<T> callable, T t) {
            this(callable);
            this.set(t);
        }

        @Override
        public boolean cancel(boolean bl) {
            boolean bl2;
            boolean bl3 = bl2 = this.cancellable == null ? true : this.cancellable.cancel();
            if (bl2) {
                boolean bl4 = this.task.cancel();
                boolean bl5 = super.cancel(bl);
                bl2 = bl4 && bl5;
            }
            return bl2;
        }

        @Override
        public Runnable getRunnable() {
            return this.runnable;
        }
    }

    private static final class WaitableCallable<T>
    implements Callable<T>,
    Cancellable {
        private final CountDownLatch countdown;
        private final Callable<T> delegate;
        private final AtomicReference<T> ref;
        private volatile boolean failed;

        WaitableCallable(Callable<T> callable, CountDownLatch countDownLatch) {
            this(callable, null, countDownLatch);
        }

        WaitableCallable(Callable<T> callable, AtomicReference<T> atomicReference, CountDownLatch countDownLatch) {
            this.delegate = callable;
            this.countdown = countDownLatch;
            this.ref = atomicReference;
        }

        boolean failed() {
            return this.failed;
        }

        @Override
        public T call() throws Exception {
            try {
                T t = this.delegate.call();
                if (this.ref != null) {
                    this.ref.set(t);
                }
                T t2 = t;
                return t2;
            }
            catch (RuntimeException runtimeException) {
                this.failed = true;
                throw runtimeException;
            }
            catch (Error error) {
                this.failed = true;
                throw error;
            }
            finally {
                if (!this.failed || this.ref == null) {
                    this.countdown.countDown();
                }
            }
        }

        @Override
        public boolean cancel() {
            return this.delegate instanceof Cancellable ? ((Cancellable)((Object)this.delegate)).cancel() : true;
        }
    }

    private static interface RunnableWrapper {
        public Runnable getRunnable();
    }

    private static final class FixedDelayTask
    extends TaskFutureWrapper {
        private final AtomicLong nextRunTime = new AtomicLong();

        FixedDelayTask(Runnable runnable, long l, long l2) {
            super(runnable, l, l2);
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            long l = this.nextRunTime.get();
            return timeUnit.convert(l - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            if (!this.fini()) {
                this.toRun.run();
            }
            if (!this.fini()) {
                this.reschedule();
            }
        }

        private boolean fini() {
            boolean bl = this.cancelled.get() || Thread.currentThread().isInterrupted();
            return bl;
        }

        private void reschedule() {
            this.nextRunTime.set(System.currentTimeMillis() + this.period);
            if (!this.fini()) {
                this.t.schedule((int)this.period);
            }
        }
    }

    private static final class FixedRateTask
    extends TaskFutureWrapper {
        private final Object runLock = new Object();
        private final Object timeLock = new Object();
        private int runCount;
        private long nextRunTime;
        private long start = Long.MIN_VALUE;
        volatile boolean firstRun = true;

        FixedRateTask(Runnable runnable, long l, long l2) {
            super(runnable, l, l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (this.firstRun) {
                object = this.timeLock;
                synchronized (object) {
                    this.start = System.currentTimeMillis();
                    this.firstRun = false;
                }
            }
            try {
                object = this.runLock;
                synchronized (object) {
                    this.toRun.run();
                }
            }
            catch (RuntimeException runtimeException) {
                this.cancel(true);
                throw runtimeException;
            }
            this.reschedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reschedule() {
            boolean bl;
            long l;
            Object object = this.timeLock;
            synchronized (object) {
                this.nextRunTime = this.start + (this.initialDelay + this.period * (long)this.runCount);
                ++this.runCount;
                l = Math.max(0L, this.nextRunTime - System.currentTimeMillis());
            }
            boolean bl2 = bl = !this.cancelled.get() && !Thread.currentThread().isInterrupted();
            if (bl) {
                this.t.schedule(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getDelay(TimeUnit timeUnit) {
            long l;
            if (this.isCancelled()) {
                return Long.MAX_VALUE;
            }
            Object object = this.timeLock;
            synchronized (object) {
                l = Math.min(0L, this.nextRunTime - System.currentTimeMillis());
            }
            return timeUnit.convert(l, TimeUnit.MILLISECONDS);
        }
    }

    private static abstract class TaskFutureWrapper
    implements ScheduledFuture<Void>,
    Runnable,
    RunnableWrapper {
        volatile Task t;
        protected final Runnable toRun;
        protected final long initialDelay;
        protected final long period;
        final AtomicBoolean cancelled = new AtomicBoolean();

        TaskFutureWrapper(Runnable runnable, long l, long l2) {
            this.toRun = runnable;
            this.initialDelay = l;
            this.period = l2;
        }

        @Override
        public final Runnable getRunnable() {
            return this.toRun;
        }

        @Override
        public int compareTo(Delayed delayed) {
            long l = delayed.getDelay(TimeUnit.MILLISECONDS);
            long l2 = this.getDelay(TimeUnit.MILLISECONDS);
            return (int)(l2 - l);
        }

        @Override
        public boolean cancel(boolean bl) {
            boolean bl2 = true;
            if (this.toRun instanceof Cancellable) {
                bl2 = ((Cancellable)((Object)this.toRun)).cancel();
            }
            if (bl2) {
                bl2 = this.t.cancel(bl);
            }
            return bl2;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.cancelled.get() || this.t.isFinished();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
            this.t.waitFinished();
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
            return null;
        }

        @Override
        public Void get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
            long l2 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            this.t.waitFinished(l2);
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
            return null;
        }
    }

    private static final class TopLevelThreadGroup
    implements PrivilegedAction<ThreadGroup> {
        private TopLevelThreadGroup() {
        }

        public ThreadGroup getTopLevelThreadGroup() {
            ThreadGroup threadGroup = AccessController.doPrivileged(this);
            ThreadGroup threadGroup2 = null;
            try {
                Class<?> clazz = Class.forName("sun.awt.AppContext");
                Method method = clazz.getMethod("getAppContext", new Class[0]);
                Method method2 = clazz.getMethod("getThreadGroup", new Class[0]);
                threadGroup2 = (ThreadGroup)method2.invoke(method.invoke(null, new Object[0]), new Object[0]);
            }
            catch (Exception exception) {
                RequestProcessor.logger().log(Level.FINE, "Cannot access sun.awt.AppContext", exception);
                return threadGroup;
            }
            assert (threadGroup2 != null);
            if (threadGroup2 != threadGroup) {
                RequestProcessor.logger().log(Level.WARNING, "AppContext group {0} differs from originally used {1}", new Object[]{threadGroup2, threadGroup});
            }
            return threadGroup2;
        }

        @Override
        public ThreadGroup run() {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            return threadGroup;
        }
    }
}

