/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.util.HelpCtx;

public final class RunGCAction
extends ProfilingAwareAction {
    private static final int[] ENABLED_STATES = new int[]{4};

    public static RunGCAction getInstance() {
        return Singleton.INSTANCE;
    }

    protected RunGCAction() {
        this.setIcon(Icons.getIcon((String)"ProfilerIcons.RunGC"));
        this.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.RunGC"));
        this.putProperty("ShortDescription", Bundle.HINT_RunGCAction());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.LBL_RunGCAction();
    }

    public void performAction() {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Profiler.getDefault().getTargetAppRunner().runGC();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProfilerDialogs.displayWarning((String)targetAppOrVMTerminated.getMessage());
                        }
                    });
                    ProfilerLogger.log((String)targetAppOrVMTerminated.getMessage());
                }
            }
        });
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    private static final class Singleton {
        private static final RunGCAction INSTANCE = new RunGCAction();

        private Singleton() {
        }
    }
}

