/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.explorer;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.openide.explorer.Bundle;
import org.netbeans.modules.openide.explorer.ExternalDragAndDrop;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExtendedDelete;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public final class ExplorerActionsImpl {
    private static final RequestProcessor RP = new RequestProcessor("Explorer Actions");
    private static final Logger LOG = Logger.getLogger(ExplorerActionsImpl.class.getName());
    private final CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private final CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private final DeleteActionPerformer deleteActionPerformerConfirm = new DeleteActionPerformer(true);
    private final DeleteActionPerformer deleteActionPerformerNoConfirm = new DeleteActionPerformer(false);
    private final OwnPaste pasteActionPerformer = new OwnPaste();
    private ActionStateUpdater actionStateUpdater;
    private ExplorerManager manager;

    public Action copyAction() {
        return this.copyActionPerformer;
    }

    public Action cutAction() {
        return this.cutActionPerformer;
    }

    public Action deleteAction(boolean bl) {
        return bl ? this.deleteActionPerformerConfirm : this.deleteActionPerformerNoConfirm;
    }

    public Action pasteAction() {
        return this.pasteActionPerformer;
    }

    public synchronized void attach(ExplorerManager explorerManager) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = explorerManager;
        this.actionStateUpdater = new ActionStateUpdater(this.manager);
        this.actionStateUpdater.schedule();
    }

    public synchronized void detach() {
        if (this.manager == null || this.actionStateUpdater == null) {
            return;
        }
        this.actionStateUpdater.unlisten(this.manager);
        this.actionStateUpdater = null;
        this.stopActions();
        this.manager = null;
    }

    final void stopActions() {
        assert (EventQueue.isDispatchThread());
        if (this.copyActionPerformer != null) {
            this.copyActionPerformer.setEnabled(false);
            this.cutActionPerformer.setEnabled(false);
            this.deleteActionPerformerConfirm.setEnabled(false);
            this.deleteActionPerformerNoConfirm.setEnabled(false);
            this.pasteActionPerformer.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateActions(boolean bl) {
        assert (!EventQueue.isDispatchThread());
        Node[] nodeArray = this;
        synchronized (this) {
            int n;
            ExplorerManager explorerManager = this.manager;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (explorerManager == null) {
                return;
            }
            nodeArray = explorerManager.getSelectedNodes();
            int n2 = n = nodeArray != null ? nodeArray.length : 0;
            if (n > 0) {
                int n3;
                boolean bl2 = false;
                if (n > 1) {
                    HashMap<Node, Object> hashMap = new HashMap<Node, Object>(101);
                    for (n3 = 0; n3 < n; ++n3) {
                        if (super.checkParents(nodeArray[n3], hashMap)) continue;
                        bl2 = true;
                        break;
                    }
                }
                for (n3 = 0; n3 < n; ++n3) {
                    if (!bl2 && nodeArray[n3].canCopy()) continue;
                    this.copyActionPerformer.toEnabled(false);
                    break;
                }
                if (n3 == n) {
                    this.copyActionPerformer.toEnabled(true);
                }
                for (n3 = 0; n3 < n; ++n3) {
                    if (!bl2 && nodeArray[n3].canCut()) continue;
                    this.cutActionPerformer.toEnabled(false);
                    break;
                }
                if (n3 == n) {
                    this.cutActionPerformer.toEnabled(true);
                }
                for (n3 = 0; n3 < n; ++n3) {
                    if (!bl2 && nodeArray[n3].canDestroy()) continue;
                    this.deleteActionPerformerConfirm.toEnabled(false);
                    this.deleteActionPerformerNoConfirm.toEnabled(false);
                    break;
                }
                if (n3 == n) {
                    this.deleteActionPerformerConfirm.toEnabled(true);
                    this.deleteActionPerformerNoConfirm.toEnabled(true);
                }
            } else {
                this.copyActionPerformer.toEnabled(false);
                this.cutActionPerformer.toEnabled(false);
                this.deleteActionPerformerConfirm.toEnabled(false);
                this.deleteActionPerformerNoConfirm.toEnabled(false);
            }
            if (bl) {
                super.updatePasteAction(nodeArray);
            }
            return;
        }
    }

    private boolean checkParents(Node node, HashMap<Node, Object> hashMap) {
        if (hashMap.get(node) != null) {
            return false;
        }
        hashMap.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (hashMap.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] nodeArray) {
        ExplorerManager explorerManager = this.manager;
        if (explorerManager == null) {
            this.pasteActionPerformer.setPasteTypes(null);
            return;
        }
        if (nodeArray != null && nodeArray.length > 1) {
            this.pasteActionPerformer.setPasteTypes(null);
            return;
        }
        Node node = explorerManager.getExploredContext();
        Node[] nodeArray2 = explorerManager.getSelectedNodes();
        if (nodeArray2 != null && nodeArray2.length == 1) {
            node = nodeArray2[0];
        }
        if (node != null) {
            if (this.actionStateUpdater != null) {
                Transferable transferable = this.actionStateUpdater.getTransferable();
                if (transferable != null) {
                    this.updatePasteTypes(this.wrapTransferable(transferable, node), node);
                }
            } else {
                LOG.fine("#126145: caused by http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6322854");
            }
        }
    }

    private Transferable wrapTransferable(Transferable transferable, Node node) {
        class ExplorerTransferable
        implements Transferable,
        Lookup.Provider {
            private final Transferable delegate;
            private final Lookup lookup;

            public ExplorerTransferable(Transferable transferable, Node node) {
                this.delegate = transferable;
                this.lookup = Lookups.singleton((Object)node);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return this.delegate.getTransferDataFlavors();
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return this.delegate.isDataFlavorSupported(dataFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return this.delegate.getTransferData(dataFlavor);
            }

            public Lookup getLookup() {
                return this.lookup;
            }
        }
        return new ExplorerTransferable(transferable, node);
    }

    private void updatePasteTypes(Transferable transferable, Node node) {
        if (transferable != null) {
            PasteType[] pasteTypeArray;
            PasteType[] pasteTypeArray2 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferable);
            if (pasteTypeArray.length != 0) {
                this.pasteActionPerformer.setPasteTypes(pasteTypeArray);
                return;
            }
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    int n = multiTransferObject.getCount();
                    boolean bl = true;
                    Transferable[] transferableArray = new Transferable[n];
                    PasteType[] pasteTypeArray3 = new PasteType[n];
                    for (int i = 0; i < n; ++i) {
                        transferableArray[i] = multiTransferObject.getTransferableAt(i);
                        PasteType[] pasteTypeArray4 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferableArray[i]);
                        if (pasteTypeArray.length == 0) {
                            bl = false;
                            break;
                        }
                        pasteTypeArray3[i] = pasteTypeArray[0];
                    }
                    if (bl) {
                        PasteType[] pasteTypeArray5 = new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray3)};
                        this.pasteActionPerformer.setPasteTypes(pasteTypeArray5);
                        return;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.pasteActionPerformer.setPasteTypes(null);
    }

    private static Transferable getTransferableOwner(Node node, boolean bl) {
        try {
            return bl ? node.clipboardCopy() : node.clipboardCut();
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return null;
        }
    }

    public static Transferable getTransferableOwner(Node[] nodeArray, boolean bl) {
        Transferable transferable;
        if (nodeArray.length != 1) {
            Transferable[] transferableArray = new Transferable[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                transferableArray[i] = ExplorerActionsImpl.getTransferableOwner(nodeArray[i], bl);
                if (transferableArray[i] != null) continue;
                return null;
            }
            transferable = ExternalDragAndDrop.maybeAddExternalFileDnd(new ExTransferable.Multi(transferableArray));
        } else {
            transferable = ExplorerActionsImpl.getTransferableOwner(nodeArray[0], bl);
        }
        return transferable;
    }

    public static Clipboard getClipboard() {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    final void syncActions() {
        this.copyActionPerformer.syncEnable();
        this.cutActionPerformer.syncEnable();
        this.deleteActionPerformerConfirm.syncEnable();
        this.deleteActionPerformerNoConfirm.syncEnable();
        this.pasteActionPerformer.syncEnable();
    }

    private boolean actionsUpdateScheduled() {
        ActionStateUpdater actionStateUpdater = this.actionStateUpdater;
        return actionStateUpdater != null ? actionStateUpdater.updateScheduled() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitFinished() {
        ActionStateUpdater actionStateUpdater = this.actionStateUpdater;
        ExplorerActionsImpl explorerActionsImpl = this;
        synchronized (explorerActionsImpl) {
            actionStateUpdater = this.actionStateUpdater;
        }
        if (actionStateUpdater == null) {
            return;
        }
        actionStateUpdater.waitFinished();
        if (EventQueue.isDispatchThread()) {
            actionStateUpdater.run();
        } else {
            try {
                EventQueue.invokeAndWait(actionStateUpdater);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    static /* synthetic */ RequestProcessor access$500() {
        return RP;
    }

    private class ActionStateUpdater
    implements PropertyChangeListener,
    FlavorListener,
    Runnable {
        private final RequestProcessor.Task timer = ExplorerActionsImpl.access$500().create((Runnable)this);
        private final PropertyChangeListener weakL;
        private FlavorListener flavL;
        private Transferable trans;

        ActionStateUpdater(ExplorerManager explorerManager) {
            this.weakL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)explorerManager);
            explorerManager.addPropertyChangeListener(this.weakL);
        }

        void unlisten(ExplorerManager explorerManager) {
            explorerManager.removePropertyChangeListener(this.weakL);
        }

        boolean updateScheduled() {
            return this.timer.getDelay() > 0;
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.schedule();
        }

        @Override
        public void flavorsChanged(FlavorEvent flavorEvent) {
            this.schedule();
        }

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                ExplorerActionsImpl.this.syncActions();
            } else {
                ExplorerActionsImpl.this.updateActions(false);
                EventQueue.invokeLater(this);
                this.registerListener();
                this.updateTrans();
                ExplorerActionsImpl.this.updateActions(true);
                EventQueue.invokeLater(this);
            }
        }

        private void registerListener() {
            Clipboard clipboard;
            if (this.flavL == null && (clipboard = ExplorerActionsImpl.getClipboard()) != null) {
                this.flavL = (FlavorListener)WeakListeners.create(FlavorListener.class, (EventListener)this, (Object)clipboard);
                clipboard.addFlavorListener(this.flavL);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTrans() {
            Clipboard clipboard = ExplorerActionsImpl.getClipboard();
            if (clipboard == null) {
                return;
            }
            Transferable transferable = clipboard.getContents(ExplorerActionsImpl.this);
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                this.trans = transferable;
            }
        }

        final Transferable getTransferable() {
            return this.trans;
        }

        public void update() {
            if (EventQueue.isDispatchThread()) {
                try {
                    this.timer.waitFinished(100L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.FINE, null, interruptedException);
                }
            } else {
                this.timer.waitFinished();
            }
        }

        private void schedule() {
            ExplorerActionsImpl.this.copyActionPerformer.toEnabled(false);
            ExplorerActionsImpl.this.cutActionPerformer.toEnabled(false);
            ExplorerActionsImpl.this.deleteActionPerformerConfirm.toEnabled(false);
            ExplorerActionsImpl.this.deleteActionPerformerNoConfirm.toEnabled(false);
            ExplorerActionsImpl.this.pasteActionPerformer.toEnabled(false);
            EventQueue.invokeLater(this);
            this.timer.schedule(0);
        }

        final void waitFinished() {
            this.timer.waitFinished();
        }
    }

    private class DeleteActionPerformer
    extends BaseAction
    implements Runnable {
        private boolean confirmDelete;

        DeleteActionPerformer(boolean bl) {
            this.confirmDelete = bl;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExplorerManager explorerManager = ExplorerActionsImpl.this.manager;
            if (explorerManager == null) {
                return;
            }
            Node[] nodeArray = explorerManager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            for (ExtendedDelete extendedDelete : Lookup.getDefault().lookupAll(ExtendedDelete.class)) {
                try {
                    if (!extendedDelete.delete(nodeArray)) continue;
                    return;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return;
                }
            }
            if (!this.confirmDelete || this.doConfirm(nodeArray)) {
                try {
                    explorerManager.setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(nodeArray);
                Mutex.EVENT.readAccess((Runnable)this);
            }
        }

        @Override
        public void run() {
            assert (EventQueue.isDispatchThread());
            this.setEnabled(false);
        }

        private boolean doConfirm(Node[] nodeArray) {
            String string;
            String string2;
            boolean bl = true;
            for (int i = 0; i < nodeArray.length; ++i) {
                if (Boolean.TRUE.equals(nodeArray[i].getValue("customDelete"))) continue;
                bl = false;
                break;
            }
            if (bl) {
                return true;
            }
            if (nodeArray.length == 1) {
                string2 = Bundle.MSG_ConfirmDeleteObject(nodeArray[0].getDisplayName());
                string = Bundle.MSG_ConfirmDeleteObjectTitle();
            } else {
                string2 = Bundle.MSG_ConfirmDeleteObjects(nodeArray.length);
                string = Bundle.MSG_ConfirmDeleteObjectsTitle();
            }
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, string, 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation));
        }

        private void doDestroy(Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                try {
                    nodeArray[i].destroy();
                    continue;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private class CopyCutActionPerformer
    extends BaseAction {
        private boolean copyCut;

        public CopyCutActionPerformer(boolean bl) {
            this.copyCut = bl;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Clipboard clipboard;
            ExplorerManager explorerManager = ExplorerActionsImpl.this.manager;
            if (explorerManager == null) {
                return;
            }
            Node[] nodeArray = explorerManager.getSelectedNodes();
            Transferable transferable = ExplorerActionsImpl.getTransferableOwner(nodeArray, this.copyCut);
            if (transferable != null && (clipboard = ExplorerActionsImpl.getClipboard()) != null) {
                clipboard.setContents(transferable, new StringSelection(""));
            }
        }
    }

    private static abstract class BaseAction
    extends AbstractAction {
        private volatile Boolean toEnable;

        private BaseAction() {
        }

        public void toEnabled(boolean bl) {
            this.toEnable = bl;
        }

        public void syncEnable() {
            assert (EventQueue.isDispatchThread());
            if (this.toEnable != null) {
                this.setEnabled(this.toEnable);
                this.toEnable = null;
            }
        }
    }

    private class OwnPaste
    extends BaseAction {
        private PasteType[] pasteTypes;

        OwnPaste() {
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPasteTypes(PasteType[] pasteTypeArray) {
            OwnPaste ownPaste = this;
            synchronized (ownPaste) {
                this.pasteTypes = pasteTypeArray;
            }
            LOG.log(Level.FINER, "setPasteTypes for {0}", Arrays.toString(pasteTypeArray));
            this.toEnabled(pasteTypeArray != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PasteType[] pasteTypeArray;
            OwnPaste ownPaste = this;
            synchronized (ownPaste) {
                pasteTypeArray = this.pasteTypes;
            }
            if (pasteTypeArray != null && pasteTypeArray.length > 0) {
                try {
                    pasteTypeArray[0].paste();
                    return;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            Utilities.disabledActionBeep();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(String string) {
            if ("delegates".equals(string)) {
                Object object;
                EventListener eventListener;
                String string2 = "";
                if (LOG.isLoggable(Level.FINE)) {
                    eventListener = this;
                    synchronized (eventListener) {
                        string2 = Arrays.toString(this.pasteTypes);
                    }
                }
                if ((eventListener = ExplorerActionsImpl.this.actionStateUpdater) != null) {
                    ((ActionStateUpdater)eventListener).update();
                }
                if (LOG.isLoggable(Level.FINE)) {
                    OwnPaste ownPaste = this;
                    synchronized (ownPaste) {
                        object = Arrays.toString(this.pasteTypes);
                    }
                    if (object == null) {
                        object = "";
                    }
                    if (string2.equals(object)) {
                        LOG.log(Level.FINER, "getDelegates {0}", object);
                    } else {
                        LOG.log(Level.FINE, "Delegates updated. Before: {0}", string2);
                        LOG.log(Level.FINE, "Delegates updated. After : {0}", object);
                    }
                }
                object = this;
                synchronized (object) {
                    return this.pasteTypes;
                }
            }
            return super.getValue(string);
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.t = transferableArray;
            this.p = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            int n = this.p.length;
            Transferable[] transferableArray = new Transferable[n];
            for (int i = 0; i < n; ++i) {
                Transferable transferable = this.p[i].paste();
                transferableArray[i] = transferable != null ? transferable : this.t[i];
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }
}

