/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.lib.profiler.ui.swing.PopupButton;

public class ActionPopupButton
extends PopupButton {
    private Action action;
    private final Action[] actions;

    public ActionPopupButton(Action ... actionArray) {
        this(0, actionArray);
    }

    public ActionPopupButton(int n, Action ... actionArray) {
        this.actions = actionArray;
        this.selectAction(n);
    }

    public final Action[] getActions() {
        return this.actions;
    }

    public final void selectAction(Action action) {
        this.action = action;
        this.setText(this.action == null ? "" : this.action.getValue("Name").toString());
    }

    public final void selectAction(int n) {
        this.selectAction(this.actions[n]);
    }

    public final Action getSelectedAction() {
        return this.action;
    }

    public final int getSelectedIndex() {
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i] != this.action) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void populatePopup(JPopupMenu jPopupMenu) {
        for (final Action action : this.actions) {
            if (action != null) {
                jPopupMenu.add(new JRadioButtonMenuItem(action.getValue("Name").toString(), action == this.action){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ActionPopupButton.this.selectAction(action);
                        action.actionPerformed(actionEvent);
                    }
                });
                continue;
            }
            jPopupMenu.addSeparator();
        }
    }
}

