/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fop.complexscripts.util.UTF32;

public class NumberConverter {
    public static final int LETTER_VALUE_ALPHABETIC = 1;
    public static final int LETTER_VALUE_TRADITIONAL = 2;
    private static final int TOKEN_NONE = 0;
    private static final int TOKEN_ALPHANUMERIC = 1;
    private static final int TOKEN_NONALPHANUMERIC = 2;
    private static final Integer[] DEFAULT_TOKEN = new Integer[]{49};
    private static final Integer[] DEFAULT_SEPARATOR = new Integer[]{46};
    private static final String DEFAULT_LANGUAGE = "eng";
    private Integer[] prefix;
    private Integer[] suffix;
    private Integer[][] tokens;
    private Integer[][] separators;
    private int groupingSeparator;
    private int groupingSize;
    private int letterValue;
    private String features;
    private String language;
    private String country;
    private static String[][] equivalentLanguages = new String[][]{{"eng", "en"}, {"fra", "fre", "fr"}, {"spa", "es"}};
    private static int[][] supportedAlphabeticSequences = new int[][]{{65, 26}, {97, 26}};
    private static int[][] supportedSpecials = new int[][]{{73}, {105}, {913}, {945}, {1488}, {1571}, {1575}, {3585}, {12354}, {12356}, {12450}, {12452}};
    private static String[] englishWordOnes = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static String[] englishWordTeens = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static String[] englishWordTens = new String[]{"", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static String[] englishWordOthers = new String[]{"hundred", "thousand", "million", "billion"};
    private static String[] englishWordOnesOrd = new String[]{"none", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth"};
    private static String[] englishWordTeensOrd = new String[]{"tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    private static String[] englishWordTensOrd = new String[]{"", "tenth", "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetith"};
    private static String[] englishWordOthersOrd = new String[]{"hundredth", "thousandth", "millionth", "billionth"};
    private static String[] frenchWordOnes = new String[]{"z\u00e9ro", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf"};
    private static String[] frenchWordTeens = new String[]{"dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix-sept", "dix-huit", "dix-neuf"};
    private static String[] frenchWordTens = new String[]{"", "dix", "vingt", "trente", "quarante", "cinquante", "soixante", "soixante-dix", "quatre-vingt", "quatre-vingt-dix"};
    private static String[] frenchWordOthers = new String[]{"cent", "cents", "mille", "million", "millions", "milliard", "milliards"};
    private static String[] frenchWordOnesOrdMale = new String[]{"premier", "deuxi\u00e8me", "troisi\u00e8me", "quatri\u00e8me", "cinqui\u00e8me", "sixi\u00e8me", "septi\u00e8me", "huiti\u00e8me", "neuvi\u00e8me", "dixi\u00e8me"};
    private static String[] frenchWordOnesOrdFemale = new String[]{"premi\u00e8re", "deuxi\u00e8me", "troisi\u00e8me", "quatri\u00e8me", "cinqui\u00e8me", "sixi\u00e8me", "septi\u00e8me", "huiti\u00e8me", "neuvi\u00e8me", "dixi\u00e8me"};
    private static String[] spanishWordOnes = new String[]{"cero", "uno", "dos", "tres", "cuatro", "cinco", "seise", "siete", "ocho", "nueve"};
    private static String[] spanishWordTeens = new String[]{"diez", "once", "doce", "trece", "catorce", "quince", "diecis\u00e9is", "diecisiete", "dieciocho", "diecinueve"};
    private static String[] spanishWordTweens = new String[]{"veinte", "veintiuno", "veintid\u00f3s", "veintitr\u00e9s", "veinticuatro", "veinticinco", "veintis\u00e9is", "veintisiete", "veintiocho", "veintinueve"};
    private static String[] spanishWordTens = new String[]{"", "diez", "veinte", "treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa"};
    private static String[] spanishWordHundreds = new String[]{"", "ciento", "doscientos", "trescientos", "cuatrocientos", "quinientos", "seiscientos", "setecientos", "ochocientos", "novecientos"};
    private static String[] spanishWordOthers = new String[]{"un", "cien", "mil", "mill\u00f3n", "millones"};
    private static String[] spanishWordOnesOrdMale = new String[]{"ninguno", "primero", "segundo", "tercero", "cuarto", "quinto", "sexto", "s\u00e9ptimo", "octavo", "novento", "d\u00e9cimo"};
    private static String[] spanishWordOnesOrdFemale = new String[]{"ninguna", "primera", "segunda", "tercera", "cuarta", "quinta", "sexta", "s\u00e9ptima", "octava", "noventa", "d\u00e9cima"};
    private static int[] romanMapping = new int[]{100000, 90000, 50000, 40000, 10000, 9000, 5000, 4000, 1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    private static String[] romanStandardForms = new String[]{null, null, null, null, null, null, null, null, "m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", null, null, null, "v", "iv", null, null, "i"};
    private static String[] romanLargeForms = new String[]{"\u2188", "\u2182\u2188", "\u2187", "\u2182\u2187", "\u2182", "\u2180\u2182", "\u2181", "\u2180\u2181", "m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", null, null, null, "v", "iv", null, null, "i"};
    private static String[] romanNumberForms = new String[]{"\u2188", "\u2182\u2188", "\u2187", "\u2182\u2187", "\u2182", "\u2180\u2182", "\u2181", "\u2180\u2181", "\u216f", "\u216d\u216f", "\u216e", "\u216d\u216e", "\u216d", "\u2169\u216d", "\u216c", "\u2169\u216c", "\u2169", "\u2168", "\u2167", "\u2166", "\u2165", "\u2164", "\u2163", "\u2162", "\u2161", "\u2160"};
    private static int[] hebrewGematriaAlphabeticMap = new int[]{1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1499, 1500, 1502, 1504, 1505, 1506, 1508, 1510, 1511, 1512, 1513, 1514, 1498, 1501, 1503, 1507, 1509};
    private static int[] arabicAbjadiAlphabeticMap = new int[]{1571, 1576, 1580, 1583, 1607, 1608, 1586, 1581, 1591, 1609, 1603, 1604, 1605, 1606, 1587, 1593, 1601, 1589, 1602, 1585, 1588, 1578, 1579, 1582, 1584, 1590, 1592, 1594};
    private static int[] arabicHijaiAlphabeticMap = new int[]{1571, 1576, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609};
    private static int[] hiraganaGojuonAlphabeticMap = new int[]{12354, 12356, 12358, 12360, 12362, 12363, 12365, 12367, 12369, 12371, 12373, 12375, 12377, 12379, 12381, 12383, 12385, 12388, 12390, 12392, 12394, 12395, 12396, 12397, 12398, 12399, 12402, 12405, 12408, 12411, 12414, 12415, 12416, 12417, 12418, 12420, 12422, 12424, 12425, 12426, 12427, 12428, 12429, 12431, 12432, 12433, 12434, 12435};
    private static int[] katakanaGojuonAlphabeticMap = new int[]{12450, 12452, 12454, 12456, 12458, 12459, 12461, 12463, 12465, 12467, 12469, 12471, 12473, 12475, 12477, 12479, 12481, 12484, 12486, 12488, 12490, 12491, 12492, 12493, 12494, 12495, 12498, 12501, 12504, 12507, 12510, 12511, 12512, 12513, 12514, 12516, 12518, 12520, 12521, 12522, 12523, 12524, 12525, 12527, 12528, 12529, 12530, 12531};
    private static int[] thaiAlphabeticMap = new int[]{3585, 3586, 3587, 3588, 3589, 3590, 3591, 3592, 3593, 3594, 3595, 3596, 3597, 3598, 3599, 3600, 3601, 3602, 3603, 3604, 3605, 3606, 3607, 3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615, 3616, 3617, 3618, 3619, 3621, 3623, 3624, 3625, 3626, 3627, 3628, 3629, 3630};

    public NumberConverter(String format, int groupingSeparator, int groupingSize, int letterValue, String features, String language, String country) throws IllegalArgumentException {
        this.groupingSeparator = groupingSeparator;
        this.groupingSize = groupingSize;
        this.letterValue = letterValue;
        this.features = features;
        this.language = language != null ? language.toLowerCase() : null;
        this.country = country != null ? country.toLowerCase() : null;
        this.parseFormatTokens(format);
    }

    public String convert(long number) {
        ArrayList<Long> numbers = new ArrayList<Long>();
        numbers.add(number);
        return this.convert(numbers);
    }

    public String convert(List<Long> numbers) {
        ArrayList<Integer> scalars = new ArrayList<Integer>();
        if (this.prefix != null) {
            NumberConverter.appendScalars(scalars, this.prefix);
        }
        this.convertNumbers(scalars, numbers);
        if (this.suffix != null) {
            NumberConverter.appendScalars(scalars, this.suffix);
        }
        return NumberConverter.scalarsToString(scalars);
    }

    private void parseFormatTokens(String format) throws IllegalArgumentException {
        Integer[] ca;
        ArrayList<Integer[]> tokens = new ArrayList<Integer[]>();
        ArrayList<Integer[]> separators = new ArrayList<Integer[]>();
        if (format == null || format.length() == 0) {
            format = "1";
        }
        int tokenType = 0;
        ArrayList<Integer> token = new ArrayList<Integer>();
        for (Integer c : ca = UTF32.toUTF32(format, 0, true)) {
            int tokenTypeNew;
            int n = tokenTypeNew = NumberConverter.isAlphaNumeric(c) ? 1 : 2;
            if (tokenTypeNew != tokenType) {
                if (token.size() > 0) {
                    if (tokenType == 1) {
                        tokens.add(token.toArray(new Integer[token.size()]));
                    } else {
                        separators.add(token.toArray(new Integer[token.size()]));
                    }
                    token.clear();
                }
                tokenType = tokenTypeNew;
            }
            token.add(c);
        }
        if (token.size() > 0) {
            if (tokenType == 1) {
                tokens.add(token.toArray(new Integer[token.size()]));
            } else {
                separators.add(token.toArray(new Integer[token.size()]));
            }
        }
        if (!separators.isEmpty()) {
            this.prefix = (Integer[])separators.remove(0);
        }
        if (!separators.isEmpty()) {
            this.suffix = (Integer[])separators.remove(separators.size() - 1);
        }
        this.separators = (Integer[][])separators.toArray((T[])new Integer[separators.size()][]);
        this.tokens = (Integer[][])tokens.toArray((T[])new Integer[tokens.size()][]);
    }

    private static boolean isAlphaNumeric(int c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private void convertNumbers(List<Integer> scalars, List<Long> numbers) {
        Integer[] tknLast = DEFAULT_TOKEN;
        int tknIndex = 0;
        int tknCount = this.tokens.length;
        int sepIndex = 0;
        int sepCount = this.separators.length;
        int numIndex = 0;
        for (Long number : numbers) {
            Integer[] tkn;
            Integer[] sep = null;
            if (tknIndex < tknCount) {
                if (numIndex > 0) {
                    sep = sepIndex < sepCount ? this.separators[sepIndex++] : DEFAULT_SEPARATOR;
                }
                tkn = this.tokens[tknIndex++];
            } else {
                tkn = tknLast;
            }
            NumberConverter.appendScalars(scalars, this.convertNumber(number, sep, tkn));
            tknLast = tkn;
            ++numIndex;
        }
    }

    private Integer[] convertNumber(long number, Integer[] separator, Integer[] token) {
        ArrayList<Integer> sl = new ArrayList<Integer>();
        if (separator != null) {
            NumberConverter.appendScalars(sl, separator);
        }
        if (token != null) {
            NumberConverter.appendScalars(sl, this.formatNumber(number, token));
        }
        return sl.toArray(new Integer[sl.size()]);
    }

    private Integer[] formatNumber(long number, Integer[] token) {
        Integer[] fn = null;
        assert (token.length > 0);
        if (number < 0L) {
            throw new IllegalArgumentException("number must be non-negative");
        }
        if (token.length == 1) {
            int s = token[0];
            switch (s) {
                case 49: {
                    fn = this.formatNumberAsDecimal(number, 49, 1);
                    break;
                }
                case 87: 
                case 119: {
                    fn = this.formatNumberAsWord(number, s == 87 ? 1 : 2);
                    break;
                }
                default: {
                    if (NumberConverter.isStartOfDecimalSequence(s)) {
                        fn = this.formatNumberAsDecimal(number, s, 1);
                        break;
                    }
                    if (NumberConverter.isStartOfAlphabeticSequence(s)) {
                        fn = this.formatNumberAsSequence(number, s, NumberConverter.getSequenceBase(s), null);
                        break;
                    }
                    if (NumberConverter.isStartOfNumericSpecial(s)) {
                        fn = this.formatNumberAsSpecial(number, s);
                        break;
                    }
                    fn = null;
                    break;
                }
            }
        } else if (token.length == 2 && token[0] == 87 && token[1] == 119) {
            fn = this.formatNumberAsWord(number, 3);
        } else if (NumberConverter.isPaddedOne(token)) {
            int s = token[token.length - 1];
            fn = this.formatNumberAsDecimal(number, s, token.length);
        } else {
            throw new IllegalArgumentException("invalid format token: \"" + UTF32.fromUTF32(token) + "\"");
        }
        if (fn == null) {
            fn = this.formatNumber(number, DEFAULT_TOKEN);
        }
        assert (fn != null);
        return fn;
    }

    private Integer[] formatNumberAsDecimal(long number, int one, int width) {
        assert (Character.getNumericValue(one) == 1);
        assert (Character.getNumericValue(one - 1) == 0);
        assert (Character.getNumericValue(one + 8) == 9);
        List<Integer> sl = new ArrayList<Integer>();
        int zero = one - 1;
        while (number > 0L) {
            long digit = number % 10L;
            sl.add(0, zero + (int)digit);
            number /= 10L;
        }
        while (width > sl.size()) {
            sl.add(0, zero);
        }
        if (this.groupingSize != 0 && this.groupingSeparator != 0) {
            sl = NumberConverter.performGrouping(sl, this.groupingSize, this.groupingSeparator);
        }
        return sl.toArray(new Integer[sl.size()]);
    }

    private static List<Integer> performGrouping(List<Integer> sl, int groupingSize, int groupingSeparator) {
        assert (groupingSize > 0);
        assert (groupingSeparator != 0);
        if (sl.size() > groupingSize) {
            ArrayList<Integer> gl = new ArrayList<Integer>();
            int n = sl.size();
            int g = 0;
            for (int i = 0; i < n; ++i) {
                int k = n - i - 1;
                if (g == groupingSize) {
                    gl.add(0, groupingSeparator);
                    g = 1;
                } else {
                    ++g;
                }
                gl.add(0, sl.get(k));
            }
            return gl;
        }
        return sl;
    }

    private Integer[] formatNumberAsSequence(long number, int one, int base, int[] map) {
        assert (base > 1);
        assert (map == null || map.length >= base);
        ArrayList<Integer> sl = new ArrayList<Integer>();
        if (number == 0L) {
            return null;
        }
        long n = number;
        while (n > 0L) {
            int d = (int)((n - 1L) % (long)base);
            int s = map != null ? map[d] : one + d;
            sl.add(0, s);
            n = (n - 1L) / (long)base;
        }
        return sl.toArray(new Integer[sl.size()]);
    }

    private Integer[] formatNumberAsSpecial(long number, int one) {
        SpecialNumberFormatter f = this.getSpecialFormatter(one, this.letterValue, this.features, this.language, this.country);
        if (f != null) {
            return f.format(number, one, this.letterValue, this.features, this.language, this.country);
        }
        return null;
    }

    private Integer[] formatNumberAsWord(long number, int caseType) {
        SpecialNumberFormatter f = null;
        f = this.isLanguage(DEFAULT_LANGUAGE) ? new EnglishNumberAsWordFormatter(caseType) : (this.isLanguage("spa") ? new SpanishNumberAsWordFormatter(caseType) : (this.isLanguage("fra") ? new FrenchNumberAsWordFormatter(caseType) : new EnglishNumberAsWordFormatter(caseType)));
        return f.format(number, 0, this.letterValue, this.features, this.language, this.country);
    }

    private boolean isLanguage(String iso3Code) {
        if (this.language == null) {
            return false;
        }
        if (this.language.equals(iso3Code)) {
            return true;
        }
        return NumberConverter.isSameLanguage(iso3Code, this.language);
    }

    private static boolean isSameLanguage(String i3c, String lc) {
        for (String[] el : equivalentLanguages) {
            assert (el.length >= 2);
            if (!el[0].equals(i3c)) continue;
            for (String anEl : el) {
                if (!anEl.equals(lc)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean hasFeature(String features, String feature) {
        if (features != null) {
            String[] fa;
            assert (feature != null);
            assert (feature.length() != 0);
            for (String f : fa = features.split(",")) {
                String fv;
                String[] fp = f.split("=");
                assert (fp.length > 0);
                String fn = fp[0];
                String string = fv = fp.length > 1 ? fp[1] : "";
                if (!fn.equals(feature)) continue;
                return true;
            }
        }
        return false;
    }

    private static void appendScalars(List<Integer> scalars, Integer[] sa) {
        Collections.addAll(scalars, sa);
    }

    private static String scalarsToString(List<Integer> scalars) {
        Integer[] sa = scalars.toArray(new Integer[scalars.size()]);
        return UTF32.fromUTF32(sa);
    }

    private static boolean isPaddedOne(Integer[] token) {
        if (NumberConverter.getDecimalValue(token[token.length - 1]) != 1) {
            return false;
        }
        int n = token.length - 1;
        for (int i = 0; i < n; ++i) {
            if (NumberConverter.getDecimalValue(token[i]) == 0) continue;
            return false;
        }
        return true;
    }

    private static int getDecimalValue(Integer scalar) {
        int s = scalar;
        if (Character.getType(s) == 9) {
            return Character.getNumericValue(s);
        }
        return -1;
    }

    private static boolean isStartOfDecimalSequence(int s) {
        return Character.getNumericValue(s) == 1 && Character.getNumericValue(s - 1) == 0 && Character.getNumericValue(s + 8) == 9;
    }

    private static boolean isStartOfAlphabeticSequence(int s) {
        for (int[] ss : supportedAlphabeticSequences) {
            assert (ss.length >= 2);
            if (ss[0] != s) continue;
            return true;
        }
        return false;
    }

    private static int getSequenceBase(int s) {
        for (int[] ss : supportedAlphabeticSequences) {
            assert (ss.length >= 2);
            if (ss[0] != s) continue;
            return ss[1];
        }
        return 0;
    }

    private static boolean isStartOfNumericSpecial(int s) {
        for (int[] ss : supportedSpecials) {
            assert (ss.length >= 1);
            if (ss[0] != s) continue;
            return true;
        }
        return false;
    }

    private SpecialNumberFormatter getSpecialFormatter(int one, int letterValue, String features, String language, String country) {
        if (one == 73) {
            return new RomanNumeralsFormatter();
        }
        if (one == 105) {
            return new RomanNumeralsFormatter();
        }
        if (one == 913) {
            return new IsopsephryNumeralsFormatter();
        }
        if (one == 945) {
            return new IsopsephryNumeralsFormatter();
        }
        if (one == 1488) {
            return new GematriaNumeralsFormatter();
        }
        if (one == 1571) {
            return new ArabicNumeralsFormatter();
        }
        if (one == 1575) {
            return new ArabicNumeralsFormatter();
        }
        if (one == 3585) {
            return new ThaiNumeralsFormatter();
        }
        if (one == 12354) {
            return new KanaNumeralsFormatter();
        }
        if (one == 12356) {
            return new KanaNumeralsFormatter();
        }
        if (one == 12450) {
            return new KanaNumeralsFormatter();
        }
        if (one == 12452) {
            return new KanaNumeralsFormatter();
        }
        return null;
    }

    private static Integer[] toUpperCase(Integer[] sa) {
        assert (sa != null);
        int n = sa.length;
        for (int i = 0; i < n; ++i) {
            Integer s = sa[i];
            sa[i] = Character.toUpperCase(s);
        }
        return sa;
    }

    private static Integer[] toLowerCase(Integer[] sa) {
        assert (sa != null);
        int n = sa.length;
        for (int i = 0; i < n; ++i) {
            Integer s = sa[i];
            sa[i] = Character.toLowerCase(s);
        }
        return sa;
    }

    private static List<String> convertWordCase(List<String> words, int caseType) {
        ArrayList<String> wl = new ArrayList<String>();
        for (String w : words) {
            wl.add(NumberConverter.convertWordCase(w, caseType));
        }
        return wl;
    }

    private static String convertWordCase(String word, int caseType) {
        if (caseType == 1) {
            return word.toUpperCase();
        }
        if (caseType == 2) {
            return word.toLowerCase();
        }
        if (caseType == 3) {
            StringBuffer sb = new StringBuffer();
            int n = word.length();
            for (int i = 0; i < n; ++i) {
                String s = word.substring(i, i + 1);
                if (i == 0) {
                    sb.append(s.toUpperCase());
                    continue;
                }
                sb.append(s.toLowerCase());
            }
            return sb.toString();
        }
        return word;
    }

    private static String joinWords(List<String> words, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String w : words) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(w);
        }
        return sb.toString();
    }

    static interface SpecialNumberFormatter {
        public Integer[] format(long var1, int var3, int var4, String var5, String var6, String var7);
    }

    private static class EnglishNumberAsWordFormatter
    implements SpecialNumberFormatter {
        private int caseType = 1;

        EnglishNumberAsWordFormatter(int caseType) {
            this.caseType = caseType;
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            List<Object> wl = new ArrayList<String>();
            if (number >= 1000000000000L) {
                return null;
            }
            boolean ordinal = NumberConverter.hasFeature(features, "ordinal");
            if (number == 0L) {
                wl.add(englishWordOnes[0]);
            } else if (ordinal && number < 10L) {
                wl.add(englishWordOnesOrd[(int)number]);
            } else {
                int ones = (int)(number % 1000L);
                int thousands = (int)(number / 1000L % 1000L);
                int millions = (int)(number / 1000000L % 1000L);
                int billions = (int)(number / 1000000000L % 1000L);
                if (billions > 0) {
                    wl = this.formatOnesInThousand(wl, billions);
                    if (ordinal && number % 1000000000L == 0L) {
                        wl.add(englishWordOthersOrd[3]);
                    } else {
                        wl.add(englishWordOthers[3]);
                    }
                }
                if (millions > 0) {
                    wl = this.formatOnesInThousand(wl, millions);
                    if (ordinal && number % 1000000L == 0L) {
                        wl.add(englishWordOthersOrd[2]);
                    } else {
                        wl.add(englishWordOthers[2]);
                    }
                }
                if (thousands > 0) {
                    wl = this.formatOnesInThousand(wl, thousands);
                    if (ordinal && number % 1000L == 0L) {
                        wl.add(englishWordOthersOrd[1]);
                    } else {
                        wl.add(englishWordOthers[1]);
                    }
                }
                if (ones > 0) {
                    wl = this.formatOnesInThousand(wl, ones, ordinal);
                }
            }
            wl = NumberConverter.convertWordCase(wl, this.caseType);
            return UTF32.toUTF32(NumberConverter.joinWords(wl, " "), 0, true);
        }

        private List<String> formatOnesInThousand(List<String> wl, int number) {
            return this.formatOnesInThousand(wl, number, false);
        }

        private List<String> formatOnesInThousand(List<String> wl, int number, boolean ordinal) {
            assert (number < 1000);
            int ones = number % 10;
            int tens = number / 10 % 10;
            int hundreds = number / 100 % 10;
            if (hundreds > 0) {
                wl.add(englishWordOnes[hundreds]);
                if (ordinal && number % 100 == 0) {
                    wl.add(englishWordOthersOrd[0]);
                } else {
                    wl.add(englishWordOthers[0]);
                }
            }
            if (tens > 0) {
                if (tens == 1) {
                    if (ordinal) {
                        wl.add(englishWordTeensOrd[ones]);
                    } else {
                        wl.add(englishWordTeens[ones]);
                    }
                } else {
                    if (ordinal && ones == 0) {
                        wl.add(englishWordTensOrd[tens]);
                    } else {
                        wl.add(englishWordTens[tens]);
                    }
                    if (ones > 0) {
                        if (ordinal) {
                            wl.add(englishWordOnesOrd[ones]);
                        } else {
                            wl.add(englishWordOnes[ones]);
                        }
                    }
                }
            } else if (ones > 0) {
                if (ordinal) {
                    wl.add(englishWordOnesOrd[ones]);
                } else {
                    wl.add(englishWordOnes[ones]);
                }
            }
            return wl;
        }
    }

    private static class SpanishNumberAsWordFormatter
    implements SpecialNumberFormatter {
        private int caseType = 1;

        SpanishNumberAsWordFormatter(int caseType) {
            this.caseType = caseType;
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            List<String> wl = new ArrayList<String>();
            if (number >= 1000000000000L) {
                return null;
            }
            boolean ordinal = NumberConverter.hasFeature(features, "ordinal");
            if (number == 0L) {
                wl.add(spanishWordOnes[0]);
            } else if (ordinal && number <= 10L) {
                boolean female = NumberConverter.hasFeature(features, "female");
                if (female) {
                    wl.add(spanishWordOnesOrdFemale[(int)number]);
                } else {
                    wl.add(spanishWordOnesOrdMale[(int)number]);
                }
            } else {
                int ones = (int)(number % 1000L);
                int thousands = (int)(number / 1000L % 1000L);
                int millions = (int)(number / 1000000L % 1000L);
                int billions = (int)(number / 1000000000L % 1000L);
                if (billions > 0) {
                    if (billions > 1) {
                        wl = this.formatOnesInThousand(wl, billions);
                    }
                    wl.add(spanishWordOthers[2]);
                    wl.add(spanishWordOthers[4]);
                }
                if (millions > 0) {
                    if (millions == 1) {
                        wl.add(spanishWordOthers[0]);
                    } else {
                        wl = this.formatOnesInThousand(wl, millions);
                    }
                    if (millions > 1) {
                        wl.add(spanishWordOthers[4]);
                    } else {
                        wl.add(spanishWordOthers[3]);
                    }
                }
                if (thousands > 0) {
                    if (thousands > 1) {
                        wl = this.formatOnesInThousand(wl, thousands);
                    }
                    wl.add(spanishWordOthers[2]);
                }
                if (ones > 0) {
                    wl = this.formatOnesInThousand(wl, ones);
                }
            }
            wl = NumberConverter.convertWordCase(wl, this.caseType);
            return UTF32.toUTF32(NumberConverter.joinWords(wl, " "), 0, true);
        }

        private List<String> formatOnesInThousand(List<String> wl, int number) {
            assert (number < 1000);
            int ones = number % 10;
            int tens = number / 10 % 10;
            int hundreds = number / 100 % 10;
            if (hundreds > 0) {
                if (hundreds == 1 && tens == 0 && ones == 0) {
                    wl.add(spanishWordOthers[1]);
                } else {
                    wl.add(spanishWordHundreds[hundreds]);
                }
            }
            if (tens > 0) {
                if (tens == 1) {
                    wl.add(spanishWordTeens[ones]);
                } else if (tens == 2) {
                    wl.add(spanishWordTweens[ones]);
                } else {
                    wl.add(spanishWordTens[tens]);
                    if (ones > 0) {
                        wl.add("y");
                        wl.add(spanishWordOnes[ones]);
                    }
                }
            } else if (ones > 0) {
                wl.add(spanishWordOnes[ones]);
            }
            return wl;
        }
    }

    private static class FrenchNumberAsWordFormatter
    implements SpecialNumberFormatter {
        private int caseType = 1;

        FrenchNumberAsWordFormatter(int caseType) {
            this.caseType = caseType;
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            List<String> wl = new ArrayList<String>();
            if (number >= 1000000000000L) {
                return null;
            }
            boolean ordinal = NumberConverter.hasFeature(features, "ordinal");
            if (number == 0L) {
                wl.add(frenchWordOnes[0]);
            } else if (ordinal && number <= 10L) {
                boolean female = NumberConverter.hasFeature(features, "female");
                if (female) {
                    wl.add(frenchWordOnesOrdFemale[(int)number]);
                } else {
                    wl.add(frenchWordOnesOrdMale[(int)number]);
                }
            } else {
                int ones = (int)(number % 1000L);
                int thousands = (int)(number / 1000L % 1000L);
                int millions = (int)(number / 1000000L % 1000L);
                int billions = (int)(number / 1000000000L % 1000L);
                if (billions > 0) {
                    wl = this.formatOnesInThousand(wl, billions);
                    if (billions == 1) {
                        wl.add(frenchWordOthers[5]);
                    } else {
                        wl.add(frenchWordOthers[6]);
                    }
                }
                if (millions > 0) {
                    wl = this.formatOnesInThousand(wl, millions);
                    if (millions == 1) {
                        wl.add(frenchWordOthers[3]);
                    } else {
                        wl.add(frenchWordOthers[4]);
                    }
                }
                if (thousands > 0) {
                    if (thousands > 1) {
                        wl = this.formatOnesInThousand(wl, thousands);
                    }
                    wl.add(frenchWordOthers[2]);
                }
                if (ones > 0) {
                    wl = this.formatOnesInThousand(wl, ones);
                }
            }
            wl = NumberConverter.convertWordCase(wl, this.caseType);
            return UTF32.toUTF32(NumberConverter.joinWords(wl, " "), 0, true);
        }

        private List<String> formatOnesInThousand(List<String> wl, int number) {
            assert (number < 1000);
            int ones = number % 10;
            int tens = number / 10 % 10;
            int hundreds = number / 100 % 10;
            if (hundreds > 0) {
                if (hundreds > 1) {
                    wl.add(frenchWordOnes[hundreds]);
                }
                if (hundreds > 1 && tens == 0 && ones == 0) {
                    wl.add(frenchWordOthers[1]);
                } else {
                    wl.add(frenchWordOthers[0]);
                }
            }
            if (tens > 0) {
                if (tens == 1) {
                    wl.add(frenchWordTeens[ones]);
                } else if (tens < 7) {
                    if (ones == 1) {
                        wl.add(frenchWordTens[tens]);
                        wl.add("et");
                        wl.add(frenchWordOnes[ones]);
                    } else {
                        StringBuffer sb = new StringBuffer();
                        sb.append(frenchWordTens[tens]);
                        if (ones > 0) {
                            sb.append('-');
                            sb.append(frenchWordOnes[ones]);
                        }
                        wl.add(sb.toString());
                    }
                } else if (tens == 7) {
                    if (ones == 1) {
                        wl.add(frenchWordTens[6]);
                        wl.add("et");
                        wl.add(frenchWordTeens[ones]);
                    } else {
                        StringBuffer sb = new StringBuffer();
                        sb.append(frenchWordTens[6]);
                        sb.append('-');
                        sb.append(frenchWordTeens[ones]);
                        wl.add(sb.toString());
                    }
                } else if (tens == 8) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(frenchWordTens[tens]);
                    if (ones > 0) {
                        sb.append('-');
                        sb.append(frenchWordOnes[ones]);
                    } else {
                        sb.append('s');
                    }
                    wl.add(sb.toString());
                } else if (tens == 9) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(frenchWordTens[8]);
                    sb.append('-');
                    sb.append(frenchWordTeens[ones]);
                    wl.add(sb.toString());
                }
            } else if (ones > 0) {
                wl.add(frenchWordOnes[ones]);
            }
            return wl;
        }
    }

    private static class RomanNumeralsFormatter
    implements SpecialNumberFormatter {
        private RomanNumeralsFormatter() {
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            int maxNumber;
            String[] forms;
            ArrayList sl = new ArrayList();
            if (number == 0L) {
                return null;
            }
            if (NumberConverter.hasFeature(features, "unicode-number-forms")) {
                forms = romanNumberForms;
                maxNumber = 199999;
            } else if (NumberConverter.hasFeature(features, "large")) {
                forms = romanLargeForms;
                maxNumber = 199999;
            } else {
                forms = romanStandardForms;
                maxNumber = 4999;
            }
            if (number > (long)maxNumber) {
                return null;
            }
            block0: while (number > 0L) {
                int n = romanMapping.length;
                for (int i = 0; i < n; ++i) {
                    int d = romanMapping[i];
                    if (number < (long)d || forms[i] == null) continue;
                    NumberConverter.appendScalars(sl, UTF32.toUTF32(forms[i], 0, true));
                    number -= (long)d;
                    continue block0;
                }
            }
            if (one == 73) {
                return NumberConverter.toUpperCase(sl.toArray(new Integer[sl.size()]));
            }
            if (one == 105) {
                return NumberConverter.toLowerCase(sl.toArray(new Integer[sl.size()]));
            }
            return null;
        }
    }

    private static class IsopsephryNumeralsFormatter
    implements SpecialNumberFormatter {
        private IsopsephryNumeralsFormatter() {
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            return null;
        }
    }

    private class GematriaNumeralsFormatter
    implements SpecialNumberFormatter {
        private GematriaNumeralsFormatter() {
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            if (one == 1488) {
                if (letterValue == 1) {
                    return NumberConverter.this.formatNumberAsSequence(number, one, hebrewGematriaAlphabeticMap.length, hebrewGematriaAlphabeticMap);
                }
                if (letterValue == 2) {
                    if (number == 0L || number > 1999L) {
                        return null;
                    }
                    return this.formatAsGematriaNumber(number, features, language, country);
                }
                return null;
            }
            return null;
        }

        private Integer[] formatAsGematriaNumber(long number, String features, String language, String country) {
            ArrayList<Integer> sl = new ArrayList<Integer>();
            assert (hebrewGematriaAlphabeticMap.length == 27);
            assert (hebrewGematriaAlphabeticMap[0] == 1488);
            assert (hebrewGematriaAlphabeticMap[21] == 1514);
            assert (number != 0L);
            assert (number < 2000L);
            int[] map = hebrewGematriaAlphabeticMap;
            int thousands = (int)(number / 1000L % 10L);
            int hundreds = (int)(number / 100L % 10L);
            int tens = (int)(number / 10L % 10L);
            int ones = (int)(number / 1L % 10L);
            if (thousands > 0) {
                sl.add(map[0 + (thousands - 1)]);
                sl.add(1523);
            }
            if (hundreds > 0) {
                if (hundreds < 5) {
                    sl.add(map[18 + (hundreds - 1)]);
                } else if (hundreds < 9) {
                    sl.add(map[21]);
                    sl.add(1524);
                    sl.add(map[18 + (hundreds - 5)]);
                } else if (hundreds == 9) {
                    sl.add(map[21]);
                    sl.add(map[21]);
                    sl.add(1524);
                    sl.add(map[18 + (hundreds - 9)]);
                }
                assert (hundreds < 10);
            }
            if (number == 15L) {
                sl.add(map[8]);
                sl.add(1524);
                sl.add(map[5]);
            } else if (number == 16L) {
                sl.add(map[8]);
                sl.add(1524);
                sl.add(map[6]);
            } else {
                if (tens > 0) {
                    assert (tens < 10);
                    sl.add(map[9 + (tens - 1)]);
                }
                if (ones > 0) {
                    assert (ones < 10);
                    sl.add(map[0 + (ones - 1)]);
                }
            }
            return sl.toArray(new Integer[sl.size()]);
        }
    }

    private class ArabicNumeralsFormatter
    implements SpecialNumberFormatter {
        private ArabicNumeralsFormatter() {
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            if (one == 1575) {
                int[] map = letterValue == 2 ? arabicAbjadiAlphabeticMap : (letterValue == 1 ? arabicHijaiAlphabeticMap : arabicAbjadiAlphabeticMap);
                return NumberConverter.this.formatNumberAsSequence(number, one, map.length, map);
            }
            if (one == 1571) {
                if (number == 0L || number > 1999L) {
                    return null;
                }
                return this.formatAsAbjadiNumber(number, features, language, country);
            }
            return null;
        }

        private Integer[] formatAsAbjadiNumber(long number, String features, String language, String country) {
            ArrayList<Integer> sl = new ArrayList<Integer>();
            assert (arabicAbjadiAlphabeticMap.length == 28);
            assert (arabicAbjadiAlphabeticMap[0] == 1571);
            assert (arabicAbjadiAlphabeticMap[27] == 1594);
            assert (number != 0L);
            assert (number < 2000L);
            int[] map = arabicAbjadiAlphabeticMap;
            int thousands = (int)(number / 1000L % 10L);
            int hundreds = (int)(number / 100L % 10L);
            int tens = (int)(number / 10L % 10L);
            int ones = (int)(number / 1L % 10L);
            if (thousands > 0) {
                assert (thousands < 2);
                sl.add(map[27 + (thousands - 1)]);
            }
            if (hundreds > 0) {
                assert (thousands < 10);
                sl.add(map[18 + (hundreds - 1)]);
            }
            if (tens > 0) {
                assert (tens < 10);
                sl.add(map[9 + (tens - 1)]);
            }
            if (ones > 0) {
                assert (ones < 10);
                sl.add(map[0 + (ones - 1)]);
            }
            return sl.toArray(new Integer[sl.size()]);
        }
    }

    private class ThaiNumeralsFormatter
    implements SpecialNumberFormatter {
        private ThaiNumeralsFormatter() {
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            if (one == 3585 && letterValue == 1) {
                return NumberConverter.this.formatNumberAsSequence(number, one, thaiAlphabeticMap.length, thaiAlphabeticMap);
            }
            return null;
        }
    }

    private class KanaNumeralsFormatter
    implements SpecialNumberFormatter {
        private KanaNumeralsFormatter() {
        }

        @Override
        public Integer[] format(long number, int one, int letterValue, String features, String language, String country) {
            if (one == 12354 && letterValue == 1) {
                return NumberConverter.this.formatNumberAsSequence(number, one, hiraganaGojuonAlphabeticMap.length, hiraganaGojuonAlphabeticMap);
            }
            if (one == 12450 && letterValue == 1) {
                return NumberConverter.this.formatNumberAsSequence(number, one, katakanaGojuonAlphabeticMap.length, katakanaGojuonAlphabeticMap);
            }
            return null;
        }
    }
}

