/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OpenChangesetPopupMenu
extends JPopupMenu {
    private static final List<ChangesetViewerEntry> DEFAULT_ENTRIES = Arrays.asList(new ChangesetViewerEntry(I18n.tr("View changeset in web browser", new Object[0]), Config.getUrls().getBaseBrowseUrl() + "/changeset/{0}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "achavi (Augmented OSM Change Viewer)"), "https://overpass-api.de/achavi/?changeset={0}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "OSMCha (OSM Changeset Analyzer)"), "https://osmcha.mapbox.com/changesets/{0}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "OSM History Viewer (Mapki)"), "http://osm.mapki.com/history/{1}.php?id={2}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "OSM History Viewer (Pewu)"), "https://pewu.github.io/osm-history/#/{1}/{2}"), new ChangesetViewerEntry(I18n.tr("Open {0}", "WhoDidIt (OSM Changeset Analyzer)"), "http://simon04.dev.openstreetmap.org/whodidit/index.html?changeset={0}&show=1"));

    public OpenChangesetPopupMenu(long changesetId, PrimitiveId primitiveId) {
        StructUtils.getListOfStructs(Config.getPref(), "history-dialog.tools", DEFAULT_ENTRIES, ChangesetViewerEntry.class).stream().map(entry -> entry.toAction(changesetId, primitiveId)).filter(Objects::nonNull).forEach(this::add);
    }

    public void show(JComponent parent) {
        Container parentParent = parent.getParent();
        if (parentParent.isShowing()) {
            Rectangle r = parent.getBounds();
            this.show(parentParent, r.x, r.y + r.height);
        }
    }

    static class OpenBrowserAction
    extends AbstractAction {
        final String url;

        OpenBrowserAction(String name, String url) {
            super(name);
            this.putValue("ShortDescription", I18n.tr("Open {0}", url));
            new ImageProvider("help/internet").getResource().attachImageIcon(this, true);
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OpenBrowser.displayUrl(this.url);
        }
    }

    public static class ChangesetViewerEntry {
        @StructUtils.StructEntry
        public String name;
        @StructUtils.StructEntry
        public String url;

        public ChangesetViewerEntry() {
        }

        ChangesetViewerEntry(String name, String url) {
            this.name = Objects.requireNonNull(name);
            this.url = Objects.requireNonNull(url);
        }

        Action toAction(long changesetId, PrimitiveId primitiveId) {
            if (primitiveId != null) {
                return new OpenBrowserAction(this.name, MessageFormat.format(this.url, Long.toString(changesetId), primitiveId.getType().getAPIName(), Long.toString(primitiveId.getUniqueId())));
            }
            if (this.url.contains("{0}")) {
                return new OpenBrowserAction(this.name, MessageFormat.format(this.url, Long.toString(changesetId)));
            }
            return null;
        }
    }
}

