/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.sf.sdedit.Constants;
import net.sf.sdedit.diagram.Diagram;

public abstract class Drawable
implements Constants {
    private int top;
    private int left;
    private int height;
    private int width;
    private boolean visible = true;
    private String[] label;
    private Diagram diagram;

    protected Drawable(Diagram diagram) {
        this.diagram = diagram;
    }

    protected Diagram getDiagram() {
        return this.diagram;
    }

    public boolean hasLabel() {
        return this.label != null && this.label.length > 0;
    }

    protected void setLabel(String[] label) {
        this.label = label;
    }

    protected String[] getLabel() {
        return this.label;
    }

    protected int textWidth() {
        return this.textWidth(false);
    }

    protected int textWidth(boolean bold) {
        int width = 0;
        for (int i = 0; i < this.label.length; ++i) {
            width = Math.max(width, this.diagram.getPaintDevice().getTextWidth(this.label[i], bold));
        }
        return width;
    }

    protected int textHeight() {
        return this.diagram.getPaintDevice().getTextHeight() * this.label.length;
    }

    public void draw(Graphics2D g2d) {
        Graphics2D g2 = (Graphics2D)g2d.create();
        this.drawObject(g2);
        g2.dispose();
    }

    protected abstract void drawObject(Graphics2D var1);

    public abstract void computeLayoutInformation();

    public final int getTop() {
        return this.top;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public final void setLeft(int left) {
        this.left = left;
    }

    public final void setTop(int top) {
        this.top = top;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final int getBottom() {
        return this.top + this.height;
    }

    public final int getRight() {
        return this.left + this.width;
    }

    public final void setRight(int right) {
        this.setWidth(right - this.left);
    }

    public final void setBottom(int bottom) {
        this.setHeight(bottom - this.getTop());
    }

    public Rectangle getRectangle() {
        Rectangle r = new Rectangle();
        r.x = this.getLeft();
        r.y = this.getTop();
        r.width = this.getWidth();
        r.height = this.getHeight();
        return r;
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this.left - 10, this.top - 10, this.width + 20, this.height + 20);
    }

    public boolean contains(Point point) {
        int x = point.x;
        int y = point.y;
        return x >= this.left && x <= this.left + this.width && y >= this.top && y <= this.top + this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    protected static final void drawMultilineString(Graphics2D g, Color color, String[] string, int x, int y, int simpleHeight, int width, Color background, boolean center, boolean underline) {
        if (background != null) {
            g.setColor(background);
            int height = 2 + string.length * simpleHeight;
            int top = y - height + 2;
            g.fillRect(x - 1, top, width, height);
        }
        g.setColor(color);
        for (int i = 0; i < string.length; ++i) {
            int yy = y - i * simpleHeight;
            String str = string[string.length - 1 - i];
            int _x = x;
            int tw = 0;
            if (center || underline) {
                tw = g.getFontMetrics().stringWidth(str);
            }
            if (center) {
                _x = x + width / 2 - tw / 2;
            }
            if (underline) {
                g.drawLine(_x, yy + 2, _x + tw, yy + 2);
            }
            g.drawString(str, _x, yy);
        }
    }

    protected void drawMultilineString(Graphics2D g, Color color, int x, int y, Color background, boolean center, boolean underline) {
        Drawable.drawMultilineString(g, color, this.label, x, y, this.diagram.getPaintDevice().getTextHeight(), this.textWidth(), background, center, underline);
    }

    protected void drawMultilineString(Graphics2D g, Color color, int x, int y, Color background) {
        this.drawMultilineString(g, color, x, y, background, false, false);
    }
}

