/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.navigator;

import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorNode;
import net.sf.sdedit.util.tree.BreadthFirstSearch;

public class TreeNavigatorModel
implements TreeModel {
    private LinkedList<TreeModelListener> listeners;
    private TreeNavigatorNode root = new TreeNavigatorNode("", null, null);

    public TreeNavigatorModel() {
        this.listeners = new LinkedList();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNavigatorNode)parent).getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNavigatorNode)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeNavigatorNode[] children = ((TreeNavigatorNode)parent).getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNavigatorNode getRoot() {
        return this.root;
    }

    public TreeNavigatorNode getCategoryNode(String category) {
        for (TreeNavigatorNode node : this.root.getChildren()) {
            if (!node.getTitle().equals(category)) continue;
            return node;
        }
        return null;
    }

    public List<JComponent> getComponents() {
        TreePath path;
        LinkedList<JComponent> result = new LinkedList<JComponent>();
        BreadthFirstSearch bfs = new BreadthFirstSearch(this);
        do {
            TreeNavigatorNode node;
            if ((path = bfs.next()) == null || (node = (TreeNavigatorNode)path.getLastPathComponent()).getComponent() == null) continue;
            result.addFirst(node.getComponent());
        } while (path != null);
        return result;
    }

    public TreeNavigatorNode find(JComponent comp) {
        TreePath path;
        BreadthFirstSearch bfs = new BreadthFirstSearch(this);
        do {
            TreeNavigatorNode node;
            if ((path = bfs.next()) == null || (node = (TreeNavigatorNode)path.getLastPathComponent()).getComponent() != comp) continue;
            return node;
        } while (path != null);
        return null;
    }

    public void addChild(TreeNavigatorNode parent, TreeNavigatorNode child, TreeNavigatorNode previousSibling) {
        int p = parent.addChild(child, previousSibling);
        TreeModelEvent tme = new TreeModelEvent((Object)this, parent.getTreePath(), new int[]{p}, new Object[]{child});
        for (TreeModelListener l : this.listeners) {
            l.treeNodesInserted(tme);
        }
    }

    public void removeChild(TreeNavigatorNode parent, TreeNavigatorNode child) {
        int i = this.getIndexOfChild(parent, child);
        parent.removeChild(child);
        TreeModelEvent tme = new TreeModelEvent((Object)this, parent.getTreePath(), new int[]{i}, new Object[]{child});
        for (TreeModelListener l : this.listeners) {
            l.treeNodesRemoved(tme);
        }
    }

    public void setTitle(TreeNavigatorNode node, String title) {
        node.setTitle(title);
        this.fireNodeChanged(node);
    }

    protected void fireComponentChanged(JComponent changed) {
        TreeNavigatorNode node = this.find(changed);
        this.fireNodeChanged(node);
    }

    protected void fireNodeChanged(TreeNavigatorNode node) {
        TreePath pathToParent = node.getParent() == null ? new TreePath(this.getRoot()) : node.getParent().getTreePath();
        int[] c = new int[]{this.getIndexOfChild(pathToParent.getLastPathComponent(), node)};
        TreeModelEvent tme = new TreeModelEvent((Object)this, pathToParent, c, new Object[]{node});
        for (TreeModelListener l : this.listeners) {
            l.treeNodesChanged(tme);
        }
    }

    public List<String> getAllTitles() {
        TreePath path;
        LinkedList<String> result = new LinkedList<String>();
        BreadthFirstSearch bfs = new BreadthFirstSearch(this);
        do {
            if ((path = bfs.next()) == null) continue;
            TreeNavigatorNode node = (TreeNavigatorNode)path.getLastPathComponent();
            result.add(node.getTitle());
        } while (path != null);
        return result;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNavigatorNode)node).getChildCount() == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

