/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class MergeSourceBuildingVisitor
implements OsmPrimitiveVisitor {
    private final DataSet selectionBase;
    private final DataSet hull;
    private final Map<OsmPrimitive, PrimitiveData> mappedPrimitives;

    public MergeSourceBuildingVisitor(DataSet selectionBase) {
        CheckParameterUtil.ensureParameterNotNull(selectionBase, "selectionBase");
        this.selectionBase = selectionBase;
        this.hull = new DataSet();
        this.mappedPrimitives = new HashMap<OsmPrimitive, PrimitiveData>();
    }

    protected boolean isInSelectionBase(OsmPrimitive primitive) {
        return this.selectionBase.getAllSelected().contains(primitive);
    }

    protected boolean isAlreadyRemembered(OsmPrimitive primitive) {
        return this.mappedPrimitives.containsKey(primitive);
    }

    protected void rememberNode(Node n) {
        if (this.isAlreadyRemembered(n)) {
            return;
        }
        this.mappedPrimitives.put(n, n.save());
    }

    protected void rememberWay(Way w) {
        if (this.isAlreadyRemembered(w)) {
            return;
        }
        WayData clone = w.save();
        ArrayList<Long> newNodes = new ArrayList<Long>(w.getNodesCount());
        for (Node n : w.getNodes()) {
            newNodes.add(this.mappedPrimitives.get(n).getUniqueId());
        }
        clone.setNodeIds(newNodes);
        this.mappedPrimitives.put(w, clone);
    }

    protected void rememberRelation(Relation r) {
        RelationData clone;
        if (this.isAlreadyRemembered(r)) {
            clone = (RelationData)this.mappedPrimitives.get(r);
        } else {
            clone = r.save();
            this.mappedPrimitives.put(r, clone);
        }
        clone.setMembers(r.getMembers().stream().map(m -> new RelationMemberData(m.getRole(), this.mappedPrimitives.get(m.getMember()))).collect(Collectors.toList()));
    }

    protected void rememberRelationPartial(Relation r) {
        if (this.isAlreadyRemembered(r)) {
            return;
        }
        RelationData clone = r.save();
        clone.getMembers().clear();
        this.mappedPrimitives.put(r, clone);
    }

    protected void rememberIncomplete(OsmPrimitive primitive) {
        if (this.isAlreadyRemembered(primitive)) {
            return;
        }
        PrimitiveData clone = primitive.save();
        clone.setIncomplete(true);
        this.mappedPrimitives.put(primitive, clone);
    }

    @Override
    public void visit(Node n) {
        this.rememberNode(n);
    }

    @Override
    public void visit(Way w) {
        for (Node n : w.getNodes()) {
            n.accept(this);
        }
        this.rememberWay(w);
    }

    @Override
    public void visit(Relation r) {
        this.rememberRelationPartial(r);
        for (RelationMember member : r.getMembers()) {
            if (this.isAlreadyRemembered(member.getMember())) continue;
            if (this.isInSelectionBase(member.getMember()) || member.getMember().isNew()) {
                member.getMember().accept(this);
                continue;
            }
            this.rememberIncomplete(member.getMember());
        }
        this.rememberRelation(r);
    }

    protected void buildHull() {
        for (PrimitiveData primitive : this.mappedPrimitives.values()) {
            boolean created;
            OsmPrimitive newPrimitive = this.hull.getPrimitiveById(primitive);
            boolean bl = created = newPrimitive == null;
            if (created) {
                newPrimitive = primitive.getType().newInstance(primitive.getUniqueId(), true);
            }
            if (newPrimitive instanceof Node && !primitive.isIncomplete()) {
                newPrimitive.load(primitive);
            }
            if (!created) continue;
            this.hull.addPrimitive(newPrimitive);
        }
        for (PrimitiveData primitive : this.mappedPrimitives.values()) {
            if (primitive instanceof NodeData || primitive.isIncomplete()) continue;
            this.hull.getPrimitiveById(primitive).load(primitive);
        }
    }

    public DataSet build() {
        for (OsmPrimitive primitive : this.selectionBase.getAllSelected()) {
            primitive.accept(this);
        }
        this.buildHull();
        return this.hull;
    }
}

