/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.KeyValueVisitor;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.TokenMgrError;
import org.openstreetmap.josm.gui.mappaint.styleelement.LineElement;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSStyleSource
extends StyleSource {
    public static final String MAPCSS_STYLE_MIME_TYPES = "text/x-mapcss, text/mapcss, text/css; q=0.9, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    public final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
    public final MapCSSRuleIndex nodeRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex wayRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex wayNoAreaRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex relationRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex multipolygonRules = new MapCSSRuleIndex();
    public final MapCSSRuleIndex canvasRules = new MapCSSRuleIndex();
    private Color backgroundColorOverride;
    private String css;
    private ZipFile zipFile;
    public static final ReadWriteLock STYLE_SOURCE_LOCK;
    static final Set<String> SUPPORTED_KEYS;

    public MapCSSStyleSource(String url, String name, String shortdescription) {
        super(url, name, shortdescription);
    }

    public MapCSSStyleSource(SourceEntry entry) {
        super(entry);
    }

    public MapCSSStyleSource(String css) {
        super(null, null, null);
        CheckParameterUtil.ensureParameterNotNull(css);
        this.css = css;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStyleSource(boolean metadataOnly) {
        STYLE_SOURCE_LOCK.writeLock().lock();
        try {
            this.init();
            this.rules.clear();
            this.nodeRules.clear();
            this.wayRules.clear();
            this.wayNoAreaRules.clear();
            this.relationRules.clear();
            this.multipolygonRules.clear();
            this.canvasRules.clear();
            try (InputStream in = this.getSourceInputStream();){
                try (BufferedReader reader = new BufferedReader(UTFInputStreamReader.create(in));){
                    MapCSSParser preprocessor = new MapCSSParser(reader, MapCSSParser.LexicalState.PREPROCESSOR);
                    try (StringReader in2 = new StringReader(preprocessor.pp_root(this));){
                        new MapCSSParser(in2, MapCSSParser.LexicalState.DEFAULT).sheet(this);
                    }
                    this.loadMeta();
                    if (!metadataOnly) {
                        this.loadCanvas();
                        this.loadSettings();
                    }
                    this.removeAreaStyleClasses();
                }
                finally {
                    this.closeSourceInputStream(in);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                Logging.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", this.url, e.toString()));
                Logging.log(Logging.LEVEL_ERROR, e);
                this.logError(e);
            }
            catch (TokenMgrError e) {
                Logging.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
                Logging.error(e);
                this.logError(e);
            }
            catch (ParseException e) {
                Logging.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
                Logging.error(e);
                this.logError(new ParseException(e.getMessage()));
            }
            if (metadataOnly) {
                return;
            }
            block46: for (MapCSSRule r : this.rules) {
                String base;
                Selector selRightmost = r.selector;
                while (selRightmost instanceof Selector.ChildOrParentSelector) {
                    selRightmost = ((Selector.ChildOrParentSelector)selRightmost).right;
                }
                MapCSSRule optRule = new MapCSSRule(r.selector.optimizedBaseCheck(), r.declaration);
                switch (base = ((Selector.GeneralSelector)selRightmost).getBase()) {
                    case "node": {
                        this.nodeRules.add(optRule);
                        continue block46;
                    }
                    case "way": {
                        this.wayNoAreaRules.add(optRule);
                        this.wayRules.add(optRule);
                        continue block46;
                    }
                    case "area": {
                        this.wayRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block46;
                    }
                    case "relation": {
                        this.relationRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block46;
                    }
                    case "*": {
                        this.nodeRules.add(optRule);
                        this.wayRules.add(optRule);
                        this.wayNoAreaRules.add(optRule);
                        this.relationRules.add(optRule);
                        this.multipolygonRules.add(optRule);
                        continue block46;
                    }
                    case "canvas": {
                        this.canvasRules.add(r);
                        continue block46;
                    }
                    case "meta": 
                    case "setting": 
                    case "settings": {
                        continue block46;
                    }
                }
                JosmRuntimeException e = new JosmRuntimeException(MessageFormat.format("Unknown MapCSS base selector {0}", base));
                Logging.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
                Logging.error(e);
                this.logError(e);
            }
            this.nodeRules.initIndex();
            this.wayRules.initIndex();
            this.wayNoAreaRules.initIndex();
            this.relationRules.initIndex();
            this.multipolygonRules.initIndex();
            this.canvasRules.initIndex();
            this.loaded = true;
        }
        finally {
            STYLE_SOURCE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        if (this.css != null) {
            return new ByteArrayInputStream(this.css.getBytes(StandardCharsets.UTF_8));
        }
        CachedFile cf = this.getCachedFile();
        if (this.isZip) {
            File file = cf.getFile();
            this.zipFile = new ZipFile(file, StandardCharsets.UTF_8);
            this.zipIcons = file;
            I18n.addTexts(this.zipIcons);
            ZipEntry zipEntry = this.zipFile.getEntry(this.zipEntryPath);
            return this.zipFile.getInputStream(zipEntry);
        }
        this.zipFile = null;
        this.zipIcons = null;
        return cf.getInputStream();
    }

    @Override
    public CachedFile getCachedFile() throws IOException {
        return new CachedFile(this.url).setHttpAccept(MAPCSS_STYLE_MIME_TYPES);
    }

    @Override
    public void closeSourceInputStream(InputStream is) {
        super.closeSourceInputStream(is);
        if (this.isZip) {
            Utils.close(this.zipFile);
        }
    }

    private void loadMeta() {
        Cascade c = this.constructSpecial("meta");
        String pTitle = c.get("title", null, String.class);
        if (this.title == null) {
            this.title = pTitle;
        }
        String pIcon = c.get("icon", null, String.class);
        if (this.icon == null) {
            this.icon = pIcon;
        }
    }

    private void loadCanvas() {
        Cascade c = this.constructSpecial("canvas");
        this.backgroundColorOverride = c.get("fill-color", null, Color.class);
    }

    private static void loadSettings(MapCSSRule r, Selector.GeneralSelector gs, Environment env) {
        if (gs.matchesConditions(env)) {
            env.layer = null;
            env.layer = gs.getSubpart().getId(env);
            r.execute(env);
        }
    }

    private void loadSettings() {
        this.settings.clear();
        this.settingValues.clear();
        this.settingGroups.clear();
        MultiCascade mc = new MultiCascade();
        MultiCascade mcGroups = new MultiCascade();
        Node n = new Node();
        n.put("lang", LanguageInfo.getJOSMLocaleCode());
        Environment env = new Environment(n, mc, "default", this);
        Environment envGroups = new Environment(n, mcGroups, "default", this);
        for (MapCSSRule mapCSSRule : this.rules) {
            if (!(mapCSSRule.selector instanceof Selector.GeneralSelector)) continue;
            Selector.GeneralSelector gs = (Selector.GeneralSelector)mapCSSRule.selector;
            if ("setting".equals(gs.getBase())) {
                MapCSSStyleSource.loadSettings(mapCSSRule, gs, env);
                continue;
            }
            if (!"settings".equals(gs.getBase())) continue;
            MapCSSStyleSource.loadSettings(mapCSSRule, gs, envGroups);
        }
        for (Map.Entry entry : mcGroups.getLayers()) {
            if ("default".equals(entry.getKey())) {
                Logging.warn("settings requires layer identifier e.g. 'settings::settings_group {...}'");
                continue;
            }
            this.settingGroups.put(StyleSetting.StyleSettingGroup.create((Cascade)entry.getValue(), this, (String)entry.getKey()), new ArrayList());
        }
        for (Map.Entry entry : mc.getLayers()) {
            if ("default".equals(entry.getKey())) {
                Logging.warn("setting requires layer identifier e.g. 'setting::my_setting {...}'");
                continue;
            }
            Cascade c = (Cascade)entry.getValue();
            String type = c.get("type", null, String.class);
            StyleSetting.BooleanStyleSetting set = null;
            if ("boolean".equals(type)) {
                set = StyleSetting.BooleanStyleSetting.create(c, this, (String)entry.getKey());
            } else {
                Logging.warn("Unknown setting type: {0}", type);
            }
            if (set == null) continue;
            this.settings.add(set);
            this.settingValues.put((String)entry.getKey(), set.getValue());
            String groupId = c.get("group", null, String.class);
            if (groupId == null) continue;
            ((List)this.settingGroups.get(this.settingGroups.keySet().stream().filter(g -> g.key.equals(groupId)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown settings group: " + groupId)))).add(set);
        }
        this.settings.sort(null);
    }

    private Cascade constructSpecial(String type) {
        MultiCascade mc = new MultiCascade();
        Node n = new Node();
        String code = LanguageInfo.getJOSMLocaleCode();
        n.put("lang", code);
        Environment env = new Environment(n, mc, "default", this);
        for (MapCSSRule r : this.rules) {
            Selector.GeneralSelector gs;
            if (!(r.selector instanceof Selector.GeneralSelector) || !(gs = (Selector.GeneralSelector)r.selector).getBase().equals(type) || !gs.matchesConditions(env)) continue;
            r.execute(env);
        }
        return mc.getCascade("default");
    }

    @Override
    public Color getBackgroundColorOverride() {
        return this.backgroundColorOverride;
    }

    @Override
    public void apply(MultiCascade mc, IPrimitive osm, double scale, boolean pretendWayIsClosed) {
        MapCSSRuleIndex matchingRuleIndex;
        if (osm instanceof INode) {
            matchingRuleIndex = this.nodeRules;
        } else if (osm instanceof IWay) {
            matchingRuleIndex = OsmUtils.isFalse(osm.get("area")) ? this.wayNoAreaRules : this.wayRules;
        } else if (osm instanceof IRelation) {
            matchingRuleIndex = ((IRelation)osm).isMultipolygon() ? this.multipolygonRules : (osm.hasKey("#canvas") ? this.canvasRules : this.relationRules);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + osm);
        }
        Environment env = new Environment(osm, mc, null, this);
        int lastDeclUsed = -1;
        Iterator<MapCSSRule> candidates = matchingRuleIndex.getRuleCandidates(osm);
        while (candidates.hasNext()) {
            MapCSSRule r = candidates.next();
            env.clearSelectorMatchingInformation();
            String sub = env.layer = r.selector.getSubpart().getId(env);
            if (!r.selector.matches(env)) continue;
            Selector s = r.selector;
            if (!s.getRange().contains(scale)) {
                mc.range = mc.range.reduceAround(scale, s.getRange());
                continue;
            }
            mc.range = Range.cut(mc.range, s.getRange());
            if (r.declaration.idx == lastDeclUsed) continue;
            lastDeclUsed = r.declaration.idx;
            if ("*".equals(sub)) {
                for (Map.Entry<String, Cascade> entry : mc.getLayers()) {
                    env.layer = entry.getKey();
                    if ("*".equals(env.layer)) continue;
                    r.execute(env);
                }
            }
            env.layer = sub;
            r.execute(env);
        }
    }

    public boolean evalSupportsDeclCondition(String feature, Object val) {
        if (feature == null) {
            return false;
        }
        if (SUPPORTED_KEYS.contains(feature)) {
            return true;
        }
        switch (feature) {
            case "user-agent": {
                String s = Cascade.convertTo(val, String.class);
                return "josm".equals(s);
            }
            case "min-josm-version": {
                Float min = Cascade.convertTo(val, Float.class);
                return min != null && Math.round(min.floatValue()) <= Version.getInstance().getVersion();
            }
            case "max-josm-version": {
                Float max = Cascade.convertTo(val, Float.class);
                return max != null && Math.round(max.floatValue()) >= Version.getInstance().getVersion();
            }
        }
        return false;
    }

    public void removeMetaRules() {
        Iterator<MapCSSRule> it = this.rules.iterator();
        while (it.hasNext()) {
            MapCSSRule x = it.next();
            if (!(x.selector instanceof Selector.GeneralSelector)) continue;
            Selector.GeneralSelector gs = (Selector.GeneralSelector)x.selector;
            if (!"meta".equals(gs.base)) continue;
            it.remove();
        }
    }

    public void removeAreaStyleClasses() {
        Iterator<MapCSSRule> it = this.rules.iterator();
        while (it.hasNext()) {
            MapCSSStyleSource.removeAreaStyleClasses(it.next().selector);
        }
    }

    private static void removeAreaStyleClasses(Selector sel) {
        if (sel instanceof Selector.ChildOrParentSelector) {
            MapCSSStyleSource.removeAreaStyleClasses((Selector.ChildOrParentSelector)sel);
        } else if (sel instanceof Selector.AbstractSelector) {
            MapCSSStyleSource.removeAreaStyleClasses((Selector.AbstractSelector)sel);
        }
    }

    private static void removeAreaStyleClasses(Selector.ChildOrParentSelector sel) {
        MapCSSStyleSource.removeAreaStyleClasses(sel.left);
        MapCSSStyleSource.removeAreaStyleClasses(sel.right);
    }

    private static void removeAreaStyleClasses(Selector.AbstractSelector sel) {
        if (sel.conds != null) {
            Iterator<Condition> it = sel.conds.iterator();
            while (it.hasNext()) {
                Condition c = it.next();
                if (!(c instanceof ConditionFactory.PseudoClassCondition)) continue;
                ConditionFactory.PseudoClassCondition cc = (ConditionFactory.PseudoClassCondition)c;
                if (!"areaStyle".equals(cc.method.getName())) continue;
                Logging.warn("Removing 'areaStyle' pseudo-class from " + sel + ". This class is only meant for validator");
                it.remove();
            }
        }
    }

    @Override
    public String toString() {
        return Utils.join("\n", this.rules);
    }

    static {
        Field[] declaredFields;
        STYLE_SOURCE_LOCK = new ReentrantReadWriteLock();
        SUPPORTED_KEYS = new HashSet<String>();
        for (Field field : declaredFields = StyleKeys.class.getDeclaredFields()) {
            try {
                SUPPORTED_KEYS.add((String)field.get(null));
                if (field.getName().toLowerCase(Locale.ENGLISH).replace('_', '-').equals(field.get(null))) continue;
                throw new JosmRuntimeException(field.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new JosmRuntimeException(ex);
            }
        }
        for (LineElement.LineType lineType : LineElement.LineType.values()) {
            SUPPORTED_KEYS.add(lineType.prefix + "color");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-background-color");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-background-opacity");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-offset");
            SUPPORTED_KEYS.add(lineType.prefix + "linecap");
            SUPPORTED_KEYS.add(lineType.prefix + "linejoin");
            SUPPORTED_KEYS.add(lineType.prefix + "miterlimit");
            SUPPORTED_KEYS.add(lineType.prefix + "offset");
            SUPPORTED_KEYS.add(lineType.prefix + "opacity");
            SUPPORTED_KEYS.add(lineType.prefix + "real-width");
            SUPPORTED_KEYS.add(lineType.prefix + "width");
        }
    }

    public static class MapCSSRuleIndex {
        private final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
        private final Map<String, MapCSSKeyRules> index = new HashMap<String, MapCSSKeyRules>();
        private final BitSet remaining = new BitSet();

        public void add(MapCSSRule rule) {
            this.rules.add(rule);
        }

        public void initIndex() {
            Collections.sort(this.rules);
            for (int ruleIndex = 0; ruleIndex < this.rules.size(); ++ruleIndex) {
                MapCSSRule r = this.rules.get(ruleIndex);
                Selector selRightmost = r.selector;
                while (selRightmost instanceof Selector.ChildOrParentSelector) {
                    selRightmost = ((Selector.ChildOrParentSelector)selRightmost).right;
                }
                Selector.OptimizedGeneralSelector s = (Selector.OptimizedGeneralSelector)selRightmost;
                if (s.conds == null) {
                    this.remaining.set(ruleIndex);
                    continue;
                }
                ArrayList sk = new ArrayList(Utils.filteredCollection(s.conds, ConditionFactory.SimpleKeyValueCondition.class));
                if (!sk.isEmpty()) {
                    ConditionFactory.SimpleKeyValueCondition c = (ConditionFactory.SimpleKeyValueCondition)sk.get(sk.size() - 1);
                    this.getEntryInIndex(c.k).addForKeyAndValue(c.v, ruleIndex);
                    continue;
                }
                String key = MapCSSRuleIndex.findAnyRequiredKey(s.conds);
                if (key != null) {
                    this.getEntryInIndex(key).addForKey(ruleIndex);
                    continue;
                }
                this.remaining.set(ruleIndex);
            }
        }

        private static String findAnyRequiredKey(List<Condition> conds) {
            String key = null;
            for (Condition c : conds) {
                ConditionFactory.KeyValueCondition keyValueCondition;
                if (c instanceof ConditionFactory.KeyCondition) {
                    ConditionFactory.KeyCondition keyCondition = (ConditionFactory.KeyCondition)c;
                    if (keyCondition.negateResult || !MapCSSRuleIndex.conditionRequiresKeyPresence(keyCondition.matchType)) continue;
                    key = keyCondition.label;
                    continue;
                }
                if (!(c instanceof ConditionFactory.KeyValueCondition) || !(keyValueCondition = (ConditionFactory.KeyValueCondition)c).requiresExactKeyMatch()) continue;
                key = keyValueCondition.k;
            }
            return key;
        }

        private static boolean conditionRequiresKeyPresence(ConditionFactory.KeyMatchType matchType) {
            return matchType != ConditionFactory.KeyMatchType.REGEX;
        }

        private MapCSSKeyRules getEntryInIndex(String key) {
            MapCSSKeyRules rulesWithMatchingKey = this.index.get(key);
            if (rulesWithMatchingKey == null) {
                rulesWithMatchingKey = new MapCSSKeyRules();
                this.index.put(key.intern(), rulesWithMatchingKey);
            }
            return rulesWithMatchingKey;
        }

        public Iterator<MapCSSRule> getRuleCandidates(IPrimitive osm) {
            BitSet ruleCandidates = new BitSet(this.rules.size());
            ruleCandidates.or(this.remaining);
            RuleCandidatesIterator candidatesIterator = new RuleCandidatesIterator(ruleCandidates);
            osm.visitKeys(candidatesIterator);
            candidatesIterator.prepare();
            return candidatesIterator;
        }

        public void clear() {
            this.rules.clear();
            this.index.clear();
            this.remaining.clear();
        }

        private static final class MapCSSKeyRules {
            BitSet generalRules = new BitSet();
            Map<String, BitSet> specialRules = new HashMap<String, BitSet>();

            private MapCSSKeyRules() {
            }

            public void addForKey(int ruleIndex) {
                this.generalRules.set(ruleIndex);
                for (BitSet r : this.specialRules.values()) {
                    r.set(ruleIndex);
                }
            }

            public void addForKeyAndValue(String value, int ruleIndex) {
                BitSet forValue = this.specialRules.get(value);
                if (forValue == null) {
                    forValue = new BitSet();
                    forValue.or(this.generalRules);
                    this.specialRules.put(value.intern(), forValue);
                }
                forValue.set(ruleIndex);
            }

            public BitSet get(String value) {
                BitSet forValue = this.specialRules.get(value);
                if (forValue != null) {
                    return forValue;
                }
                return this.generalRules;
            }
        }

        private final class RuleCandidatesIterator
        implements Iterator<MapCSSRule>,
        KeyValueVisitor {
            private final BitSet ruleCandidates;
            private int next;

            private RuleCandidatesIterator(BitSet ruleCandidates) {
                this.ruleCandidates = ruleCandidates;
            }

            @Override
            public boolean hasNext() {
                return this.next >= 0 && this.next < MapCSSRuleIndex.this.rules.size();
            }

            @Override
            public MapCSSRule next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                MapCSSRule rule = (MapCSSRule)MapCSSRuleIndex.this.rules.get(this.next);
                this.next = this.ruleCandidates.nextSetBit(this.next + 1);
                return rule;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void visitKeyValue(Tagged p, String key, String value) {
                MapCSSKeyRules v = (MapCSSKeyRules)MapCSSRuleIndex.this.index.get(key);
                if (v != null) {
                    BitSet rs = v.get(value);
                    this.ruleCandidates.or(rs);
                }
            }

            public void prepare() {
                this.next = this.ruleCandidates.nextSetBit(0);
            }
        }
    }
}

