/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.Exceptions;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        BcTlsSigner bcTlsSigner;
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            if (signatureAndHashAlgorithm != null) {
                short s = signatureAndHashAlgorithm.getSignature();
                switch (s) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return new BcTlsRSAPSSSigner(bcTlsCrypto, (RSAKeyParameters)asymmetricKeyParameter, s);
                    }
                }
            }
            bcTlsSigner = new BcTlsRSASigner(bcTlsCrypto, (RSAKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            bcTlsSigner = new BcTlsDSASigner(bcTlsCrypto, (DSAPrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            bcTlsSigner = new BcTlsECDSASigner(bcTlsCrypto, (ECPrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
            try {
                bcTlsSigner = new BcTlsEd25519Signer(bcTlsCrypto, (Ed25519PrivateKeyParameters)asymmetricKeyParameter, BcTlsCertificate.convert(bcTlsCrypto, certificate.getCertificateAt(0)).getPubKeyEd25519());
            }
            catch (IOException iOException) {
                throw Exceptions.illegalArgumentException("exception converting certificate", iOException);
            }
        } else if (asymmetricKeyParameter instanceof Ed448PrivateKeyParameters) {
            try {
                bcTlsSigner = new BcTlsEd448Signer(bcTlsCrypto, (Ed448PrivateKeyParameters)asymmetricKeyParameter, BcTlsCertificate.convert(bcTlsCrypto, certificate.getCertificateAt(0)).getPubKeyEd448());
            }
            catch (IOException iOException) {
                throw Exceptions.illegalArgumentException("exception converting certificate", iOException);
            }
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        return bcTlsSigner;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(tlsCryptoParameters, BcDefaultTlsCredentialedSigner.makeSigner(bcTlsCrypto, asymmetricKeyParameter, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

