/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.shaj;

import com.cenqua.shaj.Authenticator;
import com.cenqua.shaj.Shaj;
import com.cenqua.shaj.log.Log;

public class Win32Authenticator
extends Authenticator {
    private static native boolean isSupportedImpl(Log var0);

    private static native boolean checkPasswordImpl(String var0, String var1, String var2, Log var3);

    private static native boolean checkGroupMembershipImpl(String var0, String var1, String var2, Log var3);

    public static boolean isSupported() {
        return Win32Authenticator.isSupported(Log.Factory.getInstance());
    }

    private static boolean isSupported(Log log) {
        if (!Shaj.sInitOkay) {
            return false;
        }
        return Win32Authenticator.isSupportedImpl(log);
    }

    public boolean checkPassword(String domain, String username, String password, Log log) {
        return Win32Authenticator.checkWin32Password(domain, username, password, log);
    }

    public boolean checkGroupMembership(String domain, String username, String group, Log log) {
        return Win32Authenticator.checkWin32GroupMembership(domain, username, group, log);
    }

    public static boolean checkWin32Password(String domain, String username, String password, Log log) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null");
        }
        if (!Shaj.sInitOkay) {
            throw new IllegalStateException("native library not loaded");
        }
        return Win32Authenticator.checkPasswordImpl(domain, username, password, log);
    }

    public static boolean checkWin32GroupMembership(String domain, String username, String group, Log log) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("group cannot be null");
        }
        if (!Shaj.sInitOkay) {
            throw new IllegalStateException("native library not loaded");
        }
        return Win32Authenticator.checkGroupMembershipImpl(domain, username, group, log);
    }

    static {
        Shaj.init();
    }
}

