/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

public class ElementMenuEntry
extends AbstractElement {
    private final TextBlock block;
    private final String text;
    private HtmlColor background;
    private double xxx;

    public ElementMenuEntry(String text, UFont font, ISkinSimple spriteContainer) {
        FontConfiguration config = FontConfiguration.blackBlueTrue(font);
        this.block = Display.create(text).create(config, HorizontalAlignment.LEFT, spriteContainer);
        this.text = text;
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        if (this.text.equals("-")) {
            return new Dimension2DDouble(10.0, 5.0);
        }
        return this.block.calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        if (this.background != null) {
            Dimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
            ug.apply(new UChangeBackColor(this.background)).draw(new URectangle(dim.getWidth(), dim.getHeight()));
        }
        this.block.drawU(ug);
    }

    public double getX() {
        return this.xxx;
    }

    public void setX(double x) {
        this.xxx = x;
    }

    public String getText() {
        return this.text;
    }

    public HtmlColor getBackground() {
        return this.background;
    }

    public void setBackground(HtmlColor background) {
        this.background = background;
    }
}

