/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class DistantLight
extends AbstractLight {
    private double azimuth;
    private double elevation;
    private double Lx;
    private double Ly;
    private double Lz;

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public DistantLight(double d, double d2, Color color) {
        super(color);
        this.azimuth = d;
        this.elevation = d2;
        this.Lx = Math.cos(Math.toRadians(d)) * Math.cos(Math.toRadians(d2));
        this.Ly = Math.sin(Math.toRadians(d)) * Math.cos(Math.toRadians(d2));
        this.Lz = Math.sin(Math.toRadians(d2));
    }

    public boolean isConstant() {
        return true;
    }

    public void getLight(double d, double d2, double d3, double[] dArray) {
        dArray[0] = this.Lx;
        dArray[1] = this.Ly;
        dArray[2] = this.Lz;
    }

    public double[][] getLightRow(double d, double d2, double d3, int n, double[][] dArray, double[][] dArray2) {
        Object object = dArray2;
        if (object == null) {
            object = new double[n][];
            double[] dArray3 = new double[]{this.Lx, this.Ly, this.Lz};
            for (int i = 0; i < n; ++i) {
                object[i] = dArray3;
            }
        } else {
            double d4 = this.Lx;
            double d5 = this.Ly;
            double d6 = this.Lz;
            for (int i = 0; i < n; ++i) {
                object[i][0] = d4;
                object[i][1] = d5;
                object[i][2] = d6;
            }
        }
        return object;
    }
}

