﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/qldb/QLDB_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace QLDB
{
namespace Model
{
  class AWS_QLDB_API ExportJournalToS3Result
  {
  public:
    ExportJournalToS3Result();
    ExportJournalToS3Result(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    ExportJournalToS3Result& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The unique ID that QLDB assigns to each journal export job.</p> <p>To
     * describe your export request and check the status of the job, you can use
     * <code>ExportId</code> to call <code>DescribeJournalS3Export</code>.</p>
     */
    inline const Aws::String& GetExportId() const{ return m_exportId; }

    /**
     * <p>The unique ID that QLDB assigns to each journal export job.</p> <p>To
     * describe your export request and check the status of the job, you can use
     * <code>ExportId</code> to call <code>DescribeJournalS3Export</code>.</p>
     */
    inline void SetExportId(const Aws::String& value) { m_exportId = value; }

    /**
     * <p>The unique ID that QLDB assigns to each journal export job.</p> <p>To
     * describe your export request and check the status of the job, you can use
     * <code>ExportId</code> to call <code>DescribeJournalS3Export</code>.</p>
     */
    inline void SetExportId(Aws::String&& value) { m_exportId = std::move(value); }

    /**
     * <p>The unique ID that QLDB assigns to each journal export job.</p> <p>To
     * describe your export request and check the status of the job, you can use
     * <code>ExportId</code> to call <code>DescribeJournalS3Export</code>.</p>
     */
    inline void SetExportId(const char* value) { m_exportId.assign(value); }

    /**
     * <p>The unique ID that QLDB assigns to each journal export job.</p> <p>To
     * describe your export request and check the status of the job, you can use
     * <code>ExportId</code> to call <code>DescribeJournalS3Export</code>.</p>
     */
    inline ExportJournalToS3Result& WithExportId(const Aws::String& value) { SetExportId(value); return *this;}

    /**
     * <p>The unique ID that QLDB assigns to each journal export job.</p> <p>To
     * describe your export request and check the status of the job, you can use
     * <code>ExportId</code> to call <code>DescribeJournalS3Export</code>.</p>
     */
    inline ExportJournalToS3Result& WithExportId(Aws::String&& value) { SetExportId(std::move(value)); return *this;}

    /**
     * <p>The unique ID that QLDB assigns to each journal export job.</p> <p>To
     * describe your export request and check the status of the job, you can use
     * <code>ExportId</code> to call <code>DescribeJournalS3Export</code>.</p>
     */
    inline ExportJournalToS3Result& WithExportId(const char* value) { SetExportId(value); return *this;}

  private:

    Aws::String m_exportId;
  };

} // namespace Model
} // namespace QLDB
} // namespace Aws
