/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class OverwriteWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        OverwriteWidget overwriteWidget = new OverwriteWidget(view);
        return overwriteWidget;
    }

    private static class OverwriteWidget
    implements Widget {
        private final JLabel overwrite = new ToolTipLabel();
        private final View view;

        OverwriteWidget(final View view) {
            this.overwrite.setHorizontalAlignment(0);
            this.overwrite.setToolTipText(jEdit.getProperty("view.status.overwrite-tooltip"));
            this.view = view;
            this.overwrite.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    JEditTextArea jEditTextArea = view.getTextArea();
                    if (jEditTextArea != null) {
                        jEditTextArea.toggleOverwriteEnabled();
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.overwrite;
        }

        @Override
        public void update() {
            JEditTextArea jEditTextArea = this.view.getTextArea();
            if (jEditTextArea != null) {
                if (jEditTextArea.isOverwriteEnabled()) {
                    this.overwrite.setText("O");
                    this.overwrite.setEnabled(true);
                } else {
                    this.overwrite.setText("o");
                    this.overwrite.setEnabled(false);
                }
            }
        }

        @Override
        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fontMetrics = this.overwrite.getFontMetrics(font);
            Dimension dimension = new Dimension(Math.max(fontMetrics.charWidth('o'), fontMetrics.charWidth('O')) + 1, fontMetrics.getHeight());
            this.overwrite.setPreferredSize(dimension);
            this.overwrite.setMaximumSize(dimension);
        }
    }
}

