/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.print.CUPSPrinter;
import sun.print.CustomMediaSizeName;
import sun.print.CustomMediaTray;
import sun.print.IPPPrintService;
import sun.print.ImagePrinter;
import sun.print.PSPrinterJob;
import sun.print.PrintJobAttributeException;
import sun.print.PrintJobFlavorException;
import sun.print.UnixPrintService;
import sun.print.UnixPrintServiceLookup;

public class UnixPrintJob
implements CancelablePrintJob {
    private static String debugPrefix = "UnixPrintJob>> ";
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private PrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 1;
    private MediaSizeName mediaName = MediaSizeName.NA_LETTER;
    private MediaSize mediaSize = MediaSize.NA.LETTER;
    private CustomMediaTray customTray = null;
    private OrientationRequested orient = OrientationRequested.PORTRAIT;
    private NumberUp nUp = null;
    private Sides sides = null;
    private static int DESTPRINTER = 1;
    private static int DESTFILE = 2;
    private int mDestType = DESTPRINTER;
    private File spoolFile;
    private String mDestination;
    private String mOptions = "";
    private boolean mNoJobSheet = false;

    UnixPrintJob(PrintService service) {
        this.service = service;
        this.mDestination = service.getName();
        this.mDestType = DESTPRINTER;
    }

    @Override
    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintJobAttributeSet getAttributes() {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet jobSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(jobSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobListener(PrintJobListener listener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (listener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobListener(PrintJobListener listener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (listener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(listener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataStreams() {
        if (this.doc == null) {
            return;
        }
        Object data = null;
        try {
            data = this.doc.getPrintData();
        }
        catch (IOException e) {
            return;
        }
        if (this.instream != null) {
            try {
                this.instream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.instream = null;
            }
        } else if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.reader = null;
            }
        } else if (data instanceof InputStream) {
            try {
                ((InputStream)data).close();
            }
            catch (IOException iOException) {}
        } else if (data instanceof Reader) {
            try {
                ((Reader)data).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int reason) {
        switch (reason) {
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: {
                this.closeDataStreams();
            }
        }
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent event = new PrintJobEvent(this, reason);
                block12: for (int i = 0; i < this.jobListeners.size(); ++i) {
                    PrintJobListener listener = (PrintJobListener)this.jobListeners.elementAt(i);
                    switch (reason) {
                        case 101: {
                            listener.printJobCanceled(event);
                            continue block12;
                        }
                        case 103: {
                            listener.printJobFailed(event);
                            continue block12;
                        }
                        case 106: {
                            listener.printDataTransferCompleted(event);
                            continue block12;
                        }
                        case 105: {
                            listener.printJobNoMoreEvents(event);
                            continue block12;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (listener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(listener);
            if (attributes == null) {
                attributes = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (listener == null || this.attrListeners == null) {
                return;
            }
            int index = this.attrListeners.indexOf(listener);
            if (index == -1) {
                return;
            }
            this.attrListeners.remove(index);
            this.listenedAttributeSets.remove(index);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
        String encoding;
        DocFlavor flavor;
        block75: {
            URL url;
            Object data;
            UnixPrintJob unixPrintJob = this;
            synchronized (unixPrintJob) {
                if (this.printing) {
                    throw new PrintException("already printing");
                }
                this.printing = true;
            }
            if (this.service.getAttribute(PrinterIsAcceptingJobs.class) == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
                throw new PrintException("Printer is not accepting job.");
            }
            this.doc = doc;
            flavor = doc.getDocFlavor();
            try {
                data = doc.getPrintData();
            }
            catch (IOException e) {
                this.notifyEvent(103);
                throw new PrintException("can't get print data: " + e.toString());
            }
            if (flavor == null || !this.service.isDocFlavorSupported(flavor)) {
                this.notifyEvent(103);
                throw new PrintJobFlavorException("invalid flavor", flavor);
            }
            this.initializeAttributeSets(doc, attributes);
            this.getAttributeValues(flavor);
            if (this.service instanceof IPPPrintService && CUPSPrinter.isCupsRunning()) {
                String choice;
                CustomMediaSizeName customMedia;
                IPPPrintService.debug_println(debugPrefix + "instanceof IPPPrintService");
                if (this.mediaName != null && (customMedia = ((IPPPrintService)this.service).findCustomMedia(this.mediaName)) != null) {
                    this.mOptions = " media=" + customMedia.getChoiceName();
                }
                if (this.customTray != null && this.customTray instanceof CustomMediaTray && (choice = this.customTray.getChoiceName()) != null) {
                    this.mOptions = this.mOptions + " media=" + choice;
                }
                if (this.nUp != null) {
                    this.mOptions = this.mOptions + " number-up=" + this.nUp.getValue();
                }
                if (this.orient != OrientationRequested.PORTRAIT && flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE)) {
                    this.mOptions = this.mOptions + " orientation-requested=" + this.orient.getValue();
                }
                if (this.sides != null) {
                    this.mOptions = this.mOptions + " sides=" + this.sides;
                }
            }
            IPPPrintService.debug_println(debugPrefix + "mOptions " + this.mOptions);
            String repClassName = flavor.getRepresentationClassName();
            String val = flavor.getParameter("charset");
            encoding = "us-ascii";
            if (val != null && !val.equals("")) {
                encoding = val;
            }
            if (flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG)) {
                try {
                    this.instream = doc.getStreamForBytes();
                    if (this.instream == null) {
                        this.notifyEvent(103);
                        throw new PrintException("No stream for data");
                    }
                    if (!(this.service instanceof IPPPrintService) || !((IPPPrintService)this.service).isIPPSupportedImages(flavor.getMimeType())) {
                        this.printableJob(new ImagePrinter(this.instream));
                        ((UnixPrintService)this.service).wakeNotifier();
                        return;
                    }
                    break block75;
                }
                catch (ClassCastException cce) {
                    this.notifyEvent(103);
                    throw new PrintException(cce);
                }
                catch (IOException ioe) {
                    this.notifyEvent(103);
                    throw new PrintException(ioe);
                }
            }
            if (flavor.equals(DocFlavor.URL.GIF) || flavor.equals(DocFlavor.URL.JPEG) || flavor.equals(DocFlavor.URL.PNG)) {
                try {
                    url = (URL)data;
                    if (!(this.service instanceof IPPPrintService) || !((IPPPrintService)this.service).isIPPSupportedImages(flavor.getMimeType())) {
                        this.printableJob(new ImagePrinter(url));
                        ((UnixPrintService)this.service).wakeNotifier();
                        return;
                    }
                    this.instream = url.openStream();
                }
                catch (ClassCastException cce) {
                    this.notifyEvent(103);
                    throw new PrintException(cce);
                }
                catch (IOException e) {
                    this.notifyEvent(103);
                    throw new PrintException(e.toString());
                }
            }
            if (flavor.equals(DocFlavor.CHAR_ARRAY.TEXT_PLAIN) || flavor.equals(DocFlavor.READER.TEXT_PLAIN) || flavor.equals(DocFlavor.STRING.TEXT_PLAIN)) {
                try {
                    this.reader = doc.getReaderForText();
                    if (this.reader == null) {
                        this.notifyEvent(103);
                        throw new PrintException("No reader for data");
                    }
                    break block75;
                }
                catch (IOException ioe) {
                    this.notifyEvent(103);
                    throw new PrintException(ioe.toString());
                }
            }
            if (repClassName.equals("[B") || repClassName.equals("java.io.InputStream")) {
                try {
                    this.instream = doc.getStreamForBytes();
                    if (this.instream == null) {
                        this.notifyEvent(103);
                        throw new PrintException("No stream for data");
                    }
                    break block75;
                }
                catch (IOException ioe) {
                    this.notifyEvent(103);
                    throw new PrintException(ioe.toString());
                }
            }
            if (repClassName.equals("java.net.URL")) {
                url = (URL)data;
                try {
                    this.instream = url.openStream();
                }
                catch (IOException e) {
                    this.notifyEvent(103);
                    throw new PrintException(e.toString());
                }
            } else {
                if (repClassName.equals("java.awt.print.Pageable")) {
                    try {
                        this.pageableJob((Pageable)doc.getPrintData());
                        if (this.service instanceof IPPPrintService) {
                            ((IPPPrintService)this.service).wakeNotifier();
                        } else {
                            ((UnixPrintService)this.service).wakeNotifier();
                        }
                        return;
                    }
                    catch (ClassCastException cce) {
                        this.notifyEvent(103);
                        throw new PrintException(cce);
                    }
                    catch (IOException ioe) {
                        this.notifyEvent(103);
                        throw new PrintException(ioe);
                    }
                }
                if (repClassName.equals("java.awt.print.Printable")) {
                    try {
                        this.printableJob((Printable)doc.getPrintData());
                        if (this.service instanceof IPPPrintService) {
                            ((IPPPrintService)this.service).wakeNotifier();
                        } else {
                            ((UnixPrintService)this.service).wakeNotifier();
                        }
                        return;
                    }
                    catch (ClassCastException cce) {
                        this.notifyEvent(103);
                        throw new PrintException(cce);
                    }
                    catch (IOException ioe) {
                        this.notifyEvent(103);
                        throw new PrintException(ioe);
                    }
                }
                this.notifyEvent(103);
                throw new PrintException("unrecognized class: " + repClassName);
            }
        }
        PrinterOpener po = new PrinterOpener();
        AccessController.doPrivileged(po);
        if (po.pex != null) {
            throw po.pex;
        }
        OutputStream output = po.result;
        BufferedWriter bw = null;
        if (this.instream == null && this.reader != null) {
            BufferedReader br = new BufferedReader(this.reader);
            OutputStreamWriter osw = new OutputStreamWriter(output);
            bw = new BufferedWriter(osw);
            char[] buffer = new char[1024];
            try {
                int cread;
                while ((cread = br.read(buffer, 0, buffer.length)) >= 0) {
                    bw.write(buffer, 0, cread);
                }
                br.close();
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                this.notifyEvent(103);
                throw new PrintException(e);
            }
        }
        if (this.instream != null && flavor.getMediaType().equalsIgnoreCase("text")) {
            try {
                int cread;
                InputStreamReader isr = new InputStreamReader(this.instream, encoding);
                BufferedReader br = new BufferedReader(isr);
                OutputStreamWriter osw = new OutputStreamWriter(output);
                bw = new BufferedWriter(osw);
                char[] buffer = new char[1024];
                while ((cread = br.read(buffer, 0, buffer.length)) >= 0) {
                    bw.write(buffer, 0, cread);
                }
                bw.flush();
            }
            catch (IOException e) {
                this.notifyEvent(103);
                throw new PrintException(e);
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (this.instream != null) {
            BufferedInputStream bin = new BufferedInputStream(this.instream);
            BufferedOutputStream bout = new BufferedOutputStream(output);
            byte[] buffer = new byte[1024];
            int bread = 0;
            try {
                while ((bread = bin.read(buffer)) >= 0) {
                    bout.write(buffer, 0, bread);
                }
                bin.close();
                bout.flush();
                bout.close();
            }
            catch (IOException e) {
                this.notifyEvent(103);
                throw new PrintException(e);
            }
        }
        this.notifyEvent(106);
        if (this.mDestType == DESTPRINTER) {
            PrinterSpooler spooler = new PrinterSpooler();
            AccessController.doPrivileged(spooler);
            if (spooler.pex != null) {
                throw spooler.pex;
            }
        }
        this.notifyEvent(105);
        if (this.service instanceof IPPPrintService) {
            ((IPPPrintService)this.service).wakeNotifier();
        } else {
            ((UnixPrintService)this.service).wakeNotifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable) throws PrintException {
        try {
            UnixPrintJob unixPrintJob = this;
            synchronized (unixPrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new PSPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            this.job.setCopies(this.copies);
            this.job.setJobName(this.jobName);
            PageFormat pf = new PageFormat();
            if (this.mediaSize != null) {
                Paper p = new Paper();
                p.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                p.setImageableArea(72.0, 72.0, p.getWidth() - 144.0, p.getHeight() - 144.0);
                pf.setPaper(p);
            }
            if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                pf.setOrientation(2);
            } else if (this.orient == OrientationRequested.LANDSCAPE) {
                pf.setOrientation(0);
            }
            this.job.setPrintable(printable, pf);
            this.job.print(this.reqAttrSet);
            this.notifyEvent(106);
            return;
        }
        catch (PrinterException pe) {
            this.notifyEvent(103);
            throw new PrintException(pe);
        }
        finally {
            this.printReturned = true;
            this.notifyEvent(105);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable) throws PrintException {
        try {
            UnixPrintJob unixPrintJob = this;
            synchronized (unixPrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new PSPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            this.job.setCopies(this.copies);
            this.job.setJobName(this.jobName);
            this.job.setPageable(pageable);
            this.job.print(this.reqAttrSet);
            this.notifyEvent(106);
            return;
        }
        catch (PrinterException pe) {
            this.notifyEvent(103);
            throw new PrintException(pe);
        }
        finally {
            this.printReturned = true;
            this.notifyEvent(105);
        }
    }

    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet reqSet) {
        DocAttributeSet docSet;
        Attribute[] attrs;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (reqSet != null) {
            this.reqAttrSet.addAll(reqSet);
            attrs = reqSet.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                if (!(attrs[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attrs[i]);
            }
        }
        if ((docSet = doc.getAttributes()) != null) {
            attrs = docSet.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(attrs[i]);
                }
                if (!(attrs[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attrs[i]);
            }
        }
        String userName = "";
        try {
            userName = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (userName == null || userName.equals("")) {
            RequestingUserName ruName = (RequestingUserName)reqSet.get(RequestingUserName.class);
            if (ruName != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(ruName.getValue(), ruName.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(userName, null));
        }
        if (this.jobAttrSet.get(JobName.class) == null) {
            JobName jobName;
            if (docSet != null && docSet.get(DocumentName.class) != null) {
                DocumentName docName = (DocumentName)docSet.get(DocumentName.class);
                jobName = new JobName(docName.getValue(), docName.getLocale());
                this.jobAttrSet.add(jobName);
            } else {
                String str = "JPS Job:" + doc;
                try {
                    Object printData = doc.getPrintData();
                    if (printData instanceof URL) {
                        str = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                jobName = new JobName(str, null);
                this.jobAttrSet.add(jobName);
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    private void getAttributeValues(DocFlavor flavor) throws PrintException {
        this.fidelity = this.reqAttrSet.get(Fidelity.class) == Fidelity.FIDELITY_TRUE;
        Attribute[] attrs = this.reqAttrSet.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            Attribute attr = attrs[i];
            Class<? extends Attribute> category = attr.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(category)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + category, category, null);
                }
                if (!this.service.isAttributeValueSupported(attr, flavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attr, null, attr);
                }
            }
            if (category == Destination.class) {
                URI uri = ((Destination)attr).getURI();
                if (!"file".equals(uri.getScheme())) {
                    this.notifyEvent(103);
                    throw new PrintException("Not a file: URI");
                }
                try {
                    this.mDestType = DESTFILE;
                    this.mDestination = new File(uri).getPath();
                }
                catch (Exception e) {
                    throw new PrintException(e);
                }
                SecurityManager security = System.getSecurityManager();
                if (security == null) continue;
                try {
                    security.checkWrite(this.mDestination);
                    continue;
                }
                catch (SecurityException se) {
                    this.notifyEvent(103);
                    throw new PrintException(se);
                }
            }
            if (category == JobSheets.class) {
                if ((JobSheets)attr != JobSheets.NONE) continue;
                this.mNoJobSheet = true;
                continue;
            }
            if (category == JobName.class) {
                this.jobName = ((JobName)attr).getValue();
                continue;
            }
            if (category == Copies.class) {
                this.copies = ((Copies)attr).getValue();
                continue;
            }
            if (category == Media.class) {
                if (attr instanceof MediaSizeName) {
                    this.mediaName = (MediaSizeName)attr;
                    IPPPrintService.debug_println(debugPrefix + "mediaName " + this.mediaName);
                    if (this.service.isAttributeValueSupported(attr, null, null)) continue;
                    this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                    continue;
                }
                if (!(attr instanceof CustomMediaTray)) continue;
                this.customTray = (CustomMediaTray)attr;
                continue;
            }
            if (category == OrientationRequested.class) {
                this.orient = (OrientationRequested)attr;
                continue;
            }
            if (category == NumberUp.class) {
                this.nUp = (NumberUp)attr;
                continue;
            }
            if (category != Sides.class) continue;
            this.sides = (Sides)attr;
        }
    }

    private String[] printExecCmd(String printer, String options, boolean noJobSheet, String banner, int copies, String spoolFile) {
        String[] execCmd;
        int PRINTER = 1;
        int OPTIONS = 2;
        int BANNER = 4;
        int COPIES = 8;
        int NOSHEET = 16;
        int pFlags = 0;
        int ncomps = 2;
        int n = 0;
        if (printer != null && !printer.equals("") && !printer.equals("lp")) {
            pFlags |= PRINTER;
            ++ncomps;
        }
        if (options != null && !options.equals("")) {
            pFlags |= OPTIONS;
            ++ncomps;
        }
        if (banner != null && !banner.equals("")) {
            pFlags |= BANNER;
            ++ncomps;
        }
        if (copies > 1) {
            pFlags |= COPIES;
            ++ncomps;
        }
        if (noJobSheet) {
            pFlags |= NOSHEET;
            ++ncomps;
        }
        if (UnixPrintServiceLookup.osname.equals("SunOS")) {
            execCmd = new String[++ncomps];
            execCmd[n++] = "/usr/bin/lp";
            execCmd[n++] = "-c";
            if ((pFlags & PRINTER) != 0) {
                execCmd[n++] = "-d" + printer;
            }
            if ((pFlags & BANNER) != 0) {
                String quoteChar = "\"";
                execCmd[n++] = "-t " + quoteChar + banner + quoteChar;
            }
            if ((pFlags & COPIES) != 0) {
                execCmd[n++] = "-n " + copies;
            }
            if ((pFlags & NOSHEET) != 0) {
                execCmd[n++] = "-o nobanner";
            }
            if ((pFlags & OPTIONS) != 0) {
                execCmd[n++] = "-o " + options;
            }
        } else {
            execCmd = new String[ncomps];
            execCmd[n++] = "/usr/bin/lpr";
            if ((pFlags & PRINTER) != 0) {
                execCmd[n++] = "-P" + printer;
            }
            if ((pFlags & BANNER) != 0) {
                execCmd[n++] = "-J " + banner;
            }
            if ((pFlags & COPIES) != 0) {
                execCmd[n++] = "-#" + copies;
            }
            if ((pFlags & NOSHEET) != 0) {
                execCmd[n++] = "-h";
            }
            if ((pFlags & OPTIONS) != 0) {
                execCmd[n++] = "-o" + options;
            }
        }
        execCmd[n++] = spoolFile;
        if (IPPPrintService.debugPrint) {
            System.out.println("UnixPrintJob>> execCmd");
            for (int i = 0; i < execCmd.length; ++i) {
                System.out.print(" " + execCmd[i]);
            }
            System.out.println();
        }
        return execCmd;
    }

    @Override
    public void cancel() throws PrintException {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrintException pex;

        private PrinterSpooler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleProcessFailure(Process failedProcess, String[] execCmd, int result) throws IOException {
            StringWriter sw = new StringWriter();
            Throwable throwable = null;
            try {
                try {
                    PrintWriter pw = new PrintWriter(sw);
                    Throwable throwable2 = null;
                    try {
                        try {
                            pw.append("error=").append(Integer.toString(result));
                            pw.append(" running:");
                            for (String arg : execCmd) {
                                pw.append(" '").append(arg).append("'");
                            }
                            try {
                                block53: {
                                    InputStream is;
                                    block54: {
                                        is = failedProcess.getErrorStream();
                                        Throwable throwable3 = null;
                                        try {
                                            try (InputStreamReader isr = new InputStreamReader(is);
                                                 BufferedReader br = new BufferedReader(isr);){
                                                while (br.ready()) {
                                                    pw.println();
                                                    pw.append("\t\t").append(br.readLine());
                                                }
                                            }
                                            if (is == null) break block53;
                                            if (throwable3 == null) break block54;
                                        }
                                        catch (Throwable throwable4) {
                                            try {
                                                throwable3 = throwable4;
                                                throw throwable4;
                                            }
                                            catch (Throwable throwable5) {
                                                if (is == null) throw throwable5;
                                                if (throwable3 == null) {
                                                    is.close();
                                                    throw throwable5;
                                                }
                                                try {
                                                    is.close();
                                                    throw throwable5;
                                                }
                                                catch (Throwable x2) {
                                                    throwable3.addSuppressed(x2);
                                                    throw throwable5;
                                                }
                                            }
                                        }
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable3.addSuppressed(x2);
                                        }
                                    }
                                    is.close();
                                }
                            }
                            finally {
                                pw.flush();
                                throw new IOException(sw.toString());
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                    }
                    catch (Throwable throwable7) {
                        if (pw == null) throw throwable7;
                        if (throwable2 == null) {
                            pw.close();
                            throw throwable7;
                        }
                        try {
                            pw.close();
                            throw throwable7;
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                            throw throwable7;
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
            }
            catch (Throwable throwable9) {
                if (sw == null) throw throwable9;
                if (throwable == null) {
                    sw.close();
                    throw throwable9;
                }
                try {
                    sw.close();
                    throw throwable9;
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                    throw throwable9;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            if (UnixPrintJob.this.spoolFile == null || !UnixPrintJob.this.spoolFile.exists()) {
                this.pex = new PrintException("No spool file");
                UnixPrintJob.this.notifyEvent(103);
                return null;
            }
            try {
                String fileName = UnixPrintJob.this.spoolFile.getAbsolutePath();
                String[] execCmd = UnixPrintJob.this.printExecCmd(UnixPrintJob.this.mDestination, UnixPrintJob.this.mOptions, UnixPrintJob.this.mNoJobSheet, UnixPrintJob.this.jobName, UnixPrintJob.this.copies, fileName);
                Process process = Runtime.getRuntime().exec(execCmd);
                process.waitFor();
                int result = process.exitValue();
                if (0 != result) {
                    this.handleProcessFailure(process, execCmd, result);
                }
                UnixPrintJob.this.notifyEvent(106);
            }
            catch (IOException ex) {
                UnixPrintJob.this.notifyEvent(103);
                this.pex = new PrintException(ex);
            }
            catch (InterruptedException ie) {
                UnixPrintJob.this.notifyEvent(103);
                this.pex = new PrintException(ie);
            }
            finally {
                UnixPrintJob.this.spoolFile.delete();
                UnixPrintJob.this.notifyEvent(105);
            }
            return null;
        }
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrintException pex;
        OutputStream result;

        private PrinterOpener() {
        }

        public Object run() {
            try {
                if (UnixPrintJob.this.mDestType == DESTFILE) {
                    UnixPrintJob.this.spoolFile = new File(UnixPrintJob.this.mDestination);
                } else {
                    UnixPrintJob.this.spoolFile = Files.createTempFile("javaprint", "", new FileAttribute[0]).toFile();
                    UnixPrintJob.this.spoolFile.deleteOnExit();
                }
                this.result = new FileOutputStream(UnixPrintJob.this.spoolFile);
                return this.result;
            }
            catch (IOException ex) {
                UnixPrintJob.this.notifyEvent(103);
                this.pex = new PrintException(ex);
                return null;
            }
        }
    }
}

