#!/usr/bin/perl
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# --------------------------------

$Lang{Start_Archive} = "Spustit Archivaci";
$Lang{Stop_Dequeue_Archive} = "Ukonit/Odstranit z Fronty Archivaci";
$Lang{Start_Full_Backup} = "Spustit pln Zlohovn";
$Lang{Start_Incr_Backup} = "Spustit Inkremetan Zlohovn";
$Lang{Stop_Dequeue_Backup} = "Ukonit/Odstranit z Fronty Zlohovn";
$Lang{Restore} = "Obnovit";
$Lang{Type_full} = "pln";
$Lang{Type_incr} = "inkrementan";

# -----

$Lang{Only_privileged_users_can_view_admin_options} = "Pouze oprvnn uivatel maj pstup k administranmu nastaven.";
$Lang{H_Admin_Options} = "BackupPC Server: Administran nastaven";
$Lang{Admin_Options} = "Administran nastaven";
$Lang{Admin_Options_Page} = <<EOF;
\${h1(qq{$Lang{Admin_Options}})}
<br>
\${h2("Kontrola Serveru")}
<form name="ReloadForm" action="\$MyURL" method="get">
<input type="hidden" name="action" value="">
<table class="tableStnd">
  <tr><td>Znovu nahrt konfiguraci serveru:<td><input type="button" value="Reload"
     onClick="document.ReloadForm.action.value='Reload';
              document.ReloadForm.submit();">
</table>
</form>
<!--
\${h2("Konfigurace serveru")}
<ul>
  <li><i>Jin nastaven mohou bt zde ... nap,</i>
  <li>Editace konfigurace serveru
</ul>
-->
EOF

$Lang{Unable_to_connect_to_BackupPC_server} = "Nen mon se pipojit k BackupPC serveru";
$Lang{Unable_to_connect_to_BackupPC_server_error_message} = <<EOF;
Tento CGI skript (\$MyURL) se nen schopn pipojit k BackupPC
server na \$Conf{ServerHost} port \$Conf{ServerPort}.<br>
Chyba: \$err.<br>
Je mon, e BackupPC server nen sputn nebo je chyba v konfiguraci.
Prosm oznamte to systmovmu administrtorovi.
EOF

$Lang{Admin_Start_Server} = <<EOF;
\${h1(qq{$Lang{Unable_to_connect_to_BackupPC_server}})}
<form action="\$MyURL" method="get">
BackupPC server na <tt>\$Conf{ServerHost}</tt> port <tt>\$Conf{ServerPort}</tt>
nen momentln sputn (mon jste ho ukonil nebo jet nespustil).<br>
Chceste ho spustit?
<input type="hidden" name="action" value="startServer">
<input type="submit" value="Spustit Server" name="ignore">
</form>
EOF

# -----

$Lang{H_BackupPC_Server_Status} = "Status Serveru BackupPC";

$Lang{BackupPC_Server_Status_General_Info}= <<EOF;
\${h2(\"Obecn Informace o Serveru\")}

<ul>
<li> PID serveru je \$Info{pid},  na hostu \$Conf{ServerHost},
     verze \$Info{Version}, sputn \$serverStartTime.
<li> Vygenerovn stavu : \$now.
<li> Nahrn konfigurace : \$configLoadTime.
<li> PC bude pt ve front : \$nextWakeupTime.
<li> Dal informace:
    <ul>
        <li>\$numBgQueue nevyzench dost o zlohu z poslednho naplnovan probuzen,
        <li>\$numUserQueue nevyzench dost o zlohu od uivatel,
        <li>\$numCmdQueue pending command requests,
        \$poolInfo
        <li>Stav loit je \$Info{DUlastValue}%
            (\$DUlastTime), dnen maximum je \$Info{DUDailyMax}% (\$DUmaxTime)
                a verej maximum bylo \$Info{DUDailyMaxPrev}%.
        <li>Inode stav loit je \$Info{DUInodelastValue}%
            (\$DUlastTime), dnen maximum je \$Info{DUInodeDailyMax}% (\$DUInodemaxTime)
                a verej maximum bylo \$Info{DUInodeDailyMaxPrev}%.
    </ul>
</ul>
EOF

$Lang{BackupPC_Server_Status} = <<EOF;
\${h1(qq{$Lang{H_BackupPC_Server_Status}})}

<p>
\${h2("Probhajc lohy")}
<p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3">
<tr class="tableheader"><td> Host </td>
    <td> Typ </td>
    <td> Uivatel </td>
    <td> Sputno </td>
    <td> Pkaz </td>
    <td align="center"> PID </td>
    <td align="center"> Xfer PID </td>
    <td align="center"> Status </td>
    <td align="center"> Count </td>
    </tr>
\$jobStr
</table>

<p>
\$generalInfo

\${h2("Selhn, kter vyaduj pozornost")}
<p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3">
<tr class="tableheader"><td align="center"> Host </td>
    <td align="center"> Typ </td>
    <td align="center"> Uivatel </td>
    <td align="center"> Posledn pokus </td>
    <td align="center"> Detaily </td>
    <td align="center"> as chyby </td>
    <td> Posledn chyba (jin ne dn ping) </td></tr>
\$statusStr
</table>
EOF

# --------------------------------
$Lang{BackupPC__Server_Summary} = "BackupPC: Vpis Host";
$Lang{BackupPC__Archive} = "BackupPC: Archiv";
$Lang{BackupPC_Summary} = <<EOF;

\${h1(qq{$Lang{BackupPC__Server_Summary}})}
<p>
<ul>
<li>Tento stav byl vygenerovn v \$now.
<li>Stav loit je \$Info{DUlastValue}%
    (\$DUlastTime), dnen maximum je \$Info{DUDailyMax}% (\$DUmaxTime)
    a verej maximum bylo \$Info{DUDailyMaxPrev}%.
<li>Inode stav loit je \$Info{DUInodelastValue}%
    (\$DUlastTime), dnen maximum je \$Info{DUInodeDailyMax}% (\$DUInodemaxTime)
    a verej maximum bylo \$Info{DUInodeDailyMaxPrev}%.
</ul>
</p>

\${h2("Host s spn provedenmi zlohami")}
<p>
\$hostCntGood host bylo spn zlohovno, v celkov velikost:
<ul>
<li> \$fullTot plnch zloh v celkov velitosti \${fullSizeTot}GiB
     (ped kompres),
<li> \$incrTot inkementanch zloh v celkov velikosti \${incrSizeTot}GiB
     (ped kompres).
</ul>
</p>
<table class="sortable" id="host_summary_backups" border cellpadding="3" cellspacing="1">
<tr class="tableheader"><td> Host </td>
    <td align="center"> Uivatel </td>
    <td align="center"> Poznmka </td>
    <td align="center"> #Pln </td>
    <td align="center"> Pln as (dn) </td>
    <td align="center"> Pln Velikost (GiB) </td>
    <td align="center"> Rychlost (MB/s) </td>
    <td align="center"> #Inkr </td>
    <td align="center"> Inkr as (dn) </td>
    <td align="center"> Posledn Zloha (dn) </td>
    <td align="center"> Stav </td>
    <td align="center"> #Xfer chyb </td>
    <td align="center"> Posledn pokus </td></tr>
\$strGood
</table>
\${h2("Host s dnmi provedenmi zlohami")}
<p>
\$hostCntNone host s dnmi zlohani.
<p>
<table class="sortable" id="host_summary_nobackups" border cellpadding="3" cellspacing="1">
<tr class="tableheader"><td> Host </td>
    <td align="center"> Uivatel </td>
    <td align="center"> Poznmka </td>
    <td align="center"> #Pln </td>
    <td align="center"> Pln as (dn) </td>
    <td align="center"> Pln Velikost (GiB) </td>
    <td align="center"> Rychlost (MB/s) </td>
    <td align="center"> #Inkr </td>
    <td align="center"> Inkr as (dn) </td>
    <td align="center"> Posledn Zloha (dn) </td>
    <td align="center"> Stav </td>
    <td align="center"> #Xfer chyb </td>
    <td align="center"> Posledn pokus </td></tr>
\$strNone
</table>
EOF

$Lang{BackupPC_Archive} = <<EOF;
\${h1(qq{$Lang{BackupPC__Archive}})}
<script language="javascript" type="text/javascript">
<!--

    function checkAll(location)
    {
      for (var i=0;i<document.form1.elements.length;i++)
      {
        var e = document.form1.elements[i];
        if ((e.checked || !e.checked) && e.name != \'all\') {
            if (eval("document.form1."+location+".checked")) {
                e.checked = true;
            } else {
                e.checked = false;
            }
        }
      }
    }

    function toggleThis(checkbox)
    {
       var cb = eval("document.form1."+checkbox);
       cb.checked = !cb.checked;
    }

//-->
</script>

\$hostCntGood host, kte byli zlohovni v celkov velikosti \${fullSizeTot}GiB
<p>
<form name="form1" method="post" action="\$MyURL">
<input type="hidden" name="fcbMax" value="\$checkBoxCnt">
<input type="hidden" name="type" value="1">
<input type="hidden" name="host" value="\${EscHTML(\$archHost)}">
<input type="hidden" name="action" value="Archive">
<table class="tableStnd" border cellpadding="3" cellspacing="1">
<tr class="tableheader"><td align=center> Host</td>
    <td align="center"> Uivatel </td>
    <td align="center"> Velikost zlohy </td>
\$strGood
\$checkAllHosts
</table>
</form>
<p>

EOF

$Lang{BackupPC_Archive2} = <<EOF;
\${h1(qq{$Lang{BackupPC__Archive}})}
Nasledujc host se chystaj k archivaci
<ul>
\$HostListStr
</ul>
<form action="\$MyURL" method="post">
\$hiddenStr
<input type="hidden" name="action" value="Archive">
<input type="hidden" name="host" value="\${EscHTML(\$archHost)}">
<input type="hidden" name="type" value="2">
<input type="hidden" value="0" name="archive_type">
<table class="tableStnd" border cellspacing="1" cellpadding="3">
\$paramStr
<tr>
    <td colspan=2><input type="submit" value="Start the Archive" name="ignore"></td>
</tr>
</form>
</table>
EOF

$Lang{BackupPC_Archive2_location} = <<EOF;
<tr>
    <td>Umstn Archivu</td>
    <td><input type="text" value="\$ArchiveDest" name="archive_device"></td>
</tr>
EOF

$Lang{BackupPC_Archive2_compression} = <<EOF;
<tr>
    <td>Komprese</td>
    <td>
    <input type="radio" value="0" name="compression" \$ArchiveCompNone>None<br>
    <input type="radio" value="1" name="compression" \$ArchiveCompGzip>gzip<br>
    <input type="radio" value="2" name="compression" \$ArchiveCompBzip2>bzip2
    </td>
</tr>
EOF

$Lang{BackupPC_Archive2_parity} = <<EOF;
<tr>
    <td>Procent paritnch dat (0 = vypnut, 5 = typick)</td>
    <td><input type="numeric" value="\$ArchivePar" name="par"></td>
</tr>
EOF

$Lang{BackupPC_Archive2_split} = <<EOF;
<tr>
    <td>Rozdlit vstup na</td>
    <td><input type="numeric" value="\$ArchiveSplit" name="splitsize">Megabytes</td>
</tr>
EOF

# -----------------------------------
$Lang{Pool_Stat} = <<EOF;
        <li>V loiti je \${poolSize}GiB zahrnujc \$info->{"\${name}FileCnt"} soubor
            a \$info->{"\${name}DirCnt"} adres (od \$poolTime),
        <li>Hashovn loit dv \$info->{"\${name}FileCntRep"} opakujcch se
        soubor s nejdelm etzem \$info->{"\${name}FileRepMax"},
        <li>Non klid loit odstranil \$info->{"\${name}FileCntRm"} soubor
            velikosti \${poolRmSize}GiB (kolem \$poolTime),
EOF

# --------------------------------
$Lang{BackupPC__Backup_Requested_on__host} = "BackupPC:  Zloha vydna na \$host";
$Lang{BackupPC__Delete_Requested_for_a_backup_of__host} = "BackupPC: Delete Requested for a backup of \$host";
# --------------------------------
$Lang{REPLY_FROM_SERVER} = <<EOF;
\${h1(\$str)}
<p>
Odpov serveru na: \$reply
<p>
Vra se na <a href="\$MyURL?host=\$host">domovskou strnku \$host</a>.
EOF
# --------------------------------
$Lang{BackupPC__Start_Backup_Confirm_on__host} = "BackupPC: Zatek zlohy potvrzen na \$host";
# --------------------------------
$Lang{Are_you_sure_start} = <<EOF;
\${h1("Are you sure?")}
<p>
Chystte se spustit \$type zlohu na \$host.

<form name="Confirm" action="\$MyURL" method="get">
<input type="hidden" name="host" value="\$host">
<input type="hidden" name="hostIP" value="\$ipAddr">
<input type="hidden" name="doit" value="1">
<input type="hidden" name="action" value="">
Opravdu to chcete provst?
<input type="button" value="\$buttonText"
  onClick="document.Confirm.action.value='\$In{action}';
           document.Confirm.submit();">
<input type="submit" value="No" name="ignore">
</form>
EOF
# --------------------------------
$Lang{BackupPC__Stop_Backup_Confirm_on__host} = "BackupPC: Ukonit potvrzen kopie na \$host";
# --------------------------------
$Lang{Are_you_sure_stop} = <<EOF;

\${h1("Jste si jist?")}

<p>
Chystte se ukonit/vyadit z fronty zlohovn na \$host;

<form name="Confirm" action="\$MyURL" method="get">
<input type="hidden" name="host"   value="\$host">
<input type="hidden" name="doit"   value="1">
<input type="hidden" name="action" value="">
Prosm, nezanejte jin zlohovn
<input type="text" name="backoff" size="10" value="\$backoff"> hodin.
<p>
Opravdu to chcete provst?
<input type="button" value="\$buttonText"
  onClick="document.Confirm.action.value='\$In{action}';
           document.Confirm.submit();">
<input type="submit" value="No" name="ignore">
</form>

EOF
# --------------------------------
$Lang{Only_privileged_users_can_view_queues_} = "Pouze oprvnn uivatel maj pistup k frontm.";
# --------------------------------
$Lang{Only_privileged_users_can_archive} = "Pouze oprvnn uivatel mohou archivovat.";
# --------------------------------
$Lang{BackupPC__Queue_Summary} = "BackupPC: Pehled front";
# --------------------------------
$Lang{Backup_Queue_Summary} = <<EOF;
\${h1("Pehled fronty zlohovn")}
\${h2("Pehled fronty uivatel")}
<p>
Nsledujc uivatel jsou momentln ve front:
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td> Host </td>
    <td> Action </td>
    <td> as do </td>
    <td> Uivatel </td></tr>
\$strUser
</table>

\${h2("Souhrn fronty v pozad")}
<p>
Nsledujc dosti v pozad jsou momentln ve front:
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td> Host </td>
    <td> Action </td>
    <td> as do </td>
    <td> Uivatel </td></tr>
\$strBg
</table>
\${h2("Souhrn fronty pkaz")}
<p>
Nsledujc pkazy jsou momentln ve front:
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td> Host </td>
    <td> Action </td>
    <td> as do </td>
    <td> Uivatel </td>
    <td> Pkaz </td></tr>
\$strCmd
</table>
EOF

# --------------------------------
$Lang{Backup_PC__Log_File__file} = "BackupPC: Soubor \$file";
$Lang{Log_File__file__comment} = <<EOF;
\${h1("Soubor \$file \$comment")}
<p>
EOF
# --------------------------------
$Lang{Contents_of_log_file} = <<EOF;
Obsah souboru <tt>\$file</tt>, modifikovn \$mtimeStr \$comment
EOF

# --------------------------------
$Lang{skipped__skipped_lines} = "[ peskoeno \$skipped dk ]\n";
# --------------------------------
$Lang{_pre___Can_t_open_log_file__file} = "<pre>\nNen mon otevt log soubor \$file\n";

# --------------------------------
$Lang{BackupPC__Log_File_History} = "BackupPC: Historie Log Souboru";
$Lang{Log_File_History__hdr} = <<EOF;
\${h1("Historie Log Souboru \$hdr")}
<p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Soubor </td>
    <td align="center"> Velikost </td>
    <td align="center"> as modifikace </td></tr>
\$str
</table>
EOF

# -------------------------------
$Lang{Recent_Email_Summary} = <<EOF;
\${h1("Pehled nedvnch email (azeno zptn)")}
<p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Pjemce </td>
    <td align="center"> Odeslatel </td>
    <td align="center"> as </td>
    <td align="center"> Pedmt </td></tr>
\$str
</table>
EOF
 

# ------------------------------
$Lang{Browse_backup__num_for__host} = "BackupPC: Prohlet zlohu \$num pro \$host";

# ------------------------------
$Lang{Restore_Options_for__host} = "BackupPC: Obnovit nastaven pro \$host";
$Lang{Restore_Options_for__host2} = <<EOF;
\${h1("Obnovit nastaven pro \$host")}
<p>
Vybral jste nsledujc soubory/adrese z
sti \$share, zloha slo #\$num:
<ul>
\$fileListStr
</ul>
</p><p>
Pro obnoven tchto soubor/adres mte ti monosti.
Vyberte si, prosm, jednu z nsledujcch monost.
</p>
\${h2("Monost 1: Pm obnova")}
<p>
EOF

$Lang{Restore_Options_for__host_Option1} = <<EOF;
Mete spustit obnoven tchto soubor do
<b>\$directHost</b>.
</p><p>
<b>Varovn:</b> jakkoliv existujc soubor, kter odpovda tm,
kter mte vybrny bude smazn!
</p>
<form action="\$MyURL" method="post" name="direct">
<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="type" value="3">
\$hiddenStr
<input type="hidden" value="\$In{action}" name="action">
<table class="tableStnd" border="0">
<tr>
    <td>Obnovit souboru do hosta</td>
    <td><!--<input type="text" size="40" value="\${EscHTML(\$host)}"
	 name="hostDest">-->
	 <select name="hostDest" onChange="document.direct.shareDest.value=''">
	 \$hostDestSel
	 </select>
	 <script language="Javascript">
	 function myOpen(URL) {
		window.open(URL,'','width=500,height=400');
	 }
	 </script>
	 <!--<a href="javascript:myOpen('\$MyURL?action=findShares&host='+document.direct.hostDest.options.value)">Hledej dostupn sti (NEN IMPLEMENTOVNO)</a>--></td>
</tr><tr>
    <td>Obnoven soubor do sti</td>
    <td><input type="text" size="40" value="\${EscHTML(\$share)}"
	 name="shareDest"></td>
</tr><tr>
    <td>Obnovit soubory v adresi<br>(vztahujc se k sti)</td>
    <td valign="top"><input type="text" size="40" maxlength="256"
	value="\${EscHTML(\$pathHdr)}" name="pathHdr"></td>
</tr><tr>
    <td><input type="submit" value="Start Restore" name="ignore"></td>
</table>
</form>
EOF

$Lang{Restore_Options_for__host_Option1_disabled} = <<EOF;
Pm obnoven bylo zakzno pro hosta \${EscHTML(\$hostDest)}.
Vyberte si, prosm, jednu z monost obnovy.
EOF

# ------------------------------
$Lang{Option_2__Download_Zip_archive} = <<EOF;
<p>
\${h2("Monost 2: Sthnout Zip archiv")}
<p>
Mete sthnout Zip archiv obsahujc vechny soubory/adrese, kter
jste vybral.  Pot mete pout aplikaci, nap. WinZip, k zobrazen
nebp rozbalen nkterho z tchto soubor.
</p><p>
<b>Varovn:</b> v zvislosti na tom, kter soubory/adrese jste vybral,
tento archiv me bt velmi velk.  Vytvoen a penos archivu me trvat
minuty, a budete potebovat dostatek msta na loklnm disku.
</p>
<form action="\$MyURL" method="post">
<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="type" value="2">
\$hiddenStr
<input type="hidden" value="\$In{action}" name="action">
<input type="checkbox" value="1" name="relative" checked> Vytvoit archiv relativn
k \${EscHTML(\$pathHdr eq "" ? "/" : \$pathHdr)}
(jinak bude archiv obsahovat plnou cestu).
<br>
<table class="tableStnd" border="0">
<tr>
    <td>Komprese (0=off, 1=rychl,...,9=nejlep)</td>
    <td><input type="text" size="6" value="5" name="compressLevel"></td>
</tr><tr>
    <td>Code page (e.g. cp866)</td>
    <td><input type="text" size="6" value="utf8" name="codePage"></td>
</tr>
</table>
<br>
<input type="submit" value="Sthnout Zip soubor" name="ignore">
</form>
EOF

# ------------------------------

$Lang{Option_2__Download_Zip_archive2} = <<EOF;
<p>
\${h2("Monost 2: Stnout Zip archiv")}
<p>
Archive::Zip nen nainstalovn, ili nebude mon sthnout
zip archiv.
Podejte systmovho administrtora o instalaci Archive::Zip z
<a href="http://www.cpan.org">www.cpan.org</a>.
</p>
EOF


# ------------------------------
$Lang{Option_3__Download_Zip_archive} = <<EOF;
\${h2("Monost 3: Sthnout Tar archiv")}
<p>
Mete sthnout Tar archiv obsahujc vechny soubory/adrese, kter
jste vybral.  Pot mete pout aplikaci, nap. tar nebo WinZip, k zobrazen
nebp rozbalen nkterho z tchto soubor.
</p><p>
<b>Varovn:</b> v zvislosti na tom, kter soubory/adrese jste vybral,
tento archiv me bt velmi velk.  Vytvoen a penos archivu me trvat
minuty, a budete potebovat dostatek msta na loklnm disku.
</p>
<form action="\$MyURL" method="post">
<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="type" value="1">
\$hiddenStr
<input type="hidden" value="\$In{action}" name="action">
<input type="checkbox" value="1" name="relative" checked> Vytvo archiv relativn
k \${EscHTML(\$pathHdr eq "" ? "/" : \$pathHdr)}
(jinak bude archiv obsahovat plnou cestu).
<br>
<input type="submit" value="Stnout Tar soubor" name="ignore">
</form>
EOF


# ------------------------------
$Lang{Restore_Confirm_on__host} = "BackupPC: Potvrzen obnoven na \$host";

$Lang{Are_you_sure} = <<EOF;
\${h1("Jsi si jist?")}
<p>
Chystte se zahjit obnovu pmo do potae \$In{hostDest}.
Nsledujc soubory budou obnoveny do sti \$In{shareDest}, ze
zlohy slo \$num:
<p>
<table class="tableStnd" border>
<tr class="tableheader"><td>Originln soubor/adres</td><td>Bude obnoven do</td></tr>
\$fileListStr
</table>

<form name="RestoreForm" action="\$MyURL" method="post">
<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="hostDest" value="\${EscHTML(\$In{hostDest})}">
<input type="hidden" name="shareDest" value="\${EscHTML(\$In{shareDest})}">
<input type="hidden" name="pathHdr" value="\${EscHTML(\$In{pathHdr})}">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="type" value="4">
<input type="hidden" name="action" value="">
\$hiddenStr
Obravdu to chce provst?
<input type="button" value="\$Lang->{Restore}"
 onClick="document.RestoreForm.action.value='Restore';
          document.RestoreForm.submit();">
<input type="submit" value="No" name="ignore">
</form>
EOF


# --------------------------
$Lang{Restore_Requested_on__hostDest} = "BackupPC: Obnovit vydan na \$hostDest";
$Lang{Reply_from_server_was___reply} = <<EOF;
\${h1(\$str)}
<p>
Odpov od serveru: \$reply
<p>
Jt zpt na <a href="\$MyURL?host=\$hostDest">domovsk strnka \$hostDest</a>.
EOF

$Lang{BackupPC_Archive_Reply_from_server} = <<EOF;
\${h1(\$str)}
<p>
Odpov od serveru: \$reply
EOF


# --------------------------------
$Lang{BackupPC__Delete_Backup_Confirm__num_of__host} = "BackupPC: Delete Backup Confirm #\$num of \$host";
# --------------------------------
$Lang{A_filled} = "a filled";
$Lang{An_unfilled} = "an unfilled";
$Lang{Are_you_sure_delete} = <<EOF;
\${h1("Are you sure?")}
<p>
You are about to delete \$filled \$type backup #\$num of \$host.

<form name="Confirm" action="\$MyURL" method="get">

<input type="hidden" name="host" value="\${EscHTML(\$host)}">
<input type="hidden" name="num" value="\$num">

<input type="hidden" name="doit" value="1">
<input type="hidden" name="action" value="">

Do you really want to do this?

<input type="button" value="\${EscHTML(\$Lang->{CfgEdit_Button_Delete})}"
 onClick="document.Confirm.action.value='deleteBackup';
          document.Confirm.submit();">

<input type="submit" value="No" name="ignore">
</form>
EOF

# -------------------------
$Lang{Host__host_Backup_Summary} = "BackupPC: Pehled zloh hosta \$host";

$Lang{Host__host_Backup_Summary2} = <<EOF;
\${h1("Pehled zloh hosta \$host")}
<p>
\$warnStr
<ul>
\$statusStr
</ul>
</p>
\${h2("User Actions")}
<p>
<form name="StartStopForm" action="\$MyURL" method="get">
<input type="hidden" name="host"   value="\$host">
<input type="hidden" name="action" value="">
\$startIncrStr
<input type="button" value="\$Lang->{Start_Full_Backup}"
 onClick="document.StartStopForm.action.value='Start_Full_Backup';
          document.StartStopForm.submit();">
<input type="button" value="\$Lang->{Stop_Dequeue_Backup}"
 onClick="document.StartStopForm.action.value='Stop_Dequeue_Backup';
          document.StartStopForm.submit();">
</form>
</p>
\${h2("Pehled zloh")}
<p>
Kliknte na slo zlohy pro prohlen a obnoven zlohy.
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3">
<tr class="tableheader"><td align="center"> Backup# </td>
    <td align="center"> Typ </td>
    <td align="center"> Vyplnno </td>
    <td align="center"> rove </td>
    <td align="center"> Datum sputn </td>
    <td align="center"> Doba trvn/minuty </td>
    <td align="center"> Doba/dny </td>
    \$deleteHdrStr
    <td align="center"> Cesta serveru zlohy </td>
</tr>
\$str
</table>
<p>

\$restoreStr
</p>
\${h2("Pehled Xfer chyb")}
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Backup# </td>
    <td align="center"> Typ </td>
    <td align="center"> Pohled </td>
    <td align="center"> #Xfer chyby </td>
    <td align="center"> #patn soubory </td>
    <td align="center"> #patn sti </td>
    <td align="center"> #tar chyby </td>
</tr>
\$errStr
</table>

\${h2("File Size/Count Reuse Summary")}
<p>
Existujc soubory jsou ty, kter jsou ji v loiti; nov jsou pidan
do loit.
Przn soubory a SMB chyby nejsou potny.
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td colspan="2" bgcolor="#ffffff"></td>
    <td align="center" colspan="3"> Celkov </td>
    <td align="center" colspan="2"> Existujc soubory </td>
    <td align="center" colspan="2"> Nov soubory </td>
</tr>
<tr class="tableheader sortheader">
    <td align="center"> Zloha # </td>
    <td align="center"> Typ </td>
    <td align="center"> #Soubory </td>
    <td align="center"> Velikost/MB </td>
    <td align="center"> MB/sec </td>
    <td align="center"> #Soubory </td>
    <td align="center"> Velikost/MB </td>
    <td align="center"> #Soubory </td>
    <td align="center"> Velikost/MB </td>
</tr>
\$sizeStr
</table>

\${h2("Pehled kompres")}
<p>
Vkon komprese pro soubory, kter jsou ji v loiti a pro nov
zkomprimovan soubory.
</p>
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td colspan="3" bgcolor="#ffffff"></td>
    <td align="center" colspan="3"> Existujc soubory </td>
    <td align="center" colspan="3"> Nov soubory </td>
</tr>
<tr class="tableheader sortheader"><td align="center"> Zloha # </td>
    <td align="center"> Typ </td>
    <td align="center"> rove komprese </td>
    <td align="center"> Velikost/MB </td>
    <td align="center"> Komprese/MB </td>
    <td align="center"> Komprese </td>
    <td align="center"> Velikost/MB </td>
    <td align="center"> Komprese/MB </td>
    <td align="center"> Komprese </td>
</tr>
\$compStr
</table>
EOF

$Lang{Host__host_Archive_Summary} = "BackupPC: Pehled archiv hosta \$host ";
$Lang{Host__host_Archive_Summary2} = <<EOF;
\${h1("Pehled archiv hosta \$host")}
<p>
\$warnStr
<ul>
\$statusStr
</ul>

\${h2("Uivatelsk akce")}
<p>
<form name="StartStopForm" action="\$MyURL" method="get">
<input type="hidden" name="archivehost" value="\$host">
<input type="hidden" name="host" value="\$host">
<input type="hidden" name="action" value="">
<input type="button" value="\$Lang->{Start_Archive}"
 onClick="document.StartStopForm.action.value='Start_Archive';
          document.StartStopForm.submit();">
<input type="button" value="\$Lang->{Stop_Dequeue_Archive}"
 onClick="document.StartStopForm.action.value='Stop_Dequeue_Archive';
          document.StartStopForm.submit();">
</form>

\$ArchiveStr

EOF

# -------------------------
$Lang{Error} = "BackupPC: Chyba";
$Lang{Error____head} = <<EOF;
\${h1("Chyba: \$head")}
<p>\$mesg</p>
EOF

# -------------------------
$Lang{NavSectionTitle_} = "Server";

# -------------------------
$Lang{Backup_browse_for__host} = <<EOF;
\${h1("Prohlen zloh pro \$host")}

<script language="javascript" type="text/javascript">
<!--

    function checkAll(location)
    {
      for (var i=0;i<document.form1.elements.length;i++)
      {
        var e = document.form1.elements[i];
        if ((e.checked || !e.checked) && e.name != \'all\') {
            if (eval("document.form1."+location+".checked")) {
            	e.checked = true;
            } else {
            	e.checked = false;
            }
        }
      }
    }
    
    function toggleThis(checkbox)
    {
       var cb = eval("document.form1."+checkbox);
       cb.checked = !cb.checked;	
    }

//-->
</script>

<form name="form0" method="post" action="\$MyURL">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="host" value="\$host">
<input type="hidden" name="share" value="\${EscHTML(\$share)}">
<input type="hidden" name="action" value="browse">
<ul>
<li> Prohlte zlohu #\$num, kter byla sputna kolem \$backupTime
        (\$backupAge dn zpt),
\$filledBackup
<li> Zadej adres: <input type="text" name="dir" size="50" maxlength="4096" value="\${EscHTML(\$dir)}"> <input type="submit" value="\$Lang->{Go}" name="Submit">
<li> Klikni na adres ne a pokrauj do nj,
<li> Klikni na soubor ne a obnov ho,
<li> Me vidt zlohu <a href="\$MyURL?action=dirHistory&host=\${EscURI(\$host)}&share=\$shareURI&dir=\$pathURI">history</a> aktulnho adrese.
</ul>
</form>

\${h2("Obsah \$dirDisplay")}
<form name="form1" method="post" action="\$MyURL">
<input type="hidden" name="num" value="\$num">
<input type="hidden" name="host" value="\$host">
<input type="hidden" name="share" value="\${EscHTML(\$share)}">
<input type="hidden" name="fcbMax" value="\$checkBoxCnt">
<input type="hidden" name="action" value="Restore">
<br>
<table width="100%">
<tr><td valign="top" width="30%">
    <table align="left" border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
    \$dirStr
    </table>
</td><td width="3%">
</td><td valign="top">
    <br>
        <table border width="100%" align="left" cellpadding="3" cellspacing="1">
        \$fileHeader
        \$topCheckAll
        \$fileStr
        \$checkAll
        </table>
    </td></tr></table>
<br>
<!--
This is now in the checkAll row
<input type="submit" name="Submit" value="Restore selected files">
-->
</form>
EOF

# ------------------------------
$Lang{DirHistory_backup_for__host} = "BackupPC: Historie zloh adres pro \$host";

#
# These two strings are used to build the links for directories and
# file versions.  Files are appended with a version number.
#
$Lang{DirHistory_dirLink}  = "adres";
$Lang{DirHistory_fileLink} = "v";

$Lang{DirHistory_for__host} = <<EOF;
\${h1("Historie zloh adres pro \$host")}
<p>
Tato obrazovka zobrazuje kadou uniktn verzi souboru
ze vech zloh:
<ul>
<li> Klikni na slo zlohy k nvratu do prohlee zloh,
<li> Klikni na odkaz adrese (\$Lang->{DirHistory_dirLink}) k pechodu do
     nj,
<li> Klikni na odkaz verze souboru (\$Lang->{DirHistory_fileLink}0,
     \$Lang->{DirHistory_fileLink}1, ...) k jeho staen,
<li> Soubory se stejnm obsahem v rznch zlohch maj stejn
     slo verze (PleaseTranslateThis: except between v3 and v4 backups),
<li> Soubory nebo adrese, kter nejsou ve vybran zloze 
     nejsou oznaeny.
<li> Soubory zobrazen se stejnm slem verze mohou mt rozdln atributy.
     Vyber slo zlohy k zobrazen atribut souboru.
</ul>

\${h2("Historie \$dirDisplay")}

<br>
<table border cellspacing="2" cellpadding="3">
<tr class="fviewheader"><td>slo zlohy</td>\$backupNumStr</tr>
<tr class="fviewheader"><td>as zlohy</td>\$backupTimeStr</tr>
\$fileStr
</table>
EOF

# ------------------------------
$Lang{Restore___num_details_for__host} = "BackupPC: Obnovit #\$num detail pro \$host";

$Lang{Restore___num_details_for__host2} = <<EOF;
\${h1("Obnovit #\$num Detail pro \$host")}
<p>
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="90%">
<tr><td class="tableheader"> slo </td><td class="border"> \$Restores[\$i]{num} </td></tr>
<tr><td class="tableheader"> Vydal </td><td class="border"> \$RestoreReq{user} </td></tr>
<tr><td class="tableheader"> as vydn </td><td class="border"> \$reqTime </td></tr>
<tr><td class="tableheader"> Vsledek </td><td class="border"> \$Restores[\$i]{result} </td></tr>
<tr><td class="tableheader"> Chybov zprva </td><td class="border"> \$Restores[\$i]{errorMsg} </td></tr>
<tr><td class="tableheader"> Zdrojov host </td><td class="border"> \$RestoreReq{hostSrc} </td></tr>
<tr><td class="tableheader"> slo zdrojov zlohy </td><td class="border"> \$RestoreReq{num} </td></tr>
<tr><td class="tableheader"> Zdrojov st </td><td class="border"> \$RestoreReq{shareSrc} </td></tr>
<tr><td class="tableheader"> Clov host </td><td class="border"> \$RestoreReq{hostDest} </td></tr>
<tr><td class="tableheader"> Clov st </td><td class="border"> \$RestoreReq{shareDest} </td></tr>
<tr><td class="tableheader"> as sputn </td><td class="border"> \$startTime </td></tr>
<tr><td class="tableheader"> Doba trvn </td><td class="border"> \$duration min </td></tr>
<tr><td class="tableheader"> Poet soubor </td><td class="border"> \$Restores[\$i]{nFiles} </td></tr>
<tr><td class="tableheader"> Celkov velikost </td><td class="border"> \${MB} MB </td></tr>
<tr><td class="tableheader"> Penosov rychlost </td><td class="border"> \$MBperSec MB/sec </td></tr>
<tr><td class="tableheader"> TarCreate chyb </td><td class="border"> \$Restores[\$i]{tarCreateErrs} </td></tr>
<tr><td class="tableheader"> Xfer chyb </td><td class="border"> \$Restores[\$i]{xferErrs} </td></tr>
<tr><td class="tableheader"> Xfer log soubor </td><td class="border">
<a href="\$MyURL?action=view&type=RestoreLOG&num=\$Restores[\$i]{num}&host=\$host">View</a>,
<a href="\$MyURL?action=view&type=RestoreErr&num=\$Restores[\$i]{num}&host=\$host">Errors</a>
</tr></tr>
</table>
</p>
\${h1("Seznam soubor/adres")}
<p>
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="100%">
<tr class="tableheader"><td>Originln soubor/adres</td><td>Obnoven do</td></tr>
\$fileListStr
</table>
EOF

# ------------------------------
$Lang{Archive___num_details_for__host} = "BackupPC: Archivovat #\$num detail pro \$host";

$Lang{Archive___num_details_for__host2 } = <<EOF;
\${h1("Archivovat #\$num Detail pro \$host")}
<p>
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="80%">
<tr><td class="tableheader"> slo </td><td class="border"> \$Archives[\$i]{num} </td></tr>
<tr><td class="tableheader"> Vydal </td><td class="border"> \$ArchiveReq{user} </td></tr>
<tr><td class="tableheader"> as vydn </td><td class="border"> \$reqTime </td></tr>
<tr><td class="tableheader"> Odpovd </td><td class="border"> \$Archives[\$i]{result} </td></tr>
<tr><td class="tableheader"> Chybov zprva </td><td class="border"> \$Archives[\$i]{errorMsg} </td></tr>
<tr><td class="tableheader"> as spustn </td><td class="border"> \$startTime </td></tr>
<tr><td class="tableheader"> Dpba trvn </td><td class="border"> \$duration min </td></tr>
<tr><td class="tableheader"> Xfer log soubor </td><td class="border">
<a href="\$MyURL?action=view&type=ArchiveLOG&num=\$Archives[\$i]{num}&host=\$host">View</a>,
<a href="\$MyURL?action=view&type=ArchiveErr&num=\$Archives[\$i]{num}&host=\$host">Errors</a>
</tr></tr>
</table>
<p>
\${h1("Seznam host")}
<p>
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td>Host</td><td>slo kopie</td></tr>
\$HostListStr
</table>
EOF

# -----------------------------------
$Lang{Email_Summary} = "BackupPC: Souhrn email";

# -----------------------------------
#  !! ERROR messages !!
# -----------------------------------
$Lang{BackupPC__Lib__new_failed__check_apache_error_log} = "BackupPC::Lib->new failed: zkontroluj apache error_log\n";
$Lang{Wrong_user__my_userid_is___} =  
              "patn uivatel: moje userid je \$>, msto \$uid"
            . "(\$Conf{BackupPCUser})\n";
# $Lang{Only_privileged_users_can_view_PC_summaries} = "Pouze oprvnn uivatel jsou oprvnni prohlet souhrny PC.";
$Lang{Only_privileged_users_can_stop_or_start_backups} = 
                  "Pouze oprvnn uivatel mohou ukonit nebo spustit zlohovn na"
		. " \${EscHTML(\$host)}.";
$Lang{Invalid_number__num} = "patn slo \${EscHTML(\$In{num})}";
$Lang{Unable_to_open__file__configuration_problem} = "Nepodailo se otevt \$file: problm konfigurace?";
$Lang{Only_privileged_users_can_view_log_or_config_files} = "Pouze oprvnn uivatel maj pstup k log a konfiguranm souborm.";
$Lang{Only_privileged_users_can_view_log_files} = "Pouze oprvnn uivatel maj pstup k log souborm.";
$Lang{Only_privileged_users_can_view_email_summaries} = "Pouze oprvnn uivatel maj pstup k souhrnu email.";
$Lang{Only_privileged_users_can_browse_backup_files} = "Pouze oprvnn uivatel mohou prohlet soubory zloh"
                . " pro host \${EscHTML(\$In{host})}.";
$Lang{Only_privileged_users_can_delete_backups} = "Only privileged users can delete backups"
                . " of host \${EscHTML(\$host)}.";
$Lang{Empty_host_name} = "Przdn jmno hosta.";
$Lang{Directory___EscHTML} = "Adres \${EscHTML(\"\$TopDir/pc/\$host/\$num\")}"
		    . " je przdn";
$Lang{Can_t_browse_bad_directory_name2} = "Nen mon prohlet - patn nzev adrese"
	            . " \${EscHTML(\$relDir)}";
$Lang{Only_privileged_users_can_restore_backup_files} = "Pouze oprvnn uivatel mohou obnovovat soubory zlohy"
                . " pro hosta \${EscHTML(\$In{host})}.";
$Lang{Bad_host_name} = "patn jmno hosta \${EscHTML(\$host)}";
$Lang{You_haven_t_selected_any_files__please_go_Back_to} = "Nevybral jste dn soubor; prosm jdte Zpt k"
                . " vbru soubor.";
$Lang{You_haven_t_selected_any_hosts} = "Nevybral jste dnho hosta; prosm jdte Zpt k"
                . " vbru host.";
$Lang{Nice_try__but_you_can_t_put} = "Nelze umstit \'..\' do nzvu souboru";
$Lang{Host__doesn_t_exist} = "Host \${EscHTML(\$In{hostDest})} neexistuje";
$Lang{You_don_t_have_permission_to_restore_onto_host} = "Nemte oprvnn k obnov na"
		    . " \${EscHTML(\$In{hostDest})}";
$Lang{Can_t_open_create__openPath} = "Nelze otevt nebo vytvoit "
		. "\${EscHTML(\"\$openPath\")}";
$Lang{Only_privileged_users_can_restore_backup_files2} = "Pouze oprvnn uivatel mohou obnovovat soubory zlohy"
                . " pro hosta \${EscHTML(\$host)}.";
$Lang{Empty_host_name} = "Przdn jmno hosta";
$Lang{Unknown_host_or_user} = "Neznm host nebo uivatel \${EscHTML(\$host)}";
$Lang{Only_privileged_users_can_view_information_about} = "Pouze oprvnn uivatel maj pstup k informacm o"
                . " hostu \${EscHTML(\$host)}." ;
$Lang{Only_privileged_users_can_view_archive_information} = "Pouze oprvnn uivatel maj pstup k informacm o archivaci.";
$Lang{Only_privileged_users_can_view_restore_information} = "Pouze oprvnn uivatel maj pstup k informacm o obnov.";
$Lang{Restore_number__num_for_host__does_not_exist} = "slo obnoven \$num pro hosta \${EscHTML(\$host)}"
	        . " neexsituje.";
$Lang{Archive_number__num_for_host__does_not_exist} = "slo archivu \$num pro hosta \${EscHTML(\$host)}"
                . " neexsituje.";
$Lang{Can_t_find_IP_address_for} = "Nelze nalzt IP adresu pro \${EscHTML(\$host)}";
$Lang{host_is_a_DHCP_host} = <<EOF;
\$host je DHCP host, and nen znma jeho IP adresa.  Zkontrolovno
netbios jmno \$ENV{REMOTE_ADDR}\$tryIP, a zjitno, e zazen 
nen \$host.
<p>
Dokud nebude vidt \$host na vybran DHCP adrese, mete pouze
spustit dost z pmo klientskho zazen.
EOF

# ------------------------------------
# !! Server Mesg !!
# ------------------------------------

$Lang{Backup_requested_on_DHCP__host} = "Zloha vydna z DHCP \$host (\$In{hostIP}) uivatelem"
		                      . " \$User z \$ENV{REMOTE_ADDR}";
$Lang{Backup_requested_on__host_by__User} = "Zloha vydna z \$host uivatelem \$User";
$Lang{Backup_stopped_dequeued_on__host_by__User} = "Zloha ukonena/vyazena z fronty z \$host uivatelem \$User";
$Lang{Restore_requested_to_host__hostDest__backup___num} = "Obnova vydna na hosta \$hostDest, obnova #\$num,"
	     . " uivatelem \$User z \$ENV{REMOTE_ADDR}";
$Lang{Delete_requested_for_backup_of__host_by__User} = "Delete requested for backup #\$num of \$host"
             . " by \$User from \$ENV{REMOTE_ADDR}";
$Lang{Archive_requested} = "Archivace vydna uivatelem \$User z \$ENV{REMOTE_ADDR}";

# -------------------------------------------------
# ------- Stuff that was forgotten ----------------
# -------------------------------------------------

$Lang{Status} = "Stav";
$Lang{PC_Summary} = "Souhrn host";
$Lang{LOG_file} = "LOG soubor";
$Lang{LOG_files} = "LOG soubory";
$Lang{Old_LOGs} = "Star LOGy";
$Lang{Email_summary} = "Souhrn email";
$Lang{Config_file} = "Konfiguran soubor";
# $Lang{Hosts_file} = "Hosts soubor";
$Lang{Current_queues} = "Aktuln fronty";
$Lang{Documentation} = "Dokumentace";

#$Lang{Host_or_User_name} = "<small>Jmno uivatele nebo hosta:</small>";
$Lang{Go} = "Jdi";
$Lang{Hosts} = "Hosts";
$Lang{Select_a_host} = "Vyber hosta...";

$Lang{There_have_been_no_archives} = "<h2> Nebyli dn archivy </h2>\n";
$Lang{This_PC_has_never_been_backed_up} = "<h2> Toto PC nebylo nikdy zlohovno!! </h2>\n";
$Lang{This_PC_is_used_by} = "<li>Toto PC je pouvno uivatelem \${UserLink(\$user)}";

$Lang{Extracting_only_Errors} = "(Rozbalovn chyb)";
$Lang{XferLOG} = "XferLOG";
$Lang{Errors}  = "Chyby";

# ------------
$Lang{Last_email_sent_to__was_at___subject} = <<EOF;
<li>Posledn email odesln uivately \${UserLink(\$user)} byl v \$mailTime, pedmt "\$subj".
EOF
# ------------
$Lang{The_command_cmd_is_currently_running_for_started} = <<EOF;
<li>Pkaz \$cmd je aktuln vykonvn pro \$host, sputn v \$startTime.
EOF

# -----------
$Lang{Host_host_is_queued_on_the_background_queue_will_be_backed_up_soon} = <<EOF;
<li>Host \$host ek ve front na pozad (bude brzy zlohovn).
EOF

# ----------
$Lang{Host_host_is_queued_on_the_user_queue__will_be_backed_up_soon} = <<EOF;
<li>Host \$host ek ve front uivatel (bude brzy zlohovn).
EOF

# ---------
$Lang{A_command_for_host_is_on_the_command_queue_will_run_soon} = <<EOF;
<li>Pkaz pro \$host ek ve front pkaz (bude brzy sputn).
EOF

# --------
$Lang{Last_status_is_state_StatusHost_state_reason_as_of_startTime} = <<EOF;
<li>Posledn stav \"\$Lang->{\$StatusHost{state}}\"\$reason v ase \$startTime.
EOF

# --------
$Lang{Last_error_is____EscHTML_StatusHost_error} = <<EOF;
<li>Posledn chyba je \"\${EscHTML(\$StatusHost{error})}\".
EOF

# ------
$Lang{Pings_to_host_have_failed_StatusHost_deadCnt__consecutive_times} = <<EOF;
<li>Pingy na \$host selhaly \$StatusHost{deadCnt} za sebou.
EOF

# -----
$Lang{Prior_to_that__pings} = "Pedchoz pingy";

# -----
$Lang{priorStr_to_host_have_succeeded_StatusHostaliveCnt_consecutive_times} = <<EOF;
<li>\$priorStr na \$host byli spn \$StatusHost{aliveCnt}
         za sebou.
EOF

$Lang{Because__host_has_been_on_the_network_at_least__Conf_BlackoutGoodCnt_consecutive_times___} = <<EOF;
<li>Protoe \$host byl na sti alespo \$Conf{BlackoutGoodCnt}
za sebou, nebude zlohovn z \$blackoutStr.
EOF

$Lang{__time0_to__time1_on__days} = "\$t0 to \$t1 on \$days";

$Lang{Backups_are_deferred_for_hours_hours_change_this_number} = <<EOF;
<li>Zlohy byli odloeny na \$hours hodin
(<a href=\"\$MyURL?action=Stop_Dequeue_Backup&host=\$host\">zmn toto slo</a>).
EOF

$Lang{tryIP} = " a \$StatusHost{dhcpHostIP}";

# $Lang{Host_Inhost} = "Host \$In{host}";

$Lang{checkAll} = <<EOF;
<tr><td class="fviewborder">
<input type="checkbox" name="allFiles" onClick="return checkAll('allFiles');">&nbsp;Select all
</td><td colspan="5" align="center" class="fviewborder">
<input type="submit" name="Submit" value="Restore selected files">
</td></tr>
EOF

$Lang{checkAllHosts} = <<EOF;
<tr><td class="fviewborder">
<input type="checkbox" name="allFiles" onClick="return checkAll('allFiles');">&nbsp;Select all
</td><td colspan="2" align="center" class="fviewborder">
<input type="submit" name="Submit" value="Archive selected hosts">
</td></tr>
EOF

$Lang{fileHeader} = <<EOF;
    <tr class="fviewheader"><td align=center> Jmno</td>
       <td align="center"> Typ</td>
       <td align="center"> Md</td>
       <td align="center"> #</td>
       <td align="center"> Velikost</td>
       <td align="center"> Datum zmny</td>
    </tr>
EOF

$Lang{Home} = "Doma";
$Lang{Browse} = "Prohlen zloh";
$Lang{Last_bad_XferLOG} = "Posledn patn XferLOG";
$Lang{Last_bad_XferLOG_errors_only} = "Posledn patn XferLOG (chyb&nbsp;pouze)";

$Lang{This_display_is_merged_with_backup} = <<EOF;
<li> Toto zobrazen je sloueno se zlohou #\$numF.
EOF

$Lang{Visit_this_directory_in_backup} = <<EOF;
<li> Vyberte zlohu, kterou si pejete zobrazit: <select onChange="window.location=this.value">\$otherDirs </select>
EOF

$Lang{Restore_Summary} = <<EOF;
\${h2("Obnovit souhrn")}
<p>
Klikni na obnoven pro vce detail.
<table class="tableStnd sortable" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Obnoven # </td>
    <td align="center"> Vsledek </td>
    <td align="right"> Datum sputen</td>
    <td align="right"> Doba trvn/minuty</td>
    <td align="right"> #soubor </td>
    <td align="right"> MB </td>
    <td align="right"> #tar chyb </td>
    <td align="right"> #xferErrs </td>
</tr>
\$restoreStr
</table>
<p>
EOF

$Lang{Archive_Summary} = <<EOF;
\${h2("Souhrn archiv")}
<p>
Klikni na slo archivu pro vce detail.
<table class="tableStnd" border cellspacing="1" cellpadding="3" width="80%">
<tr class="tableheader"><td align="center"> Archiv# </td>
    <td align="center"> Vsledek </td>
    <td align="right"> Datum sputen</td>
    <td align="right"> Doba trvn/minuty</td>
</tr>
\$ArchiveStr
</table>
<p>
EOF

$Lang{BackupPC__Documentation} = "BackupPC: Documentace";

$Lang{No} = "ne";
$Lang{Yes} = "ano";

$Lang{The_directory_is_empty} = <<EOF;
<tr><td bgcolor="#ffffff">Adres \$dirDisplay je przdn
</td></tr>
EOF

#$Lang{on} = "zapnout";
$Lang{off} = "vypnout";

$Lang{backupType_full}    = "pln";
$Lang{backupType_incr}    = "inkr";
$Lang{backupType_active}  = "active";
$Lang{backupType_partial} = "sten";

$Lang{failed} = "nespn";
$Lang{success} = "spn";
$Lang{and} = "a";

# ------
# Hosts states and reasons
$Lang{Status_idle} = "neinn";
$Lang{Status_backup_starting} = "zloha se spout";
$Lang{Status_backup_in_progress} = "zloha probh";
$Lang{Status_restore_starting} = "obnoven se spout";
$Lang{Status_restore_in_progress} = "obnoven probh";
$Lang{Status_admin_pending} = "link ek";
$Lang{Status_admin_running} = "link b";

$Lang{Reason_backup_done}    = "hotovo";
$Lang{Reason_restore_done}   = "obnoven dokoneno";
$Lang{Reason_archive_done}   = "archivace dokonena";
$Lang{Reason_nothing_to_do}  = "neinn";
$Lang{Reason_backup_failed}  = "zlohovn selhalo";
$Lang{Reason_restore_failed} = "obnoven selhalo";
$Lang{Reason_archive_failed} = "archivace selhala";
$Lang{Reason_no_ping}        = "dn ping";
$Lang{Reason_backup_canceled_by_user}  = "zlohovn zrueno uivatelem";
$Lang{Reason_restore_canceled_by_user} = "obnoven zrueno uivatelem";
$Lang{Reason_archive_canceled_by_user} = "archivace zruena uivatelem";
$Lang{Disabled_OnlyManualBackups}  = "automatick zlohovn zakzno";  
$Lang{Disabled_AllBackupsDisabled} = "zakzno";                  


# ---------
# Email messages

# No backup ever
$Lang{EMailNoBackupEverSubj} = "BackupPC: adn zlohy hosta \$host se nezdaili";
$Lang{EMailNoBackupEverMesg} = <<'EOF';
To: $user$domain
cc:
Pedmt: $subj
$headers
Dear $userName,

Vae PC ($host) nebylo nikdy spn zlohovno nam
zlohovacm softwarem.  Zlohovn PC by mlo bt sputno 
automaticky, kdy je Vae PC pipojeno do st. Mel by jste
kontaktovat Vai podporu pokud:

  - Vae PC bylo pravideln pipojovno do st, zejm
    je njak probm v nastaven nebo konfiguraci, kter zabrauje
    zlohovn.

  - Nechcete Vae PC zlohovat a chcete pestat dostvat tyto zprvy.

Ujistte se, e je Vae PC pipojeno do st, a budete pt v kanceli.

S pozdravem,
BackupPC Genie
https://backuppc.github.io/backuppc
EOF

# No recent backup
$Lang{EMailNoBackupRecentSubj} = "BackupPC: dn nov zlohy pro \$host";
$Lang{EMailNoBackupRecentMesg} = <<'EOF';
To: $user$domain
cc:
Pedmt: $subj
$headers
Drah $userName,

Vae PC ($host) nebylo spn zlohovno ji $days dn.
Vae PC bylo korektn zlohovno $numBackups krt od $firstTime 
do dne ped $days dny.  Zlohovn PC by se mlo spustit automaticky,
kdy je Vae PC pipojeno do st.

Pokud bylo Vae PC pipojeno do st vce ne nkolik hodin v prbhu
poslednch $days dn, ml by jste kontaktovat Vai podporu k zjitn,
pro zlohovn nefunguje.

Pokud jste mimo kancel, nemete udlat nic jinho ne zkoprovat kritick
soubory na jin media. Ml by jste mt na pamti, e vechny soubory vytvoen
nebo zmnn v poslednch $days dnech (i s vemi novmi emaily a plohami) 
nebudou moci bti obnoveny, pokud se disk ve Vaem potai pokod.

S pozdravem,
BackupPC Genie
https://backuppc.github.io/backuppc
EOF

# Old Outlook files
$Lang{EMailOutlookBackupSubj} = "BackupPC: Soubory programu Outlook na \$host je nutn zlohovat";
$Lang{EMailOutlookBackupMesg} = <<'EOF';
To: $user$domain
cc:
Pedmt: $subj
$headers
Drah $userName,

Soubory programu Outlook na Vaem PC maj $howLong.
Tyto soubory obsahuj vechny Vae emaily, plohy, kontakty a informace v           
kalendi.  Vae PC bylo naposled korektn zlohovno $numBackups krt od
$firstTime do $lastTime. Nicmn Outlook zamkne vechny svoje soubory kdy
je sputn a znemouje jejich zlohovn.

Doporuujeme Vm zlohovat soubory Outlooku, kdy jste pipojen do st tak,
e ukonte program Outlook a vechny ostatn aplikace a ve vaem prohlei
otevete tuto adresu:

    $CgiURL?host=$host               

Vyberte "Spustit inkrementan zlohovn" dvakrt ke sputen novho 
zlohovn. Mete vybrat "Nvrat na $host page" a pot stiknout "obnovit"
ke zjitn stavu zlohovn. Dokonen me trvat nkolik minut.

S pozdravem,
BackupPC Genie
https://backuppc.github.io/backuppc
EOF

$Lang{howLong_not_been_backed_up} = "nebylo zlohovno spn";
$Lang{howLong_not_been_backed_up_for_days_days} = "nebylo zlohovno \$days dn";

#######################################################################
# RSS strings
#######################################################################
$Lang{RSS_Doc_Title}       = "BackupPC Server";
$Lang{RSS_Doc_Description} = "RSS kanl BackupPC";
$Lang{RSS_Host_Summary}    = <<EOF;
Poet plnch: \$fullCnt;
as plnch/dn: \$fullAge;
Celkov velikost/GiB: \$fullSize;
Rychlost MB/sec: \$fullRate;
Poet inkr: \$incrCnt;
as inkr/Dn: \$incrAge;
Stav: \$host_state;
Zakzno: \$host_disabled;
Posledn pokus: \$host_last_attempt;
EOF

#######################################################################
# Configuration editor strings
#######################################################################

$Lang{Only_privileged_users_can_edit_config_files} = "Pouze oprvnn uivatel mohou editovat konfikuraci.";
$Lang{CfgEdit_Edit_Config} = "Editovat konfiguraci";
$Lang{CfgEdit_Edit_Hosts}  = "Editovat Hosty";

$Lang{CfgEdit_Title_Server} = "Server";
$Lang{CfgEdit_Title_General_Parameters} = "Hlavn parametry";
$Lang{CfgEdit_Title_Wakeup_Schedule} = "Pln probuzen";
$Lang{CfgEdit_Title_Concurrent_Jobs} = "Rovnocenn lohy";
$Lang{CfgEdit_Title_Pool_Filesystem_Limits} = "Limity loit";
$Lang{CfgEdit_Title_Other_Parameters} = "Ostatn paramtery";
$Lang{CfgEdit_Title_Remote_Apache_Settings} = "Vzdlen nastaven Apache";
$Lang{CfgEdit_Title_Program_Paths} = "Cesty programu";
$Lang{CfgEdit_Title_Install_Paths} = "Instalan cesty";
$Lang{CfgEdit_Title_Email} = "Email";
$Lang{CfgEdit_Title_Email_settings} = "Nastaven emailu";
$Lang{CfgEdit_Title_Email_User_Messages} = "Nastaven emailu uivatelm";
$Lang{CfgEdit_Title_CGI} = "CGI";
$Lang{CfgEdit_Title_Admin_Privileges} = "Administran prva";
$Lang{CfgEdit_Title_Page_Rendering} = "Renderovn strnky";
$Lang{CfgEdit_Title_Paths} = "Cesty";
$Lang{CfgEdit_Title_User_URLs} = "Uivatelsk URL";
$Lang{CfgEdit_Title_User_Config_Editing} = "Editace konfigurace uivatel";
$Lang{CfgEdit_Title_Xfer} = "Xfer";
$Lang{CfgEdit_Title_Xfer_Settings} = "Nastaven Xfer";
$Lang{CfgEdit_Title_Ftp_Settings} = "Nastaven FTP";
$Lang{CfgEdit_Title_Smb_Settings} = "Nastaven Smb";
$Lang{CfgEdit_Title_Tar_Settings} = "Nastaven Tar";
$Lang{CfgEdit_Title_Rsync_Settings} = "Nastaven Rsync";
$Lang{CfgEdit_Title_Rsyncd_Settings} = "Nastaven Rsyncd";
$Lang{CfgEdit_Title_Archive_Settings} = "Nastaven Archivace";
$Lang{CfgEdit_Title_Include_Exclude} = "Zahrnout/Vylouit";
$Lang{CfgEdit_Title_Smb_Paths_Commands} = "Smb Cesty/Pkazy";
$Lang{CfgEdit_Title_Tar_Paths_Commands} = "Tar Cesty/Pkazy";
$Lang{CfgEdit_Title_Rsync_Paths_Commands_Args} = "Rsync  Cesty/Pkazy/Argumenty";
$Lang{CfgEdit_Title_Rsyncd_Port_Args} = "Rsyncd Port/Argumenty";
$Lang{CfgEdit_Title_Archive_Paths_Commands} = "Archivace Cesty/Pkazy";
$Lang{CfgEdit_Title_Schedule} = "Pln";
$Lang{CfgEdit_Title_Full_Backups} = "Pln zlohy";
$Lang{CfgEdit_Title_Incremental_Backups} = "Inkrementan zlohy";
$Lang{CfgEdit_Title_Blackouts} = "Peten";
$Lang{CfgEdit_Title_Other} = "Ostatn";
$Lang{CfgEdit_Title_Backup_Settings} = "Nastaven zlohovn";
$Lang{CfgEdit_Title_Client_Lookup} = "Vyhledvn klientp";
$Lang{CfgEdit_Title_User_Commands} = "Uivatelsk pkazy";
$Lang{CfgEdit_Title_Hosts} = "Hosti";

$Lang{CfgEdit_Hosts_Comment} = <<EOF;
K pidn novho hosta, vyberte Pidat a zadejte jmno. Pro
konfiguraci hosta z jinho hosta, zadejte jmno hosta jako
NEWHOST=COPYHOST. To pepe existujc konfiguraci pro NEWHOST.  
Tento postup mete pout i pto existujcho hosta.
Hosta smaete stisknutm tlatka delete. Pidn, smazn a koprovn
konfigurace nanabude platnosti dokud nedojde k stisknut tlatka Uloit 
dn ze zloh smazanch host nebude odstranna, tedy pokud omylem
so if you accidently delete a host, simply re-add it.  To completely
smaete hostovy zlohy, muste run smazat soubory v \$topDir/pc/HOST
EOF

$Lang{CfgEdit_Header_Main} = <<EOF;
\${h1("Hlavn editor konfigurace")}
EOF

$Lang{CfgEdit_Header_Host} = <<EOF;
\${h1("Editor konfigurace hosta \$host")}
<p>
Poznmka: oznate Pepsat, pokud chcete modifikovat hodnotu
specifickou pro tohoto hosta.
<p>
EOF

$Lang{CfgEdit_Button_Save}     = "Uloit";
$Lang{CfgEdit_Button_Insert}   = "Vloit";
$Lang{CfgEdit_Button_Delete}   = "Smazat";
$Lang{CfgEdit_Button_Add}      = "Pidat";
$Lang{CfgEdit_Button_Override} = "Pepsat";
$Lang{CfgEdit_Button_New_Key}  = "Nov kl";
$Lang{CfgEdit_Button_New_Share} = "New ShareName or '*'";

$Lang{CfgEdit_Error_No_Save}
            = "Chyba: Neuloeno z dvody chyb";
$Lang{CfgEdit_Error__must_be_an_integer}
            = "Chyba: \$var mus bt cel slo";
$Lang{CfgEdit_Error__must_be_real_valued_number}
            = "Chyba: \$var mus bt reln slo";
$Lang{CfgEdit_Error__entry__must_be_an_integer}
            = "Chyba: vstup \$var \$k mus bt cel slo";
$Lang{CfgEdit_Error__entry__must_be_real_valued_number}
            = "Chyba: vstup \$var \$k mus bt reln slo";
$Lang{CfgEdit_Error__must_be_executable_program}
            = "Chyba: \$var mus bt sprvn cesta";
$Lang{CfgEdit_Error__must_be_valid_option}
            = "Chyba: \$var mus bt sprvn monost";
$Lang{CfgEdit_Error_Copy_host_does_not_exist}
            = "Kopie hosta \$copyHost neexistuje; vytvm nov nzev hosta \$fullHost. Smate tohota hosta, pokud to nen to, co jste chtl.";

$Lang{CfgEdit_Log_Copy_host_config}
            = "\$User zkoproval konfiguraci z hosta \$fromHost do \$host\n";
$Lang{CfgEdit_Log_Delete_param}
            = "\$User smazal \$p z \$conf\n";
$Lang{CfgEdit_Log_Add_param_value}
            = "\$User pidal \$p do \$conf, nastavil na \$value\n";
$Lang{CfgEdit_Log_Change_param_value}
            = "\$User zmnil \$p v \$conf do \$valueNew z \$valueOld\n";
$Lang{CfgEdit_Log_Host_Delete}
            = "\$User smazal hosta \$host\n";
$Lang{CfgEdit_Log_Host_Change}
            = "\$User host \$host zmnil \$key z \$valueOld na \$valueNew\n";
$Lang{CfgEdit_Log_Host_Add}
            = "\$User pidal host \$host: \$value\n";
  
#end of lang_cz.pm
