/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.FileTreeDataViews;
import com.swoval.files.LinkOption;
import com.swoval.files.NioWrappers;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.functional.Either;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

final class Entries {
    static final int DIRECTORY = 1;
    static final int FILE = 2;
    static final int LINK = 4;
    static final int UNKNOWN = 8;
    static final int NONEXISTENT = 16;

    private Entries() {
    }

    static <T> FileTreeDataViews.Entry<T> get(TypedPath typedPath, FileTreeDataViews.Converter<T> converter, TypedPath typedPath2) {
        try {
            return new ValidEntry<T>(typedPath, converter.apply(typedPath2));
        }
        catch (IOException iOException) {
            return new InvalidEntry(typedPath, iOException);
        }
    }

    static <T> FileTreeDataViews.Entry<T> setExists(FileTreeDataViews.Entry<T> entry, boolean bl) {
        TypedPath typedPath = entry.getTypedPath();
        int n = (bl ? 0 : 16) | (typedPath.isFile() ? 2 : 0) | (typedPath.isDirectory() ? 1 : 0) | (typedPath.isSymbolicLink() ? 4 : 0);
        TypedPath typedPath2 = TypedPaths.get(typedPath.getPath(), n);
        if (entry.getValue().isLeft()) {
            return new InvalidEntry(typedPath2, Either.leftProjection(entry.getValue()).getValue());
        }
        return new ValidEntry<T>(typedPath2, entry.getValue().get());
    }

    static <T> FileTreeDataViews.Entry<T> resolve(Path path, FileTreeDataViews.Entry<T> entry) {
        Either<IOException, T> either = entry.getValue();
        int n = Entries.getKind(entry);
        TypedPath typedPath = TypedPaths.get(path.resolve(entry.getTypedPath().getPath()), n);
        return either.isRight() ? new ValidEntry<T>(typedPath, either.get()) : new InvalidEntry(typedPath, Either.leftProjection(either).getValue());
    }

    private static int getKindFromAttrs(Path path, BasicFileAttributes basicFileAttributes) {
        return basicFileAttributes.isSymbolicLink() ? 4 | (Files.isDirectory(path, new java.nio.file.LinkOption[0]) ? 1 : 2) : (basicFileAttributes.isDirectory() ? 1 : 2);
    }

    static int getKind(Path path) throws IOException {
        BasicFileAttributes basicFileAttributes = NioWrappers.readAttributes(path, LinkOption.NOFOLLOW_LINKS);
        return Entries.getKindFromAttrs(path, basicFileAttributes);
    }

    private static int getKind(FileTreeDataViews.Entry<?> entry) {
        TypedPath typedPath = entry.getTypedPath();
        return (typedPath.isSymbolicLink() ? 4 : 0) | (typedPath.isDirectory() ? 1 : 0) | (typedPath.isFile() ? 2 : 0);
    }

    private static class InvalidEntry<T>
    extends EntryImpl<T> {
        private final IOException exception;

        InvalidEntry(TypedPath typedPath, IOException iOException) {
            super(typedPath);
            this.exception = iOException;
        }

        @Override
        public Either<IOException, T> getValue() {
            return Either.left(this.exception);
        }

        public String toString() {
            return "InvalidEntry(" + this.getTypedPath().getPath() + ", " + this.exception + ")";
        }
    }

    private static final class ValidEntry<T>
    extends EntryImpl<T> {
        private final T value;

        @Override
        public Either<IOException, T> getValue() {
            return Either.right(this.value);
        }

        ValidEntry(TypedPath typedPath, T t) {
            super(typedPath);
            this.value = t;
        }

        public String toString() {
            return "ValidEntry(" + this.getTypedPath().getPath() + ", " + this.value + ")";
        }
    }

    private static abstract class EntryImpl<T>
    implements FileTreeDataViews.Entry<T> {
        private final TypedPath typedPath;

        EntryImpl(TypedPath typedPath) {
            this.typedPath = typedPath;
        }

        public int hashCode() {
            int n = ((Object)Either.getOrElse(this.getValue(), 0)).hashCode();
            return this.typedPath.hashCode() ^ n;
        }

        public boolean equals(Object object) {
            return object instanceof FileTreeDataViews.Entry && ((FileTreeDataViews.Entry)object).getTypedPath().getPath().equals(this.getTypedPath().getPath()) && this.getValue().equals(((FileTreeDataViews.Entry)object).getValue());
        }

        @Override
        public int compareTo(FileTreeDataViews.Entry<T> entry) {
            return this.getTypedPath().getPath().compareTo(entry.getTypedPath().getPath());
        }

        @Override
        public TypedPath getTypedPath() {
            return this.typedPath;
        }
    }
}

