﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace IoT
{
namespace Model
{

  /**
   * <p>An object that specifies the authorization service for a
   * domain.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/iot-2015-05-28/AuthorizerConfig">AWS
   * API Reference</a></p>
   */
  class AWS_IOT_API AuthorizerConfig
  {
  public:
    AuthorizerConfig();
    AuthorizerConfig(Aws::Utils::Json::JsonView jsonValue);
    AuthorizerConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The name of the authorization service for a domain configuration.</p>
     */
    inline const Aws::String& GetDefaultAuthorizerName() const{ return m_defaultAuthorizerName; }

    /**
     * <p>The name of the authorization service for a domain configuration.</p>
     */
    inline bool DefaultAuthorizerNameHasBeenSet() const { return m_defaultAuthorizerNameHasBeenSet; }

    /**
     * <p>The name of the authorization service for a domain configuration.</p>
     */
    inline void SetDefaultAuthorizerName(const Aws::String& value) { m_defaultAuthorizerNameHasBeenSet = true; m_defaultAuthorizerName = value; }

    /**
     * <p>The name of the authorization service for a domain configuration.</p>
     */
    inline void SetDefaultAuthorizerName(Aws::String&& value) { m_defaultAuthorizerNameHasBeenSet = true; m_defaultAuthorizerName = std::move(value); }

    /**
     * <p>The name of the authorization service for a domain configuration.</p>
     */
    inline void SetDefaultAuthorizerName(const char* value) { m_defaultAuthorizerNameHasBeenSet = true; m_defaultAuthorizerName.assign(value); }

    /**
     * <p>The name of the authorization service for a domain configuration.</p>
     */
    inline AuthorizerConfig& WithDefaultAuthorizerName(const Aws::String& value) { SetDefaultAuthorizerName(value); return *this;}

    /**
     * <p>The name of the authorization service for a domain configuration.</p>
     */
    inline AuthorizerConfig& WithDefaultAuthorizerName(Aws::String&& value) { SetDefaultAuthorizerName(std::move(value)); return *this;}

    /**
     * <p>The name of the authorization service for a domain configuration.</p>
     */
    inline AuthorizerConfig& WithDefaultAuthorizerName(const char* value) { SetDefaultAuthorizerName(value); return *this;}


    /**
     * <p>A Boolean that specifies whether the domain configuration's authorization
     * service can be overridden.</p>
     */
    inline bool GetAllowAuthorizerOverride() const{ return m_allowAuthorizerOverride; }

    /**
     * <p>A Boolean that specifies whether the domain configuration's authorization
     * service can be overridden.</p>
     */
    inline bool AllowAuthorizerOverrideHasBeenSet() const { return m_allowAuthorizerOverrideHasBeenSet; }

    /**
     * <p>A Boolean that specifies whether the domain configuration's authorization
     * service can be overridden.</p>
     */
    inline void SetAllowAuthorizerOverride(bool value) { m_allowAuthorizerOverrideHasBeenSet = true; m_allowAuthorizerOverride = value; }

    /**
     * <p>A Boolean that specifies whether the domain configuration's authorization
     * service can be overridden.</p>
     */
    inline AuthorizerConfig& WithAllowAuthorizerOverride(bool value) { SetAllowAuthorizerOverride(value); return *this;}

  private:

    Aws::String m_defaultAuthorizerName;
    bool m_defaultAuthorizerNameHasBeenSet;

    bool m_allowAuthorizerOverride;
    bool m_allowAuthorizerOverrideHasBeenSet;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
