﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/lakeformation/LakeFormation_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace LakeFormation
{
namespace Model
{

  /**
   * <p>A wildcard object, consisting of an optional list of excluded column names or
   * indexes.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ColumnWildcard">AWS
   * API Reference</a></p>
   */
  class AWS_LAKEFORMATION_API ColumnWildcard
  {
  public:
    ColumnWildcard();
    ColumnWildcard(Aws::Utils::Json::JsonView jsonValue);
    ColumnWildcard& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline const Aws::Vector<Aws::String>& GetExcludedColumnNames() const{ return m_excludedColumnNames; }

    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline bool ExcludedColumnNamesHasBeenSet() const { return m_excludedColumnNamesHasBeenSet; }

    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline void SetExcludedColumnNames(const Aws::Vector<Aws::String>& value) { m_excludedColumnNamesHasBeenSet = true; m_excludedColumnNames = value; }

    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline void SetExcludedColumnNames(Aws::Vector<Aws::String>&& value) { m_excludedColumnNamesHasBeenSet = true; m_excludedColumnNames = std::move(value); }

    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline ColumnWildcard& WithExcludedColumnNames(const Aws::Vector<Aws::String>& value) { SetExcludedColumnNames(value); return *this;}

    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline ColumnWildcard& WithExcludedColumnNames(Aws::Vector<Aws::String>&& value) { SetExcludedColumnNames(std::move(value)); return *this;}

    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline ColumnWildcard& AddExcludedColumnNames(const Aws::String& value) { m_excludedColumnNamesHasBeenSet = true; m_excludedColumnNames.push_back(value); return *this; }

    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline ColumnWildcard& AddExcludedColumnNames(Aws::String&& value) { m_excludedColumnNamesHasBeenSet = true; m_excludedColumnNames.push_back(std::move(value)); return *this; }

    /**
     * <p>Excludes column names. Any column with this name will be excluded.</p>
     */
    inline ColumnWildcard& AddExcludedColumnNames(const char* value) { m_excludedColumnNamesHasBeenSet = true; m_excludedColumnNames.push_back(value); return *this; }

  private:

    Aws::Vector<Aws::String> m_excludedColumnNames;
    bool m_excludedColumnNamesHasBeenSet;
  };

} // namespace Model
} // namespace LakeFormation
} // namespace Aws
