﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/LoadBalancerMetricName.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lightsail/model/MetricDatapoint.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Lightsail
{
namespace Model
{
  class AWS_LIGHTSAIL_API GetLoadBalancerMetricDataResult
  {
  public:
    GetLoadBalancerMetricDataResult();
    GetLoadBalancerMetricDataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    GetLoadBalancerMetricDataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The metric about which you are receiving information. Valid values are listed
     * below, along with the most useful <code>statistics</code> to include in your
     * request.</p> <ul> <li> <p> <b> <code>ClientTLSNegotiationErrorCount</code> </b>
     * - The number of TLS connections initiated by the client that did not establish a
     * session with the load balancer. Possible causes include a mismatch of ciphers or
     * protocols.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>HealthyHostCount</code> </b> -
     * The number of target instances that are considered healthy.</p> <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>,
     * <code>Minimum</code>, and <code>Maximum</code>.</p> </li> <li> <p> <b>
     * <code>UnhealthyHostCount</code> </b> - The number of target instances that are
     * considered unhealthy.</p> <p> <code>Statistics</code>: The most useful statistic
     * are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP
     * 4XX client error codes that originate from the load balancer. Client errors are
     * generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response
     * codes generated by the target instances.</p> <p> <code>Statistics</code>: The
     * most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP
     * 5XX server error codes that originate from the load balancer. This count does
     * not include any response codes generated by the target instances.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and
     * <code>Average</code> all return <code>1</code>.</p> </li> <li> <p> <b>
     * <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response
     * codes generated by the target instances. This does not include any response
     * codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most
     * useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer. </p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in
     * seconds, after the request leaves the load balancer until a response from the
     * target instance is received.</p> <p> <code>Statistics</code>: The most useful
     * statistic is <code>Average</code>.</p> </li> <li> <p> <b>
     * <code>RejectedConnectionCount</code> </b> - The number of connections that were
     * rejected because the load balancer had reached its maximum number of
     * connections.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>RequestCount</code> </b> - The
     * number of requests processed over IPv4. This count includes only the requests
     * with a response generated by a target instance of the load balancer.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>.</p> </li> </ul>
     */
    inline const LoadBalancerMetricName& GetMetricName() const{ return m_metricName; }

    /**
     * <p>The metric about which you are receiving information. Valid values are listed
     * below, along with the most useful <code>statistics</code> to include in your
     * request.</p> <ul> <li> <p> <b> <code>ClientTLSNegotiationErrorCount</code> </b>
     * - The number of TLS connections initiated by the client that did not establish a
     * session with the load balancer. Possible causes include a mismatch of ciphers or
     * protocols.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>HealthyHostCount</code> </b> -
     * The number of target instances that are considered healthy.</p> <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>,
     * <code>Minimum</code>, and <code>Maximum</code>.</p> </li> <li> <p> <b>
     * <code>UnhealthyHostCount</code> </b> - The number of target instances that are
     * considered unhealthy.</p> <p> <code>Statistics</code>: The most useful statistic
     * are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP
     * 4XX client error codes that originate from the load balancer. Client errors are
     * generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response
     * codes generated by the target instances.</p> <p> <code>Statistics</code>: The
     * most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP
     * 5XX server error codes that originate from the load balancer. This count does
     * not include any response codes generated by the target instances.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and
     * <code>Average</code> all return <code>1</code>.</p> </li> <li> <p> <b>
     * <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response
     * codes generated by the target instances. This does not include any response
     * codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most
     * useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer. </p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in
     * seconds, after the request leaves the load balancer until a response from the
     * target instance is received.</p> <p> <code>Statistics</code>: The most useful
     * statistic is <code>Average</code>.</p> </li> <li> <p> <b>
     * <code>RejectedConnectionCount</code> </b> - The number of connections that were
     * rejected because the load balancer had reached its maximum number of
     * connections.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>RequestCount</code> </b> - The
     * number of requests processed over IPv4. This count includes only the requests
     * with a response generated by a target instance of the load balancer.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>.</p> </li> </ul>
     */
    inline void SetMetricName(const LoadBalancerMetricName& value) { m_metricName = value; }

    /**
     * <p>The metric about which you are receiving information. Valid values are listed
     * below, along with the most useful <code>statistics</code> to include in your
     * request.</p> <ul> <li> <p> <b> <code>ClientTLSNegotiationErrorCount</code> </b>
     * - The number of TLS connections initiated by the client that did not establish a
     * session with the load balancer. Possible causes include a mismatch of ciphers or
     * protocols.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>HealthyHostCount</code> </b> -
     * The number of target instances that are considered healthy.</p> <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>,
     * <code>Minimum</code>, and <code>Maximum</code>.</p> </li> <li> <p> <b>
     * <code>UnhealthyHostCount</code> </b> - The number of target instances that are
     * considered unhealthy.</p> <p> <code>Statistics</code>: The most useful statistic
     * are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP
     * 4XX client error codes that originate from the load balancer. Client errors are
     * generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response
     * codes generated by the target instances.</p> <p> <code>Statistics</code>: The
     * most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP
     * 5XX server error codes that originate from the load balancer. This count does
     * not include any response codes generated by the target instances.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and
     * <code>Average</code> all return <code>1</code>.</p> </li> <li> <p> <b>
     * <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response
     * codes generated by the target instances. This does not include any response
     * codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most
     * useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer. </p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in
     * seconds, after the request leaves the load balancer until a response from the
     * target instance is received.</p> <p> <code>Statistics</code>: The most useful
     * statistic is <code>Average</code>.</p> </li> <li> <p> <b>
     * <code>RejectedConnectionCount</code> </b> - The number of connections that were
     * rejected because the load balancer had reached its maximum number of
     * connections.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>RequestCount</code> </b> - The
     * number of requests processed over IPv4. This count includes only the requests
     * with a response generated by a target instance of the load balancer.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>.</p> </li> </ul>
     */
    inline void SetMetricName(LoadBalancerMetricName&& value) { m_metricName = std::move(value); }

    /**
     * <p>The metric about which you are receiving information. Valid values are listed
     * below, along with the most useful <code>statistics</code> to include in your
     * request.</p> <ul> <li> <p> <b> <code>ClientTLSNegotiationErrorCount</code> </b>
     * - The number of TLS connections initiated by the client that did not establish a
     * session with the load balancer. Possible causes include a mismatch of ciphers or
     * protocols.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>HealthyHostCount</code> </b> -
     * The number of target instances that are considered healthy.</p> <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>,
     * <code>Minimum</code>, and <code>Maximum</code>.</p> </li> <li> <p> <b>
     * <code>UnhealthyHostCount</code> </b> - The number of target instances that are
     * considered unhealthy.</p> <p> <code>Statistics</code>: The most useful statistic
     * are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP
     * 4XX client error codes that originate from the load balancer. Client errors are
     * generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response
     * codes generated by the target instances.</p> <p> <code>Statistics</code>: The
     * most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP
     * 5XX server error codes that originate from the load balancer. This count does
     * not include any response codes generated by the target instances.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and
     * <code>Average</code> all return <code>1</code>.</p> </li> <li> <p> <b>
     * <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response
     * codes generated by the target instances. This does not include any response
     * codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most
     * useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer. </p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in
     * seconds, after the request leaves the load balancer until a response from the
     * target instance is received.</p> <p> <code>Statistics</code>: The most useful
     * statistic is <code>Average</code>.</p> </li> <li> <p> <b>
     * <code>RejectedConnectionCount</code> </b> - The number of connections that were
     * rejected because the load balancer had reached its maximum number of
     * connections.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>RequestCount</code> </b> - The
     * number of requests processed over IPv4. This count includes only the requests
     * with a response generated by a target instance of the load balancer.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>.</p> </li> </ul>
     */
    inline GetLoadBalancerMetricDataResult& WithMetricName(const LoadBalancerMetricName& value) { SetMetricName(value); return *this;}

    /**
     * <p>The metric about which you are receiving information. Valid values are listed
     * below, along with the most useful <code>statistics</code> to include in your
     * request.</p> <ul> <li> <p> <b> <code>ClientTLSNegotiationErrorCount</code> </b>
     * - The number of TLS connections initiated by the client that did not establish a
     * session with the load balancer. Possible causes include a mismatch of ciphers or
     * protocols.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>HealthyHostCount</code> </b> -
     * The number of target instances that are considered healthy.</p> <p>
     * <code>Statistics</code>: The most useful statistic are <code>Average</code>,
     * <code>Minimum</code>, and <code>Maximum</code>.</p> </li> <li> <p> <b>
     * <code>UnhealthyHostCount</code> </b> - The number of target instances that are
     * considered unhealthy.</p> <p> <code>Statistics</code>: The most useful statistic
     * are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP
     * 4XX client error codes that originate from the load balancer. Client errors are
     * generated when requests are malformed or incomplete. These requests have not
     * been received by the target instance. This count does not include any response
     * codes generated by the target instances.</p> <p> <code>Statistics</code>: The
     * most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP
     * 5XX server error codes that originate from the load balancer. This count does
     * not include any response codes generated by the target instances.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and
     * <code>Average</code> all return <code>1</code>.</p> </li> <li> <p> <b>
     * <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP response
     * codes generated by the target instances. This does not include any response
     * codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most
     * useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer. </p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of
     * HTTP response codes generated by the target instances. This does not include any
     * response codes generated by the load balancer.</p> <p> <code>Statistics</code>:
     * The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>,
     * <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p>
     * </li> <li> <p> <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in
     * seconds, after the request leaves the load balancer until a response from the
     * target instance is received.</p> <p> <code>Statistics</code>: The most useful
     * statistic is <code>Average</code>.</p> </li> <li> <p> <b>
     * <code>RejectedConnectionCount</code> </b> - The number of connections that were
     * rejected because the load balancer had reached its maximum number of
     * connections.</p> <p> <code>Statistics</code>: The most useful statistic is
     * <code>Sum</code>.</p> </li> <li> <p> <b> <code>RequestCount</code> </b> - The
     * number of requests processed over IPv4. This count includes only the requests
     * with a response generated by a target instance of the load balancer.</p> <p>
     * <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note
     * that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all
     * return <code>1</code>.</p> </li> </ul>
     */
    inline GetLoadBalancerMetricDataResult& WithMetricName(LoadBalancerMetricName&& value) { SetMetricName(std::move(value)); return *this;}


    /**
     * <p>An array of metric datapoint objects.</p>
     */
    inline const Aws::Vector<MetricDatapoint>& GetMetricData() const{ return m_metricData; }

    /**
     * <p>An array of metric datapoint objects.</p>
     */
    inline void SetMetricData(const Aws::Vector<MetricDatapoint>& value) { m_metricData = value; }

    /**
     * <p>An array of metric datapoint objects.</p>
     */
    inline void SetMetricData(Aws::Vector<MetricDatapoint>&& value) { m_metricData = std::move(value); }

    /**
     * <p>An array of metric datapoint objects.</p>
     */
    inline GetLoadBalancerMetricDataResult& WithMetricData(const Aws::Vector<MetricDatapoint>& value) { SetMetricData(value); return *this;}

    /**
     * <p>An array of metric datapoint objects.</p>
     */
    inline GetLoadBalancerMetricDataResult& WithMetricData(Aws::Vector<MetricDatapoint>&& value) { SetMetricData(std::move(value)); return *this;}

    /**
     * <p>An array of metric datapoint objects.</p>
     */
    inline GetLoadBalancerMetricDataResult& AddMetricData(const MetricDatapoint& value) { m_metricData.push_back(value); return *this; }

    /**
     * <p>An array of metric datapoint objects.</p>
     */
    inline GetLoadBalancerMetricDataResult& AddMetricData(MetricDatapoint&& value) { m_metricData.push_back(std::move(value)); return *this; }

  private:

    LoadBalancerMetricName m_metricName;

    Aws::Vector<MetricDatapoint> m_metricData;
  };

} // namespace Model
} // namespace Lightsail
} // namespace Aws
