﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/robomaker/RoboMaker_EXPORTS.h>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace RoboMaker
{
namespace Model
{

  /**
   * <p>An object representing a port mapping.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/PortMapping">AWS
   * API Reference</a></p>
   */
  class AWS_ROBOMAKER_API PortMapping
  {
  public:
    PortMapping();
    PortMapping(Aws::Utils::Json::JsonView jsonValue);
    PortMapping& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The port number on the simulation job instance to use as a remote connection
     * point. </p>
     */
    inline int GetJobPort() const{ return m_jobPort; }

    /**
     * <p>The port number on the simulation job instance to use as a remote connection
     * point. </p>
     */
    inline bool JobPortHasBeenSet() const { return m_jobPortHasBeenSet; }

    /**
     * <p>The port number on the simulation job instance to use as a remote connection
     * point. </p>
     */
    inline void SetJobPort(int value) { m_jobPortHasBeenSet = true; m_jobPort = value; }

    /**
     * <p>The port number on the simulation job instance to use as a remote connection
     * point. </p>
     */
    inline PortMapping& WithJobPort(int value) { SetJobPort(value); return *this;}


    /**
     * <p>The port number on the application.</p>
     */
    inline int GetApplicationPort() const{ return m_applicationPort; }

    /**
     * <p>The port number on the application.</p>
     */
    inline bool ApplicationPortHasBeenSet() const { return m_applicationPortHasBeenSet; }

    /**
     * <p>The port number on the application.</p>
     */
    inline void SetApplicationPort(int value) { m_applicationPortHasBeenSet = true; m_applicationPort = value; }

    /**
     * <p>The port number on the application.</p>
     */
    inline PortMapping& WithApplicationPort(int value) { SetApplicationPort(value); return *this;}


    /**
     * <p>A Boolean indicating whether to enable this port mapping on public IP.</p>
     */
    inline bool GetEnableOnPublicIp() const{ return m_enableOnPublicIp; }

    /**
     * <p>A Boolean indicating whether to enable this port mapping on public IP.</p>
     */
    inline bool EnableOnPublicIpHasBeenSet() const { return m_enableOnPublicIpHasBeenSet; }

    /**
     * <p>A Boolean indicating whether to enable this port mapping on public IP.</p>
     */
    inline void SetEnableOnPublicIp(bool value) { m_enableOnPublicIpHasBeenSet = true; m_enableOnPublicIp = value; }

    /**
     * <p>A Boolean indicating whether to enable this port mapping on public IP.</p>
     */
    inline PortMapping& WithEnableOnPublicIp(bool value) { SetEnableOnPublicIp(value); return *this;}

  private:

    int m_jobPort;
    bool m_jobPortHasBeenSet;

    int m_applicationPort;
    bool m_applicationPortHasBeenSet;

    bool m_enableOnPublicIp;
    bool m_enableOnPublicIpHasBeenSet;
  };

} // namespace Model
} // namespace RoboMaker
} // namespace Aws
