/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ILambda;
import org.objectweb.asm.Type;

public final class ECapturingFunctionRef
extends AExpression
implements ILambda {
    private final String variable;
    private final String call;
    private FunctionRef ref;
    private Locals.Variable captured;
    private String defPointer;

    public ECapturingFunctionRef(Location location, String variable, String call) {
        super(location);
        this.variable = Objects.requireNonNull(variable);
        this.call = Objects.requireNonNull(call);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.captured = locals.getVariable(this.location, this.variable);
        if (this.expected == null) {
            this.defPointer = this.captured.clazz == def.class ? "D" + this.variable + "." + this.call + ",1" : "S" + PainlessLookupUtility.typeToCanonicalTypeName(this.captured.clazz) + "." + this.call + ",1";
            this.actual = String.class;
        } else {
            this.defPointer = null;
            if (this.captured.clazz != def.class) {
                this.ref = FunctionRef.create(scriptRoot.getPainlessLookup(), scriptRoot.getFunctionTable(), this.location, this.expected, PainlessLookupUtility.typeToCanonicalTypeName(this.captured.clazz), this.call, 1);
            }
            this.actual = this.expected;
        }
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (this.defPointer != null) {
            methodWriter.push(null);
            methodWriter.visitVarInsn(MethodWriter.getType(this.captured.clazz).getOpcode(21), this.captured.getSlot());
        } else if (this.ref == null) {
            methodWriter.visitVarInsn(MethodWriter.getType(this.captured.clazz).getOpcode(21), this.captured.getSlot());
            Type methodType = Type.getMethodType((Type)MethodWriter.getType(this.expected), (Type[])new Type[]{MethodWriter.getType(this.captured.clazz)});
            methodWriter.invokeDefCall(this.call, methodType, 6, PainlessLookupUtility.typeToCanonicalTypeName(this.expected));
        } else {
            methodWriter.visitVarInsn(MethodWriter.getType(this.captured.clazz).getOpcode(21), this.captured.getSlot());
            methodWriter.invokeLambdaCall(this.ref);
        }
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        return new Type[]{MethodWriter.getType(this.captured.clazz)};
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.variable, this.call);
    }
}

