/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;

public final class ENewArray
extends AExpression {
    private final String type;
    private final List<AExpression> arguments;
    private final boolean initialize;

    public ENewArray(Location location, String type, List<AExpression> arguments, boolean initialize) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.arguments = Objects.requireNonNull(arguments);
        this.initialize = initialize;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        for (AExpression argument : this.arguments) {
            argument.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("A newly created array must be read from."));
        }
        Class<?> clazz = scriptRoot.getPainlessLookup().canonicalTypeNameToType(this.type);
        if (clazz == null) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.expected = this.initialize ? clazz.getComponentType() : Integer.TYPE;
            expression.internal = true;
            expression.analyze(scriptRoot, locals);
            this.arguments.set(argument, expression.cast(scriptRoot, locals));
        }
        this.actual = clazz;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (this.initialize) {
            methodWriter.push(this.arguments.size());
            methodWriter.newArray(MethodWriter.getType(this.actual.getComponentType()));
            for (int index = 0; index < this.arguments.size(); ++index) {
                AExpression argument = this.arguments.get(index);
                methodWriter.dup();
                methodWriter.push(index);
                argument.write(classWriter, methodWriter, globals);
                methodWriter.arrayStore(MethodWriter.getType(this.actual.getComponentType()));
            }
        } else {
            for (AExpression argument : this.arguments) {
                argument.write(classWriter, methodWriter, globals);
            }
            if (this.arguments.size() > 1) {
                methodWriter.visitMultiANewArrayInsn(MethodWriter.getType(this.actual).getDescriptor(), this.arguments.size());
            } else {
                methodWriter.newArray(MethodWriter.getType(this.actual.getComponentType()));
            }
        }
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.type, this.initialize ? "init" : "dims");
    }
}

