/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoCutAndMove
implements UndoOperation {
    private int _startIndex;
    private int _endIndex;
    private int _moveToIndex;
    private DataPoint _firstTrackPoint = null;
    private DataPoint _followingTrackPoint = null;
    private DataPoint _moveTrackPoint = null;
    private boolean _firstSegmentFlag;
    private boolean _followingSegmentFlag;
    private boolean _moveToSegmentFlag;

    public UndoCutAndMove(Track track, int n, int n2, int n3) {
        this._startIndex = n;
        this._endIndex = n2;
        this._moveToIndex = n3;
        this._firstTrackPoint = track.getNextTrackPoint(n);
        if (this._firstTrackPoint != null) {
            this._firstSegmentFlag = this._firstTrackPoint.getSegmentStart();
        }
        this._followingTrackPoint = track.getNextTrackPoint(n2 + 1);
        if (this._followingTrackPoint != null) {
            this._followingSegmentFlag = this._followingTrackPoint.getSegmentStart();
        }
        this._moveTrackPoint = track.getNextTrackPoint(n3);
        if (this._moveTrackPoint != null) {
            this._moveToSegmentFlag = this._moveTrackPoint.getSegmentStart();
        }
    }

    public String getDescription() {
        return String.valueOf(I18nManager.getText("undo.cutandmove")) + " (" + (this._endIndex - this._startIndex + 1) + ")";
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        int n = this._endIndex - this._startIndex + 1;
        if (this._startIndex > this._moveToIndex) {
            trackInfo.getTrack().cutAndMoveSection(this._moveToIndex, this._moveToIndex + n - 1, this._startIndex + n);
        } else {
            trackInfo.getTrack().cutAndMoveSection(this._moveToIndex - n, this._moveToIndex - 1, this._startIndex);
        }
        if (this._firstTrackPoint != null) {
            this._firstTrackPoint.setSegmentStart(this._firstSegmentFlag);
        }
        if (this._followingTrackPoint != null) {
            this._followingTrackPoint.setSegmentStart(this._followingSegmentFlag);
        }
        if (this._moveTrackPoint != null) {
            this._moveTrackPoint.setSegmentStart(this._moveToSegmentFlag);
        }
        trackInfo.getSelection().clearAll();
        UpdateMessageBroker.informSubscribers();
    }
}

