/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.RegisterChanged;
import org.gjt.sp.util.GenericGUIUtilities;

public class RegisterViewer
extends JPanel
implements DockableWindow,
DefaultFocusComponent {
    private JList<String> registerList;
    private JTextArea contentTextArea;
    private DocumentHandler documentHandler;
    private View view;
    private boolean editing;
    private JSplitPane splitPane;
    private JPopupMenu popup;

    public RegisterViewer(View view, String string) {
        super(new BorderLayout());
        this.view = view;
        Box box = new Box(0);
        JLabel jLabel = new JLabel(jEdit.getProperty("view-registers.title"));
        jLabel.setBorder(new EmptyBorder(0, 0, 3, 0));
        box.add(jLabel);
        box.add(Box.createGlue());
        RolloverButton rolloverButton = new RolloverButton(GUIUtilities.loadIcon("Paste.png"));
        rolloverButton.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("paste-string-register.label")));
        rolloverButton.addActionListener(new InsertHandler());
        rolloverButton.setActionCommand("paste-string-register");
        box.add(rolloverButton);
        RolloverButton rolloverButton2 = new RolloverButton(GUIUtilities.loadIcon("Clear.png"));
        rolloverButton2.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("clear-string-register.label")));
        rolloverButton2.addActionListener(new ClearHandler());
        rolloverButton2.setActionCommand("clear-string-register");
        box.add(rolloverButton2);
        this.add("North", box);
        DefaultListModel defaultListModel = new DefaultListModel();
        this.registerList = new JList(defaultListModel);
        this.registerList.setSelectionMode(0);
        this.registerList.setCellRenderer(new Renderer());
        this.registerList.addListSelectionListener(new ListHandler());
        this.registerList.addMouseListener(new MouseHandler());
        this.contentTextArea = new JTextArea(10, 20);
        this.contentTextArea.setEditable(true);
        this.documentHandler = new DocumentHandler();
        this.contentTextArea.addFocusListener(new FocusHandler());
        this.registerKeyboardAction(new EscapeHandler(), KeyStroke.getKeyStroke(27, 0), 1);
        this.registerList.registerKeyboardAction(new InsertHandler(), KeyStroke.getKeyStroke(10, 0), 0);
        this.registerList.registerKeyboardAction(new InsertHandler(), KeyStroke.getKeyStroke(155, 0), 0);
        this.registerList.registerKeyboardAction(new ClearHandler(), KeyStroke.getKeyStroke(127, 0), 0);
        this.contentTextArea.registerKeyboardAction(new TabHandler(), KeyStroke.getKeyStroke(9, 1), 0);
        int n = 1;
        if (string.equals("left") || string.equals("right")) {
            n = 0;
        }
        this.splitPane = new JSplitPane(n, new JScrollPane(this.registerList), new JScrollPane(this.contentTextArea));
        this.add("Center", this.splitPane);
        this.refreshList();
    }

    @Override
    public void focusOnDefaultComponent() {
        this.registerList.requestFocusInWindow();
    }

    @EditBus.EBHandler
    public void handleRegisterChanged(RegisterChanged registerChanged) {
        if (registerChanged.getRegisterName() != '%') {
            this.refreshList();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
    }

    @Override
    public void move(String string) {
        int n = 1;
        if (string.equals("left") || string.equals("right")) {
            n = 0;
        }
        this.splitPane.setOrientation(n);
        this.revalidate();
    }

    private void refreshList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.registerList.getModel();
        String string = this.registerList.getSelectedValue();
        int n = -1;
        if (string != null && string.length() == 1) {
            n = string.charAt(0);
        }
        defaultListModel.removeAllElements();
        Registers.Register[] registerArray = Registers.getRegisters();
        int n2 = 0;
        for (int i = 0; i < registerArray.length; ++i) {
            String string2;
            Registers.Register register = registerArray[i];
            if (register == null || i == 37 || (string2 = register.toString()) == null) continue;
            if (i == n) {
                n2 = defaultListModel.size();
            }
            defaultListModel.addElement(String.valueOf((char)i));
        }
        if (defaultListModel.getSize() == 0) {
            defaultListModel.addElement(jEdit.getProperty("view-registers.none"));
            this.registerList.setEnabled(false);
        } else {
            this.registerList.setEnabled(true);
        }
        this.registerList.setSelectedIndex(n2);
    }

    private void insertRegister() {
        String string = this.registerList.getSelectedValue();
        if (string == null || string.length() > 1) {
            return;
        }
        Registers.Register register = Registers.getRegister(string.charAt(0));
        this.view.getTextArea().setSelectedText(register.toString());
        this.view.getTextArea().requestFocus();
        DockableWindowManager dockableWindowManager = this.view.getDockableWindowManager();
        if (!dockableWindowManager.isDockableWindowDocked("view-registers")) {
            dockableWindowManager.hideDockableWindow("view-registers");
        }
    }

    private void clearSelectedIndex() {
        String string = this.registerList.getSelectedValue();
        if (string != null && string.length() == 1) {
            Registers.clearRegister(string.charAt(0));
            this.refreshList();
        }
    }

    class ClearHandler
    implements ActionListener {
        ClearHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RegisterViewer.this.clearSelectedIndex();
        }
    }

    class InsertHandler
    implements ActionListener {
        InsertHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RegisterViewer.this.insertRegister();
        }
    }

    class TabHandler
    implements ActionListener {
        TabHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RegisterViewer.this.registerList.requestFocusInWindow();
        }
    }

    class EscapeHandler
    implements ActionListener {
        EscapeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RegisterViewer.this.view.getTextArea().requestFocus();
            RegisterViewer.this.view.toFront();
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            RegisterViewer.this.contentTextArea.getDocument().addDocumentListener(RegisterViewer.this.documentHandler);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            RegisterViewer.this.contentTextArea.getDocument().removeDocumentListener(RegisterViewer.this.documentHandler);
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateRegisterSafely();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateRegisterSafely();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateRegisterSafely();
        }

        private void updateRegisterSafely() {
            try {
                RegisterViewer.this.editing = true;
                this.updateRegister();
            }
            finally {
                RegisterViewer.this.editing = false;
            }
        }

        private void updateRegister() {
            String string = (String)RegisterViewer.this.registerList.getSelectedValue();
            if (string == null || string.length() < 1) {
                return;
            }
            char c = string.charAt(0);
            Registers.setRegister(c, RegisterViewer.this.contentTextArea.getText());
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = RegisterViewer.this.registerList.locationToIndex(mouseEvent.getPoint());
            if (n != -1) {
                RegisterViewer.this.registerList.setSelectedIndex(n);
            }
            if (GenericGUIUtilities.isPopupTrigger(mouseEvent)) {
                if (RegisterViewer.this.popup == null) {
                    RegisterViewer.this.popup = new JPopupMenu();
                    JMenuItem jMenuItem = GUIUtilities.loadMenuItem("paste");
                    RegisterViewer.this.popup.add(jMenuItem);
                    jMenuItem = new JMenuItem(jEdit.getProperty("clear-string-register.label"));
                    jMenuItem.addActionListener(new ClearHandler());
                    RegisterViewer.this.popup.add(jMenuItem);
                }
                GenericGUIUtilities.showPopupMenu(RegisterViewer.this.popup, RegisterViewer.this.registerList, mouseEvent.getX(), mouseEvent.getY(), false);
            } else if (mouseEvent.getClickCount() % 2 == 0) {
                RegisterViewer.this.insertRegister();
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string = (String)RegisterViewer.this.registerList.getSelectedValue();
            if (string == null || string.length() < 1) {
                if (!RegisterViewer.this.editing) {
                    RegisterViewer.this.contentTextArea.setText("");
                    RegisterViewer.this.contentTextArea.setEditable(false);
                }
                return;
            }
            char c = string.charAt(0);
            Registers.Register register = Registers.getRegister(c);
            if (register == null) {
                if (!RegisterViewer.this.editing) {
                    RegisterViewer.this.contentTextArea.setText("");
                    RegisterViewer.this.contentTextArea.setEditable(false);
                }
                return;
            }
            if (!RegisterViewer.this.editing) {
                RegisterViewer.this.contentTextArea.setText(register.toString());
                RegisterViewer.this.contentTextArea.setEditable(true);
                RegisterViewer.this.contentTextArea.setCaretPosition(0);
            }
        }
    }

    static class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (!jEdit.getProperty("view-registers.none").equals(object)) {
                String string;
                char c = object.toString().charAt(0);
                String string2 = c == '\n' ? "\n" : (c == '\t' ? "\t" : (c == '$' ? jEdit.getProperty("view-registers.clipboard") : (c == '%' ? jEdit.getProperty("view-registers.selection") : String.valueOf(c))));
                Registers.Register register = Registers.getRegister(c);
                if (register == null) {
                    string = jEdit.getProperty("view-registers.undefined");
                } else {
                    string = register.toString();
                    if (string.length() > 100) {
                        string = string.substring(0, 100) + "...";
                    }
                    string = string.replaceAll("\n", " ");
                    string = string.replaceAll("\t", " ");
                }
                this.setText(string2 + " : " + string);
            }
            return this;
        }
    }
}

