/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock.examples;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.parsers.ParserConfigurationException;
import org.coode.mdock.ComponentFactory;
import org.coode.mdock.ComponentPropertiesFactory;
import org.coode.mdock.DynamicConfigPanel;
import org.coode.mdock.NodePanel;
import org.coode.mdock.NodeReanimator;
import org.coode.mdock.NodeSerialiser;
import org.coode.mdock.SplitterNode;
import org.coode.mdock.VerticalSplitterNode;

public class ExampleFrame
extends JFrame {
    private JMenu menu;
    private NodePanel nodePanel;
    private SplitterNode rootNode;
    private DynamicConfigPanel dynamicConfigPanel;

    public ExampleFrame() {
        this.createMenuBar();
        this.rootNode = new VerticalSplitterNode(new ArrayList(), new ArrayList<Double>());
        this.nodePanel = new NodePanel(this.rootNode);
        this.setContentPane(this.nodePanel);
        this.dynamicConfigPanel = new DynamicConfigPanel(this.nodePanel);
        this.setDefaultCloseOperation(3);
    }

    private void createMenuBar() {
        this.menu = new JMenu("Nodes");
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.menu);
        this.setJMenuBar(menuBar);
        this.menu.add(new AbstractAction("Add..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleFrame.this.addNewComponent();
            }
        });
        this.menu.add(new AbstractAction("Dump"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleFrame.this.dumpAndReanimate();
            }
        });
    }

    private void dumpAndReanimate() {
        try {
            StringWriter sw = new StringWriter();
            NodeSerialiser serialiser = new NodeSerialiser(this.rootNode, new ComponentPropertiesFactory(){

                @Override
                public Map<String, String> getProperties(JComponent component) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("class", component.getClass().getName());
                    return map;
                }
            }, sw);
            serialiser.serialise();
            System.out.println(sw.getBuffer().toString());
            StringReader sr = new StringReader(sw.getBuffer().toString());
            NodeReanimator reanimator = new NodeReanimator(sr, new ComponentFactory(){

                @Override
                public JComponent createComponent(Map<String, String> properties) {
                    String cls = properties.get("class");
                    try {
                        return (JComponent)Class.forName(cls).newInstance();
                    }
                    catch (InstantiationException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                    catch (ClassNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    return new JButton("Error");
                }
            });
            SplitterNode sn = reanimator.getRootNode();
            NodePanel np = new NodePanel(sn);
            JFrame f = new JFrame();
            f.setContentPane(np);
            f.setVisible(true);
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void addNewComponent() {
        final JComponent comp = ExampleFrame.createDummyComponent();
        JMenuItem item = new JMenuItem(new AbstractAction("Remove " + comp.hashCode()){

            @Override
            public void actionPerformed(ActionEvent e) {
                comp.getParent().remove(comp);
                ExampleFrame.this.nodePanel.rebuild();
                this.setEnabled(false);
            }
        });
        this.menu.add(item);
        this.dynamicConfigPanel.setCurrentComponent(comp, "Text Area");
        this.dynamicConfigPanel.activate();
    }

    private static JComponent createDummyComponent() {
        JTextArea textArea = new JTextArea();
        JScrollPane sp = new JScrollPane(textArea);
        for (int i = 0; i < 30; ++i) {
            textArea.append("wfukhwe w erlfjh jwhegr fhyyg werr\n");
        }
        return sp;
    }

    public static void main(String[] args) {
        ExampleFrame f = new ExampleFrame();
        f.setSize(800, 600);
        f.setVisible(true);
    }
}

