/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.ContentRecording;
import com.eteks.sweethome3d.io.DamagedHomeIOException;
import com.eteks.sweethome3d.io.HomeContentContext;
import com.eteks.sweethome3d.io.HomeXMLHandler;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultHomeInputStream
extends FilterInputStream {
    private final ContentRecording contentRecording;
    private final HomeXMLHandler xmlHandler;
    private final UserPreferences preferences;
    private final boolean preferPreferencesContent;
    private File zipFile;

    public DefaultHomeInputStream(InputStream inputStream) throws IOException {
        this(inputStream, ContentRecording.INCLUDE_ALL_CONTENT);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording) throws IOException {
        this(inputStream, contentRecording, null, false);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording, UserPreferences userPreferences, boolean bl) {
        this(inputStream, contentRecording, null, userPreferences, bl);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording, HomeXMLHandler homeXMLHandler, UserPreferences userPreferences, boolean bl) {
        super(new PushbackInputStream(inputStream, 5));
        this.contentRecording = contentRecording;
        this.xmlHandler = homeXMLHandler;
        this.preferences = userPreferences;
        this.preferPreferencesContent = bl;
    }

    public DefaultHomeInputStream(File file, ContentRecording contentRecording, HomeXMLHandler homeXMLHandler, UserPreferences userPreferences, boolean bl) throws FileNotFoundException {
        super(new FileInputStream(file));
        this.zipFile = file;
        this.contentRecording = contentRecording;
        this.xmlHandler = homeXMLHandler;
        this.preferences = userPreferences;
        this.preferPreferencesContent = bl;
    }

    private static void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    public boolean isPrefixCorrect() throws IOException {
        if (this.isZipPrefix()) {
            return true;
        }
        return this.isPrefix(new byte[]{60, 63, 120, 109, 108});
    }

    private boolean isZipPrefix() throws IOException {
        return this.isPrefix(new byte[]{80, 75});
    }

    private boolean isPrefix(byte[] byArray) throws IOException {
        if (!(this.in instanceof PushbackInputStream)) {
            throw new IOException("Can't check prefix");
        }
        byte[] byArray2 = new byte[byArray.length];
        int n = this.in.read(byArray2);
        if (n != -1) {
            ((PushbackInputStream)this.in).unread(byArray2, 0, n);
        }
        return Arrays.equals(byArray, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Home readHome() throws IOException, ClassNotFoundException {
        int n;
        ArrayList arrayList;
        InputStream inputStream;
        boolean bl = true;
        boolean bl2 = true;
        URL uRL = null;
        HomeContentContext homeContentContext = null;
        if (this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
            inputStream = null;
            if (this.zipFile == null) {
                if (this.isZipPrefix()) {
                    this.zipFile = OperatingSystem.createTemporaryFile("open", ".sweethome3d");
                    arrayList = new BufferedOutputStream(new FileOutputStream(this.zipFile));
                    inputStream = new CopiedInputStream(new BufferedInputStream(this.in), (OutputStream)((Object)arrayList));
                } else {
                    bl = false;
                    bl2 = false;
                }
            } else {
                inputStream = this.in;
            }
            if (bl2) {
                arrayList = new ArrayList();
                boolean bl3 = bl2 = this.isZipFileValidUsingInputStream(inputStream, arrayList) && arrayList.size() > 0;
                if (!bl2) {
                    n = arrayList.size();
                    arrayList.clear();
                    this.isZipFileValidUsingDictionnary(this.zipFile, arrayList);
                    this.zipFile = arrayList.size() > n ? this.createTemporaryFileFromValidEntries(this.zipFile, arrayList) : this.createTemporaryFileFromValidEntriesCount(this.zipFile, n);
                }
                uRL = this.zipFile.toURI().toURL();
                homeContentContext = new HomeContentContext(uRL, this.preferences, this.preferPreferencesContent);
            }
        }
        inputStream = null;
        try {
            if (bl) {
                ZipEntry zipEntry;
                n = 0;
                boolean bl4 = false;
                ZipInputStream zipInputStream = new ZipInputStream(this.contentRecording == ContentRecording.INCLUDE_NO_CONTENT ? this.in : new FileInputStream(this.zipFile));
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if ("Home".equals(zipEntry.getName())) {
                        n = 1;
                    } else if (this.xmlHandler != null && "Home.xml".equals(zipEntry.getName())) {
                        bl4 = true;
                    }
                    if (this.contentRecording == ContentRecording.INCLUDE_NO_CONTENT) {
                        if (n == 0 && !bl4) continue;
                        break;
                    }
                    if (!bl4) continue;
                    n = 0;
                    break;
                }
                DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
                if (n == 0 && !bl4) {
                    throw new IOException("Missing entry \"Home\" or \"Home.xml\"");
                }
                if (this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                    zipInputStream.close();
                    zipInputStream = new ZipInputStream(new FileInputStream(this.zipFile));
                    zipEntry = null;
                    do {
                        zipEntry = zipInputStream.getNextEntry();
                    } while ((n == 0 || !"Home".equals(zipEntry.getName())) && (!bl4 || !"Home.xml".equals(zipEntry.getName())));
                }
                inputStream = zipInputStream;
                DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
                arrayList = n != 0 ? this.readHomeObject(inputStream, homeContentContext) : this.readHomeXML(inputStream, homeContentContext);
                if (homeContentContext != null && (!bl2 || homeContentContext.containsInvalidContents())) {
                    if (!homeContentContext.containsCheckedContents()) throw new DamagedHomeIOException((Home)((Object)arrayList), homeContentContext.getInvalidContents());
                    ((Home)((Object)arrayList)).setRepaired(true);
                }
            } else {
                inputStream = this.in;
                arrayList = this.readHomeXML(inputStream, null);
            }
            if (arrayList == null) {
                throw new IOException("No home object in input");
            }
            this.checkModelSizes(((Home)((Object)arrayList)).getFurniture());
            Cloneable cloneable = arrayList;
            return cloneable;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private Home readHomeObject(InputStream inputStream, HomeContentContext homeContentContext) throws IOException, ClassNotFoundException {
        Object object = new HomeObjectInputStream(inputStream, homeContentContext).readObject();
        return object instanceof Home ? (Home)object : null;
    }

    private Home readHomeXML(InputStream inputStream, HomeContentContext homeContentContext) throws IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.xmlHandler.setContentContext(homeContentContext);
            sAXParser.parse(inputStream, (DefaultHandler)this.xmlHandler);
            return this.xmlHandler.getHome();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException("Can't parse home XML stream");
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("Can't parse home XML stream");
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFileValidUsingInputStream(InputStream inputStream, List<ZipEntry> list) throws IOException {
        try (ZipInputStream zipInputStream = null;){
            zipInputStream = new ZipInputStream(inputStream);
            byte[] byArray = new byte[8192];
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                while (zipInputStream.read(byArray) != -1) {
                }
                list.add(zipEntry);
                DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFileValidUsingDictionnary(File file, List<ZipEntry> list) throws IOException {
        boolean bl = true;
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                try {
                    ZipEntry zipEntry = enumeration.nextElement();
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    byte[] byArray = new byte[8192];
                    while (inputStream.read(byArray) != -1) {
                    }
                    inputStream.close();
                    list.add(zipEntry);
                    DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTemporaryFileFromValidEntriesCount(File file, int n) throws IOException {
        if (n <= 0) {
            throw new IOException("No valid entries");
        }
        File file2 = OperatingSystem.createTemporaryFile("part", ".sh3d");
        ZipOutputStream zipOutputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            zipOutputStream.setLevel(0);
            while (n-- > 0) {
                this.copyEntry(zipInputStream, zipInputStream.getNextEntry(), zipOutputStream);
            }
            File file3 = file2;
            return file3;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTemporaryFileFromValidEntries(File file, List<ZipEntry> list) throws IOException {
        if (list.size() <= 0) {
            throw new IOException("No valid entries");
        }
        File file2 = OperatingSystem.createTemporaryFile("part", ".sh3d");
        ZipOutputStream zipOutputStream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            zipOutputStream.setLevel(0);
            for (ZipEntry zipEntry : list) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                this.copyEntry(inputStream, zipEntry, zipOutputStream);
                inputStream.close();
            }
            File file3 = file2;
            return file3;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private void copyEntry(InputStream inputStream, ZipEntry zipEntry, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setTime(zipEntry.getTime());
        zipEntry2.setExtra(zipEntry.getExtra());
        zipOutputStream.putNextEntry(zipEntry2);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        zipOutputStream.closeEntry();
    }

    private boolean checkModelSizes(List<HomePieceOfFurniture> list) {
        ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                if (!this.checkModelSizes(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture())) continue;
                return true;
            }
            if (homePieceOfFurniture.getModelSize() == null) {
                Long l = contentDigestManager.getContentSize(homePieceOfFurniture.getModel());
                homePieceOfFurniture.setModelSize(l != null ? l : Long.valueOf(-1L));
                continue;
            }
            return true;
        }
        return false;
    }

    private class HomeObjectInputStream
    extends ObjectInputStream {
        private HomeContentContext contentContext;

        public HomeObjectInputStream(InputStream inputStream, HomeContentContext homeContentContext) throws IOException {
            super(inputStream);
            if (DefaultHomeInputStream.this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                this.enableResolveObject(true);
                this.contentContext = homeContentContext;
            }
        }

        @Override
        protected Object resolveObject(Object object) throws IOException {
            String string;
            if (object instanceof URLContent && (string = ((URLContent)object).getURL().toString()).startsWith("jar:file:temp!/")) {
                return this.contentContext.lookupContent(string.substring(string.indexOf(33) + 2));
            }
            return object;
        }
    }

    private class CopiedInputStream
    extends FilterInputStream {
        private OutputStream out;

        protected CopiedInputStream(InputStream inputStream, OutputStream outputStream) {
            super(inputStream);
            this.out = outputStream;
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                this.out.write(n);
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.out.write(byArray, n, n3);
            }
            return n3;
        }

        @Override
        public void close() throws IOException {
            try {
                int n;
                byte[] byArray = new byte[8192];
                while ((n = this.in.read(byArray)) != -1) {
                    this.out.write(byArray, 0, n);
                }
                this.out.flush();
            }
            finally {
                this.out.close();
                super.close();
            }
        }
    }
}

