/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.merge;

import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.merger.NodeMergeAlgorithm;
import org.openoffice.xmerge.merger.diff.CellNodeIterator;
import org.openoffice.xmerge.merger.merge.SheetUtil;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PositionBaseRowMerge
implements NodeMergeAlgorithm {
    private final ConverterCapabilities cc_;

    public PositionBaseRowMerge(ConverterCapabilities cc) {
        this.cc_ = cc;
    }

    @Override
    public void merge(Node orgRow, Node modRow) {
        CellNodeIterator orgCells = new CellNodeIterator(this.cc_, orgRow);
        CellNodeIterator modCells = new CellNodeIterator(this.cc_, modRow);
        this.mergeCellSequences(orgCells, modCells);
    }

    private void mergeCellSequences(Iterator orgSeq, Iterator modSeq) {
        Element orgCell;
        boolean needMerge = true;
        Object orgSeqObject = orgSeq.start();
        Object modSeqObject = modSeq.start();
        while (orgSeqObject != null) {
            needMerge = true;
            if (modSeqObject == null) {
                SheetUtil.emptyCell(this.cc_, (Node)orgSeqObject);
                orgSeqObject = orgSeq.next();
                continue;
            }
            if (!orgSeq.equivalent(orgSeqObject, modSeqObject)) {
                orgCell = (Element)orgSeqObject;
                Element modCell = (Element)modSeqObject;
                String orgColRepeated = orgCell.getAttribute("table:number-columns-repeated");
                String modColRepeated = modCell.getAttribute("table:number-columns-repeated");
                int orgColNum = 1;
                int modColNum = 1;
                if (orgColRepeated.length() > 0) {
                    orgColNum = Integer.parseInt(orgColRepeated);
                }
                if (modColRepeated.length() > 0) {
                    modColNum = Integer.parseInt(modColRepeated);
                }
                if (orgColNum == modColNum) {
                    orgSeqObject = orgSeq.next();
                    modSeqObject = modSeq.next();
                } else if (orgColNum > modColNum) {
                    Element orgSplitCell = this.splitColRepeatedCell(orgCell, modColNum, orgColNum - modColNum);
                    if (orgSeq.equivalent(orgSplitCell, modCell)) {
                        needMerge = false;
                    }
                    orgCell = orgSplitCell;
                    modSeqObject = modSeq.next();
                } else {
                    Element modSplitCell = this.splitColRepeatedCell(modCell, orgColNum, modColNum - orgColNum);
                    if (modSeq.equivalent(orgCell, modSplitCell)) {
                        needMerge = false;
                    }
                    modCell = modSplitCell;
                    orgSeqObject = orgSeq.next();
                }
                if (!needMerge) continue;
                this.mergeCells(orgCell, modCell);
                continue;
            }
            orgSeqObject = orgSeq.next();
            modSeqObject = modSeq.next();
        }
        orgCell = (Element)orgSeq.start();
        while (modSeqObject != null) {
            Node clonedNode = XmlUtil.deepClone(orgCell, (Node)modSeqObject);
            Node parent = orgCell.getParentNode();
            parent.appendChild(clonedNode);
            modSeqObject = modSeq.next();
        }
    }

    private Element splitColRepeatedCell(Element orgCell, int splitNum, int orgNum) {
        Element splitCell = (Element)orgCell.cloneNode(true);
        if (splitNum > 1) {
            splitCell.setAttribute("table:number-columns-repeated", String.valueOf(splitNum));
        } else if (splitNum == 1) {
            splitCell.removeAttribute("table:number-columns-repeated");
        }
        if (orgNum > 1) {
            orgCell.setAttribute("table:number-columns-repeated", String.valueOf(orgNum));
        } else if (orgNum == 1) {
            orgCell.removeAttribute("table:number-columns-repeated");
        }
        Node parentNode = orgCell.getParentNode();
        parentNode.insertBefore(splitCell, orgCell);
        return splitCell;
    }

    private void mergeCells(Element orgCell, Element modCell) {
        SheetUtil.emptyCell(this.cc_, orgCell);
        NamedNodeMap attrNodes = modCell.getAttributes();
        if (attrNodes != null) {
            NodeList paraNodes = modCell.getElementsByTagName("text:p");
            Node firstParaNode = paraNodes.item(0);
            if (firstParaNode != null) {
                Node clonedNode = XmlUtil.deepClone(orgCell, firstParaNode);
                Node firstChild = orgCell.getFirstChild();
                if (firstChild != null) {
                    orgCell.insertBefore(clonedNode, firstChild);
                } else {
                    orgCell.appendChild(clonedNode);
                }
            }
            int len = attrNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = attrNodes.item(i);
                if (!this.cc_.canConvertAttribute("table:table-cell", attr.getNodeName())) continue;
                orgCell.setAttribute(attr.getNodeName(), attr.getNodeValue());
            }
        }
    }
}

