/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;
import org.elasticsearch.painless.node.PSubBrace;
import org.elasticsearch.painless.node.PSubDefArray;
import org.elasticsearch.painless.node.PSubListShortcut;
import org.elasticsearch.painless.node.PSubMapShortcut;

public final class PBrace
extends AStoreable {
    private AExpression index;
    private AStoreable sub = null;

    public PBrace(Location location, AExpression prefix, AExpression index) {
        super(location, prefix);
        this.index = Objects.requireNonNull(index);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.prefix.storeSettings(settings);
        this.index.storeSettings(settings);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.prefix.extractVariables(variables);
        this.index.extractVariables(variables);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.prefix.analyze(scriptRoot, locals);
        this.prefix.expected = this.prefix.actual;
        this.prefix = this.prefix.cast(scriptRoot, locals);
        if (this.prefix.actual.isArray()) {
            this.sub = new PSubBrace(this.location, this.prefix.actual, this.index);
        } else if (this.prefix.actual == def.class) {
            this.sub = new PSubDefArray(this.location, this.index);
        } else if (Map.class.isAssignableFrom(this.prefix.actual)) {
            this.sub = new PSubMapShortcut(this.location, this.prefix.actual, this.index);
        } else if (List.class.isAssignableFrom(this.prefix.actual)) {
            this.sub = new PSubListShortcut(this.location, this.prefix.actual, this.index);
        } else {
            throw this.createError(new IllegalArgumentException("Illegal array access on type [" + PainlessLookupUtility.typeToCanonicalTypeName(this.prefix.actual) + "]."));
        }
        this.sub.write = this.write;
        this.sub.read = this.read;
        this.sub.expected = this.expected;
        this.sub.explicit = this.explicit;
        this.sub.analyze(scriptRoot, locals);
        this.actual = this.sub.actual;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.prefix.write(classWriter, methodWriter, globals);
        this.sub.write(classWriter, methodWriter, globals);
    }

    @Override
    boolean isDefOptimized() {
        return this.sub.isDefOptimized();
    }

    @Override
    void updateActual(Class<?> actual) {
        this.sub.updateActual(actual);
        this.actual = actual;
    }

    @Override
    int accessElementCount() {
        return this.sub.accessElementCount();
    }

    @Override
    void setup(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.prefix.write(classWriter, methodWriter, globals);
        this.sub.setup(classWriter, methodWriter, globals);
    }

    @Override
    void load(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.sub.load(classWriter, methodWriter, globals);
    }

    @Override
    void store(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        this.sub.store(classWriter, methodWriter, globals);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.index);
    }
}

