/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;

public class RestClearScrollAction
extends BaseRestHandler {
    public RestClearScrollAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.DELETE, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/_search/scroll/{scroll_id}", this);
    }

    @Override
    public String getName() {
        return "clear_scroll_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String scrollIds = request.param("scroll_id");
        ClearScrollRequest clearRequest = new ClearScrollRequest();
        clearRequest.setScrollIds(Arrays.asList(Strings.splitStringByCommaToArray(scrollIds)));
        request.withContentOrSourceParamParserOrNull(xContentParser -> {
            if (xContentParser != null) {
                try {
                    clearRequest.fromXContent((XContentParser)xContentParser);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse request body", e);
                }
            }
        });
        return channel -> client.clearScroll(clearRequest, new RestStatusToXContentListener<ClearScrollResponse>((RestChannel)channel));
    }
}

