/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.gui.menus.actions.CopyOffsetToAllAction;
import org.fibs.geotag.gui.menus.actions.CopyOffsetToSelectedAction;
import org.fibs.geotag.table.ImagesTable;

public class CopyOffsetMenu
extends JMenu
implements MenuConstants,
ActionListener {
    private JMenuItem copyOffsetToAllItem;
    private JMenuItem copyOffsetToSelectedItem;
    private ImagesTable imagesTable;
    private ImageInfo currentImage;

    public CopyOffsetMenu(boolean backgroundTask, ImagesTable imagesTable, ImageInfo currentImage) {
        super(COPY_TIME_OFFSET);
        this.imagesTable = imagesTable;
        this.currentImage = currentImage;
        boolean menuEnabled = false;
        int[] selectedRows = imagesTable.getSelectedRows();
        this.copyOffsetToSelectedItem = new JMenuItem(COPY_TIME_OFFSET_SELECTED);
        boolean itemEnabled = !backgroundTask && selectedRows.length > 0;
        menuEnabled |= itemEnabled;
        this.copyOffsetToSelectedItem.setEnabled(itemEnabled);
        this.copyOffsetToSelectedItem.addActionListener(this);
        this.add(this.copyOffsetToSelectedItem);
        this.copyOffsetToAllItem = new JMenuItem(COPY_TIME_OFFSET_ALL);
        itemEnabled = !backgroundTask;
        this.copyOffsetToAllItem.setEnabled(itemEnabled);
        this.copyOffsetToAllItem.addActionListener(this);
        this.add(this.copyOffsetToAllItem);
        this.setEnabled(menuEnabled |= itemEnabled);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.copyOffsetToAllItem) {
            new CopyOffsetToAllAction(this.currentImage, this.imagesTable).perform();
        } else if (event.getSource() == this.copyOffsetToSelectedItem) {
            new CopyOffsetToSelectedAction(this.currentImage, this.imagesTable).perform();
        }
    }
}

