/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.Option;
import org.joni.ast.Node;
import org.joni.ast.StateNode;
import org.joni.constants.internal.EncloseType;

public final class EncloseNode
extends StateNode
implements EncloseType {
    public final int type;
    public int regNum;
    public int option;
    public Node target;
    public int callAddr;
    public int minLength;
    public int maxLength;
    public int charLength;
    public int optCount;
    public Node containingAnchor;

    public EncloseNode(int type2) {
        super(6);
        this.type = type2;
        this.callAddr = -1;
    }

    public static EncloseNode newMemory(int option, boolean isNamed) {
        EncloseNode en = new EncloseNode(1);
        en.option = option;
        if (isNamed) {
            en.setNamedGroup();
        }
        return en;
    }

    public static EncloseNode newOption(int option) {
        EncloseNode en = new EncloseNode(2);
        en.option = option;
        return en;
    }

    @Override
    protected void setChild(Node child) {
        this.target = child;
    }

    @Override
    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node tgt) {
        this.target = tgt;
        tgt.parent = this;
    }

    @Override
    public String getName() {
        return "Enclose";
    }

    @Override
    public String toString(int level2) {
        StringBuilder value2 = new StringBuilder(super.toString(level2));
        value2.append("\n  type: " + this.typeToString());
        value2.append("\n  regNum: " + this.regNum);
        value2.append(", option: " + Option.toString(this.option));
        value2.append(", callAddr: " + this.callAddr);
        value2.append(", minLength: " + this.minLength);
        value2.append(", maxLength: " + this.maxLength);
        value2.append(", charLength: " + this.charLength);
        value2.append(", optCount: " + this.optCount);
        value2.append("\n  target: " + EncloseNode.pad(this.target, level2 + 1));
        return value2.toString();
    }

    public String typeToString() {
        StringBuilder types = new StringBuilder();
        if (this.isStopBacktrack()) {
            types.append("STOP_BACKTRACK ");
        }
        if (this.isMemory()) {
            types.append("MEMORY ");
        }
        if (this.isOption()) {
            types.append("OPTION ");
        }
        if (this.isCondition()) {
            types.append("CONDITION ");
        }
        if (this.isAbsent()) {
            types.append("ABSENT ");
        }
        return types.toString();
    }

    public void setEncloseStatus(int flag) {
        this.state |= flag;
    }

    public void clearEncloseStatus(int flag) {
        this.state &= ~flag;
    }

    public boolean isMemory() {
        return (this.type & 1) != 0;
    }

    public boolean isOption() {
        return (this.type & 2) != 0;
    }

    public boolean isCondition() {
        return (this.type & 8) != 0;
    }

    public boolean isStopBacktrack() {
        return (this.type & 4) != 0;
    }

    public boolean isAbsent() {
        return (this.type & 0x10) != 0;
    }
}

