/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@Deprecated
@JRubyClass(name={"NativeException"}, parent="RuntimeError")
public class NativeException
extends RubyException {
    private final Throwable cause;
    private final String messageAsJavaString;
    public static final String CLASS_NAME = "NativeException";
    private static ObjectAllocator NATIVE_EXCEPTION_ALLOCATOR = (runtime2, klazz) -> new NativeException(runtime2, klazz);

    public NativeException(Ruby runtime2, RubyClass rubyClass, Throwable cause2) {
        this(runtime2, rubyClass, cause2, NativeException.buildMessage(cause2));
    }

    private NativeException(Ruby runtime2, RubyClass rubyClass, Throwable cause2, String message2) {
        super(runtime2, rubyClass, message2);
        this.cause = cause2;
        String s2 = NativeException.buildMessage(cause2);
        this.messageAsJavaString = message2;
    }

    private static String buildMessage(Throwable cause2) {
        return cause2.getClass().getName() + ": " + NativeException.searchStackMessage(cause2);
    }

    private NativeException(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass, null);
        this.cause = new Throwable();
        this.messageAsJavaString = null;
    }

    public static RubyClass createClass(Ruby runtime2, RubyClass baseClass) {
        RubyClass exceptionClass = runtime2.defineClass(CLASS_NAME, baseClass, NATIVE_EXCEPTION_ALLOCATOR);
        runtime2.getObject().deprecateConstant(runtime2, CLASS_NAME);
        exceptionClass.defineAnnotatedMethods(NativeException.class);
        return exceptionClass;
    }

    @JRubyMethod
    public final IRubyObject cause() {
        return Java.getInstance(this.getRuntime(), this.getCause());
    }

    @Deprecated
    public final IRubyObject cause(Block unusedBlock) {
        return this.cause();
    }

    @Override
    public final IRubyObject backtrace() {
        IRubyObject rubyTrace = super.backtrace();
        if (rubyTrace.isNil()) {
            return rubyTrace;
        }
        Ruby runtime2 = this.getRuntime();
        RubyArray rTrace = (RubyArray)rubyTrace;
        StackTraceElement[] jTrace = this.cause.getStackTrace();
        if (rTrace.size() > 0 && jTrace.length > 0) {
            String r0 = rTrace.eltInternal(0).toString();
            String method2 = jTrace[0].getMethodName();
            String file2 = jTrace[0].getFileName();
            if (method2 != null && file2 != null && r0.indexOf(method2) != -1 && r0.indexOf(file2) != -1) {
                return rTrace;
            }
        }
        return NativeException.joinedBacktrace(runtime2, rTrace, jTrace);
    }

    private static RubyArray joinedBacktrace(Ruby runtime2, RubyArray rTrace, StackTraceElement[] jTrace) {
        IRubyObject[] trace2 = new IRubyObject[jTrace.length + rTrace.size()];
        StringBuilder line = new StringBuilder(32);
        for (int i2 = 0; i2 < jTrace.length; ++i2) {
            StackTraceElement element = jTrace[i2];
            String className = element.getClassName();
            line.setLength(0);
            if (element.getFileName() == null) {
                line.append(className).append(':').append(element.getLineNumber()).append(":in `").append(element.getMethodName()).append('\'');
            } else {
                int index2 = className.lastIndexOf(46);
                if (index2 > -1) {
                    line.append(className.substring(0, index2).replace('.', '/'));
                    line.append('/');
                }
                line.append(element.getFileName()).append(':').append(element.getLineNumber()).append(":in `").append(element.getMethodName()).append('\'');
            }
            trace2[i2] = RubyString.newString(runtime2, line.toString());
        }
        System.arraycopy(rTrace.toJavaArrayMaybeUnsafe(), 0, trace2, jTrace.length, rTrace.size());
        return RubyArray.newArrayMayCopy(runtime2, trace2);
    }

    @Deprecated
    public void trimStackTrace(Member target) {
        StackTraceElement b2;
        StackTraceElement a;
        Throwable t = new Throwable();
        StackTraceElement[] origStackTrace = this.cause.getStackTrace();
        StackTraceElement[] currentStackTrace = t.getStackTrace();
        int skip2 = 0;
        for (int i2 = 1; i2 <= origStackTrace.length && i2 <= currentStackTrace.length && (a = origStackTrace[origStackTrace.length - i2]).equals(b2 = currentStackTrace[currentStackTrace.length - i2]); ++i2) {
            ++skip2;
        }
        if (target != null) {
            String className = target.getDeclaringClass().getName();
            String methodName = target.getName();
            for (int i3 = origStackTrace.length - skip2 - 1; i3 >= 0; --i3) {
                StackTraceElement frame = origStackTrace[i3];
                if (!frame.getClassName().equals(className) || !frame.getMethodName().equals(methodName)) continue;
                skip2 = origStackTrace.length - i3 - 1;
                break;
            }
        }
        if (skip2 > 0) {
            int len = origStackTrace.length - skip2;
            StackTraceElement[] newStackTrace = new StackTraceElement[len];
            System.arraycopy(origStackTrace, 0, newStackTrace, 0, len);
            this.cause.setStackTrace(newStackTrace);
        }
    }

    @Override
    public final IRubyObject getMessage() {
        if (this.message == null) {
            if (this.messageAsJavaString == null) {
                this.message = this.getRuntime().getNil();
                return this.message;
            }
            this.message = this.getRuntime().newString(this.messageAsJavaString);
            return this.message;
        }
        return this.message;
    }

    @Override
    public final String getMessageAsJavaString() {
        return this.messageAsJavaString;
    }

    @Override
    public final Throwable getCause() {
        return this.cause;
    }

    private static String searchStackMessage(Throwable cause2) {
        do {
            String message2;
            if ((message2 = cause2.getMessage()) == null) continue;
            return message2;
        } while ((cause2 = cause2.getCause()) != null);
        return null;
    }
}

