# -*- coding: utf-8 -*-
info = {
    "name": "es",
    "date_order": "DMY",
    "january": [
        "enero",
        "ene"
    ],
    "february": [
        "febrero",
        "feb"
    ],
    "march": [
        "marzo",
        "mar"
    ],
    "april": [
        "abril",
        "abr"
    ],
    "may": [
        "mayo",
        "may"
    ],
    "june": [
        "junio",
        "jun"
    ],
    "july": [
        "julio",
        "jul"
    ],
    "august": [
        "agosto",
        "ago"
    ],
    "september": [
        "septiembre",
        "sept",
        "Setiembre",
        "Sep",
        "Set"
    ],
    "october": [
        "octubre",
        "oct"
    ],
    "november": [
        "noviembre",
        "nov"
    ],
    "december": [
        "diciembre",
        "dic"
    ],
    "monday": [
        "lunes",
        "lun",
        "Lu"
    ],
    "tuesday": [
        "martes",
        "mar"
    ],
    "wednesday": [
        "miércoles",
        "mié",
        "Mi"
    ],
    "thursday": [
        "jueves",
        "jue",
        "Ju"
    ],
    "friday": [
        "viernes",
        "vie",
        "Vi"
    ],
    "saturday": [
        "sábado",
        "sáb",
        "Sa"
    ],
    "sunday": [
        "domingo",
        "dom",
        "Do"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "año",
        "a",
        "años"
    ],
    "month": [
        "mes",
        "m",
        "meses"
    ],
    "week": [
        "semana",
        "sem",
        "semanas"
    ],
    "day": [
        "día",
        "d",
        "días"
    ],
    "hour": [
        "hora",
        "h",
        "horas"
    ],
    "minute": [
        "minuto",
        "min",
        "minutos"
    ],
    "second": [
        "segundo",
        "s",
        "segundos"
    ],
    "relative-type": {
        "1 year ago": [
            "el año pasado"
        ],
        "0 year ago": [
            "este año"
        ],
        "in 1 year": [
            "el próximo año"
        ],
        "1 month ago": [
            "el mes pasado"
        ],
        "0 month ago": [
            "este mes"
        ],
        "in 1 month": [
            "el próximo mes"
        ],
        "1 week ago": [
            "la semana pasada"
        ],
        "0 week ago": [
            "esta semana"
        ],
        "in 1 week": [
            "la próxima semana"
        ],
        "1 day ago": [
            "ayer"
        ],
        "0 day ago": [
            "hoy"
        ],
        "in 1 day": [
            "mañana"
        ],
        "0 hour ago": [
            "esta hora"
        ],
        "0 minute ago": [
            "este minuto"
        ],
        "0 second ago": [
            "ahora"
        ],
        "2 day ago": [
            "anteayer"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "dentro de (\\d+) año",
            "dentro de (\\d+) años",
            "dentro de (\\d+) a"
        ],
        "\\1 year ago": [
            "hace (\\d+) año",
            "hace (\\d+) años",
            "hace (\\d+) a"
        ],
        "in \\1 month": [
            "dentro de (\\d+) mes",
            "dentro de (\\d+) meses",
            "dentro de (\\d+) m"
        ],
        "\\1 month ago": [
            "hace (\\d+) mes",
            "hace (\\d+) meses",
            "hace (\\d+) m"
        ],
        "in \\1 week": [
            "dentro de (\\d+) semana",
            "dentro de (\\d+) semanas",
            "dentro de (\\d+) sem"
        ],
        "\\1 week ago": [
            "hace (\\d+) semana",
            "hace (\\d+) semanas",
            "hace (\\d+) sem"
        ],
        "in \\1 day": [
            "dentro de (\\d+) día",
            "dentro de (\\d+) días"
        ],
        "\\1 day ago": [
            "hace (\\d+) día",
            "hace (\\d+) días"
        ],
        "in \\1 hour": [
            "dentro de (\\d+) hora",
            "dentro de (\\d+) horas",
            "dentro de (\\d+) h"
        ],
        "\\1 hour ago": [
            "hace (\\d+) hora",
            "hace (\\d+) horas",
            "hace (\\d+) h"
        ],
        "in \\1 minute": [
            "dentro de (\\d+) minuto",
            "dentro de (\\d+) minutos",
            "dentro de (\\d+) min"
        ],
        "\\1 minute ago": [
            "hace (\\d+) minuto",
            "hace (\\d+) minutos",
            "hace (\\d+) min"
        ],
        "in \\1 second": [
            "dentro de (\\d+) segundo",
            "dentro de (\\d+) segundos",
            "dentro de (\\d+) s"
        ],
        "\\1 second ago": [
            "hace (\\d+) segundo",
            "hace (\\d+) segundos",
            "hace (\\d+) s"
        ]
    },
    "locale_specific": {
        "es-CO": {
            "name": "es-CO",
            "september": [
                "sep"
            ]
        },
        "es-MX": {
            "name": "es-MX",
            "september": [
                "sep"
            ],
            "relative-type": {
                "in 1 year": [
                    "el año próximo"
                ],
                "in 1 month": [
                    "el mes próximo"
                ],
                "in 1 week": [
                    "la semana próxima"
                ]
            },
            "relative-type-regex": {
                "in \\1 year": [
                    "en (\\d+) a"
                ],
                "in \\1 month": [
                    "en (\\d+) mes",
                    "en (\\d+) m",
                    "en (\\d+) meses"
                ],
                "in \\1 week": [
                    "en (\\d+) sem"
                ],
                "in \\1 day": [
                    "en (\\d+) día",
                    "en (\\d+) días"
                ],
                "in \\1 hour": [
                    "en (\\d+) n",
                    "en (\\d+) h"
                ],
                "in \\1 minute": [
                    "en (\\d+) min"
                ],
                "in \\1 second": [
                    "en (\\d+) s"
                ]
            }
        },
        "es-PA": {
            "name": "es-PA",
            "date_order": "MDY",
            "september": [
                "sep"
            ]
        },
        "es-CR": {
            "name": "es-CR",
            "september": [
                "sep"
            ]
        },
        "es-PR": {
            "name": "es-PR",
            "date_order": "MDY",
            "september": [
                "sep"
            ]
        },
        "es-CU": {
            "name": "es-CU",
            "september": [
                "sep"
            ]
        },
        "es-UY": {
            "name": "es-UY",
            "september": [
                "setiembre",
                "set"
            ]
        },
        "es-EC": {
            "name": "es-EC",
            "september": [
                "sep"
            ]
        },
        "es-GQ": {
            "name": "es-GQ"
        },
        "es-BO": {
            "name": "es-BO",
            "september": [
                "sep"
            ]
        },
        "es-NI": {
            "name": "es-NI",
            "september": [
                "sep"
            ]
        },
        "es-HN": {
            "name": "es-HN",
            "september": [
                "sep"
            ]
        },
        "es-IC": {
            "name": "es-IC"
        },
        "es-BR": {
            "name": "es-BR",
            "september": [
                "sep"
            ]
        },
        "es-EA": {
            "name": "es-EA"
        },
        "es-PY": {
            "name": "es-PY",
            "second": [
                "seg"
            ],
            "relative-type-regex": {
                "in \\1 second": [
                    "dentro de (\\d+) seg"
                ],
                "\\1 second ago": [
                    "hace (\\d+) seg"
                ]
            }
        },
        "es-SV": {
            "name": "es-SV",
            "september": [
                "sep"
            ]
        },
        "es-BZ": {
            "name": "es-BZ",
            "september": [
                "sep"
            ]
        },
        "es-GT": {
            "name": "es-GT",
            "september": [
                "sep"
            ]
        },
        "es-PH": {
            "name": "es-PH"
        },
        "es-PE": {
            "name": "es-PE",
            "september": [
                "setiembre",
                "set"
            ]
        },
        "es-419": {
            "name": "es-419",
            "september": [
                "sep"
            ]
        },
        "es-AR": {
            "name": "es-AR",
            "september": [
                "sep"
            ],
            "second": [
                "seg"
            ],
            "relative-type-regex": {
                "in \\1 second": [
                    "dentro de (\\d+) seg"
                ],
                "\\1 second ago": [
                    "hace (\\d+) seg"
                ]
            }
        },
        "es-VE": {
            "name": "es-VE"
        },
        "es-DO": {
            "name": "es-DO",
            "september": [
                "sep"
            ]
        },
        "es-US": {
            "name": "es-US",
            "september": [
                "sep"
            ]
        },
        "es-CL": {
            "name": "es-CL",
            "september": [
                "sep"
            ]
        }
    },
    "skip": [
        "de",
        "del",
        "cerca",
        "y",
        "a las",
        "en",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "pertain": [
        "de",
        "del"
    ],
    "sentence_splitter_group": 2,
    "ago": [
        "hace"
    ],
    "in": [
        "en"
    ],
    "simplifications": [
        {
            "una": "1"
        },
        {
            "un": "1"
        }
    ]
}