#ifndef _EFL_CANVAS_ANIMATION_PLAYER_EO_H_
#define _EFL_CANVAS_ANIMATION_PLAYER_EO_H_

#ifndef _EFL_CANVAS_ANIMATION_PLAYER_EO_CLASS_TYPE
#define _EFL_CANVAS_ANIMATION_PLAYER_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Animation_Player;

#endif

#ifndef _EFL_CANVAS_ANIMATION_PLAYER_EO_TYPES
#define _EFL_CANVAS_ANIMATION_PLAYER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Player object for playing canvas animations.
 *
 * This player object can be used to play animations on a
 * @ref efl_animation_player_target_get canvas object. The type of animation
 * depends on the @ref efl_animation_player_animation_get object.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
#define EFL_CANVAS_ANIMATION_PLAYER_CLASS efl_canvas_animation_player_class_get()

EWAPI const Efl_Class *efl_canvas_animation_player_class_get(void);

/**
 * @brief The animation to play.
 *
 * This animation object will be used to change the visual state of the
 * @ref efl_animation_player_target_get object.
 *
 * @param[in] obj The object.
 * @param[in] animation An already-configured animation object.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI void efl_animation_player_animation_set(Eo *obj, Efl_Canvas_Animation *animation);

/**
 * @brief The animation to play.
 *
 * This animation object will be used to change the visual state of the
 * @ref efl_animation_player_target_get object.
 *
 * @param[in] obj The object.
 *
 * @return An already-configured animation object.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI Efl_Canvas_Animation *efl_animation_player_animation_get(const Eo *obj);

/**
 * @brief Auto delete property
 *
 * @param[in] obj The object.
 * @param[in] auto_del @c true to delete animation object automatically when
 * animation is finished or animation is cancelled, @c false otherwise.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI void efl_animation_player_auto_del_set(Eo *obj, Eina_Bool auto_del);

/**
 * @brief Auto delete property
 *
 * @param[in] obj The object.
 *
 * @return @c true to delete animation object automatically when animation is
 * finished or animation is cancelled, @c false otherwise.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI Eina_Bool efl_animation_player_auto_del_get(const Eo *obj);

/**
 * @brief The canvas object to apply the effects of the
 * @ref efl_animation_player_animation_get object on.
 *
 * The @ref efl_animation_player_animation_get object can change several
 * properties of the @c target. You should ensure that nothing else is trying
 * to change them too.
 *
 * @param[in] obj The object.
 * @param[in] target Canvas object to animate.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI void efl_animation_player_target_set(Eo *obj, Efl_Canvas_Object *target);

/**
 * @brief The canvas object to apply the effects of the
 * @ref efl_animation_player_animation_get object on.
 *
 * The @ref efl_animation_player_animation_get object can change several
 * properties of the @c target. You should ensure that nothing else is trying
 * to change them too.
 *
 * @param[in] obj The object.
 *
 * @return Canvas object to animate.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
EOAPI Efl_Canvas_Object *efl_animation_player_target_get(const Eo *obj);

EWAPI extern const Efl_Event_Description _EFL_ANIMATION_PLAYER_EVENT_STARTED;

/** Animation is started.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
#define EFL_ANIMATION_PLAYER_EVENT_STARTED (&(_EFL_ANIMATION_PLAYER_EVENT_STARTED))

EWAPI extern const Efl_Event_Description _EFL_ANIMATION_PLAYER_EVENT_RUNNING;

/** Animation is running.
 * @return Efl_Canvas_Object_Animation_Event
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
#define EFL_ANIMATION_PLAYER_EVENT_RUNNING (&(_EFL_ANIMATION_PLAYER_EVENT_RUNNING))

EWAPI extern const Efl_Event_Description _EFL_ANIMATION_PLAYER_EVENT_ENDED;

/** Animation is ended.
 *
 * @ingroup Efl_Canvas_Animation_Player
 */
#define EFL_ANIMATION_PLAYER_EVENT_ENDED (&(_EFL_ANIMATION_PLAYER_EVENT_ENDED))
#endif /* EFL_BETA_API_SUPPORT */

#endif
