/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.pathfinding;

import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;

class BaseCostDecider
implements CostDecider {
    protected int movesLeft;
    protected int newTurns;

    BaseCostDecider() {
    }

    @Override
    public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeftBefore) {
        int cost = 0;
        this.newTurns = 0;
        Tile oldTile = oldLocation.getTile();
        Tile newTile = newLocation.getTile();
        if (oldLocation instanceof Europe) {
            if (newLocation instanceof Europe || newTile == null || !newTile.isDirectlyHighSeasConnected() || !unit.getType().canMoveToHighSeas()) {
                return -1;
            }
            this.newTurns = unit.getSailTurns();
            this.movesLeft = unit.getInitialMovesLeft();
            cost = this.newTurns * unit.getInitialMovesLeft();
        } else {
            if (oldTile == null) {
                return -1;
            }
            if (newLocation instanceof Europe) {
                if (!unit.getType().canMoveToHighSeas()) {
                    return -1;
                }
                this.newTurns = unit.getSailTurns();
                this.movesLeft = unit.getInitialMovesLeft();
                cost = this.newTurns * unit.getInitialMovesLeft();
            } else {
                if (newTile == null || !newTile.isExplored()) {
                    return -1;
                }
                boolean consumeMove = false;
                switch (unit.getSimpleMoveType(oldTile, newTile)) {
                    case MOVE_HIGH_SEAS: {
                        break;
                    }
                    case ATTACK_UNIT: 
                    case MOVE: {
                        if (!unit.isOnCarrier()) break;
                    }
                    case ATTACK_SETTLEMENT: 
                    case EXPLORE_LOST_CITY_RUMOUR: 
                    case EMBARK: 
                    case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: 
                    case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: 
                    case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: 
                    case ENTER_FOREIGN_COLONY_WITH_SCOUT: 
                    case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                        consumeMove = true;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                cost = unit.getMoveCost(oldTile, newTile, movesLeftBefore);
                if (cost <= movesLeftBefore) {
                    this.movesLeft = movesLeftBefore - cost;
                } else {
                    int thisTurnMovesLeft = movesLeftBefore;
                    int initialMoves = unit.getInitialMovesLeft();
                    int moveCostNextTurn = unit.getMoveCost(oldTile, newTile, initialMoves);
                    cost = thisTurnMovesLeft + moveCostNextTurn;
                    this.movesLeft = initialMoves - moveCostNextTurn;
                    ++this.newTurns;
                }
                if (consumeMove) {
                    cost += this.movesLeft;
                    this.movesLeft = 0;
                }
            }
        }
        return cost;
    }

    @Override
    public int getMovesLeft() {
        return this.movesLeft;
    }

    @Override
    public int getNewTurns() {
        return this.newTurns;
    }
}

