/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthButtonUI;
import javax.swing.plaf.synth.SynthContext;

class SynthArrowButton
extends JButton
implements SwingConstants,
UIResource {
    private int direction;

    public SynthArrowButton(int direction) {
        super.setFocusable(false);
        this.setDirection(direction);
        this.setDefaultCapable(false);
    }

    @Override
    public String getUIClassID() {
        return "ArrowButtonUI";
    }

    @Override
    public void updateUI() {
        this.setUI(new SynthArrowButtonUI());
    }

    public void setDirection(int dir) {
        this.direction = dir;
        this.putClientProperty("__arrow_direction__", dir);
        this.repaint();
    }

    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setFocusable(boolean focusable) {
    }

    private static class SynthArrowButtonUI
    extends SynthButtonUI {
        private SynthArrowButtonUI() {
        }

        @Override
        protected void installDefaults(AbstractButton b) {
            super.installDefaults(b);
            this.updateStyle(b);
        }

        @Override
        protected void paint(SynthContext context, Graphics g) {
            SynthArrowButton button = (SynthArrowButton)context.getComponent();
            context.getPainter().paintArrowButtonForeground(context, g, 0, 0, button.getWidth(), button.getHeight(), button.getDirection());
        }

        @Override
        void paintBackground(SynthContext context, Graphics g, JComponent c) {
            context.getPainter().paintArrowButtonBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        }

        @Override
        public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            context.getPainter().paintArrowButtonBorder(context, g, x, y, w, h);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Object scaleKey;
            Container parent;
            SynthContext context = this.getContext(c);
            Dimension dim = null;
            if (context.getComponent().getName() == "ScrollBar.button") {
                dim = (Dimension)context.getStyle().get(context, "ScrollBar.buttonSize");
            }
            if (dim == null) {
                int size = context.getStyle().getInt(context, "ArrowButton.size", 16);
                dim = new Dimension(size, size);
            }
            if ((parent = context.getComponent().getParent()) instanceof JComponent && !(parent instanceof JComboBox) && (scaleKey = ((JComponent)parent).getClientProperty("JComponent.sizeVariant")) != null) {
                if ("large".equals(scaleKey)) {
                    dim = new Dimension((int)((double)dim.width * 1.15), (int)((double)dim.height * 1.15));
                } else if ("small".equals(scaleKey)) {
                    dim = new Dimension((int)((double)dim.width * 0.857), (int)((double)dim.height * 0.857));
                } else if ("mini".equals(scaleKey)) {
                    dim = new Dimension((int)((double)dim.width * 0.714), (int)((double)dim.height * 0.714));
                }
            }
            context.dispose();
            return dim;
        }
    }
}

