/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

class WindowTableModel
extends AbstractTableModel {
    private static final String PLUGIN_SET_PREFIX = "Plugin: ";
    private static final String CORE_DOCKABLE_SET = "Core";
    private static final String ALL_DOCKABLE_SET = "All";
    private HashMap<String, List<Entry>> dockableSets = new HashMap();
    private List<Entry> windows;

    WindowTableModel() {
        String[] stringArray;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        this.dockableSets.put(ALL_DOCKABLE_SET, arrayList);
        this.windows = new ArrayList<Entry>();
        for (String string : stringArray = DockableWindowManager.getRegisteredDockableWindows()) {
            String string2 = DockableWindowManager.getDockableWindowPluginName(string);
            String string3 = string2 != null ? PLUGIN_SET_PREFIX + string2 : CORE_DOCKABLE_SET;
            List<Entry> list = this.dockableSets.get(string3);
            if (list == null) {
                list = new ArrayList<Entry>();
                this.dockableSets.put(string3, list);
            }
            Entry entry = new Entry(string);
            list.add(entry);
            arrayList.add(entry);
        }
        this.showSet(ALL_DOCKABLE_SET);
    }

    public List<String> getDockableSets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.dockableSets.keySet()) {
            arrayList.add(string);
        }
        arrayList.remove(ALL_DOCKABLE_SET);
        arrayList.remove(CORE_DOCKABLE_SET);
        Collections.sort(arrayList);
        arrayList.add(0, CORE_DOCKABLE_SET);
        arrayList.add(0, ALL_DOCKABLE_SET);
        return arrayList;
    }

    public void showSet(String string) {
        this.windows = this.dockableSets.get(string);
        Collections.sort(this.windows, new WindowCompare());
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.windows.size();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Entry entry = this.windows.get(n);
        switch (n2) {
            case 0: {
                return entry.title;
            }
            case 1: {
                return entry.dockPosition;
            }
        }
        throw new InternalError();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        Entry entry = this.windows.get(n);
        switch (n2) {
            case 1: {
                entry.dockPosition = (String)object;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return jEdit.getProperty("options.docking.title");
            }
            case 1: {
                return jEdit.getProperty("options.docking.dockPosition");
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.windows.size(); ++i) {
            this.windows.get(i).save();
        }
    }

    static class WindowCompare
    implements Comparator<Object> {
        WindowCompare() {
        }

        @Override
        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            return StandardUtilities.compareStrings(entry.title, entry2.title, true);
        }
    }

    static class Entry {
        String name;
        String title;
        String dockPosition;

        Entry(String string) {
            this.name = string;
            this.title = jEdit.getProperty(string + ".title");
            if (this.title == null) {
                this.title = string;
            }
            this.dockPosition = jEdit.getProperty(string + ".dock-position");
            if (this.dockPosition == null) {
                this.dockPosition = "floating";
            }
        }

        void save() {
            jEdit.setProperty(this.name + ".dock-position", this.dockPosition);
        }
    }
}

