/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SSLSessionUtil;
import org.bouncycastle.jsse.provider.SessionBindingListenerAdapter;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

abstract class ProvSSLSessionBase
extends BCExtendedSSLSession {
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLSessionContext sslSessionContext;
    protected final String peerHost;
    protected final int peerPort;
    protected final long creationTime;
    protected final SSLSession exportSSLSession;
    protected long lastAccessedTime;
    protected boolean invalidated;

    ProvSSLSessionBase(ProvSSLSessionContext provSSLSessionContext, String string, int n) {
        this.sslSessionContext = provSSLSessionContext;
        this.peerHost = string;
        this.peerPort = n;
        this.creationTime = System.currentTimeMillis();
        this.exportSSLSession = SSLSessionUtil.exportSSLSession(this);
        this.lastAccessedTime = this.creationTime;
        this.invalidated = false;
    }

    protected abstract int getCipherSuiteTLS();

    protected abstract byte[] getIDArray();

    protected abstract JsseSessionParameters getJsseSessionParameters();

    protected abstract Certificate getLocalCertificateTLS();

    protected abstract Certificate getPeerCertificateTLS();

    protected abstract ProtocolVersion getProtocolTLS();

    SSLSession getExportSSLSession() {
        return this.exportSSLSession;
    }

    synchronized void accessedAt(long l) {
        this.lastAccessedTime = Math.max(this.lastAccessedTime, l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProvSSLSessionBase)) {
            return false;
        }
        ProvSSLSessionBase provSSLSessionBase = (ProvSSLSessionBase)object;
        return Arrays.areEqual((byte[])this.getIDArray(), (byte[])provSSLSessionBase.getIDArray());
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public String getCipherSuite() {
        return this.sslSessionContext.getSSLContext().getCipherSuiteString(this.getCipherSuiteTLS());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        byte[] byArray = this.getIDArray();
        return null == byArray ? TlsUtils.EMPTY_BYTES : Arrays.clone((byte[])byArray);
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public java.security.cert.Certificate[] getLocalCertificates() {
        java.security.cert.Certificate[] certificateArray = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.getLocalCertificateTLS());
        if (null != certificateArray && certificateArray.length > 0) {
            return certificateArray;
        }
        return null;
    }

    public Principal getLocalPrincipal() {
        return JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.getLocalCertificateTLS());
    }

    public int getPacketBufferSize() {
        return 18443;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        java.security.cert.Certificate[] certificateArray = this.getPeerCertificates();
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                x509CertificateArray[i] = X509Certificate.getInstance(certificateArray[i].getEncoded());
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            throw new SSLPeerUnverifiedException(exception.getMessage());
        }
    }

    public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        java.security.cert.Certificate[] certificateArray = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.getPeerCertificateTLS());
        if (null != certificateArray && certificateArray.length > 0) {
            return certificateArray;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal x500Principal = JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.getPeerCertificateTLS());
        if (null != x500Principal) {
            return x500Principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getProtocol() {
        return this.sslSessionContext.getSSLContext().getProtocolString(this.getProtocolTLS());
    }

    public SSLSessionContext getSessionContext() {
        return this.sslSessionContext;
    }

    public Object getValue(String string) {
        return this.valueMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.getIDArray());
    }

    public void invalidate() {
        this.sslSessionContext.removeSession(this.getIDArray());
        this.invalidated = true;
    }

    public boolean isValid() {
        byte[] byArray = this.getIDArray();
        return null != byArray && byArray.length > 0 && !this.invalidated;
    }

    public void putValue(String string, Object object) {
        this.notifyUnbound(string, this.valueMap.put(string, object));
        this.notifyBound(string, object);
    }

    public void removeValue(String string) {
        this.notifyUnbound(string, this.valueMap.remove(string));
    }

    public String toString() {
        return "Session(" + this.getCreationTime() + "|" + this.getCipherSuite() + ")";
    }

    protected void notifyBound(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
        }
    }

    protected void notifyUnbound(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
        }
    }
}

