/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven;

import com.getsentry.raven.Raven;
import com.getsentry.raven.dsn.Dsn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RavenFactory {
    private static final ServiceLoader<RavenFactory> AUTO_REGISTERED_FACTORIES = ServiceLoader.load(RavenFactory.class, RavenFactory.class.getClassLoader());
    private static final Set<RavenFactory> MANUALLY_REGISTERED_FACTORIES = new HashSet<RavenFactory>();
    private static final Logger logger = LoggerFactory.getLogger(RavenFactory.class);

    public static void registerFactory(RavenFactory ravenFactory) {
        MANUALLY_REGISTERED_FACTORIES.add(ravenFactory);
    }

    private static Iterable<RavenFactory> getRegisteredFactories() {
        LinkedList<RavenFactory> ravenFactories = new LinkedList<RavenFactory>();
        ravenFactories.addAll(MANUALLY_REGISTERED_FACTORIES);
        for (RavenFactory autoRegisteredFactory : AUTO_REGISTERED_FACTORIES) {
            ravenFactories.add(autoRegisteredFactory);
        }
        return ravenFactories;
    }

    public static Raven ravenInstance() {
        return RavenFactory.ravenInstance(Dsn.dsnLookup());
    }

    public static Raven ravenInstance(String dsn) {
        return RavenFactory.ravenInstance(new Dsn(dsn));
    }

    public static Raven ravenInstance(Dsn dsn) {
        return RavenFactory.ravenInstance(dsn, null);
    }

    public static Raven ravenInstance(Dsn dsn, String ravenFactoryName) {
        String delim;
        logger.debug("Attempting to find a working RavenFactory");
        ArrayList<String> skippedFactories = new ArrayList<String>();
        ArrayList<String> triedFactories = new ArrayList<String>();
        RuntimeException lastExc = null;
        for (RavenFactory ravenFactory : RavenFactory.getRegisteredFactories()) {
            String name = ravenFactory.getClass().getName();
            if (ravenFactoryName != null && !ravenFactoryName.equals(name)) {
                skippedFactories.add(name);
                continue;
            }
            logger.debug("Attempting to use '{}' as a RavenFactory.", (Object)ravenFactory);
            triedFactories.add(name);
            try {
                Raven ravenInstance = ravenFactory.createRavenInstance(dsn);
                logger.debug("The RavenFactory '{}' created an instance of Raven.", (Object)ravenFactory);
                return ravenInstance;
            }
            catch (RuntimeException e) {
                lastExc = e;
                logger.debug("The RavenFactory '{}' couldn't create an instance of Raven.", (Object)ravenFactory, (Object)e);
            }
        }
        if (ravenFactoryName != null && triedFactories.isEmpty()) {
            try {
                Class.forName(ravenFactoryName);
                logger.error("The RavenFactory class '{}' was found on your classpath but was not registered with Raven, see: https://github.com/getsentry/raven-java/#custom-ravenfactory", (Object)ravenFactoryName);
            }
            catch (ClassNotFoundException e) {
                logger.error("The RavenFactory class name '{}' was specified but the class was not found on your classpath.", (Object)ravenFactoryName);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Couldn't create a raven instance for: '");
        sb.append(dsn);
        sb.append('\'');
        if (ravenFactoryName != null) {
            sb.append("; ravenFactoryName: ");
            sb.append(ravenFactoryName);
            if (skippedFactories.isEmpty()) {
                sb.append("; no skipped factories");
            } else {
                sb.append("; skipped factories: ");
                delim = "";
                for (String skippedFactory : skippedFactories) {
                    sb.append(delim);
                    sb.append(skippedFactory);
                    delim = ", ";
                }
            }
        }
        if (triedFactories.isEmpty()) {
            sb.append("; no factories tried!");
            throw new IllegalStateException(sb.toString());
        }
        sb.append("; tried factories: ");
        delim = "";
        for (String triedFactory : triedFactories) {
            sb.append(delim);
            sb.append(triedFactory);
            delim = ", ";
        }
        sb.append("; cause contains exception thrown by the last factory tried.");
        throw new IllegalStateException(sb.toString(), lastExc);
    }

    public abstract Raven createRavenInstance(Dsn var1);

    public String toString() {
        return "RavenFactory{name='" + this.getClass().getName() + '\'' + '}';
    }
}

