/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sigrok.core.classes;
import org.sigrok.core.interfaces.DatafeedCallback;
/** A sigrok session. */
public class Session {
  protected transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Session(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Session obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        classesJNI.delete_Session(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /** Add a device to this session.
   * @param device Device to add. */
public void add_device(Device device) {
    classesJNI.Session_add_device(swigCPtr, this, Device.getCPtr(device), device);
  }

  /** List devices attached to this session. */
public DeviceVector devices() {
    return new DeviceVector(classesJNI.Session_devices(swigCPtr, this), true);
  }

  /** Remove all devices from this session. */
public void remove_devices() {
    classesJNI.Session_remove_devices(swigCPtr, this);
  }

  /** Add a datafeed callback to this session.
   * @param callback Callback of the form callback(Device, Packet). */
public void add_datafeed_callback(SWIGTYPE_p_std__functionT_void_fstd__shared_ptrT_sigrok__Device_t_std__shared_ptrT_sigrok__Packet_tF_t callback) {
    classesJNI.Session_add_datafeed_callback__SWIG_0(swigCPtr, this, SWIGTYPE_p_std__functionT_void_fstd__shared_ptrT_sigrok__Device_t_std__shared_ptrT_sigrok__Packet_tF_t.getCPtr(callback));
  }

  /** Remove all datafeed callbacks from this session. */
public void remove_datafeed_callbacks() {
    classesJNI.Session_remove_datafeed_callbacks(swigCPtr, this);
  }

  /** Start the session. */
public void start() {
    classesJNI.Session_start(swigCPtr, this);
  }

  /** Run the session event loop. */
public void run() {
    classesJNI.Session_run(swigCPtr, this);
  }

  /** Stop the session. */
public void stop() {
    classesJNI.Session_stop(swigCPtr, this);
  }

  /** Return whether the session is running. */
public boolean is_running() {
    return classesJNI.Session_is_running(swigCPtr, this);
  }

  /** Set callback to be invoked on session stop. */
public void set_stopped_callback(SWIGTYPE_p_std__functionT_void_fF_t callback) {
    classesJNI.Session_set_stopped_callback(swigCPtr, this, SWIGTYPE_p_std__functionT_void_fF_t.getCPtr(callback));
  }

  /** Get current trigger setting. */
public Trigger trigger() {
    long cPtr = classesJNI.Session_trigger(swigCPtr, this);
    return (cPtr == 0) ? null : new Trigger(cPtr, true);
  }

  /** Get the context. */
public Context context() {
    long cPtr = classesJNI.Session_context(swigCPtr, this);
    return (cPtr == 0) ? null : new Context(cPtr, true);
  }

  /** Set trigger setting.
   * @param trigger Trigger object to use. */
public void set_trigger(Trigger trigger) {
    classesJNI.Session_set_trigger(swigCPtr, this, Trigger.getCPtr(trigger), trigger);
  }

  /** Get filename this session was loaded from. */
public String filename() {
    return classesJNI.Session_filename(swigCPtr, this);
  }

  public void add_datafeed_callback(DatafeedCallback obj) {
    classesJNI.Session_add_datafeed_callback__SWIG_1(swigCPtr, this, obj);
  }

}
